/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.codingrule.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleEntryInfo;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.codingrule.IMaxSerial;
import com.kingdee.eas.base.codingrule.IMutexFacade;
import com.kingdee.eas.base.codingrule.MaxSerialCollection;
import com.kingdee.eas.base.codingrule.MaxSerialFactory;
import com.kingdee.eas.base.codingrule.MaxSerialInfo;
import com.kingdee.eas.base.codingrule.MutexFacadeFactory;
import com.kingdee.eas.base.codingrule.SegmentStateEnum;
import com.kingdee.eas.base.codingrule.SeqSegmentEntryCollection;
import com.kingdee.eas.base.codingrule.SeqSegmentEntryInfo;
import com.kingdee.eas.base.codingrule.SeqSegmentInfo;
import com.kingdee.eas.base.codingrule.app.AbstractMaxSerialControllerBean;
import com.kingdee.eas.base.codingrule.app.CodingRuleAppUtils;
import com.kingdee.eas.base.codingrule.app.CodingRuleDAO;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import javax.sql.RowSet;
import org.apache.log4j.Logger;

public class MaxSerialControllerBean
extends AbstractMaxSerialControllerBean {
    private Logger logger = Logger.getLogger(MaxSerialControllerBean.class);
    private static final String SplitOfSortValue = "_split_";

    @Override
    protected boolean _deleteByCreId(Context ctx, String creId) throws BOSException, CodingRuleException, EASBizException {
        MaxSerialCollection mscollection = (MaxSerialCollection)this._getCollection(ctx, creId, "");
        if (mscollection.size() > 0) {
            for (int i = 0; i < mscollection.size(); ++i) {
                ObjectUuidPK pk = new ObjectUuidPK(mscollection.get(i).getId());
                this._delete(ctx, (IObjectPK)pk);
            }
            return true;
        }
        return false;
    }

    @Override
    protected IObjectCollection _getCollection(Context ctx, String creId, String id) throws BOSException, CodingRuleException {
        IMaxSerial iMaxSerial = MaxSerialFactory.getLocalInstance(ctx);
        FilterInfo filters = new FilterInfo();
        filters.getFilterItems().add(new FilterItemInfo("codingRuleEntry.Id", (Object)creId, CompareType.EQUALS));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filters);
        evi.getSelector().add(new SelectorItemInfo("*"));
        MaxSerialCollection mscollection = iMaxSerial.getMaxSerialCollection(evi);
        return mscollection;
    }

    @Override
    protected IObjectValue _getValue(Context ctx, String creId, String sortItemValue) throws BOSException, CodingRuleException {
        IMaxSerial iMaxSerial = MaxSerialFactory.getLocalInstance(ctx);
        FilterInfo filters = new FilterInfo();
        filters.getFilterItems().add(new FilterItemInfo("codingRuleEntry.Id", (Object)creId, CompareType.EQUALS));
        filters.getFilterItems().add(new FilterItemInfo("sortItemValue", (Object)sortItemValue, CompareType.EQUALS));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filters);
        evi.getSelector().add(new SelectorItemInfo("*"));
        MaxSerialCollection mscollection = iMaxSerial.getMaxSerialCollection(evi);
        if (mscollection.size() > 1) {
            throw new CodingRuleException(CodingRuleException.ERROR_MAXS_INVALID);
        }
        if (mscollection.size() == 1) {
            return mscollection.get(0);
        }
        return null;
    }

    @Override
    protected String _getMaxValue(Context ctx, IObjectValue creVO, String sortItemValue, boolean isNonBreak) throws BOSException, CodingRuleException, EASBizException {
        this.logger.debug((Object)"this is the new MaxSerialControllerBean!");
        return this.getMaxValueForNonBreak(ctx, creVO, sortItemValue, isNonBreak);
    }

    private String getMaxValueForNonBreak(Context ctx, IObjectValue creVO, String sortItemValue, boolean isNonBreak) throws BOSException, CodingRuleException, EASBizException {
        long value = 0L;
        CodingRuleEntryInfo cre = (CodingRuleEntryInfo)creVO;
        IMutexFacade iMutexFacade = MutexFacadeFactory.getLocalInstance(ctx);
        sortItemValue = sortItemValue.length() > 0 ? sortItemValue : "codingrule_maxserial";
        value = CodingRuleAppUtils.isInSameTransaction(ctx) ? iMutexFacade.updateMaxSerialReqCtx(cre, sortItemValue, isNonBreak) : iMutexFacade.updateMaxSerialNewCtx(cre, sortItemValue, isNonBreak);
        return value + "";
    }

    private void update4Lock(Context ctx, String sortItemValue, CodingRuleEntryInfo cre) {
        try {
            String mustUseLock = ParamManager.getParamValue((Context)ctx, null, (String)"MUST_USE_LOCK");
            IMutexFacade iMutexFacade = MutexFacadeFactory.getLocalInstance(ctx);
            this.logger.info((Object)(" get MUST_USE_LOCK is:" + StringUtils.cnulls((String)mustUseLock)));
            if ("true".equalsIgnoreCase(mustUseLock)) {
                iMutexFacade.getMaxSerialReqCtx(sortItemValue, cre);
            } else {
                iMutexFacade.getMaxSerialNewCtx(sortItemValue, cre);
            }
        }
        catch (EASBizException e) {
            this.logger.error((Object)"getMaxSerial error", (Throwable)e);
        }
        catch (BOSException e) {
            this.logger.error((Object)"getMaxSerial error", (Throwable)e);
        }
    }

    private String getSelectValueForNonBreak(Context ctx, IObjectValue creVO, String sortItemValue, long number) throws BOSException, CodingRuleException, EASBizException {
        long value = 0L;
        CodingRuleEntryInfo cre = (CodingRuleEntryInfo)creVO;
        this.update4Lock(ctx, sortItemValue, cre);
        try {
            sortItemValue = sortItemValue.length() > 0 ? sortItemValue : "codingrule_maxserial";
            RowSet rowset = CodingRuleDAO.getSelectIntermilNOInfoValue(ctx, cre.getId().toString(), sortItemValue, number);
            boolean flag = rowset.next();
            if (flag) {
                value = rowset.getLong("FSerialNumber");
                CodingRuleDAO.deleteIntermilNOInfoValue(ctx, rowset.getString("FID"));
            } else {
                rowset = CodingRuleDAO.getMaxSerialInfoValue(ctx, cre.getId().toString(), sortItemValue);
                flag = rowset.next();
                if (!flag && sortItemValue.indexOf(SplitOfSortValue) != -1) {
                    rowset = CodingRuleDAO.getMaxSerialInfoValue(ctx, cre.getId().toString(), sortItemValue.replaceAll(SplitOfSortValue, ""));
                    flag = rowset.next();
                }
                if (!flag) {
                    MaxSerialInfo ms = new MaxSerialInfo();
                    ms.setCodingRuleEntry(cre);
                    ms.setSortItemValue(sortItemValue);
                    ms.setSerialNumber(cre.getInitial());
                    ms.setId(BOSUuid.create((BOSObjectType)ms.getBOSType()));
                    CodingRuleDAO.addMaxSerialInfoValue(ctx, ms);
                    value = ms.getSerialNumber();
                } else {
                    value = rowset.getLong("FSerialNumber");
                    long initValue = rowset.getLong("FInitValue");
                    if (cre.getStep() > 0 && initValue > (value += (long)cre.getStep())) {
                        value = initValue;
                    } else if (cre.getStep() < 0 && initValue < value && initValue > 0L) {
                        value = initValue;
                    }
                    CodingRuleDAO.updateMaxSerialInfoValue(ctx, rowset.getString("FID"), sortItemValue, value);
                }
            }
        }
        catch (SQLException err) {
            throw new BOSException(err.getMessage(), (Throwable)err);
        }
        return value + "";
    }

    private String getMaxValueForNonBreakBySegment(Context ctx, IObjectValue creVO, String sortItemValue, String segmentAttrValue) throws BOSException, CodingRuleException, EASBizException {
        String value = "";
        CodingRuleEntryInfo cre = (CodingRuleEntryInfo)creVO;
        this.update4Lock(ctx, sortItemValue, cre);
        try {
            sortItemValue = sortItemValue.length() > 0 ? sortItemValue : "codingrule_maxserial";
            RowSet rowset = CodingRuleDAO.getIntermilNOInfoValue(ctx, cre.getId().toString(), sortItemValue + SplitOfSortValue + segmentAttrValue, cre.getInitial(), cre.getStep());
            boolean flag = rowset.next();
            if (flag) {
                value = rowset.getLong("FSerialNumber") + "";
                CodingRuleDAO.deleteIntermilNOInfoValue(ctx, rowset.getString("FID"));
            } else {
                value = this.getSegmentMaxValue(ctx, sortItemValue, segmentAttrValue, cre);
            }
        }
        catch (SQLException err) {
            throw new BOSException(err.getMessage(), (Throwable)err);
        }
        return value;
    }

    private String getSegmentMaxValue(Context ctx, String sortItemValue, String segmentAttrValue, CodingRuleEntryInfo cre) throws CodingRuleException, BOSException, SQLException {
        long value;
        SeqSegmentInfo sInfo = cre.getCodingRule().getSeqSegment();
        if (segmentAttrValue == null || segmentAttrValue.trim().length() == 0) {
            throw new CodingRuleException(CodingRuleException.ERROR_SEGMENTINFOLACKATTR);
        }
        if (sInfo == null) {
            throw new BOSException(EASResource.getString((String)"com.kingdee.eas.base.codingrule.CODINGRULEAutoGenerateResource", (String)"46_MaxSerialControllerBean"));
        }
        SeqSegmentEntryInfo entryInfo = null;
        SeqSegmentEntryCollection entries = sInfo.getEntries();
        RowSet rowset = CodingRuleDAO.getMaxSerialInfoValueOfSegment(ctx, cre.getId().toString(), sortItemValue, segmentAttrValue);
        boolean flag = rowset.next();
        long iMax = -1L;
        if (flag) {
            iMax = rowset.getLong("FSerialNumber");
        }
        if (cre.getStep() > 0) {
            for (int index = 0; index < entries.size(); ++index) {
                entryInfo = entries.get(index);
                if (entryInfo.getState().equals((Object)SegmentStateEnum.State_open) && segmentAttrValue.equalsIgnoreCase(entryInfo.getLinkID())) {
                    if (iMax != -1L && (iMax > entryInfo.getEndNum() || iMax < entryInfo.getBeginNum())) continue;
                    if (iMax != -1L) break;
                    if (cre.getStep() > 0) {
                        iMax = entryInfo.getBeginNum() - (long)cre.getStep();
                        break;
                    }
                    iMax = entryInfo.getEndNum() - (long)cre.getStep();
                    break;
                }
                if (entryInfo.getState().equals((Object)SegmentStateEnum.State_close) && segmentAttrValue.equalsIgnoreCase(entryInfo.getLinkID()) && iMax >= entryInfo.getBeginNum() && iMax <= entryInfo.getEndNum()) {
                    iMax = -1L;
                    CodingRuleDAO.updateMaxSerialInfoValue(ctx, rowset.getString("FID"), sortItemValue, -1L);
                    index = -1;
                }
                entryInfo = null;
            }
        }
        if (entryInfo == null) {
            if (flag) {
                CodingRuleDAO.updateMaxSerialInfoValue(ctx, rowset.getString("FID"), sortItemValue, -1L);
            }
            throw new CodingRuleException(CodingRuleException.INFO_SEGMENTINFONOTAVAILABLE);
        }
        if (!flag) {
            MaxSerialInfo ms = new MaxSerialInfo();
            ms.setCodingRuleEntry(cre);
            ms.setSortItemValue(sortItemValue);
            if (cre.getStep() > 0) {
                ms.setSerialNumber(entryInfo.getBeginNum());
            } else {
                ms.setSerialNumber(entryInfo.getEndNum());
            }
            ms.setId(BOSUuid.create((BOSObjectType)ms.getBOSType()));
            ms.setSegmentAttrValue(segmentAttrValue);
            CodingRuleDAO.addMaxSerialInfoValue(ctx, ms);
            value = ms.getSerialNumber();
        } else {
            value = iMax + (long)cre.getStep();
            if (value >= entryInfo.getEndNum()) {
                CodingRuleDAO.setStateOfSegment(ctx, entryInfo.getId().toString(), 0);
                CodingRuleDAO.updateMaxSerialInfoValue(ctx, rowset.getString("FID"), sortItemValue, -1L);
            } else {
                CodingRuleDAO.updateMaxSerialInfoValue(ctx, rowset.getString("FID"), sortItemValue, value);
            }
        }
        return value + "";
    }

    private String getMaxValueBySegment(Context ctx, IObjectValue creVO, String sortItemValue, String segmentAttrValue) throws BOSException, CodingRuleException {
        CodingRuleEntryInfo cre = (CodingRuleEntryInfo)creVO;
        try {
            sortItemValue = sortItemValue.length() > 0 ? sortItemValue : "codingrule_maxserial";
            String string = this.getSegmentMaxValue(ctx, sortItemValue, segmentAttrValue, cre);
            return string;
        }
        catch (SQLException err) {
            throw new BOSException(err.getMessage(), (Throwable)err);
        }
    }

    @Override
    protected String _getMaxValue(Context ctx, IObjectValue creVO, String sortItemValue, boolean isNonBreak, String segmentAttrValue) throws BOSException, CodingRuleException, EASBizException {
        this.logger.debug((Object)"this is the new MaxSerialControllerBean!");
        if (isNonBreak) {
            return this.getMaxValueForNonBreakBySegment(ctx, creVO, sortItemValue, segmentAttrValue);
        }
        return this.getMaxValueBySegment(ctx, creVO, sortItemValue, segmentAttrValue);
    }

    @Override
    protected long _getMaxValue(Context ctx, IObjectValue creVO, String sortItemValue, int count) throws BOSException, CodingRuleException, EASBizException {
        long startValue = 0L;
        CodingRuleEntryInfo cre = (CodingRuleEntryInfo)creVO;
        sortItemValue = sortItemValue.length() > 0 ? sortItemValue : "codingrule_maxserial";
        MaxSerialInfo ms = (MaxSerialInfo)this._getValue(ctx, cre.getId().toString(), sortItemValue);
        if (ms == null) {
            ms = new MaxSerialInfo();
            ms.setCodingRuleEntry(cre);
            ms.setSortItemValue(sortItemValue);
            startValue = cre.getInitial();
            ms.setSerialNumber(startValue + (long)((count - 1) * cre.getStep()));
            this._addnew(ctx, (IObjectValue)ms);
        } else {
            startValue = ms.getSerialNumber() + (long)cre.getStep();
            this.logger.debug((Object)("startValue: " + startValue));
            ms.setSerialNumber(startValue + (long)((count - 1) * cre.getStep()));
            this.logger.debug((Object)("ms.getSerialNumber(): " + ms.getSerialNumber()));
            ObjectUuidPK pk = new ObjectUuidPK(ms.getId());
            this._update(ctx, (IObjectPK)pk, (IObjectValue)ms);
        }
        return startValue;
    }

    @Override
    protected String _readMaxValue(Context ctx, IObjectValue creVO, String sortItemValue) throws BOSException, CodingRuleException {
        return this._readMaxValue(ctx, creVO, sortItemValue, null);
    }

    @Override
    protected String _readMaxValue(Context ctx, IObjectValue creVO, String sortItemValue, String segmentAttrValue) throws BOSException {
        CodingRuleEntryInfo cre = (CodingRuleEntryInfo)creVO;
        sortItemValue = sortItemValue.length() > 0 ? sortItemValue : "codingrule_maxserial";
        String maxVaule = "";
        long value = 0L;
        try {
            sortItemValue = sortItemValue.length() > 0 ? sortItemValue : "codingrule_maxserial";
            RowSet rowset = CodingRuleDAO.getIntermilNOInfoValue(ctx, cre.getId().toString(), sortItemValue, cre.getInitial(), cre.getStep());
            boolean flag = rowset.next();
            if (flag) {
                maxVaule = rowset.getLong("FSerialNumber") + "";
            } else {
                rowset = CodingRuleDAO.getMaxSerialInfoValueOfSegment(ctx, cre.getId().toString(), sortItemValue, segmentAttrValue);
                flag = rowset.next();
                if (!flag && sortItemValue.indexOf(SplitOfSortValue) != -1 && StringUtils.isEmpty((String)segmentAttrValue)) {
                    rowset = CodingRuleDAO.getMaxSerialInfoValue(ctx, cre.getId().toString(), sortItemValue.replaceAll(SplitOfSortValue, ""));
                    flag = rowset.next();
                }
                if (flag) {
                    value = rowset.getLong("FSerialNumber");
                }
                maxVaule = value == 0L ? cre.getInitial() + "" : value + (long)cre.getStep() + "";
            }
        }
        catch (SQLException err) {
            throw new BOSException(err.getMessage(), (Throwable)err);
        }
        return maxVaule;
    }

    @Override
    protected String _getSelectValue(Context ctx, IObjectValue creVO, String sortItemValue, long number) throws BOSException, CodingRuleException, EASBizException {
        this.logger.debug((Object)"this is the new SelectSerialControllerBean!");
        return this.getSelectValueForNonBreak(ctx, creVO, sortItemValue, number);
    }
}

