/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.codingrule.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleEntryInfo;
import com.kingdee.eas.base.codingrule.IntermilNOInfo;
import com.kingdee.eas.base.codingrule.MaxSerialInfo;
import com.kingdee.eas.base.codingrule.app.AbstractMutexFacadeControllerBean;
import com.kingdee.eas.base.codingrule.app.CodingRuleDAO;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import javax.sql.RowSet;
import org.apache.log4j.Logger;

public class MutexFacadeControllerBean
extends AbstractMutexFacadeControllerBean {
    private static final String SplitOfSortValue = "_split_";
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.codingrule.app.MutexFacadeControllerBean");

    @Override
    protected void _getMaxSerialReqCtx(Context ctx, String sortItemValue, CodingRuleEntryInfo codingRuleEntryInfo) throws BOSException {
        this.updateLockTable(ctx, sortItemValue, codingRuleEntryInfo);
    }

    @Override
    protected void _getMaxSerialNewCtx(Context ctx, String sortItemValue, CodingRuleEntryInfo codingRuleEntryInfo) throws BOSException {
        this.updateLockTable(ctx, sortItemValue, codingRuleEntryInfo);
    }

    private void updateLockTable(Context ctx, String sortItemValue, CodingRuleEntryInfo cre) {
        logger.debug((Object)("updateLockTable begin , ctx.id is:" + ctx.getContextID()));
        String strSortItem = cre.getId().toString() + sortItemValue;
        String id = cre.getId().toString() + strSortItem;
        String sql = "select FID from T_BAS_CodingRuleLock where FID= ?";
        Object[] params = new Object[]{id};
        try {
            logger.debug((Object)(" excute query lock talbe sql :" + sql));
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])params);
            sql = rs.next() ? "update T_BAS_CodingRuleLock set FLock = 2 where FID = ?" : "insert into T_BAS_CodingRuleLock values(?,1)";
            logger.debug((Object)(" in MutexFacadeControllerBean of codingrule lock execute sql:" + sql));
            DbUtil.execute((Context)ctx, (String)sql, (Object[])params);
            logger.debug((Object)("updateLockTable begin over,ctx.id is:" + ctx.getContextID()));
        }
        catch (BOSException e) {
            logger.info((Object)("BOSException happened. e.getCause() instanceof " + e.getCause()));
            if (e.getCause() instanceof SQLException) {
                SQLException exception = (SQLException)e.getCause();
                logger.info((Object)("SQLException happened. SQLState is: " + exception.getSQLState()));
                if (exception.getSQLState().equals("23000")) {
                    logger.info((Object)"updateLock table again.");
                    this.updateLockTable(ctx, sortItemValue, cre);
                }
            }
        }
        catch (Exception e) {
            logger.info((Object)e);
        }
    }

    protected String deleteBreakNumber(Context ctx, String sortItemValue, boolean isNonBreak, CodingRuleEntryInfo cre) throws BOSException {
        String fsn = "";
        logger.debug((Object)(" begin deal breakNumber" + isNonBreak));
        try {
            RowSet rowset;
            if (isNonBreak && (rowset = CodingRuleDAO.getIntermilNOInfoValue(ctx, cre.getId().toString(), sortItemValue, cre.getInitial(), cre.getStep())).next()) {
                fsn = rowset.getLong("FSerialNumber") + "";
                String id = rowset.getString("FID");
                logger.info((Object)(" begin delete breakNumber FSerialNumber is:" + fsn + " id is:" + id));
                CodingRuleDAO.deleteIntermilNOInfoValue(ctx, id);
            }
        }
        catch (SQLException err) {
            throw new BOSException(err.getMessage(), (Throwable)err);
        }
        return fsn;
    }

    @Override
    protected long _updateMaxSerialReqCtx(Context ctx, CodingRuleEntryInfo codingRuleEntryInfo, String sortItemValue, boolean isNoBreak) throws BOSException {
        this.updateLockTable(ctx, sortItemValue, codingRuleEntryInfo);
        String dbk = this.deleteBreakNumber(ctx, sortItemValue, isNoBreak, codingRuleEntryInfo);
        long returnLong = !StringUtils.isEmpty((String)dbk) ? Long.parseLong(dbk) : this.getMaxSerialNoBreak(ctx, sortItemValue, codingRuleEntryInfo);
        return returnLong;
    }

    @Override
    protected long _updateMaxSerialNewCtx(Context ctx, CodingRuleEntryInfo codingRuleEntryInfo, String sortItemValue, boolean isNoBreak) throws BOSException {
        logger.debug((Object)(" begin _updateMaxSerialNewCtx,ctx.id is:" + ctx.getContextID()));
        this.updateLockTable(ctx, sortItemValue, codingRuleEntryInfo);
        String dbk = this.deleteBreakNumber(ctx, sortItemValue, isNoBreak, codingRuleEntryInfo);
        long returnLong = !StringUtils.isEmpty((String)dbk) ? Long.parseLong(dbk) : this.getMaxSerialNoBreak(ctx, sortItemValue, codingRuleEntryInfo);
        logger.debug((Object)(" begin _updateMaxSerialNewCtx,ctx.id is:" + ctx.getContextID() + "  get returnLong over , returnLong is:" + returnLong));
        return returnLong;
    }

    private long getMaxSerialNoBreak(Context ctx, String sortItemValue, CodingRuleEntryInfo cre) throws BOSException {
        try {
            long value;
            logger.debug((Object)" getMaxSerialNoBreak");
            RowSet rowset = CodingRuleDAO.getMaxSerialInfoValue(ctx, cre.getId().toString(), sortItemValue);
            boolean flag = rowset.next();
            if (!flag) {
                if (sortItemValue.indexOf(SplitOfSortValue) != -1) {
                    rowset = CodingRuleDAO.getMaxSerialInfoValue(ctx, cre.getId().toString(), sortItemValue.replaceAll(SplitOfSortValue, ""));
                    flag = rowset.next();
                }
            }
            if (!flag) {
                MaxSerialInfo ms = new MaxSerialInfo();
                ms.setCodingRuleEntry(cre);
                ms.setSortItemValue(sortItemValue);
                ms.setSerialNumber(cre.getInitial());
                ms.setId(BOSUuid.create((BOSObjectType)ms.getBOSType()));
                CodingRuleDAO.addMaxSerialInfoValue(ctx, ms);
                value = ms.getSerialNumber();
            } else {
                value = rowset.getLong("FSerialNumber");
                long initValue = rowset.getLong("FInitValue");
                if (cre.getStep() > 0 && initValue > (value += (long)cre.getStep())) {
                    value = initValue;
                } else if (cre.getStep() < 0 && initValue < value && initValue > 0L) {
                    value = initValue;
                }
                CodingRuleDAO.updateMaxSerialInfoValue(ctx, rowset.getString("FID"), sortItemValue, value);
            }
            logger.debug((Object)(" getMaxSerialNoBreak retvalue is: " + value));
            return value;
        }
        catch (SQLException err) {
            throw new BOSException(err.getMessage(), (Throwable)err);
        }
    }

    @Override
    protected boolean _updateIntermitNoNewCtx(Context ctx, String entryid, String sortItemValue, long recycleNumber, IObjectValue model) throws BOSException {
        logger.debug((Object)"recycle number require new");
        IntermilNOInfo Itnmodel = (IntermilNOInfo)model;
        RowSet rs = CodingRuleDAO.getSelectIntermilNOInfoValue(ctx, entryid, sortItemValue, recycleNumber);
        try {
            if (!rs.next()) {
                CodingRuleDAO.addIntermilNOInfoValue(ctx, Itnmodel);
                logger.error((Object)"save intermilNO success!");
            }
            return true;
        }
        catch (BOSException e) {
            logger.error((Object)e);
            return false;
        }
        catch (SQLException e) {
            logger.error((Object)e);
            return false;
        }
    }

    @Override
    protected boolean _updateIntermitNoReqCtx(Context ctx, String entryid, String sortItemValue, long recycleNumber, IObjectValue model) throws BOSException {
        logger.debug((Object)"recycle number require");
        IntermilNOInfo Itnmodel = (IntermilNOInfo)model;
        RowSet rs = CodingRuleDAO.getSelectIntermilNOInfoValue(ctx, entryid, sortItemValue, recycleNumber);
        try {
            if (!rs.next()) {
                CodingRuleDAO.addIntermilNOInfoValue(ctx, Itnmodel);
                logger.error((Object)"save intermilNO success!");
            }
            return true;
        }
        catch (BOSException e) {
            logger.error((Object)e);
            return false;
        }
        catch (SQLException e) {
            logger.error((Object)e);
            return false;
        }
    }
}

