/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.codingrule.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.view.BusinessObjectBriefView;
import com.kingdee.bos.metadata.view.ExtendedPropertyFilter;
import com.kingdee.bos.metadata.view.IBriefViewTreeNode;
import com.kingdee.bos.metadata.view.MetaDataBriefCollection;
import com.kingdee.bos.metadata.view.MetaDataBriefInfo;
import com.kingdee.bos.metadata.view.MetaDataBriefViewFilter;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.subsystemhelper.UserCustomSubSystem;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public class SubSystemCommonUtils {
    private static Logger logger = Logger.getLogger((String)SubSystemCommonUtils.class.getName());
    public static final String BASE_MDB_VIEW_NAME = "eas_base_subsystem";
    public static final String DEFAULT_METADATA_PATH = "w:\\apusic\\metas";
    public static final String RESOURCE_NAME = "MetaDataPath.properties";
    private static IMetaDataLoader loader;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getMetaDataPath() {
        InputStream in = null;
        try {
            in = SubSystemCommonUtils.class.getResourceAsStream(RESOURCE_NAME);
            InputStreamReader ireader = new InputStreamReader(in);
            BufferedReader reader = new BufferedReader(ireader);
            String path = reader.readLine();
            reader.close();
            String string = path;
            return string;
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            String string = DEFAULT_METADATA_PATH;
            return string;
        }
        finally {
            if (null != in) {
                try {
                    in.close();
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public static IMetaDataLoader getMetaDataLoader() {
        if (loader != null) {
            return loader;
        }
        loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        return loader;
    }

    public static IMetaDataLoader getMetaDataLoader(Context ctx) {
        if (loader != null) {
            return loader;
        }
        loader = ctx == null ? MetaDataLoaderFactory.getRemoteMetaDataLoader() : MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        return loader;
    }

    private static MetaDataBriefViewFilter getFilterByName(String mdbViewName) {
        MetaDataBriefViewFilter filter = new MetaDataBriefViewFilter();
        filter.setViewName(mdbViewName);
        filter.addMetaDataTypeFilter(MetaDataTypeList.ENTITY);
        filter.addMetaDataTypeFilter(MetaDataTypeList.FACADE);
        filter.addMetaDataTypeFilter(MetaDataTypeList.UIOBJECT);
        filter.addMetaDataTypeFilter(MetaDataTypeList.DATATABLE);
        filter.addMetaDataTypeFilter(MetaDataTypeList.JOINQUERY);
        filter.addMetaDataTypeFilter(MetaDataTypeList.FUNCTION);
        return filter;
    }

    private static MetaDataBriefViewFilter getFilterByName(String mdbViewName, BOSObjectType[] types) {
        MetaDataBriefViewFilter filter = new MetaDataBriefViewFilter();
        filter.setViewName(mdbViewName);
        if (types != null) {
            for (int i = 0; i < types.length; ++i) {
                filter.addMetaDataTypeFilter(types[i]);
            }
        }
        return filter;
    }

    private static MetaDataBriefViewFilter getFilterByName(String mdbViewName, BOSObjectType type) {
        return SubSystemCommonUtils.getFilterByName(mdbViewName, new BOSObjectType[]{type});
    }

    public static MetaDataBriefViewFilter getGeneratedSubSystemFilter() {
        MetaDataBriefViewFilter filter = SubSystemCommonUtils.getSubSystemFilter();
        filter.addMetaDataTypeFilter(MetaDataTypeList.ENTITY);
        filter.addMetaDataTypeFilter(MetaDataTypeList.FACADE);
        filter.addMetaDataTypeFilter(MetaDataTypeList.UIOBJECT);
        filter.addMetaDataTypeFilter(MetaDataTypeList.DATATABLE);
        filter.addMetaDataTypeFilter(MetaDataTypeList.JOINQUERY);
        filter.addMetaDataTypeFilter(MetaDataTypeList.FUNCTION);
        filter.setPackagePrefix("com.kingdee.eas");
        return filter;
    }

    private static MetaDataBriefViewFilter getSubSystemFilter() {
        MetaDataBriefViewFilter filter = new MetaDataBriefViewFilter();
        filter.setViewName(BASE_MDB_VIEW_NAME);
        filter.setPackagePrefix("com.kingdee.eas");
        filter.addMetaDataTypeFilter(MetaDataTypeList.PACKAGE);
        return filter;
    }

    private static MetaDataBriefViewFilter getFacadeFilter() {
        MetaDataBriefViewFilter filter = SubSystemCommonUtils.getSubSystemFilter();
        filter.addMetaDataTypeFilter(MetaDataTypeList.FACADE);
        return filter;
    }

    private static MetaDataBriefViewFilter getUIFilter() {
        MetaDataBriefViewFilter filter = SubSystemCommonUtils.getSubSystemFilter();
        filter.addMetaDataTypeFilter(MetaDataTypeList.UIOBJECT);
        return filter;
    }

    private static MetaDataBriefViewFilter getEntityFilter(ExtendedPropertyFilter[] extfilters, String baseEntityFullName) {
        MetaDataBriefViewFilter filter = SubSystemCommonUtils.getSubSystemFilter();
        filter.addMetaDataTypeFilter(MetaDataTypeList.ENTITY);
        if (extfilters != null) {
            for (int i = 0; i < extfilters.length; ++i) {
                filter.addExtendedPropertyFilter(extfilters[i]);
            }
        }
        if (baseEntityFullName != null) {
            filter.setEntityChainFilter(baseEntityFullName);
        }
        return filter;
    }

    private static MetaDataBriefViewFilter getEntityFilter() {
        return SubSystemCommonUtils.getEntityFilter(null, null);
    }

    private static MetaDataBriefViewFilter getFilter(BOSObjectType type) {
        return SubSystemCommonUtils.getFilter(new BOSObjectType[]{type});
    }

    private static MetaDataBriefViewFilter getFilter(BOSObjectType[] types) {
        MetaDataBriefViewFilter filter = new MetaDataBriefViewFilter();
        filter.setViewName(BASE_MDB_VIEW_NAME);
        if (types != null) {
            for (int i = 0; i < types.length; ++i) {
                filter.addMetaDataTypeFilter(types[i]);
            }
        }
        return filter;
    }

    private static IBriefViewTreeNode getIBriefViewTreeNode(MetaDataBriefViewFilter filter) {
        return SubSystemCommonUtils.getIBriefViewTreeNode(null, filter);
    }

    private static IBriefViewTreeNode getIBriefViewTreeNode(Context ctx, MetaDataBriefViewFilter filter) {
        return SubSystemCommonUtils.getBusinessObjectBriefView(ctx, filter.getViewName()).getViewRootByType(filter.getMetaDataTypeFilters());
    }

    public static IBriefViewTreeNode getBaseSubSystem(BOSObjectType[] types) {
        return SubSystemCommonUtils.getIBriefViewTreeNode(SubSystemCommonUtils.getFilter(types));
    }

    public static IBriefViewTreeNode getBaseSubSystem(BOSObjectType type) {
        return SubSystemCommonUtils.getIBriefViewTreeNode(SubSystemCommonUtils.getFilter(type));
    }

    public static IBriefViewTreeNode getSubSystem() {
        return SubSystemCommonUtils.getIBriefViewTreeNode(SubSystemCommonUtils.getSubSystemFilter());
    }

    public static IBriefViewTreeNode getEntityTree() {
        return SubSystemCommonUtils.getIBriefViewTreeNode(SubSystemCommonUtils.getEntityFilter());
    }

    public static IBriefViewTreeNode getFacadeTree() {
        return SubSystemCommonUtils.getIBriefViewTreeNode(SubSystemCommonUtils.getFacadeFilter());
    }

    public static IBriefViewTreeNode getUITree() {
        return SubSystemCommonUtils.getIBriefViewTreeNode(SubSystemCommonUtils.getUIFilter());
    }

    public static IBriefViewTreeNode getSubSystemByName(String mdbViewName, BOSObjectType[] types) {
        return SubSystemCommonUtils.getSubSystemByName(null, mdbViewName, types);
    }

    public static IBriefViewTreeNode getSubSystemByName(Context ctx, String mdbViewName, BOSObjectType[] types) {
        return SubSystemCommonUtils.getIBriefViewTreeNode(ctx, SubSystemCommonUtils.getFilterByName(mdbViewName, types));
    }

    public static IBriefViewTreeNode getSubSystemByName(String mdbViewName, BOSObjectType type) {
        return SubSystemCommonUtils.getIBriefViewTreeNode(SubSystemCommonUtils.getFilterByName(mdbViewName, type));
    }

    public static IBriefViewTreeNode getSubSystemByName(String mdbViewName) {
        return SubSystemCommonUtils.getIBriefViewTreeNode(SubSystemCommonUtils.getFilterByName(mdbViewName));
    }

    public static IBriefViewTreeNode getSubSystemByName(Context ctx, String mdbViewName) {
        return SubSystemCommonUtils.getIBriefViewTreeNode(ctx, SubSystemCommonUtils.getFilterByName(mdbViewName));
    }

    public static IBriefViewTreeNode getStandardSubSystemByName(String mdbViewName) {
        return SubSystemCommonUtils.getStandardBusinessObjectBriefView(null, mdbViewName).getViewRootByType(SubSystemCommonUtils.getFilterByName(mdbViewName).getMetaDataTypeFilters());
    }

    public static EntityObjectInfo getEntityObjectInfo(MetaDataBriefInfo info) {
        if (!info.getMetaDataType().equals((Object)MetaDataTypeList.ENTITY)) {
            return null;
        }
        IMetaDataPK pk = info.getMetaDataPK();
        return SubSystemCommonUtils.getMetaDataLoader().getEntity(pk);
    }

    public static PropertyCollection getProperties(MetaDataBriefInfo info) {
        if (!info.getMetaDataType().equals((Object)MetaDataTypeList.ENTITY)) {
            return null;
        }
        IMetaDataPK pk = info.getMetaDataPK();
        return SubSystemCommonUtils.getMetaDataLoader().getEntity(pk).getProperties();
    }

    public static String getExtendPropertyValue(MetaDataBriefInfo info, String propertyKey) {
        if (!info.getMetaDataType().equals((Object)MetaDataTypeList.ENTITY)) {
            return null;
        }
        IMetaDataPK pk = info.getMetaDataPK();
        return SubSystemCommonUtils.getMetaDataLoader().getEntity(pk).getExtendedProperty(propertyKey);
    }

    private static DefaultKingdeeTreeNode getNode(IBriefViewTreeNode node) {
        DefaultKingdeeTreeNode newNode = new DefaultKingdeeTreeNode();
        newNode.setText(node.getAlias());
        newNode.setUserObject((Object)node.getMetaDataObjectBriefInfo());
        return newNode;
    }

    public static DefaultKingdeeTreeNode getKDTreeNode_new(IBriefViewTreeNode root) {
        if (root.getChildCount() == 0) {
            return SubSystemCommonUtils.getNode(root);
        }
        DefaultKingdeeTreeNode newRoot = SubSystemCommonUtils.getNode(root);
        IBriefViewTreeNode node = null;
        for (int i = 0; i < root.getChildCount(); ++i) {
            node = (IBriefViewTreeNode)root.getChildAt(i);
            newRoot.add((MutableTreeNode)SubSystemCommonUtils.getKDTreeNode(node));
        }
        return newRoot;
    }

    public static DefaultKingdeeTreeNode getKDTreeNode(IBriefViewTreeNode root) {
        return SubSystemCommonUtils.doAfterTreeCreated(SubSystemCommonUtils.getKDTreeNodeAfterHandle(root));
    }

    private static DefaultKingdeeTreeNode doAfterTreeCreated(DefaultKingdeeTreeNode root) {
        String calName = "com.kingdee.eas.scm.cal";
        String fiName = "com.kingdee.eas.fi";
        String faName = "com.kingdee.eas.fi.fa";
        String lcmName = "com.kingdee.eas.fi.lcm";
        String fxName = "com.kingdee.eas.am";
        DefaultKingdeeTreeNode calNode = null;
        DefaultKingdeeTreeNode fiNode = null;
        DefaultKingdeeTreeNode faNode = null;
        DefaultKingdeeTreeNode lcmNode = null;
        DefaultKingdeeTreeNode fxNode = null;
        boolean hasFiNode = false;
        boolean hasCalNode = false;
        boolean hasFxNode = false;
        boolean hasFaNode = false;
        boolean hasLcmNode = false;
        DefaultKingdeeTreeNode aNode = null;
        MetaDataBriefInfo mdbi = null;
        String pkgName = "";
        Enumeration enu = root.breadthFirstEnumeration();
        while (enu.hasMoreElements()) {
            aNode = (DefaultKingdeeTreeNode)enu.nextElement();
            mdbi = (MetaDataBriefInfo)aNode.getUserObject();
            if (!mdbi.isPackage()) continue;
            pkgName = mdbi.getPackgeName().trim();
            if (pkgName.equals("com.kingdee.eas.fi")) {
                fiNode = aNode;
                hasFiNode = true;
                if (!hasFiNode || !hasCalNode || !hasFaNode || !hasLcmNode || !hasFxNode) continue;
                break;
            }
            if (pkgName.equals("com.kingdee.eas.scm.cal")) {
                calNode = aNode;
                hasCalNode = true;
                if (!hasFiNode || !hasCalNode || !hasFaNode || !hasLcmNode || !hasFxNode) continue;
                break;
            }
            if (pkgName.equals("com.kingdee.eas.fi.fa")) {
                faNode = aNode;
                hasFaNode = true;
                if (!hasFiNode || !hasCalNode || !hasFaNode || !hasLcmNode || !hasFxNode) continue;
                break;
            }
            if (pkgName.equals("com.kingdee.eas.fi.lcm")) {
                lcmNode = aNode;
                hasLcmNode = true;
                if (!hasFiNode || !hasCalNode || !hasFaNode || !hasLcmNode || !hasFxNode) continue;
                break;
            }
            if (!pkgName.equals("com.kingdee.eas.am")) continue;
            fxNode = aNode;
            hasFxNode = true;
            if (!hasFiNode || !hasCalNode || !hasFaNode || !hasLcmNode || !hasFxNode) continue;
        }
        if (hasFiNode && hasCalNode) {
            if (null != calNode) {
                calNode.removeFromParent();
            }
            if (null != fiNode) {
                fiNode.add(calNode);
            }
        }
        if (hasFxNode && hasFaNode) {
            if (null != faNode) {
                faNode.removeFromParent();
            }
            if (null != fxNode) {
                fxNode.add(faNode);
            }
        }
        if (hasFxNode && hasLcmNode) {
            if (null != lcmNode) {
                lcmNode.removeFromParent();
            }
            if (null != fxNode) {
                fxNode.add(lcmNode);
            }
        }
        return root;
    }

    public static DefaultKingdeeTreeNode getKDTreeNodeAfterHandle(IBriefViewTreeNode root) {
        if (root.getChildCount() == 0) {
            return SubSystemCommonUtils.getNode(root);
        }
        DefaultKingdeeTreeNode newRoot = SubSystemCommonUtils.getNode(root);
        IBriefViewTreeNode node = null;
        for (int i = 0; i < root.getChildCount(); ++i) {
            node = (IBriefViewTreeNode)root.getChildAt(i);
            newRoot.add((MutableTreeNode)SubSystemCommonUtils.getKDTreeNodeAfterHandle(node));
        }
        return newRoot;
    }

    public static String getSubSystemName(String fullName) {
        return SubSystemCommonUtils.getSubSystemName(fullName, null);
    }

    public static String getSubSystemName(String fullName, String mdbViewName) {
        MetaDataBriefInfo info;
        if (mdbViewName == null) {
            mdbViewName = BASE_MDB_VIEW_NAME;
        }
        if ((info = SubSystemCommonUtils.getMetaDataBriefInfoByFullName(SubSystemCommonUtils.getParentFullName(fullName), mdbViewName)) == null) {
            return null;
        }
        if (info.getAlias() != null && info.getAlias().trim().length() > 0) {
            return info.getAlias();
        }
        return info.getName();
    }

    public static String getAncestorSubSystemName(String fullName, String mdbViewName) {
        String fullpath;
        MetaDataBriefInfo info;
        if (mdbViewName == null) {
            mdbViewName = BASE_MDB_VIEW_NAME;
        }
        if ((info = SubSystemCommonUtils.getMetaDataBriefInfoByFullName(fullpath = SubSystemCommonUtils.getParentFullName(fullName), mdbViewName)) == null) {
            if ("com.kingdee.eas".equals(fullpath) || fullpath.indexOf(".") == -1) {
                return null;
            }
            return SubSystemCommonUtils.getAncestorSubSystemName(fullpath, mdbViewName);
        }
        if (info.getAlias() != null && info.getAlias().trim().length() > 0) {
            return info.getAlias();
        }
        return info.getName();
    }

    private static String getParentFullName(String name) {
        String sourceName = name;
        if (name.indexOf(".app.") >= 0) {
            name = name.substring(0, name.indexOf(".app."));
        } else if (name.indexOf(".client.") >= 0) {
            name = name.substring(0, name.indexOf(".client."));
        } else if (name.indexOf(".") != -1) {
            name = name.substring(0, name.lastIndexOf("."));
        }
        logger.info((Object)("name : " + sourceName));
        logger.info((Object)("parent name : " + name));
        return name;
    }

    private static boolean isAvaliablePackage(MetaDataBriefInfo info) {
        if (!info.getMetaDataType().equals((Object)MetaDataTypeList.PACKAGE)) {
            return false;
        }
        if (info.getPackgeName() == null) {
            return false;
        }
        String[] strs = info.getPackgeName().split("\\.");
        if (strs.length >= 5) {
            return info.getPackgeName().indexOf(".app") < 0 && info.getPackgeName().indexOf(".client") < 0;
        }
        return false;
    }

    private static BusinessObjectBriefView getCustomerBusinessObjectBriefView(Context ctx, String mdbViewName) {
        BusinessObjectBriefView retView = null;
        try {
            if (UserCustomSubSystem.startUserCustom((Context)ctx, (String)mdbViewName)) {
                retView = UserCustomSubSystem.getSubSystemByName((Context)ctx, (String)mdbViewName);
            }
        }
        catch (EASBizException e) {
            logger.error((Object)"", (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
        }
        return retView;
    }

    private static BusinessObjectBriefView getStandardBusinessObjectBriefView(Context ctx, String mdbViewName) {
        BusinessObjectBriefView retView = SubSystemCommonUtils.getMetaDataLoader(ctx).getBusinessObjectBriefView((IMetaDataPK)new MetaDataPK(null, mdbViewName));
        return retView;
    }

    private static BusinessObjectBriefView getBusinessObjectBriefView(Context ctx, String mdbViewName) {
        BusinessObjectBriefView retView = SubSystemCommonUtils.getCustomerBusinessObjectBriefView(ctx, mdbViewName);
        if (retView == null) {
            retView = SubSystemCommonUtils.getStandardBusinessObjectBriefView(ctx, mdbViewName);
        }
        return retView;
    }

    public static MetaDataBriefCollection getSubSystemCollection(String mdbViewName) {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)SubSystemCommonUtils.getBusinessObjectBriefView(null, mdbViewName).getViewRoot();
        Enumeration<TreeNode> enums = root.breadthFirstEnumeration();
        MetaDataBriefInfo info = null;
        MetaDataBriefCollection c = new MetaDataBriefCollection();
        while (enums.hasMoreElements()) {
            info = ((IBriefViewTreeNode)enums.nextElement()).getMetaDataObjectBriefInfo();
            if (!SubSystemCommonUtils.isAvaliablePackage(info)) continue;
            c.add(info);
        }
        return c;
    }

    public static MetaDataBriefInfo getMetaDataBriefInfoByFullName(String fullName) {
        return SubSystemCommonUtils.getMetaDataBriefInfoByFullName(fullName, null);
    }

    public static MetaDataBriefInfo getMetaDataBriefInfoByFullName(String fullName, String mdbViewName) {
        if (mdbViewName == null) {
            mdbViewName = BASE_MDB_VIEW_NAME;
        }
        Context ctx = new Context();
        ctx.put((Object)"METADATAPATH", (Object)SubSystemCommonUtils.getMetaDataPath());
        BusinessObjectBriefView view = SubSystemCommonUtils.getMetaDataLoader().getBusinessObjectBriefView((IMetaDataPK)new MetaDataPK(null, mdbViewName));
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)view.getViewRoot();
        Enumeration<TreeNode> enums = root.breadthFirstEnumeration();
        MetaDataBriefInfo info = null;
        while (enums.hasMoreElements()) {
            info = ((IBriefViewTreeNode)enums.nextElement()).getMetaDataObjectBriefInfo();
            if (info == null) continue;
            if (info.getMetaDataType().equals((Object)MetaDataTypeList.PACKAGE) && info.getPackgeName() != null && info.getPackgeName().equals(fullName)) {
                return info;
            }
            if (!info.getFullName().equals(fullName)) continue;
            return info;
        }
        return null;
    }

    public static IBriefViewTreeNode getRemoveEmptyPackageNode(IBriefViewTreeNode root) {
        SubSystemCommonUtils.removeEmptyPackageNode(root);
        return root;
    }

    private static void removeEmptyPackageNode(IBriefViewTreeNode root) {
        IBriefViewTreeNode node = null;
        if (root.getChildCount() > 0) {
            for (int i = root.getChildCount() - 1; i >= 0; --i) {
                node = (IBriefViewTreeNode)root.getChildAt(i);
                SubSystemCommonUtils.removeEmptyPackageNode(node);
                if (node.getChildCount() != 0 || !node.getMetaDataType().equals((Object)MetaDataTypeList.PACKAGE)) continue;
                root.remove((MutableTreeNode)node);
            }
        }
    }

    public static MetaDataBriefCollection getSubSystemCollection() {
        return SubSystemCommonUtils.getSubSystemCollection(BASE_MDB_VIEW_NAME);
    }
}

