/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.eas.base.permission.app.AbstractAuthenSchemeControllerBean;
import com.kingdee.eas.base.permission.app.RemoveAuthenSchemeManager;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class AuthenSchemeControllerBean
extends AbstractAuthenSchemeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.permission.app.AuthenSchemeControllerBean");

    @Override
    protected IObjectPK[] _delete(Context ctx, FilterInfo filter) throws BOSException, EASBizException {
        IObjectPK[] authenSchemePKs = super._delete(ctx, filter);
        this.removeAuthenScheme(ctx, authenSchemePKs);
        return authenSchemePKs;
    }

    @Override
    protected IObjectPK[] _delete(Context ctx, String oql) throws BOSException, EASBizException {
        IObjectPK[] authenSchemePKs = super._delete(ctx, oql);
        this.removeAuthenScheme(ctx, authenSchemePKs);
        return authenSchemePKs;
    }

    @Override
    protected void _delete(Context ctx, IObjectPK[] arrayPK) throws BOSException, EASBizException {
        super._delete(ctx, arrayPK);
        this.removeAuthenScheme(ctx, arrayPK);
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        super._delete(ctx, pk);
        this.removeAuthenScheme(ctx, new IObjectPK[]{pk});
    }

    private void removeAuthenScheme(Context ctx, IObjectPK[] authenSchemePKs) throws BOSException {
        if (authenSchemePKs == null || authenSchemePKs.length == 0) {
            return;
        }
        Connection con = null;
        try {
            con = EJBFactory.getConnection((Context)ctx);
            RemoveAuthenSchemeManager removeAuthenSchemeManager = RemoveAuthenSchemeManager.getInstance();
            for (IObjectPK authenSchemePK : authenSchemePKs) {
                removeAuthenSchemeManager.cleanAboutAuthenScheme(con, authenSchemePK.toString());
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)con);
        }
    }
}

