/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.permission.EasXtException;
import com.kingdee.eas.base.permission.XtLogFacadeFactory;
import com.kingdee.eas.base.permission.app.AbstractEasXtSyncFacadeControllerBean;
import com.kingdee.eas.base.permission.util.EasXtSyncUtil;
import com.kingdee.eas.base.permission.util.XtCommunicateUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.io.Serializable;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class EasXtSyncFacadeControllerBean
extends AbstractEasXtSyncFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.permission.app.EasXtSyncFacadeControllerBean");
    private static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionResource";
    private final String DbTypeMSSQLServer = "MS SQL Server";

    @Override
    protected void _check(Context ctx) throws BOSException {
        this.updateUserStatus(ctx);
        this.updateUserMapByPersonNotInServ(ctx);
        this.updateUserInfo(ctx);
        this.fillUserId(ctx);
        this.insertNewPersonToMap(ctx);
        this.updateSynchStatus(ctx);
        this.updateXtUser(ctx);
    }

    private void fillUserId(Context ctx) throws BOSException {
        long t1 = System.currentTimeMillis();
        String sql = EasXtSyncUtil.getInstance().getValue("fillUserId");
        logger.error((Object)("*****fillUserId***" + sql));
        DbUtil.execute((Context)ctx, (String)sql);
        logger.error((Object)("*****fillUserId cost***" + (System.currentTimeMillis() - t1)));
    }

    @Override
    protected void _updateXtUser(Context ctx) throws BOSException {
        String lastCheckTime = this.getLastCheckTime(ctx);
        int start = 0;
        int length = 1000;
        JSONArray array = new JSONArray();
        JSONArray totalArray = new JSONArray();
        String checkTime = null;
        int count = 0;
        try {
            while (true) {
                JSONObject response;
                if (!(response = XtCommunicateUtil.getDataAfterCheckTime(lastCheckTime, start, length)).getBooleanValue("success")) {
                    if (300 == response.getIntValue("errorCode") || 301 == response.getIntValue("errorCode")) {
                        throw new EasXtException(EasXtException.OPENCLOUD);
                    }
                    throw new BOSException(response.getString("error"));
                }
                array = response.getJSONArray("data");
                if (array != null) {
                    logger.error((Object)(this.getCurTime() + "***\u83b7\u53d6\u4e91\u4e4b\u5bb6\u6570\u636e**** array.size : " + array.size()));
                } else {
                    logger.error((Object)(this.getCurTime() + "***\u83b7\u53d6\u4e91\u4e4b\u5bb6\u6570\u636e**** array is null"));
                }
                checkTime = (String)response.get((Object)"curTime");
                if (array != null && array.size() != 0) {
                    totalArray.addAll((Collection)array);
                    if (count <= 29) {
                        ++count;
                        start += length;
                        continue;
                    }
                }
                break;
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException(e.getMessage());
        }
        if (totalArray != null) {
            logger.error((Object)(this.getCurTime() + "***\u83b7\u53d6\u4e91\u4e4b\u5bb6\u6570\u636e**** totalArray.size : " + totalArray.size()));
        } else {
            logger.error((Object)(this.getCurTime() + "***\u83b7\u53d6\u4e91\u4e4b\u5bb6\u6570\u636e**** totalArray is null "));
        }
        if (EasXtSyncUtil.getInstance().isFirstCheck(lastCheckTime)) {
            this.clearXtUserDatas(ctx);
            this.insertIntoXtTable(ctx, totalArray);
        } else {
            this.clearXtUserDatas(ctx, totalArray);
            this.insertIntoXtTable(ctx, totalArray);
        }
        this.insertCheckTime(ctx, checkTime);
    }

    private void insertIntoXtTable(Context ctx, JSONArray totalArray) throws BOSException {
        String sql = EasXtSyncUtil.getInstance().getValue("insertIntoXtTable");
        ArrayList<String> ids = new ArrayList<String>();
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        ArrayList<Object> param = null;
        for (int i = 0; i < totalArray.size(); ++i) {
            JSONObject json = totalArray.getJSONObject(i);
            if (StringUtils.isEmpty((String)json.getString("openId")) || StringUtils.isEmpty((String)json.getString("name")) || ids.contains(json.getString("openId"))) continue;
            ids.add(json.getString("openId"));
            param = new ArrayList<Object>();
            param.add(json.getString("openId"));
            param.add(json.getString("name"));
            String phone = json.getString("phone");
            if (phone == null || "".equals(phone.trim()) || "null".equalsIgnoreCase(phone)) {
                param.add(null);
            } else {
                param.add(phone);
            }
            String department = json.getString("department");
            if (department == null || "".equals(department.trim()) || "null".equalsIgnoreCase(department)) {
                param.add(null);
            } else {
                param.add(department);
            }
            String jobTitle = json.getString("jobTitle");
            if (jobTitle == null || "".equals(jobTitle.trim()) || "null".equalsIgnoreCase(jobTitle)) {
                param.add(null);
            } else {
                param.add(jobTitle);
            }
            String email = json.getString("email");
            if (email == null || "".equals(email.trim()) || "null".equalsIgnoreCase(email)) {
                param.add(null);
            } else {
                param.add(email);
            }
            param.add(json.getInteger("status"));
            params.add(param.toArray());
        }
        logger.error((Object)(this.getCurTime() + "---------\u5168\u90e8\u63d2\u5165\u8baf\u901a\u8868----------"));
        logger.error((Object)(this.getCurTime() + " SQL: " + sql));
        logger.error((Object)(this.getCurTime() + " params " + params == null ? 0 : params.size()));
        DbUtil.executeBatch((Context)ctx, (String)sql, params);
        logger.error((Object)(this.getCurTime() + "---------\u5168\u90e8\u63d2\u5165\u8baf\u901a\u8868\u6210\u529f----------"));
    }

    private void clearXtUserDatas(Context ctx) throws BOSException {
        String sql = "delete from t_xt_user";
        DbUtil.execute((Context)ctx, (String)sql);
    }

    private void clearXtUserDatas(Context ctx, JSONArray totalArray) throws BOSException {
        if (totalArray == null || totalArray.size() == 0) {
            return;
        }
        ArrayList<String> ids = new ArrayList<String>();
        for (int i = 0; i < totalArray.size(); ++i) {
            JSONObject json = totalArray.getJSONObject(i);
            if (StringUtils.isEmpty((String)json.getString("openId"))) continue;
            String openId = json.getString("openId");
            ids.add(openId);
            if (ids.size() % 500 != 0) continue;
            this.deleteXtUser(ctx, ids);
            ids = new ArrayList();
        }
        if (ids.size() > 0) {
            this.deleteXtUser(ctx, ids);
        }
    }

    private void deleteXtUser(Context ctx, List ids) throws BOSException {
        String sql = "delete from t_xt_user where fid in ";
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < ids.size(); ++i) {
            sb.append("'").append(ids.get(i)).append("',");
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        DbUtil.execute((Context)ctx, (String)new StringBuffer(sql).append("(").append(sb).append(")").toString());
    }

    private void insertCheckTime(Context ctx, String curTime) throws BOSException {
        if (StringUtils.isEmpty((String)curTime)) {
            long time = new Date().getTime();
            Timestamp checktime = new Timestamp(time);
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            curTime = formatter.format(checktime);
        }
        String sql = "insert into T_XT_CHECKTIME (fid,fchecktime) select newbosid('F4AF4F04'),{ts'" + curTime + "'}";
        DbUtil.execute((Context)ctx, (String)sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getLastCheckTime(Context ctx) throws BOSException {
        String sql = "select max(fchecktime) from t_xt_checktime";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            if (rs.next()) {
                Timestamp checktime = rs.getTimestamp(1);
                if (checktime == null) {
                    String string = "1900-01-01 01:01:01";
                    return string;
                }
                SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String string = formatter.format(checktime);
                return string;
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        return "1900-01-01 01:01:01";
    }

    private void updateSynchStatus(Context ctx) throws BOSException {
        long t1 = System.currentTimeMillis();
        String sql = EasXtSyncUtil.getInstance().getValue("canSyncWithCellNotNull");
        logger.error((Object)("**canSyncWithCellNotNull***" + sql));
        DbUtil.execute((Context)ctx, (String)sql);
        logger.error((Object)("**canSyncWithCellNotNull cost***" + (System.currentTimeMillis() - t1)));
        long t2 = System.currentTimeMillis();
        sql = EasXtSyncUtil.getInstance().getValue("canSyncWithCellNotRepeat");
        logger.error((Object)("**canSyncWithCellNotRepeat***" + sql));
        DbUtil.execute((Context)ctx, (String)sql);
        logger.error((Object)("**canSyncWithCellNotRepeat cost***" + (System.currentTimeMillis() - t2)));
        long t3 = System.currentTimeMillis();
        sql = EasXtSyncUtil.getInstance().getValue("cantSyncWithCellNull");
        logger.error((Object)("**cantSyncWithCellNull***" + sql));
        DbUtil.execute((Context)ctx, (String)sql);
        logger.error((Object)("**cantSyncWithCellNull cost***" + (System.currentTimeMillis() - t3)));
        long t4 = System.currentTimeMillis();
        sql = EasXtSyncUtil.getInstance().getValue("cantSyncWithCellRepeat");
        logger.error((Object)("**cantSyncWithCellRepeat***" + sql));
        DbUtil.execute((Context)ctx, (String)sql);
        logger.error((Object)("**cantSyncWithCellRepeat cost***" + (System.currentTimeMillis() - t4)));
        long t5 = System.currentTimeMillis();
        sql = EasXtSyncUtil.getInstance().getValue("cantSyncWithNoInservice");
        logger.error((Object)("**cantSyncWithNoInservice***" + sql));
        DbUtil.execute((Context)ctx, (String)sql);
        logger.error((Object)("**cantSyncWithNoInservice cost***" + (System.currentTimeMillis() - t5)));
    }

    private void insertNewPersonToMap(Context ctx) throws BOSException {
        long t1 = System.currentTimeMillis();
        String sql = EasXtSyncUtil.getInstance().getValue("insertNewPersonToMap");
        logger.error((Object)("*****insertNewPersonToMap******" + sql));
        DbUtil.execute((Context)ctx, (String)sql);
        logger.error((Object)("*****insertNewPersonToMap cost ******" + (System.currentTimeMillis() - t1)));
    }

    private void updateUserInfo(Context ctx) throws BOSException {
        long t1 = System.currentTimeMillis();
        String sql = EasXtSyncUtil.getInstance().getValue("updateUserCell");
        logger.error((Object)("*****updateUserCell***" + sql));
        DbUtil.execute((Context)ctx, (String)sql);
        logger.error((Object)("*****updateUserCell cost ***" + (System.currentTimeMillis() - t1)));
        long t2 = System.currentTimeMillis();
        sql = EasXtSyncUtil.getInstance().getValue("updateUserEmail");
        logger.error((Object)("*****updateUserEmail***" + sql));
        DbUtil.execute((Context)ctx, (String)sql);
        logger.error((Object)("*****updateUserEmail cost ***" + (System.currentTimeMillis() - t2)));
        long t3 = System.currentTimeMillis();
        sql = EasXtSyncUtil.getInstance().getValue("updateUserPosition");
        logger.error((Object)("*****updateUserPosition***" + sql));
        DbUtil.execute((Context)ctx, (String)sql);
        logger.error((Object)("*****updateUserPosition cost ***" + (System.currentTimeMillis() - t3)));
        long t4 = System.currentTimeMillis();
        sql = EasXtSyncUtil.getInstance().getValue("updateUserOrg");
        logger.error((Object)("*****updateUserOrg***" + sql));
        DbUtil.execute((Context)ctx, (String)sql);
        logger.error((Object)("*****updateUserOrg cost ***" + (System.currentTimeMillis() - t4)));
        long t5 = System.currentTimeMillis();
        sql = EasXtSyncUtil.getInstance().getValue("updateUserName");
        logger.error((Object)("*****updateUserName***" + sql));
        DbUtil.execute((Context)ctx, (String)sql);
        logger.error((Object)("*****updateUserName cost ***" + (System.currentTimeMillis() - t5)));
    }

    private void updateUserMapByPersonNotInServ(Context ctx) throws BOSException {
        long t1 = System.currentTimeMillis();
        String sql = EasXtSyncUtil.getInstance().getValue("updateDeletedUserMap");
        logger.error((Object)("*****updateDeletedUserMap***" + sql));
        logger.error((Object)("sql: " + sql));
        if (!StringUtils.isEmpty((String)sql)) {
            DbUtil.execute((Context)ctx, (String)sql);
        }
        logger.error((Object)("*****updateDeletedUserMap cost***" + (System.currentTimeMillis() - t1)));
    }

    private void updateUserStatus(Context ctx) throws BOSException {
        long t1 = System.currentTimeMillis();
        String sql = EasXtSyncUtil.getInstance().getValue("updateUserStatus");
        logger.error((Object)("*****updateUserStatus***" + sql));
        DbUtil.execute((Context)ctx, (String)sql);
        logger.error((Object)("*****updateUserStatus cost***" + (System.currentTimeMillis() - t1)));
        long t2 = System.currentTimeMillis();
        String sql2 = EasXtSyncUtil.getInstance().getValue("updateUserStatus2");
        logger.error((Object)("*****updateUserStatus2**" + sql2));
        DbUtil.execute((Context)ctx, (String)sql2);
        logger.error((Object)("*****updateUserStatus2 cost***" + (System.currentTimeMillis() - t2)));
    }

    private void sync(Context ctx) throws BOSException, EasXtException {
        this.syncAddNewOrgInfo(ctx);
        this.updateXtByOrg(ctx);
        this.syncPersonInfo(ctx);
        this.insertsynchTime(ctx);
        this.updateXtUser(ctx);
    }

    private void insertsynchTime(Context ctx) throws BOSException {
        logger.error((Object)"---------------\u66f4\u65b0\u540c\u6b65\u65f6\u95f4---------------");
        String sql = "insert into t_xt_synchtime (fid,fsynchtime) select newbosid('F4AF4F04'),now()";
        DbUtil.execute((Context)ctx, (String)sql);
    }

    private void syncPersonInfo(Context ctx) throws BOSException {
        this.syncAddNewPersonInfo(ctx);
        this.syncDeletePersonInfo(ctx);
        this.syncUpdatePersonInfo(ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncUpdatePersonInfo(Context ctx, JSONArray dataArray, JSONArray logArray) throws BOSException {
        Map logIdMap = XtLogFacadeFactory.getLocalInstance(ctx).updatePersonInfo(logArray);
        boolean isAll = true;
        String description = EASResource.getString((String)RESOURCE, (String)"CLOUD_HUB_EXCEPTION");
        JSONArray result = new JSONArray();
        logger.error((Object)("*****syncUpdatePersonInfo****" + dataArray));
        try {
            JSONObject response = XtCommunicateUtil.syncUpdatePersonInfo(dataArray);
            if (response.getBoolean("success").booleanValue()) {
                logger.error((Object)"******syncUpdatePersonInfo success*****");
                isAll = false;
                result = response.getJSONArray("data");
            } else {
                logger.error((Object)("*******syncUpdatePersonInfo fail************" + response.toString()));
                description = response.getString("error");
                if (300 == response.getIntValue("errorCode") || 301 == response.getIntValue("errorCode")) {
                    throw new EasXtException(EasXtException.OPENCLOUD);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"******syncUpdatePersonInfo exception*****");
            logger.error((Object)e);
        }
        finally {
            this.updateLog(ctx, logIdMap, result, isAll, description);
        }
        EasXtSyncFacadeControllerBean.updateSynchStatusByFail(ctx, result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncUpdatePersonInfo(Context ctx) throws BOSException {
        String sql = EasXtSyncUtil.getInstance().getValue("selectUserChanged");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            boolean isUpdateName = EasXtSyncUtil.getInstance().isUpdateName();
            boolean isUpdateEmail = EasXtSyncUtil.getInstance().isUpdateEmail();
            boolean isUpdatePosition = EasXtSyncUtil.getInstance().isUpdatePosition();
            logger.error((Object)("**isUpdateName=" + isUpdateName));
            logger.error((Object)("**isUpdateEmail=" + isUpdateEmail));
            logger.error((Object)("**isUpdatePosition=" + isUpdatePosition));
            JSONArray dataArray = new JSONArray();
            JSONArray logArray = new JSONArray();
            while (rowSet.next()) {
                JSONObject o = new JSONObject();
                o.put("openId", (Object)rowSet.getString("xtId"));
                if (isUpdateName) {
                    o.put("name", (Object)rowSet.getString("easPersonName"));
                }
                if (isUpdateEmail) {
                    o.put("email", (Object)rowSet.getString("email"));
                }
                if (isUpdatePosition) {
                    o.put("jobTitle", (Object)rowSet.getString("position"));
                }
                o.put("cell", (Object)rowSet.getString("cell"));
                dataArray.add((Object)o);
                JSONObject oLog = new JSONObject();
                oLog.put("openId", (Object)rowSet.getString("xtId"));
                oLog.put("personId", (Object)rowSet.getString("personId"));
                logArray.add((Object)oLog);
                if (dataArray.size() / 500 <= 0) continue;
                this.syncUpdatePersonInfo(ctx, dataArray, logArray);
                logger.error((Object)"****syncUpdatePersonInfo  one more again****");
                dataArray = new JSONArray();
                logArray = new JSONArray();
            }
            if (dataArray.size() > 0) {
                this.syncUpdatePersonInfo(ctx, dataArray, logArray);
                logger.error((Object)"****syncUpdatePersonInfo over****");
                dataArray = new JSONArray();
                logArray = new JSONArray();
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        finally {
            if (rowSet != null) {
                try {
                    rowSet.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncDeletePersonInfo(Context ctx, JSONArray dataArray, JSONArray logArray) throws BOSException {
        Map logIdMap = XtLogFacadeFactory.getLocalInstance(ctx).updatePersonStatus(logArray);
        boolean isAll = true;
        String description = EASResource.getString((String)RESOURCE, (String)"CLOUD_HUB_EXCEPTION");
        JSONArray result = new JSONArray();
        logger.error((Object)("*****deletePerson****" + dataArray));
        try {
            JSONObject response = XtCommunicateUtil.updatePersonStatus(dataArray);
            if (response.getBoolean("success").booleanValue()) {
                logger.error((Object)"******deletePerson success*****");
                isAll = false;
                result = response.getJSONArray("data");
            } else {
                logger.error((Object)("*******deletePerson fail************" + response.toString()));
                description = response.getString("error");
                if (300 == response.getIntValue("errorCode") || 301 == response.getIntValue("errorCode")) {
                    throw new EasXtException(EasXtException.OPENCLOUD);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"******deletePerson exception*****");
            logger.error((Object)e);
        }
        finally {
            this.updateLog(ctx, logIdMap, result, isAll, description);
        }
        EasXtSyncFacadeControllerBean.updateSynchStatusByFail(ctx, result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncDeletePersonInfo(Context ctx) throws BOSException {
        String sql = EasXtSyncUtil.getInstance().getValue("selectDeletedUser");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        JSONArray jsonArray = new JSONArray();
        JSONArray logArray = new JSONArray();
        try {
            while (rowSet.next()) {
                JSONObject o = new JSONObject();
                o.put("openId", (Object)rowSet.getString("xtId"));
                o.put("type", (Object)"1");
                jsonArray.add((Object)o);
                JSONObject oLog = new JSONObject();
                oLog.put("openId", (Object)rowSet.getString("xtId"));
                oLog.put("personId", (Object)rowSet.getString("easPersonId"));
                logArray.add((Object)oLog);
                if (jsonArray.size() / 500 <= 0) continue;
                this.syncDeletePersonInfo(ctx, jsonArray, logArray);
                logger.error((Object)"*******deleteperson one more again*****");
                jsonArray = new JSONArray();
                logArray = new JSONArray();
            }
            if (jsonArray.size() > 0) {
                this.syncDeletePersonInfo(ctx, jsonArray, logArray);
                logger.error((Object)"*******deleteperson over*****");
                jsonArray = new JSONArray();
                logArray = new JSONArray();
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        finally {
            if (rowSet != null) {
                try {
                    rowSet.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        sql = EasXtSyncUtil.getInstance().getValue("deleteBothDeUsers");
        DbUtil.execute((Context)ctx, (String)sql);
        sql = EasXtSyncUtil.getInstance().getValue("deleteUsersWithProblem");
        DbUtil.execute((Context)ctx, (String)sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncAddNewPersonInfo(Context ctx, JSONArray dataArray, JSONArray logArray) throws BOSException {
        Map logIdMap = XtLogFacadeFactory.getLocalInstance(ctx).addPerson(logArray);
        boolean isAll = true;
        String description = EASResource.getString((String)RESOURCE, (String)"CLOUD_HUB_EXCEPTION");
        JSONArray result = new JSONArray();
        if (dataArray != null) {
            logger.error((Object)("*****addnewPerson****" + dataArray.size()));
        } else {
            logger.error((Object)"*****addnewPerson**** dataArray is null");
        }
        try {
            JSONObject response = XtCommunicateUtil.syncAddNewPersonInfo(dataArray);
            if (response.getBoolean("success").booleanValue()) {
                logger.error((Object)"******addnewPerson success*****");
                isAll = false;
                result = response.getJSONArray("data");
                logger.error((Object)("****data********" + result));
            } else {
                logger.error((Object)("*******88addnewperson fail************" + response.toString()));
                description = response.getString("error");
                if (300 == response.getIntValue("errorCode") || 301 == response.getIntValue("errorCode")) {
                    throw new EasXtException(EasXtException.OPENCLOUD);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"******addnewperson exception*****");
            logger.error((Object)e);
        }
        finally {
            this.updateLog(ctx, logIdMap, result, isAll, description);
        }
        EasXtSyncFacadeControllerBean.updateSynchStatusByFail(ctx, result);
    }

    private static void updateSynchStatusByFail(Context ctx, JSONArray result) throws BOSException {
        if (result != null && result.size() > 0) {
            ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
            for (int i = 0; i < result.size(); ++i) {
                JSONObject json = result.getJSONObject(i);
                if (json.getInteger("msgCode") == 209) continue;
                ArrayList<String> paramList = new ArrayList<String>();
                paramList.add(json.getString("msg"));
                paramList.add(json.getString("msgId"));
                paramsList.add(paramList.toArray());
            }
            String sql = EasXtSyncUtil.getInstance().getValue("syncUserInfoFail");
            DbUtil.executeBatch((Context)ctx, (String)sql, paramsList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncAddNewPersonInfo(Context ctx) throws BOSException {
        String sql = EasXtSyncUtil.getInstance().getValue("selectAddNewUserInfo");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        JSONArray jsonArray = new JSONArray();
        JSONArray logArray = new JSONArray();
        try {
            while (rowSet.next()) {
                JSONObject o = new JSONObject();
                o.put("name", (Object)rowSet.getString("easPersonName"));
                o.put("phone", (Object)rowSet.getString("cell"));
                o.put("department", (Object)rowSet.getString("orgLongName"));
                o.put("email", (Object)rowSet.getString("email"));
                o.put("jobTitle", (Object)rowSet.getString("position"));
                jsonArray.add((Object)o);
                JSONObject oLog = new JSONObject();
                oLog.put("personId", (Object)rowSet.getString("personId"));
                oLog.put("phone", (Object)rowSet.getString("cell"));
                logArray.add((Object)oLog);
                if (jsonArray.size() / 500 <= 0) continue;
                this.syncAddNewPersonInfo(ctx, jsonArray, logArray);
                logger.error((Object)"*******addnewperson one more again*****");
                jsonArray = new JSONArray();
                logArray = new JSONArray();
            }
            if (jsonArray.size() > 0) {
                this.syncAddNewPersonInfo(ctx, jsonArray, logArray);
                logger.error((Object)"*******addnewperson over*****");
                jsonArray = new JSONArray();
                logArray = new JSONArray();
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        finally {
            if (rowSet != null) {
                try {
                    rowSet.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void syncAddNewOrgInfo(Context ctx, JSONArray logArray, JSONArray orgArray) throws BOSException, EasXtException {
        logger.error((Object)("*****addNewOrg********" + logArray));
        Map logIdMap = XtLogFacadeFactory.getLocalInstance(ctx).addDept(logArray);
        boolean isAll = true;
        String description = EASResource.getString((String)RESOURCE, (String)"CLOUD_HUB_EXCEPTION");
        JSONArray result = null;
        try {
            JSONObject response = XtCommunicateUtil.syncAddNewOrgInfo(orgArray);
            if (response.getBooleanValue("success")) {
                logger.error((Object)"***addnewOrg  success*********");
                isAll = false;
                result = response.getJSONArray("data");
                logger.error((Object)result);
            } else {
                logger.error((Object)("***addnewOrg  fail*********" + response.toString()));
                description = response.getString("error");
                if (300 == response.getIntValue("errorCode")) throw new EasXtException(EasXtException.OPENCLOUD);
                if (301 == response.getIntValue("errorCode")) {
                    throw new EasXtException(EasXtException.OPENCLOUD);
                }
            }
            this.updateLog(ctx, logIdMap, result, isAll, description);
            return;
        }
        catch (EasXtException e) {
            throw e;
            catch (Exception e2) {
                logger.error((Object)"***addnewOrg  exception*********");
                logger.error((Object)e2);
                return;
            }
        }
        finally {
            this.updateLog(ctx, logIdMap, result, isAll, description);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncAddNewOrgInfo(Context ctx) throws BOSException, EasXtException {
        String sql = EasXtSyncUtil.getInstance().getValue("selectAddNewOrgInfo");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        JSONArray orgArray = new JSONArray();
        JSONArray logArray = new JSONArray();
        try {
            while (rowSet.next()) {
                if (rowSet.getString(1) == null) continue;
                orgArray.add((Object)rowSet.getString(1));
                logArray.add((Object)rowSet.getString(1));
                if (orgArray.size() / 500 <= 0) continue;
                this.syncAddNewOrgInfo(ctx, logArray, orgArray);
                logger.error((Object)"******addNewOrg one more again********");
                orgArray = new JSONArray();
                logArray = new JSONArray();
            }
            if (orgArray.size() > 0) {
                this.syncAddNewOrgInfo(ctx, logArray, orgArray);
                logger.error((Object)"******addNewOrg over********");
                orgArray = new JSONArray();
                logArray = new JSONArray();
            }
        }
        catch (EasXtException e) {
            logger.error((Object)e);
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        finally {
            if (rowSet != null) {
                try {
                    rowSet.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateXtByOrg(Context ctx, JSONArray dataArray, JSONArray logArray) throws BOSException {
        logger.error((Object)("*****updateXtByOrg********" + dataArray));
        Map logIdMap = XtLogFacadeFactory.getLocalInstance(ctx).updatePersonDept(logArray);
        boolean isAll = true;
        String description = EASResource.getString((String)RESOURCE, (String)"CLOUD_HUB_EXCEPTION");
        JSONArray result = null;
        try {
            logger.error((Object)("*****updateXtByOrg******" + dataArray));
            JSONObject response = XtCommunicateUtil.syncUpdateUserOrgInfo(dataArray);
            if (response.getBooleanValue("success")) {
                logger.error((Object)"***updateXtByOrg  success*********");
                isAll = false;
                result = response.getJSONArray("data");
                logger.error((Object)result);
            } else {
                logger.error((Object)("***updateXtByOrg  fail*********" + response.toString()));
                description = response.getString("error");
                if (300 == response.getIntValue("errorCode") || 301 == response.getIntValue("errorCode")) {
                    throw new EasXtException(EasXtException.OPENCLOUD);
                }
            }
            this.updateLog(ctx, logIdMap, result, isAll, description);
        }
        catch (Exception e) {
            logger.error((Object)"***updateXtByOrg  exception*********");
            logger.error((Object)e);
        }
        finally {
            this.updateLog(ctx, logIdMap, result, isAll, description);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateXtByOrg(Context ctx) throws BOSException {
        if (!EasXtSyncUtil.getInstance().isUpdateOrg()) {
            logger.error((Object)"***isUpdateOrg is false******");
            return;
        }
        logger.error((Object)"***isUpdateOrg is true******");
        String sql = EasXtSyncUtil.getInstance().getValue("selectOrgChanged");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        JSONArray dataArray = new JSONArray();
        JSONArray logArray = new JSONArray();
        try {
            while (rowSet.next()) {
                JSONObject o = new JSONObject();
                o.put("openId", (Object)rowSet.getString("xtId"));
                o.put("department", (Object)rowSet.getString("orgLongName"));
                dataArray.add((Object)o);
                logArray.add((Object)o);
                if (dataArray.size() / 500 <= 0) continue;
                this.updateXtByOrg(ctx, dataArray, logArray);
                logger.error((Object)"******updateXtByOrg one more again********");
                dataArray = new JSONArray();
                logArray = new JSONArray();
            }
            if (dataArray.size() > 0) {
                this.updateXtByOrg(ctx, dataArray, logArray);
                logger.error((Object)"******updateXtByOrg over********");
                dataArray = new JSONArray();
                logArray = new JSONArray();
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        finally {
            if (rowSet != null) {
                try {
                    rowSet.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void clearTemp(Context ctx) throws BOSException {
        String sql = "delete from t_tm_tmp";
        DbUtil.execute((Context)ctx, (String)sql);
    }

    private void bindByNameAndOrg(Context ctx, String bindSql) throws BOSException {
        String sql = EasXtSyncUtil.getInstance().getValue("bindByNameAndOrg");
        DbUtil.execute((Context)ctx, (String)sql);
        DbUtil.execute((Context)ctx, (String)bindSql);
    }

    private void bindByNameAndMail(Context ctx, String bindSql) throws BOSException {
        String sql = EasXtSyncUtil.getInstance().getValue("bindByNameAndMail");
        DbUtil.execute((Context)ctx, (String)sql);
        DbUtil.execute((Context)ctx, (String)bindSql);
    }

    private void bindByNameAndCell(Context ctx, String bindSql) throws BOSException {
        String sql = EasXtSyncUtil.getInstance().getValue("bindByNameAndCell");
        DbUtil.execute((Context)ctx, (String)sql);
        DbUtil.execute((Context)ctx, (String)bindSql);
    }

    @Override
    protected void _syncAndBind(Context ctx) throws BOSException, EASBizException {
        this._autoBind(ctx);
        this.sync(ctx);
        this._autoBind(ctx);
    }

    @Override
    protected void _unBindWithXt(Context ctx, String personID) throws BOSException {
        String sql = "update T_PM_EASXTUSERMAP set fxtid = null where fpersonid in";
        StringBuffer buffer = new StringBuffer();
        personID = personID.replaceAll(",", "','");
        buffer.append("('").append(personID).append("')");
        DbUtil.execute((Context)ctx, (String)(sql + buffer.toString()));
    }

    @Override
    protected void _oneKeyBinding(Context ctx) throws BOSException, EASBizException {
        this.check(ctx);
        this.syncAndBind(ctx);
    }

    protected IRowSet _getRowSetByCondition(Context ctx, String filter, String key, int rowCount, int page) throws BOSException {
        String sql = EasXtSyncUtil.getInstance().getValue(key);
        StringBuffer extraFilter = new StringBuffer();
        if (!StringUtils.isEmpty((String)filter)) {
            extraFilter.append(" and (easxt.fpersonname like '%").append(filter).append("%' or easxt.fcell like '%").append(filter).append("%')");
        }
        return DbUtil.executeQuery((Context)ctx, (String)(sql + extraFilter.toString()), (int)((page - 1) * rowCount), (int)rowCount);
    }

    protected void _clearCheckTime(Context ctx) throws BOSException {
        String sql = "select * from t_xt_checktime order by fchecktime";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            rowSet.next();
            String id = rowSet.getString(1);
            sql = "delete from t_xt_checktime where fid <> '" + id + "'";
            DbUtil.execute((Context)ctx, (String)sql);
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException(e.getMessage());
        }
    }

    protected int _getRowCount(Context ctx, String valueType, String filter) throws BOSException {
        StringBuffer sql = new StringBuffer("select count(*) from (select");
        sql.append(" distinct easxt.fpersonid,easxt.fpersonname,easxt.fcell,easxt.forglongname");
        sql.append(" from T_PM_EASXTUSERMAP easxt");
        if ("unBindDatas".equals(valueType)) {
            sql.append(" where easxt.FxtId is null");
        } else if ("bindDatas".equals(valueType)) {
            sql.append(" inner join t_xt_user xt on easxt.fxtId = xt.fid where easxt.FStatus = 1 and xt.fstatus = 1");
        } else if ("deletedPerson".equals(valueType)) {
            sql.append(" inner join t_xt_user xt on easxt.fxtid = xt.fid where easxt.FStatus = 0 and xt.fstatus =1");
        } else {
            sql.append(" inner join t_xt_user xt on easxt.FXtId = xt.FID where (easxt.FStatus=1 and xt.FStatus=1) and (((easxt.FOrgLongName is not null and xt.FOrgLongName is null) or (easxt.FOrgLongName is not null and xt.FOrgLongName is not null and rtrim(easxt.FOrgLongName)<>rtrim(xt.FOrgLongName)))  or   ((easxt.FPosition is not null and xt.FPosition is null) or (easxt.FPosition is not null and xt.FPosition is not null and rtrim(easxt.FPosition)<>rtrim(xt.FPosition))) or ((easxt.FEMail is not null and xt.FEmail is null) or (easxt.FEMail is not null and xt.FEmail is not null and rtrim(easxt.FEmail)<>rtrim(xt.FEmail))) or((easxt.FPersonName is not null and xt.FPersonName is null) or (easxt.FPersonName is not null and xt.FPersonName is not null and rtrim(easxt.FPersonName)<>rtrim(xt.FPersonName))) or ((easxt.Fcell is not null and xt.Fcell is null) or (easxt.Fcell is not null and xt.Fcell is not null and rtrim(easxt.Fcell)<>rtrim(xt.Fcell))))");
        }
        StringBuffer extraFilter = new StringBuffer();
        if (!StringUtils.isEmpty((String)filter)) {
            extraFilter.append(" and (easxt.fpersonname like '%").append(filter).append("%' or easxt.fcell like '%").append(filter).append("%')");
        }
        sql.append(extraFilter).append(") tmp");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            rowSet.next();
            return rowSet.getInt(1);
        }
        catch (SQLException e) {
            System.out.println(e);
            return 0;
        }
    }

    @Override
    protected void _autoBind(Context ctx) throws BOSException {
        String bindSql = EasXtSyncUtil.getInstance().getValue("bindSql");
        this.bindByNameAndCell(ctx, bindSql);
        this.clearTemp(ctx);
        this.bindByNameAndMail(ctx, bindSql);
        this.clearTemp(ctx);
    }

    protected Map _getSyncSuccessInfo(Context ctx) throws BOSException {
        HashMap map = new HashMap();
        return map;
    }

    @Override
    protected Map _getXtConfig(Context ctx) throws BOSException {
        return EasXtSyncUtil.getInstance().getXtConfig();
    }

    @Override
    protected void _saveXtConfig(Context ctx, Map map, boolean isInit) throws BOSException, EASBizException {
        if (isInit) {
            this.init(ctx);
        }
        EasXtSyncUtil.getInstance().writeXtConfig(map);
        XtCommunicateUtil.resetURL();
    }

    @Override
    protected void _init(Context ctx) throws BOSException, EASBizException {
        String sql1 = "delete from t_pm_easxtusermap";
        String sql2 = "delete from t_xt_log";
        String sql3 = "delete from t_xt_checktime";
        String sql4 = "delete from t_xt_synchtime";
        String sql5 = "delete from t_xt_user";
        DbUtil.execute((Context)ctx, (String)sql1);
        DbUtil.execute((Context)ctx, (String)sql2);
        DbUtil.execute((Context)ctx, (String)sql3);
        DbUtil.execute((Context)ctx, (String)sql4);
        DbUtil.execute((Context)ctx, (String)sql5);
        XtCommunicateUtil.clearKey();
    }

    private void updateLog(Context ctx, Map logIdMap, JSONArray xtIds, boolean isAll, String description) throws BOSException {
        if (isAll) {
            ArrayList logIds = new ArrayList();
            Object[] c = logIdMap.values().toArray();
            for (int i = 0; i < c.length; ++i) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("logId", c[i]);
                map.put("description", description);
                logIds.add(map);
            }
            XtLogFacadeFactory.getLocalInstance(ctx).updateSuccess(logIds);
        } else if (xtIds != null && xtIds.size() > 0) {
            ArrayList logIds = new ArrayList();
            for (int k = 0; k < xtIds.size(); ++k) {
                JSONObject temO = (JSONObject)xtIds.get(k);
                if (temO.getInteger("msgCode") == 209) continue;
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("logId", logIdMap.get(temO.get((Object)"msgId")));
                map.put("description", temO.get((Object)"msg"));
                logIds.add(map);
            }
            XtLogFacadeFactory.getLocalInstance(ctx).updateSuccess(logIds);
        }
    }

    @Override
    protected byte[] _download(Context ctx) throws BOSException {
        return EasXtSyncUtil.getInstance().downloadPdf();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String _getUnBindCloudPerson(Context ctx, String condition) throws BOSException {
        JSONObject o = JSONObject.parseObject((String)condition);
        String filter = o.getString("filter");
        int page = o.getIntValue("page");
        int rowCount = o.getIntValue("rowCount");
        String sql = "select distinct fid ,fpersonName,fCell,forglongname,fposition,femail from t_xt_user where fstatus = 1 and not exists (select fid from t_pm_easxtusermap where fxtId = t_xt_user.fid) ";
        StringBuffer extraFilter = new StringBuffer(sql);
        if (!StringUtils.isEmpty((String)filter)) {
            filter = filter.trim();
            extraFilter.append(" and (fpersonname like '%").append(filter).append("%' or fcell like '%").append(filter).append("%')");
        }
        IRowSet rsCount = DbUtil.executeQuery((Context)ctx, (String)("select count(*) from (" + extraFilter.toString() + ") tmp"));
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)extraFilter.toString(), (int)((page - 1) * rowCount), (int)rowCount);
        ArrayList rows = new ArrayList();
        int total = 0;
        try {
            if (rsCount.next()) {
                total = rsCount.getInt(1);
            }
            while (rs.next()) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("id", rs.getString("fid"));
                map.put("name", rs.getString("fpersonName"));
                map.put("phone", rs.getString("fCell"));
                map.put("org", rs.getString("forglongname"));
                map.put("position", rs.getString("fposition"));
                map.put("email", rs.getString("femail"));
                rows.add(map);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        int totalPage = total % rowCount == 0 ? total / rowCount : total / rowCount + 1;
        HashMap<String, Serializable> result = new HashMap<String, Serializable>();
        result.put("page", Integer.valueOf(page));
        result.put("total", Integer.valueOf(totalPage));
        result.put("records", Integer.valueOf(total));
        result.put("rows", rows);
        return JSONObject.toJSONString(result);
    }

    @Override
    protected void _pbind(Context ctx, String easId, String xtId) throws BOSException {
        String sql = "update t_pm_easxtusermap set FxtId =? where fpersonId=?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{xtId, easId});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String _getEasPerson(Context ctx, String condition, String valueType) throws BOSException {
        JSONObject o = JSONObject.parseObject((String)condition);
        String filter = o.getString("filter");
        int page = o.getIntValue("page");
        int rowCount = o.getIntValue("rowCount");
        String sql = EasXtSyncUtil.getInstance().getValue(valueType);
        StringBuffer extraFilter = new StringBuffer(sql);
        if (!StringUtils.isEmpty((String)filter)) {
            filter = filter.trim();
            extraFilter.append(" and (easxt.fpersonname like '%").append(filter).append("%' or easxt.fcell like '%").append(filter).append("%')");
        }
        IRowSet rsCount = DbUtil.executeQuery((Context)ctx, (String)("select count(*) from (" + extraFilter.toString() + ") tmp"));
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)extraFilter.toString(), (int)((page - 1) * rowCount), (int)rowCount);
        ArrayList rows = new ArrayList();
        int total = 0;
        try {
            HashMap<String, String> map;
            if (rsCount.next()) {
                total = rsCount.getInt(1);
            }
            if (!"diffInfo".equalsIgnoreCase(valueType)) {
                while (rs.next()) {
                    map = new HashMap<String, String>();
                    map.put("id", rs.getString("easPersonId"));
                    map.put("name", rs.getString("easPersonName"));
                    map.put("phone", rs.getString("cell"));
                    map.put("org", rs.getString("org"));
                    map.put("position", rs.getString("position"));
                    map.put("email", rs.getString("email"));
                    map.put("desc", rs.getString("description"));
                    rows.add(map);
                }
            } else {
                while (rs.next()) {
                    map = new HashMap();
                    map.put("id", rs.getString("easPersonId"));
                    map.put("easname", rs.getString("easPersonName"));
                    map.put("xtname", rs.getString("xtPersonName"));
                    map.put("eascell", rs.getString("easCell"));
                    map.put("xtcell", rs.getString("xtCell"));
                    map.put("easorg", rs.getString("easOrgLongName"));
                    map.put("xtorg", rs.getString("xtOrgLongName"));
                    map.put("easposition", rs.getString("easPosition"));
                    map.put("xtposition", rs.getString("xtPosition"));
                    map.put("easmail", rs.getString("easEmail"));
                    map.put("xtmail", rs.getString("xtEmail"));
                    rows.add(map);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        int totalPage = total % rowCount == 0 ? total / rowCount : total / rowCount + 1;
        HashMap<String, Serializable> result = new HashMap<String, Serializable>();
        result.put("page", Integer.valueOf(page));
        result.put("total", Integer.valueOf(totalPage));
        result.put("records", Integer.valueOf(total));
        result.put("rows", rows);
        return JSONObject.toJSONString(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String _getQuerySyncLogs(Context ctx, String dataType, String condition, String queryType) throws BOSException {
        JSONObject o = JSONObject.parseObject((String)condition);
        String filter = o.getString("filter");
        int page = o.getIntValue("page");
        int rowCount = o.getIntValue("rowCount");
        String sql = EasXtSyncUtil.getInstance().getValue(dataType);
        StringBuffer extraFilter = new StringBuffer(sql);
        if (StringUtils.isEmpty((String)filter)) {
            return this._getSynchLog(ctx, dataType, condition);
        }
        filter = filter.trim();
        if ("orgLog".equalsIgnoreCase(dataType)) {
            if ("OrgName".equalsIgnoreCase(queryType)) {
                extraFilter.append(" and (forgName like '%").append(filter).append("%')");
            } else if ("Operation".equalsIgnoreCase(queryType)) {
                extraFilter.append(" and (foperation in (").append(filter).append("))");
            } else if ("Status".equalsIgnoreCase(queryType)) {
                extraFilter.append(" and (fsuccess like '%").append(filter).append("%')");
            } else if ("Des".equalsIgnoreCase(queryType)) {
                extraFilter.append(" and (fdescription like '%").append(filter).append("%')");
            }
        } else if ("EasPerson".equalsIgnoreCase(queryType)) {
            extraFilter.append(" and (b.fpersonName like '%").append(filter).append("%')");
        } else if ("Operation".equalsIgnoreCase(queryType)) {
            extraFilter.append(" and (a.foperation in (").append(filter).append("))");
        } else if ("Status".equalsIgnoreCase(queryType)) {
            extraFilter.append(" and (a.fsuccess like '%").append(filter).append("%')");
        } else if ("Des".equalsIgnoreCase(queryType)) {
            extraFilter.append(" and (a.fdescription like '%").append(filter).append("%')");
        }
        extraFilter.append(" order by foperationtime desc");
        String s = "select count(*) from ( " + extraFilter.toString() + " ) tmp";
        IRowSet rsCount = DbUtil.executeQuery((Context)ctx, (String)s);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)extraFilter.toString(), (int)((page - 1) * rowCount), (int)rowCount);
        ArrayList rows = new ArrayList();
        int total = 0;
        try {
            HashMap<String, String> map;
            if (rsCount.next()) {
                total = rsCount.getInt(1);
            }
            if ("orgLog".equalsIgnoreCase(dataType)) {
                while (rs.next()) {
                    map = new HashMap<String, String>();
                    map.put("id", rs.getString("id"));
                    map.put("orgName", rs.getString("orgName"));
                    map.put("easPerson", null);
                    map.put("operation", "0");
                    map.put("status", rs.getString("status"));
                    map.put("desc", rs.getString("description"));
                    map.put("createTime", rs.getString("createTime"));
                    rows.add(map);
                }
            } else {
                while (rs.next()) {
                    map = new HashMap();
                    map.put("id", rs.getString("id"));
                    map.put("orgName", null);
                    map.put("easPerson", rs.getString("easPerson"));
                    map.put("operation", rs.getString("operation"));
                    map.put("status", rs.getString("status"));
                    map.put("desc", rs.getString("description"));
                    map.put("createTime", rs.getString("createTime"));
                    rows.add(map);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        int totalPage = total % rowCount == 0 ? total / rowCount : total / rowCount + 1;
        HashMap<String, Serializable> result = new HashMap<String, Serializable>();
        result.put("page", Integer.valueOf(page));
        result.put("total", Integer.valueOf(totalPage));
        result.put("records", Integer.valueOf(total));
        result.put("rows", rows);
        return JSONObject.toJSONString(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String _getQueryEasPerson(Context ctx, String condition, String valueType, String queryType) throws BOSException {
        JSONObject o = JSONObject.parseObject((String)condition);
        String filter = o.getString("filter");
        int page = o.getIntValue("page");
        int rowCount = o.getIntValue("rowCount");
        String sql = EasXtSyncUtil.getInstance().getValue(valueType);
        StringBuffer extraFilter = new StringBuffer(sql);
        if (StringUtils.isEmpty((String)filter)) {
            return this._getEasPerson(ctx, condition, valueType);
        }
        filter = filter.trim();
        if ("diffInfo".equalsIgnoreCase(valueType)) {
            if ("easName".equalsIgnoreCase(queryType)) {
                extraFilter.append(" and (easxt.FPersonName like '%").append(filter).append("%')");
            } else if ("XTName".equalsIgnoreCase(queryType)) {
                extraFilter.append(" and (xt.FPersonName like '%").append(filter).append("%')");
            } else if ("easPhone".equalsIgnoreCase(queryType)) {
                extraFilter.append(" and (easxt.FCell like '%").append(filter).append("%')");
            } else if ("XTPhone".equalsIgnoreCase(queryType)) {
                extraFilter.append(" and (xt.FCell like '%").append(filter).append("%')");
            } else if ("easOrg".equalsIgnoreCase(queryType)) {
                extraFilter.append(" and (easxt.FOrgLongName like '%").append(filter).append("%')");
            } else if ("XTOrg".equalsIgnoreCase(queryType)) {
                extraFilter.append(" and (xt.FOrglongName like '%").append(filter).append("%')");
            } else if ("EASPostion".equalsIgnoreCase(queryType)) {
                extraFilter.append(" and (easxt.FPosition like '%").append(filter).append("%')");
            } else if ("XTPostion".equalsIgnoreCase(queryType)) {
                extraFilter.append(" and (xt.FPosition like '%").append(filter).append("%')");
            } else if ("easEmail".equalsIgnoreCase(queryType)) {
                extraFilter.append(" and (easxt.FEmail like '%").append(filter).append("%')");
            } else if ("XTEamil".equalsIgnoreCase(queryType)) {
                extraFilter.append(" and (xt.FEmail like '%").append(filter).append("%')");
            }
        } else if ("name".equalsIgnoreCase(queryType)) {
            extraFilter.append(" and (easxt.fpersonname like '%").append(filter).append("%')");
        } else if ("phone".equalsIgnoreCase(queryType)) {
            extraFilter.append(" and (easxt.fcell like '%").append(filter).append("%')");
        } else if ("org".equalsIgnoreCase(queryType)) {
            extraFilter.append(" and (easxt.FOrgLongName like '%").append(filter).append("%')");
        } else if ("position".equalsIgnoreCase(queryType)) {
            extraFilter.append(" and (easxt.FPosition like '%").append(filter).append("%')");
        } else if ("Email".equalsIgnoreCase(queryType)) {
            extraFilter.append(" and (easxt.FEmail like '%").append(filter).append("%')");
        }
        IRowSet rsCount = DbUtil.executeQuery((Context)ctx, (String)("select count(*) from (" + extraFilter.toString() + ") tmp"));
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)extraFilter.toString(), (int)((page - 1) * rowCount), (int)rowCount);
        ArrayList rows = new ArrayList();
        int total = 0;
        try {
            HashMap<String, String> map;
            if (rsCount.next()) {
                total = rsCount.getInt(1);
            }
            if (!"diffInfo".equalsIgnoreCase(valueType)) {
                while (rs.next()) {
                    map = new HashMap<String, String>();
                    map.put("id", rs.getString("easPersonId"));
                    map.put("name", rs.getString("easPersonName"));
                    map.put("phone", rs.getString("cell"));
                    map.put("org", rs.getString("org"));
                    map.put("position", rs.getString("position"));
                    map.put("email", rs.getString("email"));
                    map.put("desc", rs.getString("description"));
                    rows.add(map);
                }
            } else {
                while (rs.next()) {
                    map = new HashMap();
                    map.put("id", rs.getString("easPersonId"));
                    map.put("easname", rs.getString("easPersonName"));
                    map.put("xtname", rs.getString("xtPersonName"));
                    map.put("eascell", rs.getString("easCell"));
                    map.put("xtcell", rs.getString("xtCell"));
                    map.put("easorg", rs.getString("easOrgLongName"));
                    map.put("xtorg", rs.getString("xtOrgLongName"));
                    map.put("easposition", rs.getString("easPosition"));
                    map.put("xtposition", rs.getString("xtPosition"));
                    map.put("easmail", rs.getString("easEmail"));
                    map.put("xtmail", rs.getString("xtEmail"));
                    rows.add(map);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        int totalPage = total % rowCount == 0 ? total / rowCount : total / rowCount + 1;
        HashMap<String, Serializable> result = new HashMap<String, Serializable>();
        result.put("page", Integer.valueOf(page));
        result.put("total", Integer.valueOf(totalPage));
        result.put("records", Integer.valueOf(total));
        result.put("rows", rows);
        return JSONObject.toJSONString(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String _getAllQueryXtUser(Context ctx, String condition, boolean isInService, String queryType) throws BOSException {
        JSONObject o = JSONObject.parseObject((String)condition);
        String filter = o.getString("filter");
        int page = o.getIntValue("page");
        int rowCount = o.getIntValue("rowCount");
        String sql = "select fid,fpersonName,fcell,forglongname,fposition,femail,fstatus from t_xt_user ";
        StringBuffer extraFilter = new StringBuffer(sql);
        if (isInService) {
            extraFilter.append(" where fstatus =1 ");
        }
        if (StringUtils.isEmpty((String)filter)) {
            return this._getAllXtUser(ctx, condition, isInService);
        }
        filter = filter.trim();
        if (isInService) {
            if ("Name".equalsIgnoreCase(queryType)) {
                extraFilter.append(" and (fpersonname like '%").append(filter).append("%')");
            } else if ("Phone".equalsIgnoreCase(queryType)) {
                extraFilter.append(" and (fcell like '%").append(filter).append("%')");
            } else if ("Org".equalsIgnoreCase(queryType)) {
                extraFilter.append(" and (forglongname like '%").append(filter).append("%')");
            } else if ("Position".equalsIgnoreCase(queryType)) {
                extraFilter.append(" and (fposition like '%").append(filter).append("%')");
            } else if ("Email".equalsIgnoreCase(queryType)) {
                extraFilter.append(" and (femail like '%").append(filter).append("%')");
            }
        } else if ("Name".equalsIgnoreCase(queryType)) {
            extraFilter.append(" where (fpersonname like '%").append(filter).append("%')");
        } else if ("Phone".equalsIgnoreCase(queryType)) {
            extraFilter.append(" where (fcell like '%").append(filter).append("%')");
        } else if ("Org".equalsIgnoreCase(queryType)) {
            extraFilter.append(" where (forglongname like '%").append(filter).append("%')");
        } else if ("Position".equalsIgnoreCase(queryType)) {
            extraFilter.append(" where (fposition like '%").append(filter).append("%')");
        } else if ("Email".equalsIgnoreCase(queryType)) {
            extraFilter.append(" where (femail like '%").append(filter).append("%')");
        }
        IRowSet rsCount = DbUtil.executeQuery((Context)ctx, (String)("select count(*) from (" + extraFilter.toString() + ") tmp"));
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)extraFilter.toString(), (int)((page - 1) * rowCount), (int)rowCount);
        ArrayList rows = new ArrayList();
        int total = 0;
        try {
            if (rsCount.next()) {
                total = rsCount.getInt(1);
            }
            while (rs.next()) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("id", rs.getString("fid"));
                map.put("name", rs.getString("fpersonName"));
                map.put("phone", rs.getString("fcell"));
                map.put("org", rs.getString("forglongname"));
                map.put("position", rs.getString("fposition"));
                map.put("email", rs.getString("femail"));
                map.put("status", rs.getString("fstatus"));
                rows.add(map);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        int totalPage = total % rowCount == 0 ? total / rowCount : total / rowCount + 1;
        HashMap<String, Serializable> result = new HashMap<String, Serializable>();
        result.put("page", Integer.valueOf(page));
        result.put("total", Integer.valueOf(totalPage));
        result.put("records", Integer.valueOf(total));
        result.put("rows", rows);
        return JSONObject.toJSONString(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String _getSynchLog(Context ctx, String dataType, String condition) throws BOSException {
        JSONObject o = JSONObject.parseObject((String)condition);
        String filter = o.getString("filter");
        int page = o.getIntValue("page");
        int rowCount = o.getIntValue("rowCount");
        String sql = EasXtSyncUtil.getInstance().getValue(dataType);
        StringBuffer extraFilter = new StringBuffer(sql);
        if (!StringUtils.isEmpty((String)filter)) {
            filter = filter.trim();
            if ("orgLog".equalsIgnoreCase(dataType)) {
                extraFilter.append(" and (forgName like '%").append(filter).append("%')");
            } else {
                extraFilter.append(" and (b.fpersonName like '%").append(filter).append("%')");
            }
        }
        if (!"MS SQL Server".equals(ctx.get((Object)"dbType"))) {
            extraFilter.append(" order by foperationtime desc");
        }
        String s = "select count(*) from ( " + extraFilter.toString() + " ) tmp";
        IRowSet rsCount = DbUtil.executeQuery((Context)ctx, (String)s);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)extraFilter.toString(), (int)((page - 1) * rowCount), (int)rowCount);
        ArrayList rows = new ArrayList();
        int total = 0;
        try {
            HashMap<String, String> map;
            if (rsCount.next()) {
                total = rsCount.getInt(1);
            }
            if ("orgLog".equalsIgnoreCase(dataType)) {
                while (rs.next()) {
                    map = new HashMap<String, String>();
                    map.put("id", rs.getString("id"));
                    map.put("orgName", rs.getString("orgName"));
                    map.put("easPerson", null);
                    map.put("operation", "0");
                    map.put("status", rs.getString("status"));
                    map.put("desc", rs.getString("description"));
                    map.put("createTime", rs.getString("createTime"));
                    rows.add(map);
                }
            } else {
                while (rs.next()) {
                    map = new HashMap();
                    map.put("id", rs.getString("id"));
                    map.put("orgName", null);
                    map.put("easPerson", rs.getString("easPerson"));
                    map.put("operation", rs.getString("operation"));
                    map.put("status", rs.getString("status"));
                    map.put("desc", rs.getString("description"));
                    map.put("createTime", rs.getString("createTime"));
                    rows.add(map);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        int totalPage = total % rowCount == 0 ? total / rowCount : total / rowCount + 1;
        HashMap<String, Serializable> result = new HashMap<String, Serializable>();
        result.put("page", Integer.valueOf(page));
        result.put("total", Integer.valueOf(totalPage));
        result.put("records", Integer.valueOf(total));
        result.put("rows", rows);
        return JSONObject.toJSONString(result);
    }

    @Override
    protected void _insertAllXtUser(Context ctx) throws BOSException {
        String sql = "delete from t_xt_checktime";
        DbUtil.execute((Context)ctx, (String)sql);
        this.updateXtUser(ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String _getAllXtUser(Context ctx, String condition, boolean isInService) throws BOSException {
        JSONObject o = JSONObject.parseObject((String)condition);
        String filter = o.getString("filter");
        int page = o.getIntValue("page");
        int rowCount = o.getIntValue("rowCount");
        String sql = "select fid,fpersonName,fcell,forglongname,fposition,femail,fstatus from t_xt_user ";
        StringBuffer extraFilter = new StringBuffer(sql);
        if (isInService) {
            extraFilter.append(" where fstatus =1 ");
        }
        if (!StringUtils.isEmpty((String)filter)) {
            filter = filter.trim();
            if (isInService) {
                extraFilter.append(" and (fpersonname like '%").append(filter).append("%' or fcell like '%").append(filter).append("%')");
            } else {
                extraFilter.append(" where fpersonname like '%").append(filter).append("%' or fcell like '%").append(filter).append("%'");
            }
        }
        IRowSet rsCount = DbUtil.executeQuery((Context)ctx, (String)("select count(*) from (" + extraFilter.toString() + ") tmp"));
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)extraFilter.toString(), (int)((page - 1) * rowCount), (int)rowCount);
        ArrayList rows = new ArrayList();
        int total = 0;
        try {
            if (rsCount.next()) {
                total = rsCount.getInt(1);
            }
            while (rs.next()) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("id", rs.getString("fid"));
                map.put("name", rs.getString("fpersonName"));
                map.put("phone", rs.getString("fcell"));
                map.put("org", rs.getString("forglongname"));
                map.put("position", rs.getString("fposition"));
                map.put("email", rs.getString("femail"));
                map.put("status", rs.getString("fstatus"));
                rows.add(map);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        int totalPage = total % rowCount == 0 ? total / rowCount : total / rowCount + 1;
        HashMap<String, Serializable> result = new HashMap<String, Serializable>();
        result.put("page", Integer.valueOf(page));
        result.put("total", Integer.valueOf(totalPage));
        result.put("records", Integer.valueOf(total));
        result.put("rows", rows);
        return JSONObject.toJSONString(result);
    }

    @Override
    protected void _deleteMap(Context ctx, String personIds) throws BOSException {
        if (personIds == null || "".equals(personIds)) {
            return;
        }
        String personParam = personIds.replaceAll(",", "','");
        String sql = "delete from t_pm_easxtusermap where fpersonId in ('" + personParam + "')";
        DbUtil.execute((Context)ctx, (String)sql);
    }

    @Override
    protected void _clearSyncLogData(Context ctx) throws BOSException, EASBizException {
        String sql = "delete from t_xt_log";
        DbUtil.execute((Context)ctx, (String)sql);
    }

    private String getCurTime() {
        long time = new Date().getTime();
        Timestamp checktime = new Timestamp(time);
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss.SSS");
        return formatter.format(checktime);
    }
}

