/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.FieldAccessStrategyCollection;
import com.kingdee.eas.base.permission.FieldAccessStrategyException;
import com.kingdee.eas.base.permission.FieldAccessStrategyFactory;
import com.kingdee.eas.base.permission.FieldAccessStrategyInfo;
import com.kingdee.eas.base.permission.IFieldAccessStrategy;
import com.kingdee.eas.base.permission.app.AbstractFieldAccessStrategyControllerBean;
import com.kingdee.eas.base.permission.app.util.PermissionUtil;
import com.kingdee.eas.base.permission.util.IObjectCol2List;
import com.kingdee.eas.base.permission.util.IObjectCol2Map;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class FieldAccessStrategyControllerBean
extends AbstractFieldAccessStrategyControllerBean {
    private static Logger logger = Logger.getLogger(FieldAccessStrategyControllerBean.class);

    private void deleteUserAlreadyPermByDel(Context ctx, Connection cn, FieldAccessStrategyCollection result, String objectType, String currentUserID, String cuIdStr) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)currentUserID)) {
            return;
        }
        Set<String> extendAllCUIDSet = new HashSet<String>();
        if ("11111111-1111-1111-1111-111111111111CCE7AED4".equals(cuIdStr)) {
            extendAllCUIDSet.add(cuIdStr);
        } else {
            extendAllCUIDSet = this.getExtendAllCUIDs(ctx, cuIdStr);
        }
        FieldAccessStrategyCollection fieldAccessCol = this.findBeDelData(ctx, objectType, extendAllCUIDSet, result);
        List delFieldList = ToolUtils.transCol2ListByPeroperty((IObjectCollection)fieldAccessCol, new IObjectCol2List(){

            @Override
            public String getList(Object obj) {
                FieldAccessStrategyInfo info = (FieldAccessStrategyInfo)obj;
                return info.getFieldName();
            }
        });
        if (delFieldList == null || delFieldList.isEmpty()) {
            return;
        }
        String delSql = "delete from T_PM_FieldAccess where fbizObjectType = '" + objectType.toString() + "' and ffieldName in (" + ToolUtils.aryToStr(ToolUtils.filterSameObj(delFieldList), true) + ")  and fcontrolunitid in (" + ToolUtils.aryToStr(ToolUtils.trans2List(extendAllCUIDSet), true) + ")";
        DbUtil.execute((Context)ctx, (String)delSql);
    }

    private FieldAccessStrategyCollection findBeDelData(Context ctx, String objectType, Set cuIdSet, FieldAccessStrategyCollection result) throws BOSException {
        Map newDataMap = ToolUtils.transCol2ListByPeroperty((IObjectCollection)result, new IObjectCol2Map(){

            @Override
            public String getKey(Object obj) {
                FieldAccessStrategyInfo fieldAccessStrategyInfo = (FieldAccessStrategyInfo)obj;
                return StringUtils.cnulls((String)fieldAccessStrategyInfo.getFieldName());
            }

            @Override
            public Object getList(Object obj) {
                FieldAccessStrategyInfo fieldAccessStrategyInfo = (FieldAccessStrategyInfo)obj;
                return fieldAccessStrategyInfo.isEnableAccessControl();
            }
        });
        String findDeledDateSql = "select *  WHERE bizObjectType = '" + objectType + "' AND CU.ID in(" + ToolUtils.aryToStr(ToolUtils.trans2List(cuIdSet), true) + ")";
        IFieldAccessStrategy iFieldAccessStrategy = FieldAccessStrategyFactory.getLocalInstance(ctx);
        FieldAccessStrategyCollection fieldAccessStrategyCol = iFieldAccessStrategy.getFieldAccessStrategyCollection(findDeledDateSql);
        FieldAccessStrategyCollection retCol = new FieldAccessStrategyCollection();
        for (int i = 0; i < fieldAccessStrategyCol.size(); ++i) {
            FieldAccessStrategyInfo fieldInfo = fieldAccessStrategyCol.get(i);
            Object obj = newDataMap.get(fieldInfo.getFieldName());
            if (obj != null && !"false".equalsIgnoreCase(StringUtils.cnulls(obj))) continue;
            retCol.add(fieldInfo);
        }
        return retCol;
    }

    private Set getExtendCUIDs(Context ctx, String ctrlUnitID, String bizObjectType, String fieldName) throws BOSException, EASBizException, SQLException {
        HashSet<String> result = new HashSet<String>();
        String orgLongNumber = PermissionUtil.getOrgLongNumber(ctx, OrgType.ControlUnit, (IObjectPK)new ObjectUuidPK(ctrlUnitID));
        StringBuffer buffer = new StringBuffer(300);
        buffer.append("SELECT FID FROM T_ORG_CtrlUnit ").append(" WHERE FLongNumber LIKE ? ").append(" AND FID NOT IN (SELECT FControlUnitID FROM T_PM_FieldAccessStrategy ").append(" WHERE FBizObjectType = ? ").append(" AND FFieldName = ? ").append(" AND FEnableAccessControl = 1)");
        Object[] params = new Object[]{orgLongNumber + "!%", bizObjectType, fieldName};
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)buffer.toString(), (Object[])params);
        while (rowSet.next()) {
            result.add(rowSet.getString("FID"));
        }
        return result;
    }

    private Set getExtendAllCUIDs(Context ctx, String ctrlUnitID) throws BOSException, EASBizException {
        StringBuffer buffer = new StringBuffer(300);
        try {
            HashSet<String> result = new HashSet<String>();
            String orgLongNumber = PermissionUtil.getOrgLongNumber(ctx, OrgType.ControlUnit, (IObjectPK)new ObjectUuidPK(ctrlUnitID));
            buffer.append("SELECT FID FROM T_ORG_CtrlUnit ").append(" WHERE FLongNumber LIKE ? ");
            Object[] params = new Object[]{orgLongNumber + "!%"};
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)buffer.toString(), (Object[])params);
            while (rowSet.next()) {
                result.add(rowSet.getString("FID"));
            }
            result.add(ctrlUnitID);
            return result;
        }
        catch (SQLException se) {
            logger.error((Object)("sqlerror sql is:" + buffer.toString()));
            throw new BOSException((Throwable)se);
        }
    }

    private String getBizObjectType(FieldAccessStrategyCollection result) {
        assert (result.size() > 0);
        return result.get(0).getBizObjectType();
    }

    private String getCtrlUnitID(FieldAccessStrategyCollection result) {
        assert (result.size() > 0);
        return result.get(0).getCU().getId().toString();
    }

    @Override
    protected Set _getLockedFieldNames(Context ctx, IObjectPK ctrlUnitPK, BOSObjectType bizObjectType) throws BOSException, EASBizException {
        HashSet<String> result = new HashSet<String>();
        String orgLongNumber = PermissionUtil.getOrgLongNumber(ctx, OrgType.ControlUnit, ctrlUnitPK);
        String[] numbers = StringUtils.split((String)orgLongNumber, (String)"!");
        if (numbers.length <= 1) {
            return result;
        }
        StringBuffer buffer = new StringBuffer(200);
        buffer.append("SELECT FieldAccessStrategy.FFieldName ").append(" FROM T_PM_FieldAccessStrategy FieldAccessStrategy ").append(" INNER JOIN T_ORG_CtrlUnit CtrlUnit ON CtrlUnit.FID = FieldAccessStrategy.FControlUnitID ").append(" WHERE FieldAccessStrategy.FBizObjectType = ? ").append(" AND FieldAccessStrategy.FEnableAccessControl = 1 ");
        buffer.append(" AND FNumber IN (");
        int length = numbers.length - 1;
        for (int i = 0; i < length; ++i) {
            if (i == length - 1) {
                buffer.append(" N'").append(numbers[i]).append("') ");
                continue;
            }
            buffer.append(" N'").append(numbers[i]).append("', ");
        }
        buffer.append(" UNION SELECT FFieldName FROM T_PM_FieldAccess ").append(" WHERE FBizObjectType = ? AND FAccessValue <> 3 ").append(" AND ( FOrgID IN ( SELECT FID FROM T_ORG_BaseUnit WHERE FControlUnitID = ? ) OR FRoleID IS NOT NULL) ");
        Object[] params = new Object[]{bizObjectType.toString(), bizObjectType.toString(), ctrlUnitPK.toString()};
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)buffer.toString(), (Object[])params);
        try {
            while (rowSet.next()) {
                result.add(rowSet.getString("FFieldName"));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new FieldAccessStrategyException(FieldAccessStrategyException.GET_DATA_FAIL, e);
        }
        return result;
    }

    @Override
    protected void _save(Context ctx, FieldAccessStrategyCollection result, String objTypeStr, String cuIdStr) throws BOSException, EASBizException {
        int size;
        Date currentTime;
        String currentUserID;
        String bizObjectType;
        BOSObjectType objectType;
        PreparedStatement ps;
        Connection cn;
        block8: {
            assert (result != null);
            cn = null;
            ps = null;
            objectType = this.getBOSType();
            bizObjectType = objTypeStr;
            currentUserID = ctx.getCaller().toString();
            currentTime = new Date(System.currentTimeMillis());
            cn = this.getConnection(ctx);
            this.deleteUserAlreadyPermByDel(ctx, cn, result, objTypeStr, currentUserID, cuIdStr);
            ps = cn.prepareStatement(" DELETE FROM T_PM_FieldAccessStrategy WHERE FBizObjectType = ? AND FControlUnitID = ? ");
            ps.setString(1, bizObjectType);
            ps.setString(2, cuIdStr);
            ps.executeUpdate();
            size = result.size();
            if (size != 0) break block8;
            SQLUtils.cleanup((Statement)ps, (Connection)cn);
            return;
        }
        try {
            StringBuffer sql = new StringBuffer(200);
            sql.append(" INSERT INTO T_PM_FieldAccessStrategy (FID, FBizObjectType, FFieldName, ").append(" FEnableAccessControl, FCreatorID, FCreateTime, ").append(" FLastUpdateUserID, FLastUpdateTime, FControlUnitID) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");
            ps = cn.prepareStatement(sql.toString());
            for (int i = 0; i < size; ++i) {
                FieldAccessStrategyInfo info = result.get(i);
                ps.setString(1, BOSUuid.create((BOSObjectType)objectType).toString());
                ps.setString(2, bizObjectType);
                ps.setString(3, info.getFieldName());
                ps.setInt(4, info.isEnableAccessControl() ? 1 : 0);
                ps.setString(5, currentUserID);
                ps.setDate(6, currentTime);
                ps.setString(7, currentUserID);
                ps.setDate(8, currentTime);
                ps.setString(9, cuIdStr);
                ps.addBatch();
                if ("11111111-1111-1111-1111-111111111111CCE7AED4".equals(cuIdStr)) continue;
                Set extendCUIDs = this.getExtendCUIDs(ctx, cuIdStr, bizObjectType, info.getFieldName());
                for (String extendCUID : extendCUIDs) {
                    ps.setString(1, BOSUuid.create((BOSObjectType)objectType).toString());
                    ps.setString(2, bizObjectType);
                    ps.setString(3, info.getFieldName());
                    ps.setInt(4, info.isEnableAccessControl() ? 1 : 0);
                    ps.setString(5, currentUserID);
                    ps.setDate(6, currentTime);
                    ps.setString(7, currentUserID);
                    ps.setDate(8, currentTime);
                    ps.setString(9, extendCUID);
                    ps.addBatch();
                }
            }
            ps.executeBatch();
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new FieldAccessStrategyException(FieldAccessStrategyException.SAVE_STRATEGY_FAIL, e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)cn);
    }
}

