/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.permission.app.AbstractModuleUseStatsControllerBean;
import com.kingdee.eas.base.permission.app.daq.util.DataAcquisitionUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class ModuleUseStatsControllerBean
extends AbstractModuleUseStatsControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.permission.app.ModuleUseStatsControllerBean");

    @Override
    protected Map _getModuleUseReport(Context ctx, Date beginTime, Date endTime, int type, List moduleNumberList) throws BOSException {
        Map<String, int[]> result = null;
        try {
            beginTime = DataAcquisitionUtil.initBeginTime(beginTime);
            endTime = DataAcquisitionUtil.initEndTime(endTime);
            String sql = "select FDataAcqTime,FModuleNumber,FUserId from T_PM_ModuleUseStats where FDataAcqTime > ? and FDataAcqTime < ? and FModuleNumber in (" + DataAcquisitionUtil.aryToStr(moduleNumberList, true) + ") order by FDataAcqTime";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])this.buildParam(beginTime, endTime, moduleNumberList));
            int size = DataAcquisitionUtil.getSizeByType(type, beginTime, endTime);
            result = this.initResult(moduleNumberList, size);
            HashMap<String, Object[]> userIdCache = new HashMap<String, Object[]>();
            if (rs.size() < 1) {
                return result;
            }
            Timestamp tsCache = null;
            int groovedCache = 0;
            while (rs.next()) {
                Timestamp ts = rs.getTimestamp("FDataAcqTime");
                String moduleNumber = rs.getString("FModuleNumber");
                String userId = rs.getString("FUserId");
                int[] countArr = result.get(moduleNumber);
                if (userIdCache.get(moduleNumber) == null) {
                    userIdCache.put(moduleNumber, new Object[size]);
                }
                Object[] userIdArr = (Object[])userIdCache.get(moduleNumber);
                if (ts.equals(tsCache)) {
                    ArrayList<String> userIds = (ArrayList<String>)userIdArr[groovedCache];
                    if (userIds == null) {
                        userIdArr[groovedCache] = userIds = new ArrayList<String>();
                    }
                    if (userIds.contains(userId)) continue;
                    userIds.add(userId);
                    int n = groovedCache;
                    countArr[n] = countArr[n] + 1;
                    continue;
                }
                tsCache = ts;
                int grooved = DataAcquisitionUtil.dataDistribution(type, new Date(ts.getTime()), beginTime);
                ArrayList<String> users = (ArrayList<String>)userIdArr[grooved];
                if (users == null) {
                    userIdArr[grooved] = users = new ArrayList<String>();
                }
                if (!users.contains(userId)) {
                    users.add(userId);
                    int n = grooved;
                    countArr[n] = countArr[n] + 1;
                }
                groovedCache = grooved;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (ParseException e) {
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    private Map<String, int[]> initResult(List moduleNumber, int size) {
        HashMap<String, int[]> result = new HashMap<String, int[]>();
        for (int i = 0; i < moduleNumber.size(); ++i) {
            result.put((String)moduleNumber.get(i), new int[size]);
        }
        return result;
    }

    private Object[] buildParam(Date beginTime, Date endTime, List moduleNumber) {
        Object[] param = new Object[moduleNumber.size() + 2];
        param[0] = new Timestamp(beginTime.getTime());
        param[1] = new Timestamp(endTime.getTime());
        for (int i = 0; i < moduleNumber.size(); ++i) {
            param[i + 2] = moduleNumber.get(i);
        }
        return param;
    }
}

