/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.permission.AuthenRecordInfo;
import com.kingdee.eas.base.permission.app.IAuthenRecordAuthen;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class RoleAssignPermAuthenRecordAuthenImpl
implements IAuthenRecordAuthen {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.permission.app.RoleAssignPermAuthenRecordAuthenImpl");

    @Override
    public void noPassAuthen(Context ctx, AuthenRecordInfo authenRecordInfo, String reasonText) throws BOSException, EASBizException {
        String currentUserId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        String permChangeId = authenRecordInfo.getPermChange().getId().toString();
        String sql = "UPDATE T_PM_RolePermChange SET FAuthenStatus =? WHERE T_PM_RolePermChange.FAuthenStatus=? AND  T_PM_RolePermChange.FPermChangeID=? AND EXISTS (SELECT 1 FROM T_PM_PermAuthentor where T_PM_PermAuthentor.FPermItemId=T_PM_RolePermChange.FPermItemId  AND T_PM_PermAuthentor.FAuthentorId=?)";
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{"30", "10", permChangeId, currentUserId});
        List<String> canAuthenPermsList = this.getCanAuthenPassPerms(ctx, currentUserId, permChangeId);
        if (canAuthenPermsList == null || canAuthenPermsList.isEmpty()) {
            return;
        }
        List<String> allChangePermItemsList = this.getAllChangePerms(ctx, permChangeId);
        if (!canAuthenPermsList.containsAll(allChangePermItemsList)) {
            return;
        }
        this.setOthenAuthenRecordStatus(ctx, "30", permChangeId);
    }

    @Override
    public void passAuthen(Context ctx, AuthenRecordInfo authenRecordInfo) throws BOSException, EASBizException {
        String currentUserId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        String permChangeId = authenRecordInfo.getPermChange().getId().toString();
        String sql = "INSERT INTO T_PM_RolePerm(FID,FRoleID,FPermItemID,FPermType,FRuleStructure,FRuleExpr) SELECT FRolePerm,FRoleID,FPermItemID,FPermType,FRuleStructure,FRuleExpr FROM  T_PM_RolePermChange WHERE FPermChangeId=? AND FAuthenStatus=? AND EXISTS (SELECT 1 FROM T_PM_PermAuthentor WHERE T_PM_PermAuthentor.FPermItemId=T_PM_RolePermChange.FPermItemId AND T_PM_PermAuthentor.FAuthentorId=? ) AND NOT EXISTS (SELECT 1 FROM T_PM_RolePerm T2 WHERE T2.FRoleId=T_PM_RolePermChange.FRoleId  AND T2.FPermItemId=T_PM_RolePermChange.FPermItemId AND T2.FPermType=T_PM_RolePermChange.FPermType AND T2.FID IS NOT NULL) ";
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{permChangeId, "10", currentUserId});
        sql = "UPDATE T_PM_RolePermChange SET FAuthenStatus =? WHERE FPermChangeId=? AND FAuthenStatus=? AND EXISTS  (SELECT 1 FROM T_PM_PermAuthentor WHERE T_PM_PermAuthentor.FPermItemId=T_PM_RolePermChange.FPermItemId  AND T_PM_PermAuthentor.FAuthentorId=?)";
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{"20", permChangeId, "10", currentUserId});
        List<String> canAuthenPermsList = this.getCanAuthenPassPerms(ctx, currentUserId, permChangeId);
        if (canAuthenPermsList == null || canAuthenPermsList.isEmpty()) {
            return;
        }
        List<String> allChangePermItemsList = this.getAllChangePerms(ctx, permChangeId);
        if (!canAuthenPermsList.containsAll(allChangePermItemsList)) {
            return;
        }
        this.setOthenAuthenRecordStatus(ctx, "20", permChangeId);
    }

    public void cancelAssign(Context ctx, AuthenRecordInfo authenRecordInfo) throws BOSException, EASBizException {
    }

    private List<String> getCanAuthenPassPerms(Context ctx, String currentUserId, String permChangeId) throws BOSException {
        ArrayList<String> canNeedAuthenPermIdList = new ArrayList<String>();
        ArrayList<String> allAuthenUnSuccessAuthentorList = new ArrayList<String>();
        allAuthenUnSuccessAuthentorList.add(currentUserId);
        String sql = "SELECT FAuthentorid FROM T_PM_AuthenRecord WHERE FPermChangeId ='" + permChangeId + "'  AND (FAuthenStatus=" + "20" + " OR FAuthenStatus=" + "30" + ")";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            while (rowSet.next()) {
                allAuthenUnSuccessAuthentorList.add(rowSet.getString("FAuthentorid"));
            }
            sql = "SELECT FPermItemId FROM T_PM_PermAuthentor WHERE FAuthentorId IN(" + ToolUtils.aryToStr(allAuthenUnSuccessAuthentorList) + ")";
            rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rowSet.next()) {
                canNeedAuthenPermIdList.add(rowSet.getString("FPermItemId"));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
            throw new BOSException(e.getMessage());
        }
        return canNeedAuthenPermIdList;
    }

    private List<String> getAllChangePerms(Context ctx, String permChangeId) throws BOSException {
        String sql = "SELECT FPermItemId FROM T_PM_RolePermChange WHERE FPermChangeId ='" + permChangeId + "' AND FAuthenStatus=" + "10" + "";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        ArrayList<String> allChangePerms = new ArrayList<String>();
        try {
            while (rowSet.next()) {
                allChangePerms.add(rowSet.getString("FPermItemId"));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
            throw new BOSException(e.getMessage());
        }
        return allChangePerms;
    }

    private void setOthenAuthenRecordStatus(Context ctx, String authenStatus, String permChangeId) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE T_PM_AuthenRecord SET FAuthenStatus=" + authenStatus + " ,FAuthenTime=NOW() WHERE FPermChangeId='" + permChangeId + "' AND FAuthenStatus=" + "10" + "");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }
}

