/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.permission.IRole;
import com.kingdee.eas.base.permission.RoleException;
import com.kingdee.eas.base.permission.RoleFactory;
import com.kingdee.eas.base.permission.RoleInfo;
import com.kingdee.eas.base.permission.util.PermBizHelper;
import com.kingdee.eas.base.permission.util.PermissionRangeHelper;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICtrlUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Locale;
import org.apache.log4j.Logger;

public class RoleDataTransmission
extends AbstractDataTransmission {
    private static Logger logger = Logger.getLogger((String)RoleDataTransmission.class.getName());
    private static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionResource";

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return RoleFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            throw new TaskExternalException(e.getMessage());
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        RoleInfo roleInfo = new RoleInfo();
        try {
            String roleNumber = (String)((DataToken)hsData.get((Object)"FRoleNumber")).data;
            if (StringUtils.isEmpty((String)roleNumber)) {
                String objectName = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity(new RoleInfo().getBOSType()).getAlias();
                Object[] params = new Object[]{objectName, roleNumber};
                String msg = MessageFormat.format(EASCommonResource.getString((String)RESOURCE, (String)"numberNotFound", (Locale)ctx.getLocale()), params);
                throw new TaskExternalException(msg);
            }
            IRole iRole = RoleFactory.getLocalInstance(ctx);
            boolean hasNumber = iRole.haveThisNumber(roleNumber);
            if (hasNumber) {
                RoleInfo alreadyRoleInfo = iRole.getRoleInfoByNumber(roleNumber);
                if (this.isSltImportUpdate()) {
                    roleInfo.setId(alreadyRoleInfo.getId());
                }
            }
            roleInfo.setNumber(roleNumber);
            roleInfo.setName(StringUtils.cnulls((String)((String)((DataToken)hsData.get((Object)"FName")).data)));
            String type = StringUtils.cnulls((String)((String)((DataToken)hsData.get((Object)"FType")).data));
            roleInfo.setType(PermBizHelper.findRoleType(type));
            roleInfo.setDescription(StringUtils.cnulls((String)((String)((DataToken)hsData.get((Object)"FDescription")).data)));
            roleInfo.setSimpleName(StringUtils.cnulls((String)((String)((DataToken)hsData.get((Object)"FSimpleName")).data)));
            String cuNumber = StringUtils.cnulls((String)((String)((DataToken)hsData.get((Object)"FControlUnitNumber")).data));
            FullOrgUnitInfo ctrlUnitOrgInfo = PermBizHelper.findFullOrgUnfoByNumber(ctx, cuNumber);
            CtrlUnitInfo ctrlUnitInfo = new CtrlUnitInfo();
            ctrlUnitInfo.setId(ctrlUnitOrgInfo.getId());
            roleInfo.setCU(ctrlUnitInfo);
            return roleInfo;
        }
        catch (RoleException e) {
            logger.error((Object)"", (Throwable)((Object)e));
            throw new TaskExternalException(e.getMessage());
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            throw new TaskExternalException(e.getMessage());
        }
        catch (EASBizException e) {
            logger.error((Object)"", (Throwable)e);
            throw new TaskExternalException(e.getMessage());
        }
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, String> result = new Hashtable<String, String>();
        try {
            result.put("FRoleNumber", rs.getString("number"));
            result.put("FType", rs.getString("type"));
            result.put("FName", StringUtils.cnulls((String)rs.getString("name")));
            result.put("FDescription", StringUtils.cnulls((String)rs.getString("description")));
            result.put("FSimpleName", StringUtils.cnulls((String)rs.getString("simpleName")));
            String cuId = rs.getString("CU.id");
            ICtrlUnit iCtrlUnit = CtrlUnitFactory.getLocalInstance((Context)ctx);
            CtrlUnitInfo ctrlUnitInfo = iCtrlUnit.getCtrlUnitInfo((IObjectPK)new ObjectStringPK(cuId));
            result.put("FControlUnitNumber", ctrlUnitInfo.getNumber());
        }
        catch (SQLException e) {
            logger.error((Object)"eccor!", (Throwable)e);
            throw new TaskExternalException(e.getMessage());
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            throw new TaskExternalException(e.getMessage());
        }
        catch (EASBizException e) {
            logger.error((Object)"", (Throwable)e);
            throw new TaskExternalException(e.getMessage());
        }
        return result;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.base.permission.app.RoleQuery";
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        try {
            FilterInfo defFilter = new FilterInfo();
            FilterItemInfo filterItemInfo = new FilterItemInfo("CU.id", (Object)ToolUtils.aryToStr(PermissionRangeHelper.getCUOrgRange(ctx), false), CompareType.INCLUDE);
            defFilter.getFilterItems().add(filterItemInfo);
            return defFilter;
        }
        catch (EASBizException e) {
            logger.error((Object)"", (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
        }
        return null;
    }
}

