/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.permission.IRoleMenuFacade;
import com.kingdee.eas.base.permission.MultiLangHelper;
import com.kingdee.eas.base.permission.PermCacheFacadeFactory;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.PermType;
import com.kingdee.eas.base.permission.PermissionResUtil;
import com.kingdee.eas.base.permission.RoleCollection;
import com.kingdee.eas.base.permission.RoleGroupInfo;
import com.kingdee.eas.base.permission.RoleInfo;
import com.kingdee.eas.base.permission.RoleMenuFacadeFactory;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.UserRoleOrgCollection;
import com.kingdee.eas.base.permission.UserRoleOrgException;
import com.kingdee.eas.base.permission.UserRoleOrgInfo;
import com.kingdee.eas.base.permission.UserRolePermCollection;
import com.kingdee.eas.base.permission.UserRolePermInfo;
import com.kingdee.eas.base.permission.app.AbstractUserRoleOrgManagerControllerBean;
import com.kingdee.eas.base.permission.app.RoleGroupControllerBean;
import com.kingdee.eas.base.permission.app.UpdateType;
import com.kingdee.eas.base.permission.app.UserOrgPermControllerBean;
import com.kingdee.eas.base.permission.app.helper.UserOrgRoleManagerHelper;
import com.kingdee.eas.base.permission.app.plunin.PermissionChangeHelper;
import com.kingdee.eas.base.permission.app.util.GroupLicenseUseInfoUtil;
import com.kingdee.eas.base.permission.app.util.PermissionUtil;
import com.kingdee.eas.base.permission.app.util.interior.permgroup.UserPermChangeListener;
import com.kingdee.eas.base.permission.util.CacheUtil;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class UserRoleOrgManagerControllerBean
extends AbstractUserRoleOrgManagerControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(UserOrgPermControllerBean.class);
    private static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionResource";

    @Override
    protected RoleCollection _getRoles(Context ctx, IObjectPK userPK, IObjectPK orgPK) throws BOSException, EASBizException {
        assert (userPK != null && orgPK != null);
        try {
            RoleCollection collection = new RoleCollection();
            this.getRoleCol(ctx, userPK, new IObjectPK[]{orgPK}, collection, "T_PM_UserRoleOrg", "");
            return collection;
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new UserRoleOrgException(UserRoleOrgException.GET_USERROLEORG_FAIL, e);
        }
    }

    @Override
    protected RoleCollection _getUserGrantRoles(Context ctx, IObjectPK userPK, IObjectPK[] orgPKs) throws BOSException, EASBizException {
        RoleCollection roleColl = new RoleCollection();
        try {
            this.getRoleCol(ctx, userPK, orgPKs, roleColl, "T_PM_GrantUserRoleOrg", "");
            return roleColl;
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new UserRoleOrgException(UserRoleOrgException.GET_USERROLEORG_FAIL, e);
        }
    }

    @Override
    protected RoleCollection[] _getUserRoles(Context ctx, IObjectPK userPk, IObjectPK orgPk, String methodName) throws BOSException, EASBizException {
        assert (userPk != null && orgPk != null);
        try {
            RoleCollection[] collection = new RoleCollection[]{new RoleCollection(), new RoleCollection()};
            this.getRoleCol(ctx, userPk, new IObjectPK[]{orgPk}, collection[0], "T_PM_UserRoleOrg", methodName);
            this.getRoleCol(ctx, userPk, new IObjectPK[]{orgPk}, collection[1], "T_PM_GrantUserRoleOrg", methodName);
            return collection;
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new UserRoleOrgException(UserRoleOrgException.GET_USERROLEORG_FAIL, e);
        }
    }

    private RoleCollection getRoleCol(Context ctx, IObjectPK userPK, IObjectPK[] orgPKs, RoleCollection collection, String tableName, String methodName) throws BOSException, SQLException, EASBizException {
        StringBuffer sql = new StringBuffer(200);
        String nameField = MultiLangHelper.getFieldName("FName", ctx.getLocale());
        StringBuffer orgPKStr = new StringBuffer();
        for (int i = 0; i < orgPKs.length; ++i) {
            if (i == orgPKs.length - 1) {
                orgPKStr.append("'").append(orgPKs[i].toString()).append("'");
                continue;
            }
            orgPKStr.append("'").append(orgPKs[i].toString()).append("',");
        }
        Object[] params = new Object[]{userPK.toString()};
        sql.append("SELECT UserRoleOrg.FRoleID FRoleID, Role.FNumber FNumber,Role.fgroupid fGroupId, ").append(" Role.").append(nameField).append(" FName").append(", Role.FControlUnitID FROM " + tableName + " UserRoleOrg ").append(" INNER JOIN T_PM_Role Role ON Role.FID = UserRoleOrg.FRoleID ").append(" WHERE UserRoleOrg.FUserID = ? ");
        if (!this.getCurrentUserInfo(ctx).isBizAdmin()) {
            sql.append(" AND UserRoleOrg.FOrgID in ( ").append(orgPKStr).append(")");
        } else {
            if ("".equals(methodName) || "loadList".equals(methodName)) {
                sql.append(" AND UserRoleOrg.FOrgID in ( ").append(orgPKStr).append(")");
            }
            sql.append(" UNION ");
            sql.append(" select ro.fid FRoleID,ro.fnumber FNumber,ro.fgroupid fGroupId,ro.").append(nameField).append(" FName ").append(", ro.FControlUnitID from T_PM_ROLE ro");
            sql.append(" where ro.fcreatorid = ? ");
            params = new Object[]{userPK.toString(), userPK.toString()};
        }
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params);
        while (rowSet.next()) {
            RoleInfo roleInfo = new RoleInfo();
            roleInfo.setId(BOSUuid.read((String)rowSet.getString("FRoleID")));
            roleInfo.setName(rowSet.getString("FName"));
            roleInfo.setNumber(rowSet.getString("FNumber"));
            String groupId = rowSet.getString("fGroupId");
            if (groupId != null && !StringUtils.isEmpty((String)groupId)) {
                RoleGroupInfo info = (RoleGroupInfo)new RoleGroupControllerBean()._getValue(ctx, (IObjectPK)new ObjectUuidPK(groupId));
                roleInfo.setGroup(info);
            }
            CtrlUnitInfo cu = new CtrlUnitInfo();
            cu.setId(BOSUuid.read((String)rowSet.getString("FControlUnitID")));
            roleInfo.setCU(cu);
            collection.add(roleInfo);
        }
        return collection;
    }

    @Override
    protected RoleCollection _getAllUserRole(Context ctx, IObjectPK userPK) throws BOSException, EASBizException {
        return this.getUserAllRole(ctx, userPK, false);
    }

    @Override
    protected RoleCollection _getUserAllGrantRole(Context ctx, IObjectPK userPK) throws BOSException, EASBizException {
        return this.getUserAllRole(ctx, userPK, true);
    }

    private RoleCollection getUserAllRole(Context ctx, IObjectPK userPK, boolean isGrant) throws BOSException, EASBizException {
        assert (userPK != null);
        try {
            String tableName = "T_PM_UserRoleOrg";
            if (isGrant) {
                tableName = "T_PM_GrantUserRoleOrg";
            }
            RoleCollection collection = new RoleCollection();
            String nameField = MultiLangHelper.getFieldName("FName", ctx.getLocale());
            StringBuffer sql = new StringBuffer(200);
            Object[] params = new Object[]{userPK.toString()};
            sql.append("SELECT FID, FNumber, ").append(nameField).append(" FROM  t_pm_role where fid in (select distinct froleid from ").append(tableName).append(" WHERE FUserID = ? ) ");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params);
            while (rowSet.next()) {
                RoleInfo roleInfo = new RoleInfo();
                roleInfo.setId(BOSUuid.read((String)rowSet.getString("FID")));
                roleInfo.setNumber(rowSet.getString("FNumber"));
                roleInfo.setName(rowSet.getString(nameField));
                collection.add(roleInfo);
            }
            return collection;
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new UserRoleOrgException(UserRoleOrgException.GET_USERROLEORG_FAIL, e);
        }
    }

    private void saveRoleComFunToUser(Context ctx, UserRoleOrgCollection userRoleOrgs) throws BOSException, EASBizException {
        HashSet<String> userIdSet = new HashSet<String>();
        HashSet<String> roleIdSet = new HashSet<String>();
        int size = userRoleOrgs.size();
        for (int i = 0; i < size; ++i) {
            UserRoleOrgInfo info = userRoleOrgs.get(i);
            RoleInfo role = info.getRole();
            if (role == null) continue;
            roleIdSet.add(role.getId().toString());
            userIdSet.add(info.getUser().getId().toString());
        }
        this.saveRoleComFunToUser(ctx, userIdSet, roleIdSet);
    }

    private void saveRoleComFunToUser(Context ctx, Set<String> userIdSet, Set<String> roleIdSet) throws BOSException, EASBizException {
        IRoleMenuFacade iRoleMenuFacade = RoleMenuFacadeFactory.getLocalInstance(ctx);
        iRoleMenuFacade.saveRoleComFunToUser(userIdSet, roleIdSet);
    }

    @Override
    protected UserCollection _getUsers(Context ctx, IObjectPK orgPK, IObjectPK rolePK) throws BOSException, EASBizException {
        assert (orgPK != null && rolePK != null);
        try {
            UserCollection collection = new UserCollection();
            StringBuffer sql = new StringBuffer(200);
            String nameField = MultiLangHelper.getFieldName("FName", ctx.getLocale());
            Object[] params = new Object[]{orgPK.toString(), rolePK.toString()};
            sql.append("SELECT UserRoleOrg.FUserID, ").append(" U.FNumber , U.").append(nameField).append(" FROM T_PM_UserRoleOrg UserRoleOrg ").append(" INNER JOIN T_PM_User U ON U.FID = UserRoleOrg.FUserID ").append(" WHERE UserRoleOrg.FOrgID = ? ").append(" AND UserRoleOrg.FRoleID = ? ");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params);
            while (rowSet.next()) {
                UserInfo userInfo = new UserInfo();
                userInfo.setId(BOSUuid.read((String)rowSet.getString("FUserID")));
                userInfo.setNumber(rowSet.getString("FNumber"));
                userInfo.setName(rowSet.getString(nameField));
                collection.add(userInfo);
            }
            return collection;
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new UserRoleOrgException(UserRoleOrgException.GET_USERROLEORG_FAIL, e);
        }
    }

    private HashMap<String, List<String>> cuOrgListHashMap(Context ctx, List<String> orgCol) throws BOSException, EASBizException {
        HashMap<String, List<String>> cuOrgHasmMap = new HashMap<String, List<String>>();
        if (orgCol == null || orgCol.isEmpty()) {
            return cuOrgHasmMap;
        }
        HashMap result = new HashMap();
        String sql = "SELECT FID,FControlUnitID FROM T_ORG_BaseUnit WHERE FID in (" + ToolUtils.aryToStr(orgCol) + ")";
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rowSet.next()) {
                String cuIDStr = rowSet.getString("FControlUnitID");
                String currentOrg = rowSet.getString("FID");
                List<String> orgList = cuOrgHasmMap.get(cuIDStr);
                if (orgList == null) {
                    orgList = new ArrayList<String>();
                    cuOrgHasmMap.put(cuIDStr, orgList);
                }
                orgList.add(currentOrg);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException();
        }
        return cuOrgHasmMap;
    }

    private void batchAddRoleComFunToUser(Context ctx, String userId, List<String> roleList) throws EASBizException, BOSException {
        HashSet<String> userIdSet = new HashSet<String>();
        userIdSet.add(userId);
        HashSet<String> roleIdSet = new HashSet<String>();
        for (String roleId : roleList) {
            roleIdSet.add(roleId);
        }
        this.saveRoleComFunToUser(ctx, userIdSet, roleIdSet);
    }

    private void transferList2Collection(Context ctx, IObjectPK userPK, List orgList, List roleList, UserRoleOrgCollection uroCollection) {
        if (orgList == null || roleList == null) {
            return;
        }
        for (int i = 0; i < orgList.size() && orgList.get(i) != null; ++i) {
            for (int j = 0; j < roleList.size() && roleList.get(j) != null; ++j) {
                UserRoleOrgInfo uroInfo = new UserRoleOrgInfo();
                UserInfo usInfo = new UserInfo();
                usInfo.setId(BOSUuid.read((String)userPK.toString()));
                uroInfo.setUser(usInfo);
                uroInfo.setOrg((FullOrgUnitInfo)orgList.get(i));
                uroInfo.setRole((RoleInfo)roleList.get(j));
                uroCollection.add(uroInfo);
            }
        }
    }

    @Override
    protected IObjectCollection _getUserRolePermCol(Context ctx, List userIdList, List orgIdList, List roleIdList) throws BOSException, EASBizException {
        try {
            String sqlStr = "select FUserID, FRoleID, FOrgId from T_PM_UserRoleOrg " + this.getWhereStr(userIdList, orgIdList, roleIdList);
            IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sqlStr);
            UserRolePermCollection userRolePermCol = new UserRolePermCollection();
            while (iRowSet.next()) {
                UserRolePermInfo userRolePermInfo = new UserRolePermInfo();
                String userId = iRowSet.getString("FUserID");
                String roleId = iRowSet.getString("FRoleID");
                String orgId = iRowSet.getString("FOrgId");
                if (!StringUtils.isEmpty((String)userId)) {
                    UserInfo userInfo = new UserInfo();
                    userInfo.setId(BOSUuid.read((String)userId));
                    userRolePermInfo.setUserId(userInfo);
                }
                if (!StringUtils.isEmpty((String)roleId)) {
                    RoleInfo roleInfo = new RoleInfo();
                    roleInfo.setId(BOSUuid.read((String)roleId));
                    userRolePermInfo.setRoleId(roleInfo);
                }
                if (!StringUtils.isEmpty((String)orgId)) {
                    FullOrgUnitInfo fullOrgInfo = new FullOrgUnitInfo();
                    fullOrgInfo.setId(BOSUuid.read((String)orgId));
                    userRolePermInfo.setOrgId(fullOrgInfo);
                }
                userRolePermCol.add(userRolePermInfo);
            }
            return userRolePermCol;
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    private String getWhereStr(List userIdList, List orgIdList, List roleIdList) {
        String retStr = "";
        if (ToolUtils.isNullList(userIdList) && ToolUtils.isNullList(orgIdList) && ToolUtils.isNullList(roleIdList)) {
            return "";
        }
        retStr = " where ";
        String whereStr = "";
        if (!ToolUtils.isNullList(userIdList)) {
            whereStr = " and FUserId in (" + ToolUtils.aryToStr(userIdList, true) + ") ";
        }
        if (!ToolUtils.isNullList(orgIdList)) {
            whereStr = whereStr + "and  FOrgId in (" + ToolUtils.aryToStr(orgIdList, true) + ") ";
        }
        if (!ToolUtils.isNullList(roleIdList)) {
            whereStr = whereStr + "and  FRoleId in (" + ToolUtils.aryToStr(roleIdList, true) + ")";
        }
        if ((whereStr = whereStr.trim()).startsWith("and")) {
            whereStr = whereStr.substring(4, whereStr.length());
        }
        return retStr + whereStr;
    }

    @Override
    protected void _cleanRolePermCache(Context ctx, BOSUuid rolePK) throws BOSException, EASBizException {
        if (rolePK == null) {
            return;
        }
        String ids = "'" + rolePK.toString() + "'";
        this.cleanPermissionCache(ctx, ids);
    }

    private void cleanPermissionCache(Context ctx, String ids) throws BOSException, EASBizException {
        String sql = "SELECT DISTINCT FUserID FROM T_PM_UserRoleOrg WHERE FRoleID in (" + ids + ")";
        IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            ArrayList<String> userIDList = new ArrayList<String>();
            while (rowset.next()) {
                String userID = rowset.getString("FUserID");
                if (userID == null) continue;
                userIDList.add(userID);
                ObjectStringPK userPK = new ObjectStringPK(userID);
                PermCacheFacadeFactory.getLocalInstance(ctx).removeAllPermCacheByUser(userPK.toString());
                CacheUtil.clearCache4User((IObjectPK)userPK);
            }
        }
        catch (SQLException e) {
            logger.error((Object)(PermissionResUtil.getResource("res_56") + "ID" + PermissionResUtil.getResource("res_57")));
        }
    }

    @Override
    protected List _getOrgList(Context ctx, IObjectPK userPK, String roleID) throws BOSException, EASBizException {
        ArrayList<String> orgList = new ArrayList<String>();
        if (userPK != null && !StringUtils.isEmpty((String)roleID)) {
            String sql = "Select FOrgID From T_PM_GrantUserRoleOrg Where FRoleID = '" + roleID + "' And FUserID = '" + userPK.toString() + "'";
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            try {
                while (rowSet.next()) {
                    String orgID = rowSet.getString("FOrgID");
                    if (StringUtils.isEmpty((String)orgID)) continue;
                    orgList.add(orgID);
                }
            }
            catch (SQLException e) {
                logger.error((Object)(PermissionResUtil.getResource("res_58") + userPK + " " + PermissionResUtil.getResource("res_59") + roleID + " " + PermissionResUtil.getResource("res_60")), (Throwable)e);
            }
        }
        return orgList;
    }

    private void handleCallBack(Context ctx, IObjectPK targetUserPK) throws EASBizException, BOSException {
        try {
            PermissionChangeHelper helper = new PermissionChangeHelper();
            helper.setUserPK(targetUserPK);
            helper.exceChange(ctx);
        }
        catch (Exception e) {
            logger.error((Object)"handleCallBack when saving user orgnization permissions:", (Throwable)e);
        }
    }

    public Map getPermsForAssignedRoles(Context ctx, String userID, List roleIDs) throws BOSException {
        HashMap roleToPerms = new HashMap();
        String pmnameField = MultiLangHelper.getFieldName("FAlias", ctx.getLocale());
        String ronameField = MultiLangHelper.getFieldName("FName", ctx.getLocale());
        Connection con = null;
        PreparedStatement ps = null;
        StringBuffer sbSQL = new StringBuffer();
        String roleS = ToolUtils.aryToStr(roleIDs);
        try {
            con = this.getConnection(ctx);
            sbSQL.append(" select ro.fid,ro.").append(ronameField).append(",pm.fid,pm.").append(pmnameField).append(" from T_PM_ROLEPERM rop ");
            sbSQL.append(" inner join T_PM_ROLE ro on ro.fid=rop.froleid ");
            sbSQL.append(" inner join T_PM_PERMITEM pm on pm.fid=rop.fpermitemid ");
            sbSQL.append(" where rop.froleid in (").append(roleS).append(")");
            ps = con.prepareStatement(sbSQL.toString());
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                String roleid = rs.getString(1);
                String permId = rs.getString(3);
                String permName = rs.getString(4);
                if (!roleToPerms.containsKey(roleid)) {
                    roleToPerms.put(roleid, new HashSet());
                }
                PermItemInfo pmInfo = new PermItemInfo();
                pmInfo.setId(BOSUuid.read((String)permId));
                pmInfo.setName(permName);
                ((Set)roleToPerms.get(roleid)).add(pmInfo);
            }
        }
        catch (Exception sqle) {
            try {
                throw new BOSException((Throwable)sqle);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)con);
        return roleToPerms;
    }

    private UserInfo getCurrentUserInfo(Context context) {
        return ContextUtil.getCurrentUserInfo((Context)context);
    }

    private Map getPermsForAssignedOrgs(Context ctx, String userID, List orgIDs) throws BOSException {
        HashMap orgToPerms = new HashMap();
        if (orgIDs.size() == 0) {
            return orgToPerms;
        }
        Connection con = null;
        PreparedStatement ps = null;
        StringBuffer sbSQL = new StringBuffer();
        String orgS = ToolUtils.aryToStr(orgIDs);
        UserInfo currentUser = ContextUtil.getCurrentUserInfo((Context)ctx);
        try {
            con = this.getConnection(ctx);
            sbSQL.append(" select distinct uop.forgid,uop.fpermitemid from T_PM_USERORGPERM uop ");
            sbSQL.append(" where uop.fowner='").append(currentUser.getId().toString()).append("' ");
            sbSQL.append(" and uop.forgid in (").append(orgS).append(") ");
            sbSQL.append(" and uop.fpermtype='").append(30).append("'");
            sbSQL.append(" union all");
            sbSQL.append(" select distinct gro.forgid,rop.fpermitemid from T_PM_ROLEPERM rop ");
            sbSQL.append(" inner join T_PM_UserRoleOrg gro on gro.froleid=rop.froleid ");
            sbSQL.append(" where gro.fuserid='").append(currentUser.getId().toString()).append("'");
            sbSQL.append(" and gro.forgid in (").append(orgS).append(") ");
            sbSQL.append(" and rop.fpermtype='").append(30).append("' ");
            ps = con.prepareStatement(sbSQL.toString());
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                String orgId = rs.getString(1);
                String permId = rs.getString(2);
                if (!orgToPerms.containsKey(orgId)) {
                    orgToPerms.put(orgId, new HashSet());
                }
                ((Set)orgToPerms.get(orgId)).add(permId);
            }
        }
        catch (Exception sqle) {
            try {
                throw new BOSException((Throwable)sqle);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)con);
        return orgToPerms;
    }

    @Override
    protected List _batchSaveUsersRolePerm(Context ctx, List userPKs, List orgList, List assignRoleList, List grantRoleList) throws BOSException, EASBizException {
        if (userPKs == null || userPKs.isEmpty() || orgList == null || orgList.isEmpty() || (assignRoleList == null || assignRoleList.isEmpty()) && (grantRoleList == null || grantRoleList.isEmpty())) {
            throw new IllegalArgumentException("when _batchRemoveUsersRolePerm , param is null !");
        }
        if (assignRoleList != null && !assignRoleList.isEmpty()) {
            this.batchSaveUserOrgRoles(ctx, PermissionUtil.getPkIds(userPKs), PermissionUtil.getPkIds(orgList), PermissionUtil.getPkIds(assignRoleList), "T_PM_UserRoleOrg");
            UserRoleOrgManagerControllerBean.handleCallBack(ctx, userPKs);
        }
        if (grantRoleList != null && !grantRoleList.isEmpty()) {
            this.batchSaveUserOrgRoles(ctx, PermissionUtil.getPkIds(userPKs), PermissionUtil.getPkIds(orgList), PermissionUtil.getPkIds(grantRoleList), "T_PM_GrantUserRoleOrg");
        }
        UserOrgRoleManagerHelper.afterSaveRoleLog(ctx);
        return null;
    }

    @Override
    protected void _saveUserRoleOrgs(Context ctx, IObjectPK userPk, IObjectPK orgPk, List rolePks, boolean check) throws BOSException, EASBizException {
        if (userPk == null || orgPk == null || rolePks == null) {
            throw new BOSException("params is null error");
        }
        List<String> roleIds = PermissionUtil.getPkIds(rolePks);
        if (check) {
            UserOrgRoleManagerHelper.saveUserRoleOrgsCheck(ctx, userPk.toString(), orgPk.toString(), roleIds, "T_PM_UserRoleOrg");
        } else {
            UserOrgRoleManagerHelper.saveUserOrgRoles(ctx, userPk.toString(), orgPk.toString(), roleIds, "T_PM_UserRoleOrg");
        }
        GroupLicenseUseInfoUtil.assignRoles(ctx, userPk.toString(), PermissionUtil.getPkIds(rolePks));
        this.handleCallBack(ctx, userPk);
        UserOrgRoleManagerHelper.afterSaveRoleLog(ctx);
    }

    public void appendUserOrgRolesNotCheck(Context ctx, IObjectPK userPk, IObjectPK orgPk, List<IObjectPK> RolePks) throws BOSException, EASBizException {
        UserOrgRoleManagerHelper.insertUserRolesOrgByCheck(ctx, userPk.toString(), orgPk.toString(), new HashSet<String>(PermissionUtil.getPkIds(new ArrayList<IObjectPK>(RolePks))), "T_PM_UserRoleOrg");
        GroupLicenseUseInfoUtil.assignRoles(ctx, userPk.toString(), PermissionUtil.getPkIds(RolePks));
    }

    public void saveUserOrgGrantRoles(Context ctx, IObjectPK userPk, IObjectPK orgPk, Set<IObjectPK> RolePks) throws BOSException {
        if (userPk == null || orgPk == null || RolePks == null) {
            throw new BOSException("params is null error");
        }
        UserOrgRoleManagerHelper.insertUserRolesOrgByCheck(ctx, userPk.toString(), orgPk.toString(), new HashSet<String>(PermissionUtil.getPkIds(new ArrayList<IObjectPK>(RolePks))), "T_PM_GrantUserRoleOrg");
    }

    private void batchSaveUsersRolesOrgsNotPermAuthen(Context ctx, List userPKs, List orgList, List assignRoleList, List grantRoleList) throws BOSException, EASBizException {
        List<String> roleIds;
        List<String> userIds = PermissionUtil.getPkIds(userPKs);
        List<String> orgIds = PermissionUtil.getPkIds(orgList);
        if (assignRoleList != null && !assignRoleList.isEmpty()) {
            roleIds = PermissionUtil.getPkIds(assignRoleList);
            UserOrgRoleManagerHelper.insertUserRolesOrgByCheck(ctx, new HashSet<String>(userIds), new HashSet<String>(orgIds), new HashSet<String>(roleIds), "T_PM_UserRoleOrg");
            GroupLicenseUseInfoUtil.assignUsersRoles(ctx, userPKs, roleIds);
            UserRoleOrgManagerControllerBean.handleCallBack(ctx, PermissionUtil.toIObjectPKs(userPKs));
        }
        if (grantRoleList != null && !grantRoleList.isEmpty()) {
            roleIds = PermissionUtil.getPkIds(grantRoleList);
            UserOrgRoleManagerHelper.insertUserRolesOrgByCheck(ctx, new HashSet<String>(userIds), new HashSet<String>(orgIds), new HashSet<String>(roleIds), "T_PM_GrantUserRoleOrg");
        }
    }

    private void batchAddRoleComFunToUser(Context ctx, List<IObjectPK> userPKs, List roleList) throws EASBizException, BOSException {
        HashSet<String> userIdSet = new HashSet<String>();
        for (IObjectPK userPK : userPKs) {
            userIdSet.add(userPK.toString());
        }
        HashSet<String> roleIdSet = new HashSet<String>();
        int size = roleList.size();
        for (int i = 0; i < size; ++i) {
            RoleInfo role = (RoleInfo)roleList.get(i);
            roleIdSet.add(role.getId().toString());
        }
        this.saveRoleComFunToUser(ctx, userIdSet, roleIdSet);
    }

    private static void handleCallBack(Context ctx, List<IObjectPK> targetUserPKs) throws EASBizException, BOSException {
        try {
            PermissionChangeHelper helper = new PermissionChangeHelper();
            helper.setUserPKs((IObjectPK[])targetUserPKs.toArray(new ObjectStringPK[targetUserPKs.size()]));
            helper.exceChange(ctx);
        }
        catch (Exception e) {
            logger.error((Object)"handleCallBack when saving user orgnization permissions:", (Throwable)e);
        }
    }

    private void batchSaveUserOrgRoles(Context ctx, List userIds, List orgIds, List roleIds, String tableName) throws EASBizException, BOSException {
        for (Object userId : userIds) {
            HashSet appendRoleIds = new HashSet();
            for (Object orgId : orgIds) {
                Map<UpdateType, List<String>> appendUserOrgRoles = UserOrgRoleManagerHelper.appendUserOrgRoles(ctx, userId.toString(), orgId.toString(), new ArrayList<String>(roleIds), tableName);
                appendRoleIds.addAll(new HashSet(appendUserOrgRoles.get((Object)UpdateType.APPEND)));
            }
            if (!"T_PM_UserRoleOrg".equalsIgnoreCase(tableName) || appendRoleIds == null || appendRoleIds.isEmpty()) continue;
            GroupLicenseUseInfoUtil.assignRoles(ctx, userId.toString(), new ArrayList<String>(appendRoleIds));
            this.batchAddRoleComFunToUser(ctx, userId.toString(), new ArrayList<String>(appendRoleIds));
        }
    }

    private void batchRemoveUserOrgRoles(Context ctx, List userIds, List orgIds, List roleIds, String tableName) throws EASBizException, BOSException {
        for (Object userId : userIds) {
            for (Object orgId : orgIds) {
                UserOrgRoleManagerHelper.removeUserOrgRoles(ctx, userId.toString(), orgId.toString(), new ArrayList<String>(roleIds), tableName);
            }
        }
    }

    @Override
    protected List _batchRemoveUsersRolePerm(Context ctx, List userPKs, List orgList, List assignRoleList, List grantRoleList) throws BOSException, EASBizException {
        if (userPKs == null || userPKs.isEmpty() || orgList == null || orgList.isEmpty() || (assignRoleList == null || assignRoleList.isEmpty()) && (grantRoleList == null || grantRoleList.isEmpty())) {
            throw new IllegalArgumentException("when _batchRemoveUsersRolePerm , param is null !");
        }
        if (assignRoleList != null && !assignRoleList.isEmpty()) {
            UserPermChangeListener userPermChangeListener = new UserPermChangeListener(ctx, PermissionUtil.getPkIds(userPKs), EASResource.getString((String)RESOURCE, (String)"MULTI_DELETE_USERROLE"));
            userPermChangeListener.before();
            this.batchRemoveUserOrgRoles(ctx, PermissionUtil.getPkIds(userPKs), PermissionUtil.getPkIds(orgList), PermissionUtil.getPkIds(assignRoleList), "T_PM_UserRoleOrg");
            userPermChangeListener.after();
        }
        if (grantRoleList != null && !grantRoleList.isEmpty()) {
            this.batchRemoveUserOrgRoles(ctx, PermissionUtil.getPkIds(userPKs), PermissionUtil.getPkIds(orgList), PermissionUtil.getPkIds(grantRoleList), "T_PM_GrantUserRoleOrg");
        }
        UserRoleOrgManagerControllerBean.handleCallBack(ctx, PermissionUtil.toIObjectPKs(userPKs));
        UserOrgRoleManagerHelper.afterSaveRoleLog(ctx);
        return new ArrayList();
    }

    @Override
    protected void _removeUserOrgRole(Context ctx, List userOrgRoles) throws BOSException, EASBizException {
        HashSet<ObjectStringPK> UserIds = new HashSet<ObjectStringPK>();
        for (int i = 0; i < userOrgRoles.size(); ++i) {
            UserRoleOrgInfo info = (UserRoleOrgInfo)userOrgRoles.get(i);
            ArrayList<String> roleIds = new ArrayList<String>();
            roleIds.add(info.getRoleId());
            UserPermChangeListener userPermChangeListener = new UserPermChangeListener(ctx, info.getUserId().toString(), EASResource.getString((String)RESOURCE, (String)"DELETE_USER_ORGROLE"));
            userPermChangeListener.before();
            UserOrgRoleManagerHelper.removeUserOrgRoles(ctx, info.getUserId(), info.getOrgId(), roleIds, "T_PM_UserRoleOrg");
            UserIds.add(new ObjectStringPK(info.getUserId().toString()));
            userPermChangeListener.after();
        }
        UserRoleOrgManagerControllerBean.handleCallBack(ctx, new ArrayList<IObjectPK>(UserIds));
        UserOrgRoleManagerHelper.afterSaveRoleLog(ctx);
    }

    @Override
    protected void _saveUserRoleOrgs(Context ctx, UserRoleOrgCollection userRoleOrgs, String userId, String orgId, String tableName) throws BOSException, EASBizException {
        if (tableName == null) {
            tableName = "T_PM_UserRoleOrg";
        }
        if (!"T_PM_UserRoleOrg".equalsIgnoreCase(tableName) && !"T_PM_GrantUserRoleOrg".equalsIgnoreCase(tableName)) {
            throw new BOSException(EASResource.getString((String)RESOURCE, (String)"SAVEUSERROLEORGS_INVALID"));
        }
        ArrayList<String> roleIds = new ArrayList<String>();
        for (int i = 0; i < userRoleOrgs.size(); ++i) {
            roleIds.add(userRoleOrgs.get(i).getRoleId());
        }
        UserPermChangeListener userPermChangeListener = new UserPermChangeListener(ctx, userId, EASResource.getString((String)RESOURCE, (String)"SAVE_USER_ROLE"));
        userPermChangeListener.before();
        Map<UpdateType, List<String>> saveUserRoleOrgsCheck = UserOrgRoleManagerHelper.saveUserRoleOrgsCheck(ctx, userId, orgId, roleIds, tableName);
        List<String> delRoleIds = saveUserRoleOrgsCheck.get((Object)UpdateType.DELETE);
        List<String> addRolIds = saveUserRoleOrgsCheck.get((Object)UpdateType.APPEND);
        if (delRoleIds != null && !delRoleIds.isEmpty()) {
            GroupLicenseUseInfoUtil.syncUserGroups(ctx, (IObjectPK)new ObjectStringPK(userId));
            this.handleCallBack(ctx, (IObjectPK)new ObjectStringPK(userId));
        } else if (addRolIds != null && !addRolIds.isEmpty()) {
            GroupLicenseUseInfoUtil.assignRoles(ctx, userId, addRolIds);
            this.handleCallBack(ctx, (IObjectPK)new ObjectStringPK(userId));
        }
        UserOrgRoleManagerHelper.afterSaveRoleLog(ctx);
    }

    @Override
    protected void _roleAssignUserOrgBatch(Context ctx, List userPKs, String roleID, String orgID) throws BOSException, EASBizException {
        if (userPKs == null || userPKs.isEmpty() || orgID == null || roleID == null) {
            throw new IllegalArgumentException("when _roleAssignUserOrgBatch , param is null !");
        }
        ArrayList<String> assignRoleIdList = new ArrayList<String>();
        assignRoleIdList.add(roleID);
        for (Object userPk : userPKs) {
            UserOrgRoleManagerHelper.appendUserOrgRoles(ctx, userPk.toString(), orgID, assignRoleIdList, "T_PM_UserRoleOrg");
            this.batchAddRoleComFunToUser(ctx, userPk.toString(), assignRoleIdList);
        }
        List<IObjectPK> iObjectPKs = PermissionUtil.toIObjectPKs(userPKs);
        GroupLicenseUseInfoUtil.assignUsersRoles(ctx, iObjectPKs, assignRoleIdList);
        UserRoleOrgManagerControllerBean.handleCallBack(ctx, iObjectPKs);
        UserOrgRoleManagerHelper.afterSaveRoleLog(ctx);
    }

    @Override
    protected void _disAssignRole2Users(Context ctx, UserRoleOrgCollection userRoleOrgCols) throws BOSException, EASBizException {
        HashSet<String> UserIds = new HashSet<String>();
        HashMap<String, ArrayList<String>> userOrgRoles = new HashMap<String, ArrayList<String>>();
        int size = userRoleOrgCols.size();
        for (int i = 0; i < size; ++i) {
            UserRoleOrgInfo userRole = userRoleOrgCols.get(i);
            String userId = userRole.getUserId();
            String orgId = userRole.getOrgId();
            String roleId = userRole.getRoleId();
            if (userId == null || orgId == null || roleId == null) continue;
            String key = userId + "," + orgId;
            ArrayList<String> roleIds = (ArrayList<String>)userOrgRoles.get(key);
            if (roleIds == null) {
                roleIds = new ArrayList<String>();
                userOrgRoles.put(key, roleIds);
            }
            roleIds.add(roleId);
            UserIds.add(userId);
        }
        UserPermChangeListener userPermChangeListener = new UserPermChangeListener(ctx, UserIds, EASResource.getString((String)RESOURCE, (String)"ROLE_CANCEL_USER"));
        userPermChangeListener.before();
        if (!userOrgRoles.isEmpty()) {
            Set userOrgIdSet = userOrgRoles.keySet();
            for (String key : userOrgIdSet) {
                List roleIds = (List)userOrgRoles.get(key);
                String[] userOrg = key.split(",");
                UserOrgRoleManagerHelper.removeUserOrgRoles(ctx, userOrg[0], userOrg[1], roleIds, "T_PM_UserRoleOrg");
            }
        }
        userPermChangeListener.after();
        UserRoleOrgManagerControllerBean.handleCallBack(ctx, PermissionUtil.toIObjectPKs(new ArrayList<String>(UserIds)));
        UserOrgRoleManagerHelper.afterSaveRoleLog(ctx);
    }

    @Override
    protected void _addnew(Context ctx, UserRoleOrgInfo userRoleOrgInfo, PermType type) throws BOSException, EASBizException {
        String tableName = null;
        if (PermType.NORMAL.equals((Object)type)) {
            tableName = "T_PM_UserRoleOrg";
        } else if (PermType.AUTHORIZATION.equals((Object)type)) {
            tableName = "T_PM_GrantUserRoleOrg";
        } else {
            throw new IllegalArgumentException("type must be 10 or 30");
        }
        String sql = "INSERT INTO " + tableName + " (FUserID, FRoleID, FOrgID ) select ''||?,''||?,''||?  where not exists (select 1 from " + tableName + " where  FUserID=? and FRoleID=? and FOrgID=?)";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{userRoleOrgInfo.getUserId(), userRoleOrgInfo.getRoleId(), userRoleOrgInfo.getOrgId(), userRoleOrgInfo.getUserId(), userRoleOrgInfo.getRoleId(), userRoleOrgInfo.getOrgId()});
        PermCacheFacadeFactory.getLocalInstance(ctx).removeAllPermCacheByUser(userRoleOrgInfo.getUserId());
        CacheUtil.clearCache4User(userRoleOrgInfo.getUserPK());
    }

    @Override
    protected boolean _existAssignedUser(Context ctx, IObjectPK rolePK) throws BOSException {
        String sql = "select 1 from T_PM_UserRoleOrg where fRoleId = '" + rolePK.toString() + "'";
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (rowSet.size() > 0) {
                return true;
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return false;
    }

    @Override
    protected Set _getBizObjectTypes(Context ctx, IObjectPK userPK, IObjectPK orgPK) throws BOSException, EASBizException {
        assert (userPK != null && orgPK != null);
        HashSet<String> result = new HashSet<String>();
        StringBuffer buffer = new StringBuffer();
        buffer.append("SELECT DISTINCT PERM.FOBJECTTYPE  FROM T_PM_USERROLEORG uro ").append(" INNER JOIN T_PM_ROLEPERM tpr ON uro.froleid=tpr.FROLEID ").append(" INNER JOIN T_PM_PermItem perm ON tpr.FPERMITEMID = perm.FID ").append(" WHERE uro.FUSERID = ? ").append(" AND ( FOrgID = '").append("11111111-1111-1111-1111-111111111111CCE7AED4").append("' ").append(" OR FOrgID = ? ) ").append(" AND perm.FObjectType IS NOT NULL ");
        Object[] params = new Object[]{userPK.toString(), orgPK.toString()};
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)buffer.toString(), (Object[])params);
        try {
            while (rowSet.next()) {
                String objectType = rowSet.getString("FObjectType");
                if (StringUtils.isEmpty((String)objectType)) continue;
                result.add(objectType);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new UserRoleOrgException(UserRoleOrgException.GET_USERROLEORG_FAIL, e);
        }
        return result;
    }
}

