/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app.clear.scan;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.eas.base.permission.PermClearScanDetailFactory;
import com.kingdee.eas.base.permission.PermClearScanDetailInfo;
import com.kingdee.eas.base.permission.PermClearScanFactory;
import com.kingdee.eas.base.permission.PermClearScanInfo;
import com.kingdee.eas.base.permission.app.clear.PermClearScanTaskManager;
import com.kingdee.eas.base.permission.app.clear.common.PermClearUtils;
import com.kingdee.eas.base.permission.app.clear.scan.IPermClearStrategyScan;
import com.kingdee.eas.base.permission.app.clear.scan.PermClearScan;
import com.kingdee.eas.base.permission.app.clear.scan.PermClearScanBeanExecutor;
import com.kingdee.eas.base.permission.app.clear.scan.PermClearStrategyScanBean;
import com.kingdee.eas.common.EASBizException;
import java.text.ParseException;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;

public class PermClearScanGatherBeanExecutor
implements Callable<Boolean> {
    private static Logger logger = Logger.getLogger((String)PermClearScanGatherBeanExecutor.class.getName());
    private long gatherTime = 1000L;
    private PermClearScanBeanExecutor executor = null;

    public PermClearScanGatherBeanExecutor(PermClearScanBeanExecutor executor) {
        this.executor = executor;
    }

    @Override
    public Boolean call() throws Exception {
        PermClearScan scanBean = this.executor.getScanBean();
        Context ctx = this.executor.getCtx();
        boolean isComplete = scanBean.refreshScan();
        while (!isComplete) {
            isComplete = scanBean.refreshScan();
            PermClearScanGatherBeanExecutor.updateScanResult(ctx, scanBean);
            Thread.sleep(this.gatherTime);
        }
        PermClearScanGatherBeanExecutor.updateScanResult(ctx, scanBean);
        return true;
    }

    public static void updateScanResult(Context ctx, PermClearScan bean) throws EASBizException, BOSException {
        try {
            String scanId = bean.getScanId();
            PermClearScanInfo info = PermClearScanTaskManager.queryScanInfo(ctx, scanId);
            info.setScanStatus(bean.getScanStatus());
            info.setScanStartTime(PermClearUtils.getTimestamp(bean.getScanStartTime()));
            info.setScanEndTime(PermClearUtils.getTimestamp(bean.getScanEndTime()));
            info.setScanGatherResult(bean.getScanGatherResult().serialize());
            info.setScanUpdateTime(PermClearUtils.getTimestamp(bean.getScanUpdateTime()));
            PermClearScanFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectStringPK(scanId), info);
            List<PermClearStrategyScanBean> strategyScanList = bean.getStrategyScanList();
            for (PermClearStrategyScanBean strategyScanBean : strategyScanList) {
                ObjectStringPK pk = new ObjectStringPK(strategyScanBean.getId().toString());
                PermClearScanDetailInfo permClearScanDetailInfo = PermClearScanDetailFactory.getLocalInstance(ctx).getPermClearScanDetailInfo((IObjectPK)pk);
                PermClearScanGatherBeanExecutor.fillClearScanDetailInfoFrom(permClearScanDetailInfo, strategyScanBean);
                PermClearScanDetailFactory.getLocalInstance(ctx).update((IObjectPK)pk, permClearScanDetailInfo);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
    }

    private static void fillClearScanDetailInfoFrom(PermClearScanDetailInfo permClearScanDetailInfo, PermClearStrategyScanBean strategyScanBean) throws ParseException, EASBizException, BOSException {
        IPermClearStrategyScan permClearStrategyScan = strategyScanBean.getPermClearStrategyScan();
        permClearScanDetailInfo.setScanStatus(strategyScanBean.getScanStatus());
        permClearScanDetailInfo.setProcess(strategyScanBean.getProccess());
        permClearScanDetailInfo.setScanStartTime(PermClearUtils.getTimestamp(strategyScanBean.getScanStartTime()));
        permClearScanDetailInfo.setScanEndTime(PermClearUtils.getTimestamp(strategyScanBean.getScanEndTime()));
        permClearScanDetailInfo.setScanUpdateTime(PermClearUtils.getTimestamp(strategyScanBean.getScanUpdateTime()));
        permClearScanDetailInfo.setPreConditionScanResult(permClearStrategyScan.serialize());
    }
}

