/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app.discrete;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.DiscretePermCollection;
import com.kingdee.eas.base.permission.DiscretePermInfo;
import com.kingdee.eas.base.permission.IPermItem;
import com.kingdee.eas.base.permission.IRolePerm;
import com.kingdee.eas.base.permission.IUserOrgPerm;
import com.kingdee.eas.base.permission.PermItemFactory;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.PermType;
import com.kingdee.eas.base.permission.PermissionCommonUtil;
import com.kingdee.eas.base.permission.RoleInfo;
import com.kingdee.eas.base.permission.RolePermFactory;
import com.kingdee.eas.base.permission.RolePermInfo;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.UserOrgPermFactory;
import com.kingdee.eas.base.permission.UserOrgPermInfo;
import com.kingdee.eas.base.permission.app.discrete.DiscretePermissionDAO;
import com.kingdee.eas.base.permission.app.discrete.IDiscretePermissionManager;
import com.kingdee.eas.base.permission.app.plunin.PermissionChangeHelper;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class DiscretePermissionManager
implements IDiscretePermissionManager {
    private Logger logger = Logger.getLogger(DiscretePermissionManager.class);
    private Context context = null;
    private BOSObjectType objectType = null;

    public DiscretePermissionManager(Context context, BOSObjectType objectType) {
        this.context = context;
        this.objectType = objectType;
    }

    @Override
    public void saveDiscretePermission(DiscretePermCollection[] ddps) throws BOSException, EASBizException {
        if (this.isUserDiscretePermission(ddps)) {
            this.saveUserDiscretePerms(ddps);
        } else {
            this.saveRoleDiscretePerms(ddps);
        }
        this.handleCallBack(this.context, ddps);
    }

    private void handleCallBack(Context ctx, DiscretePermCollection[] ddps) throws EASBizException, BOSException {
        try {
            PermissionChangeHelper helper = new PermissionChangeHelper();
            IObjectPK[][] roleAndUserPKs = this.getRoleAndUserPKs(ddps);
            IObjectPK[] rolePKs = roleAndUserPKs[0];
            IObjectPK[] userPKs = roleAndUserPKs[1];
            if (rolePKs != null && rolePKs.length > 0) {
                helper.setRolePKs(rolePKs);
            }
            if (userPKs != null && userPKs.length > 0) {
                helper.setUserPKs(userPKs);
            }
            helper.exceChange(ctx);
        }
        catch (Exception e) {
            this.logger.error((Object)"handleCallBack when saving user orgnization permissions:", (Throwable)e);
        }
    }

    private IObjectPK[][] getRoleAndUserPKs(DiscretePermCollection[] ddps) {
        HashSet<ObjectUuidPK> rolePKSet = new HashSet<ObjectUuidPK>();
        HashSet<ObjectUuidPK> userPKSet = new HashSet<ObjectUuidPK>();
        for (int i = 0; i < ddps.length; ++i) {
            DiscretePermCollection dpc = ddps[i];
            for (int j = 0; j < dpc.size(); ++j) {
                DiscretePermInfo info = dpc.get(j);
                if (info.getRole() != null) {
                    rolePKSet.add(new ObjectUuidPK(info.getRole().getId()));
                }
                if (info.getUser() == null) continue;
                userPKSet.add(new ObjectUuidPK(info.getUser().getId()));
            }
        }
        IObjectPK[] rolePKs = this.setToArray(rolePKSet);
        IObjectPK[] userPKs = this.setToArray(userPKSet);
        IObjectPK[][] roleAndUserPKs = new IObjectPK[][]{rolePKs, userPKs};
        return roleAndUserPKs;
    }

    private IObjectPK[] setToArray(Set pkSet) {
        IObjectPK[] ret = new IObjectPK[pkSet.size()];
        Object[] temp = pkSet.toArray();
        for (int i = 0; i < temp.length; ++i) {
            ret[i] = (IObjectPK)temp[i];
        }
        return ret;
    }

    private void saveUserDiscretePerms(DiscretePermCollection[] ddps) throws EASBizException, BOSException {
        Map mapDDP;
        DiscretePermissionDAO dao = new DiscretePermissionDAO(this.context);
        IObjectPK userPK = this.getUserPK(ddps);
        IObjectPK orgPK = this.getOrgPK(ddps);
        this.processDiscretePerms(ddps);
        DiscretePermCollection removeDPs = ddps[1];
        DiscretePermCollection addDPs = ddps[0];
        DiscretePermCollection updateDPs = ddps[2];
        if (removeDPs.size() > 0) {
            mapDDP = this.getBizDataIDMap(removeDPs);
            dao.removeDiscretePermission(this.objectType, userPK, orgPK, null, mapDDP.keySet());
        }
        if (addDPs.size() > 0) {
            dao.addDiscretePermission(this.objectType, addDPs);
        }
        if (updateDPs.size() > 0) {
            mapDDP = this.getBizDataIDMap(updateDPs);
            dao.removeDiscretePermission(this.objectType, userPK, orgPK, null, mapDDP.keySet());
            dao.addDiscretePermission(this.objectType, updateDPs);
        }
        this.syncUserFunctionPermission(userPK, orgPK);
    }

    public void syncUserFunctionPermission(IObjectPK userPK, IObjectPK orgPK) throws EASBizException, BOSException {
        DiscretePermissionDAO dao = new DiscretePermissionDAO(this.context);
        Map allUOPs = dao.getAllUOPs(userPK, orgPK);
        IUserOrgPerm iUserOrgPerm = UserOrgPermFactory.getLocalInstance(this.context);
        IPermItem iPermItem = PermItemFactory.getLocalInstance(this.context);
        UserInfo userInfo = new UserInfo();
        userInfo.setId(BOSUuid.read((String)userPK.toString()));
        FullOrgUnitInfo org = new FullOrgUnitInfo();
        org.setId(BOSUuid.read((String)orgPK.toString()));
        ObjectUuidPK sysCUPK = new ObjectUuidPK("11111111-1111-1111-1111-111111111111CCE7AED4");
        FullOrgUnitInfo sysOrg = new FullOrgUnitInfo();
        sysOrg.setId(BOSUuid.read((String)sysCUPK.toString()));
        Set permItemIDs = dao.getDiscretePermItems(this.objectType, userPK, orgPK, null);
        for (BOSUuid permItemID : permItemIDs) {
            String key = PermissionCommonUtil.getKey(permItemID, PermType.NORMAL);
            if (allUOPs.containsKey(key)) continue;
            PermItemInfo permItemInfo = iPermItem.getPermItemInfo((IObjectPK)new ObjectUuidPK(permItemID));
            UserOrgPermInfo uop = new UserOrgPermInfo();
            uop.setOwner(userInfo);
            uop.setOrg(permItemInfo.getOrgRelation().equals((Object)OrgType.NONE) ? sysOrg : org);
            uop.setPermItem(permItemInfo);
            uop.setPermType(PermType.NORMAL);
            uop.setCtrlUnit(ContextUtil.getCurrentCtrlUnit((Context)this.context));
            iUserOrgPerm.addnew(uop);
            allUOPs.put(key, uop);
        }
    }

    private void processDiscretePerms(DiscretePermCollection[] ddps) {
        ObjectUuidPK sysCUPK = new ObjectUuidPK("11111111-1111-1111-1111-111111111111CCE7AED4");
        FullOrgUnitInfo sysOrg = new FullOrgUnitInfo();
        sysOrg.setId(BOSUuid.read((String)sysCUPK.toString()));
        int length = ddps.length;
        for (int i = 0; i < length; ++i) {
            int size = ddps[i].size();
            for (int j = 0; j < size; ++j) {
                DiscretePermInfo discretePermInfo = ddps[i].get(j);
                if (discretePermInfo.getPermItem() == null || !OrgType.NONE.equals((Object)discretePermInfo.getPermItem().getOrgRelation())) continue;
                discretePermInfo.setOrg(sysOrg);
            }
        }
    }

    private void saveRoleDiscretePerms(DiscretePermCollection[] ddps) throws EASBizException, BOSException {
        Map mapDDP;
        DiscretePermissionDAO dao = new DiscretePermissionDAO(this.context);
        IObjectPK rolePK = this.getRolePK(ddps);
        DiscretePermCollection removeDPs = ddps[1];
        DiscretePermCollection addDPs = ddps[0];
        DiscretePermCollection updateDPs = ddps[2];
        if (removeDPs.size() > 0) {
            mapDDP = this.getBizDataIDMap(removeDPs);
            dao.removeDiscretePermission(this.objectType, null, null, rolePK, mapDDP.keySet());
        }
        if (addDPs.size() > 0) {
            dao.addDiscretePermission(this.objectType, addDPs);
        }
        if (updateDPs.size() > 0) {
            mapDDP = this.getBizDataIDMap(updateDPs);
            dao.removeDiscretePermission(this.objectType, null, null, rolePK, mapDDP.keySet());
            dao.addDiscretePermission(this.objectType, updateDPs);
        }
        this.syncRoleFunctionPermission(rolePK);
    }

    private void syncRoleFunctionPermission(IObjectPK rolePK) throws BOSException, EASBizException {
        DiscretePermissionDAO dao = new DiscretePermissionDAO(this.context);
        Set permItemIDs = dao.getDiscretePermItems(this.objectType, null, null, rolePK);
        Map allRPs = dao.getAllRPs(rolePK);
        IRolePerm iRolePerm = RolePermFactory.getLocalInstance(this.context);
        RoleInfo roleInfo = new RoleInfo();
        roleInfo.setId(BOSUuid.read((String)rolePK.toString()));
        for (BOSUuid permItemID : permItemIDs) {
            String key = PermissionCommonUtil.getKey(permItemID, PermType.NORMAL);
            if (allRPs.containsKey(key)) continue;
            RolePermInfo uop = new RolePermInfo();
            uop.setRole(roleInfo);
            PermItemInfo permItemInfo = new PermItemInfo();
            permItemInfo.setId(permItemID);
            uop.setPermItem(permItemInfo);
            uop.setPermType(PermType.NORMAL);
            iRolePerm.addnew(uop);
            allRPs.put(key, uop);
        }
    }

    private boolean isUserDiscretePermission(DiscretePermCollection[] ddps) {
        if (ddps[1].size() > 0) {
            return ddps[1].get(0).getUser() != null;
        }
        if (ddps[0].size() > 0) {
            return ddps[0].get(0).getUser() != null;
        }
        if (ddps[2].size() > 0) {
            return ddps[2].get(0).getUser() != null;
        }
        if (ddps[3].size() > 0) {
            return ddps[3].get(0).getUser() != null;
        }
        throw new IllegalArgumentException("ddps is error!");
    }

    @Override
    public Set getUserAuthorizedBizDatas(IObjectPK userPK, IObjectPK orgPK) throws BOSException, EASBizException {
        DiscretePermissionDAO dao = new DiscretePermissionDAO(this.context);
        return dao.getBizDatas(this.objectType, userPK, orgPK, null);
    }

    @Override
    public Set getRoleAuthorizedBizDatas(IObjectPK rolePK) throws BOSException, EASBizException {
        DiscretePermissionDAO dao = new DiscretePermissionDAO(this.context);
        return dao.getBizDatas(this.objectType, null, null, rolePK);
    }

    public Set getUserAllAuthorizedBizDatas(IObjectPK userPK, IObjectPK orgPK) throws BOSException, EASBizException {
        DiscretePermissionDAO dao = new DiscretePermissionDAO(this.context);
        return dao.getBizDatas(this.objectType, userPK, orgPK);
    }

    public DiscretePermCollection getUserDiscretePerms(IObjectPK userPK, IObjectPK orgPK, IObjectPK bizDataPK) throws BOSException, EASBizException {
        DiscretePermissionDAO dao = new DiscretePermissionDAO(this.context);
        return dao.getDiscretePerms(this.objectType, userPK, orgPK, null, bizDataPK);
    }

    @Override
    public DiscretePermCollection getRoleDiscretePerms(IObjectPK rolePK, IObjectPK bizDataPK) throws BOSException, EASBizException {
        DiscretePermissionDAO dao = new DiscretePermissionDAO(this.context);
        return dao.getDiscretePerms(this.objectType, null, null, rolePK, bizDataPK);
    }

    private Map getBizDataIDMap(DiscretePermCollection ddps) {
        HashMap<BOSUuid, DiscretePermCollection> map = new HashMap<BOSUuid, DiscretePermCollection>();
        int size = ddps.size();
        for (int i = 0; i < size; ++i) {
            DiscretePermCollection entry;
            DiscretePermInfo info = ddps.get(i);
            if (map.containsKey(info.getBizDataID())) {
                entry = (DiscretePermCollection)((Object)map.get(info.getBizDataID()));
                entry.add(info);
                continue;
            }
            entry = new DiscretePermCollection();
            entry.add(info);
            map.put(info.getBizDataID(), entry);
        }
        return map;
    }

    private IObjectPK getUserPK(DiscretePermCollection[] ddps) {
        assert (ddps != null);
        int length = ddps.length;
        for (int i = 0; i < length; ++i) {
            int size = ddps[i].size();
            for (int j = 0; j < size; ++j) {
                if (ddps[i].get(j).getUser() == null) continue;
                return new ObjectUuidPK(ddps[i].get(j).getUser().getId());
            }
        }
        throw new IllegalArgumentException("result is error");
    }

    private IObjectPK getOrgPK(DiscretePermCollection[] ddps) {
        assert (ddps != null);
        int length = ddps.length;
        for (int i = 0; i < length; ++i) {
            int size = ddps[i].size();
            for (int j = 0; j < size; ++j) {
                if (ddps[i].get(j).getOrg() == null) continue;
                return new ObjectUuidPK(ddps[i].get(j).getOrg().getId());
            }
        }
        throw new IllegalArgumentException("result is error");
    }

    private IObjectPK getRolePK(DiscretePermCollection[] ddps) {
        assert (ddps != null);
        int length = ddps.length;
        for (int i = 0; i < length; ++i) {
            int size = ddps[i].size();
            for (int j = 0; j < size; ++j) {
                if (ddps[i].get(j).getRole() == null) continue;
                return new ObjectUuidPK(ddps[i].get(j).getRole().getId());
            }
        }
        throw new IllegalArgumentException("result is error");
    }

    @Override
    public void saveDiscretePermission(DiscretePermCollection ddps, boolean isUser) throws BOSException, EASBizException {
        if (ddps == null || ddps.size() == 0) {
            return;
        }
        if (isUser) {
            this.removeDiscretePermission(ddps, true, false);
        } else {
            this.removeDiscretePermission(ddps, false, false);
        }
        DiscretePermissionDAO dao = new DiscretePermissionDAO(this.context);
        dao.addDiscretePermission(this.objectType, ddps);
        if (isUser) {
            DiscretePermCollection filterDuplicInfoCol = this.getFilterDuplicInfo(ddps);
            for (int i = 0; i < filterDuplicInfoCol.size(); ++i) {
                DiscretePermInfo discretePermInfo = filterDuplicInfoCol.get(i);
                this.syncUserFunctionPermission((IObjectPK)new ObjectStringPK(discretePermInfo.getUser().getId().toString()), (IObjectPK)new ObjectStringPK(discretePermInfo.getOrg().getId().toString()));
            }
        } else {
            DiscretePermCollection filterRoleCol = this.getfilterDuplicRole(ddps);
            for (int i = 0; i < filterRoleCol.size(); ++i) {
                DiscretePermInfo discretePermInfo = filterRoleCol.get(i);
                this.syncRoleFunctionPermission((IObjectPK)new ObjectStringPK(discretePermInfo.getRole().getId().toString()));
            }
        }
        this.handleCallBack(this.context, new DiscretePermCollection[]{ddps});
    }

    private DiscretePermCollection getfilterDuplicRole(DiscretePermCollection ddps) {
        DiscretePermCollection retCol = new DiscretePermCollection();
        if (ddps == null || ddps.isEmpty()) {
            return retCol;
        }
        HashSet<String> alreadyAddRoleSet = new HashSet<String>();
        for (int i = 0; i < ddps.size(); ++i) {
            String setKey;
            DiscretePermInfo discretePermInfo = ddps.get(i);
            if (discretePermInfo.getRole() == null || discretePermInfo.getRole().getId() == null || alreadyAddRoleSet.contains(setKey = discretePermInfo.getRole().getId().toString())) continue;
            retCol.add(discretePermInfo);
            alreadyAddRoleSet.add(setKey);
        }
        return retCol;
    }

    private DiscretePermCollection getFilterDuplicInfo(DiscretePermCollection ddps) {
        DiscretePermCollection retCol = new DiscretePermCollection();
        if (ddps == null || ddps.isEmpty()) {
            return retCol;
        }
        HashSet<String> alreadyAddUserSet = new HashSet<String>();
        for (int i = 0; i < ddps.size(); ++i) {
            String setKey;
            DiscretePermInfo discretePermInfo = ddps.get(i);
            if (discretePermInfo.getUser() == null || discretePermInfo.getUser().getId() == null || discretePermInfo.getOrg() == null || discretePermInfo.getOrg().getId() == null || alreadyAddUserSet.contains(setKey = discretePermInfo.getUser().getId().toString() + discretePermInfo.getOrg().getId().toString())) continue;
            retCol.add(discretePermInfo);
            alreadyAddUserSet.add(setKey);
        }
        return retCol;
    }

    @Override
    public void removeDiscretePermission(DiscretePermCollection ddps, boolean isUser, boolean needSync) throws BOSException, EASBizException {
        DiscretePermInfo discretePermInfo;
        int i;
        if (ddps == null || ddps.size() == 0) {
            return;
        }
        DiscretePermissionDAO dao = new DiscretePermissionDAO(this.context);
        DiscretePermCollection userDiscretePermissionCol = this.getFilterInfo(ddps);
        int size = userDiscretePermissionCol.size();
        for (i = 0; i < size; ++i) {
            discretePermInfo = userDiscretePermissionCol.get(i);
            Set bizDataSet = this.getBizDataIDMap(discretePermInfo, ddps);
            if (isUser) {
                dao.removeDiscretePermission(this.objectType, (IObjectPK)new ObjectStringPK(discretePermInfo.getUser().getId().toString()), (IObjectPK)new ObjectStringPK(discretePermInfo.getOrg().getId().toString()), null, bizDataSet);
                continue;
            }
            dao.removeDiscretePermission(this.objectType, null, null, (IObjectPK)new ObjectStringPK(discretePermInfo.getRole().getId().toString()), bizDataSet);
        }
        if (needSync) {
            if (isUser) {
                size = userDiscretePermissionCol.size();
                for (i = 0; i < size; ++i) {
                    discretePermInfo = userDiscretePermissionCol.get(i);
                    this.syncUserFunctionPermission((IObjectPK)new ObjectStringPK(discretePermInfo.getUser().getId().toString()), (IObjectPK)new ObjectStringPK(discretePermInfo.getOrg().getId().toString()));
                }
            } else {
                size = userDiscretePermissionCol.size();
                for (i = 0; i < size; ++i) {
                    discretePermInfo = userDiscretePermissionCol.get(i);
                    this.syncRoleFunctionPermission((IObjectPK)new ObjectStringPK(discretePermInfo.getRole().getId().toString()));
                }
            }
        }
        this.handleCallBack(this.context, new DiscretePermCollection[]{ddps});
    }

    private Set getBizDataIDMap(DiscretePermInfo discretePermInfo, DiscretePermCollection ddps) {
        HashSet<BOSUuid> retSet = new HashSet<BOSUuid>();
        if (discretePermInfo == null || ddps == null || ddps.size() == 0) {
            return retSet;
        }
        String keyStr = this.getKeyStr(discretePermInfo);
        int size = ddps.size();
        for (int i = 0; i < size; ++i) {
            DiscretePermInfo oneDiscretePermInfo = ddps.get(i);
            if (!keyStr.equals(this.getKeyStr(oneDiscretePermInfo)) || oneDiscretePermInfo.getBizDataID() == null || retSet.contains(oneDiscretePermInfo.getBizDataID())) continue;
            retSet.add(oneDiscretePermInfo.getBizDataID());
        }
        return retSet;
    }

    private String getKeyStr(DiscretePermInfo discretePermInfo) {
        if (discretePermInfo == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer("");
        if (discretePermInfo.getUser() != null) {
            sb.append(StringUtils.cnulls((Object)discretePermInfo.getUser().getId()));
        }
        if (discretePermInfo.getOrg() != null) {
            sb.append(StringUtils.cnulls((Object)discretePermInfo.getOrg().getId()));
        }
        if (discretePermInfo.getRole() != null) {
            sb.append(StringUtils.cnulls((Object)discretePermInfo.getRole().getId()));
        }
        return sb.toString();
    }

    private DiscretePermCollection getFilterInfo(DiscretePermCollection ddps) {
        DiscretePermCollection retCol = new DiscretePermCollection();
        if (ddps == null || ddps.size() == 0) {
            return retCol;
        }
        HashSet<String> alreadyAddSet = new HashSet<String>();
        int size = ddps.size();
        for (int i = 0; i < size; ++i) {
            DiscretePermInfo oneDiscretePermInfo = ddps.get(i);
            String keyStr = this.getKeyStr(oneDiscretePermInfo);
            if (alreadyAddSet.contains(keyStr)) continue;
            alreadyAddSet.add(keyStr);
            retCol.add(oneDiscretePermInfo);
        }
        return retCol;
    }

    @Override
    public void removeDiscretePermsByBoId(List boIdList) throws BOSException, EASBizException {
        if (boIdList == null || boIdList.isEmpty()) {
            this.logger.debug((Object)"boIdList is null!");
        }
        DiscretePermissionDAO dao = new DiscretePermissionDAO(this.context);
        dao.removeDiscretePermsByBoId(this.objectType, boIdList);
    }

    @Override
    public DiscretePermCollection getUserDiscretePerms(IObjectPK userPK, IObjectPK orgPK, IObjectPK rolePK, IObjectPK permItemId, IObjectPK bizDataPK, String conditionStr) throws BOSException, EASBizException {
        DiscretePermissionDAO dao = new DiscretePermissionDAO(this.context);
        return dao.getDiscretePermsAny(this.objectType, userPK, orgPK, rolePK, permItemId, bizDataPK, conditionStr);
    }

    @Override
    public IRowSet getUserDiscretePerms(IObjectPK userPK, IObjectPK orgPK, IObjectPK rolePK, IObjectPK permItemId, IObjectPK bizDataPK, IMetaDataPK queryPK, int startPos, int endPos, String conditionStr, boolean queryUser) throws BOSException, EASBizException {
        DiscretePermissionDAO dao = new DiscretePermissionDAO(this.context);
        return dao.getUserDiscretePerms(this.objectType, userPK, orgPK, rolePK, permItemId, bizDataPK, queryPK, startPos, endPos, conditionStr, queryUser);
    }
}

