/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app.helper;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.PermItemCollection;
import com.kingdee.eas.base.permission.PermType;
import com.kingdee.eas.base.permission.RoleInfo;
import com.kingdee.eas.base.permission.RolePermCollection;
import com.kingdee.eas.base.permission.RolePermInfo;
import com.kingdee.eas.base.permission.app.cache.PermissionCacheFactory;
import com.kingdee.eas.base.permission.app.util.interior.UserLicenseGroupTool;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class RolePermHelper {
    private static Logger logger = Logger.getLogger(RolePermHelper.class);

    public static RolePermCollection[] getDiffUserOrgPerm(Context ctx, RolePermCollection oldRolePerms, RolePermCollection newRolePerms) throws EASBizException, BOSException {
        int i;
        RolePermHelper.filterNull(oldRolePerms);
        RolePermHelper.filterNull(newRolePerms);
        RolePermCollection[] operations = new RolePermCollection[3];
        Map<String, RolePermInfo> oldRolePermsMap = RolePermHelper.createUOPMap(oldRolePerms);
        RolePermCollection addRolePerms = RolePermHelper.removeUserPermOrg(newRolePerms, oldRolePerms);
        RolePermCollection delRolePerms = RolePermHelper.removeUserPermOrg(oldRolePerms, newRolePerms);
        RolePermCollection updateRolePerms = RolePermHelper.getUpdateUserPermOrg(oldRolePerms, newRolePerms);
        addRolePerms = RolePermHelper.addDepPerm(ctx, addRolePerms, false);
        delRolePerms = RolePermHelper.addDepPerm(ctx, delRolePerms, true);
        addRolePerms = RolePermHelper.removeUserPermOrg(addRolePerms, delRolePerms);
        for (i = 0; i < addRolePerms.size(); ++i) {
            if (!oldRolePermsMap.containsKey(RolePermHelper.getUniqueKey(addRolePerms.get(i)))) continue;
            addRolePerms.removeObject(i--);
        }
        for (i = 0; i < delRolePerms.size(); ++i) {
            if (oldRolePermsMap.containsKey(RolePermHelper.getUniqueKey(delRolePerms.get(i)))) continue;
            delRolePerms.removeObject(i--);
        }
        operations[0] = addRolePerms;
        operations[1] = delRolePerms;
        operations[2] = updateRolePerms;
        return operations;
    }

    public static RolePermCollection addDepPerm(Context context, RolePermCollection rolePerms, boolean isDelete) throws EASBizException, BOSException {
        int i;
        RolePermCollection result = new RolePermCollection();
        HashSet<String> alreadyAddedRolePerms = new HashSet<String>();
        int size = rolePerms.size();
        for (i = 0; i < size; ++i) {
            String key = RolePermHelper.getUniqueKey(rolePerms.get(i));
            alreadyAddedRolePerms.add(key);
        }
        for (i = 0; i < rolePerms.size(); ++i) {
            RolePermInfo rolePermInfo = rolePerms.get(i);
            result.add(rolePermInfo);
            PermItemCollection depPerms = new PermItemCollection();
            depPerms = !isDelete ? (rolePermInfo.getPermType().equals((Object)PermType.AUTHORIZATION) || rolePermInfo.getPermType().equals((Object)PermType.NORMAL) ? PermissionCacheFactory.getPermItemCache(context).getDepPermItems(context, (IObjectPK)new ObjectUuidPK(rolePermInfo.getPermItem().getId())) : PermissionCacheFactory.getPermItemCache(context).getBeenDepPermItems(context, (IObjectPK)new ObjectUuidPK(rolePermInfo.getPermItem().getId()))) : (rolePermInfo.getPermType().equals((Object)PermType.AUTHORIZATION) || rolePermInfo.getPermType().equals((Object)PermType.NORMAL) ? PermissionCacheFactory.getPermItemCache(context).getBeenDepPermItems(context, (IObjectPK)new ObjectUuidPK(rolePermInfo.getPermItem().getId())) : PermissionCacheFactory.getPermItemCache(context).getDepPermItems(context, (IObjectPK)new ObjectUuidPK(rolePermInfo.getPermItem().getId())));
            if (depPerms == null) continue;
            for (int j = 0; j < depPerms.size(); ++j) {
                RolePermInfo depRolePermInfo = new RolePermInfo();
                depRolePermInfo.setPermType(rolePermInfo.getPermType());
                RoleInfo role = new RoleInfo();
                role.setId(BOSUuid.read((String)rolePermInfo.getRoleId()));
                depRolePermInfo.setRole(role);
                depRolePermInfo.setPermItem(depPerms.get(j));
                String key = RolePermHelper.getUniqueKey(depRolePermInfo);
                if (alreadyAddedRolePerms.contains(key)) continue;
                alreadyAddedRolePerms.add(key);
                result.add(depRolePermInfo);
            }
        }
        return result;
    }

    public static RolePermCollection getUpdateUserPermOrg(RolePermCollection oldRolePerms, RolePermCollection newRolePerms) {
        RolePermCollection updateRolePerms = new RolePermCollection();
        Map<String, RolePermInfo> mapOldRolePermsMap = RolePermHelper.createUOPMap(oldRolePerms);
        for (int i = 0; i < newRolePerms.size(); ++i) {
            RolePermInfo oldRolePermInfo;
            RolePermInfo newRolePermInfo = newRolePerms.get(i);
            String key = RolePermHelper.getUniqueKey(newRolePermInfo);
            if (!mapOldRolePermsMap.containsKey(key) || !RolePermHelper.isRuleChanged((oldRolePermInfo = mapOldRolePermsMap.get(key)).getRuleStructure(), newRolePermInfo.getRuleStructure())) continue;
            newRolePermInfo.setId(oldRolePermInfo.getId());
            updateRolePerms.add(newRolePermInfo);
        }
        return updateRolePerms;
    }

    public static RolePermCollection removeUserPermOrg(RolePermCollection srcRolePerms, RolePermCollection removeRolePerms) {
        RolePermCollection result = new RolePermCollection();
        Map<String, RolePermInfo> removeRolePermsMap = RolePermHelper.createUOPMap(removeRolePerms);
        for (int i = 0; i < srcRolePerms.size(); ++i) {
            RolePermInfo srcRolePermInfo = srcRolePerms.get(i);
            String key = RolePermHelper.getUniqueKey(srcRolePermInfo);
            if (removeRolePermsMap.containsKey(key)) continue;
            result.add(srcRolePermInfo);
        }
        return result;
    }

    public static void filterNull(RolePermCollection roleperms) {
        for (int i = 0; i < roleperms.size(); ++i) {
            RolePermInfo roleperm = roleperms.get(i);
            if (roleperm != null) continue;
            roleperms.removeObject(i--);
        }
    }

    public static String getUniqueKey(RolePermInfo info) {
        return new StringBuffer().append(info.getRoleId()).append("-").append(info.getPermItemId()).append("-").append((Object)info.getPermType()).toString();
    }

    public static Map<String, RolePermInfo> createUOPMap(RolePermCollection rolePerms) {
        HashMap<String, RolePermInfo> map = new HashMap<String, RolePermInfo>();
        RolePermInfo rolePermInfo = null;
        int size = rolePerms.size();
        for (int i = 0; i < size; ++i) {
            rolePermInfo = rolePerms.get(i);
            map.put(RolePermHelper.getUniqueKey(rolePermInfo), rolePermInfo);
        }
        return map;
    }

    public static boolean isRuleChanged(String ruleA, String ruleB) {
        if (StringUtils.isEmpty((String)ruleA) || StringUtils.isEmpty((String)ruleB)) {
            return !StringUtils.isEmpty((String)ruleA) || !StringUtils.isEmpty((String)ruleB);
        }
        return !ruleA.equals(ruleB);
    }

    public static void removeRolePerms(Context ctx, RolePermCollection rolePerms) throws BOSException {
        String sql = "DELETE FROM T_PM_RolePerm WHERE froleId= ? and fpermitemid =? and fpermType=? ";
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        int size = rolePerms.size();
        for (int i = 0; i < size; ++i) {
            Object[] param = new Object[3];
            RolePermInfo info = rolePerms.get(i);
            param[0] = info.getRole().getId().toString();
            param[1] = info.getPermItemId();
            param[2] = String.valueOf(info.getPermType().getValue());
            paramsList.add(param);
        }
        DbUtil.executeBatch((Context)ctx, (String)sql, paramsList);
    }

    public static List<String> getPermIdsByRoleids(Context ctx, Set<String> roleIds) throws BOSException {
        ArrayList<String> permids = new ArrayList<String>();
        String tableName = UserLicenseGroupTool.getPermUIGroupTableName(ctx);
        String sql = "SELECT pm.FID as fid FROM T_PM_permitem pm inner join " + tableName + " pug on pm.fid=pug.FPERMITEMID   where pm.FISLEAF = 1  and exists(SELECT 1  FROM T_PM_roleperm rm where  rm.FPERMITEMID = pm.fid and rm.froleid in(" + ToolUtils.aryToStr(roleIds) + "))";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            while (rs.next()) {
                permids.add(rs.getString("fid"));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return permids;
    }
}

