/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.eas.base.permission.IOwnerExceptPermitem;
import com.kingdee.eas.base.permission.IOwnerPermExcept;
import com.kingdee.eas.base.permission.ISpecialDirectorPerm;
import com.kingdee.eas.base.permission.ISpecialDirectorPermitem;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.OwnerExceptPermitemCollection;
import com.kingdee.eas.base.permission.OwnerExceptPermitemFactory;
import com.kingdee.eas.base.permission.OwnerExceptPermitemInfo;
import com.kingdee.eas.base.permission.OwnerPermExceptFactory;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.PermissionException;
import com.kingdee.eas.base.permission.RuleUtil;
import com.kingdee.eas.base.permission.SpecialDataPermEntryCollection;
import com.kingdee.eas.base.permission.SpecialDataPermEntryInfo;
import com.kingdee.eas.base.permission.SpecialDataPermInfo;
import com.kingdee.eas.base.permission.SpecialDataPermType;
import com.kingdee.eas.base.permission.SpecialDirectorPermCollection;
import com.kingdee.eas.base.permission.SpecialDirectorPermFactory;
import com.kingdee.eas.base.permission.SpecialDirectorPermitemCollection;
import com.kingdee.eas.base.permission.SpecialDirectorPermitemFactory;
import com.kingdee.eas.base.permission.SpecialDirectorPermitemInfo;
import com.kingdee.eas.base.permission.SpecialPermTypeEnum;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.app.service.ISpecialDataPermissionHandler;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;

public class SpecialDataPermissionHandler
implements ISpecialDataPermissionHandler {
    private static Logger logger = Logger.getLogger((String)SpecialDataPermissionHandler.class.getName());
    private Context context = null;

    public SpecialDataPermissionHandler(Context context) {
        this.context = context;
    }

    @Override
    public String getSpecialDataPermissionRule(IObjectPK userPK, IObjectPK orgPK, SpecialDataPermInfo specialDataPermInfo, PermItemInfo permItem) throws BOSException, EASBizException {
        UserInfo userInfo = this.getUserInfo(userPK);
        String rule = null;
        try {
            rule = RuleUtil.mergeOQL(this.getCreatorRule(specialDataPermInfo, userInfo, permItem), this.getSpecialDirectorRule(specialDataPermInfo, userInfo, permItem), "or");
        }
        catch (ParserException e) {
            logger.error((Object)"getSpecialDataPermissionRule error:", (Throwable)e);
            throw new PermissionException(PermissionException.CHECK_PERMISSION_FAIL, e);
        }
        return rule;
    }

    private Set getUserPositionNumber(SpecialDataPermInfo specialDataPermInfo, UserInfo userInfo, String cuId) throws EASBizException, BOSException {
        String oql;
        ISpecialDirectorPerm iSpecialDirector = SpecialDirectorPermFactory.getLocalInstance(this.context);
        SpecialDirectorPermCollection specialCol = iSpecialDirector.getSpecialDirectorPermCollection(oql = " select *,userOrgRange.org.id where bizObjectType = '" + specialDataPermInfo.getBizObjectType() + "' and userOrgRange.user.id = '" + userInfo.getId().toString() + "' and CU.id = '" + cuId + "'");
        if (specialCol == null || specialCol.isEmpty()) {
            if (userInfo.getPerson() != null) {
                String personID = userInfo.getPerson().getId().toString();
                Set positionLongNumbers = this.getPositionLongNumbers(this.context, personID);
                return positionLongNumbers;
            }
            return null;
        }
        ArrayList<String> adminOrgList = new ArrayList<String>();
        for (int i = 0; i < specialCol.size(); ++i) {
            adminOrgList.add(specialCol.get(i).getUserOrgRange().getOrg().getId().toString());
        }
        HashSet retSet = new HashSet();
        for (int i = 0; i < adminOrgList.size(); ++i) {
            String adminIdStr = adminOrgList.get(i).toString();
            retSet.addAll(this.getPositionLongNumbersByAdmin(this.context, adminIdStr));
        }
        return retSet;
    }

    private boolean userInExcepRange(SpecialDataPermInfo specialDataPermInfo, UserInfo userInfo, CtrlUnitInfo ctrlUnitInfo) throws EASBizException, BOSException {
        IOwnerPermExcept iOwnerPermExcept = OwnerPermExceptFactory.getLocalInstance(this.context);
        String oql = "select * where objType ='" + specialDataPermInfo.getBizObjectType() + "' and CU.id = '" + ctrlUnitInfo.getId().toString() + "'  and user.id = '" + userInfo.getId().toString() + "'";
        return iOwnerPermExcept.exists(oql);
    }

    private UserInfo getUserInfo(IObjectPK userPK) throws BOSException, EASBizException {
        if (this.context.getCaller().equals((Object)userPK)) {
            return ContextUtil.getCurrentUserInfo((Context)this.context);
        }
        IUser iUser = UserFactory.getLocalInstance(this.context);
        UserInfo userInfo = iUser.getUserInfo(userPK);
        return userInfo;
    }

    @Override
    public SpecialDataPermEntryInfo getSpecialDataPermEntry(SpecialDataPermInfo specialDataPermInfo, PermItemInfo permItemInfo) {
        SpecialDataPermEntryCollection entryCol = specialDataPermInfo.getEntries();
        for (int i = 0; i < entryCol.size(); ++i) {
            if (!entryCol.get(i).getPermItem().getId().equals((Object)permItemInfo.getId())) continue;
            return entryCol.get(i);
        }
        SpecialDataPermEntryInfo ret = new SpecialDataPermEntryInfo();
        ret.setPermType(SpecialDataPermType.DEFAULT);
        return ret;
    }

    private boolean isEnableDirectorPerm(SpecialDataPermInfo specialDataPermInfo) {
        return specialDataPermInfo.isEnableDirectorPerm();
    }

    private boolean isEnableDirectorPermitemEntry(SpecialDataPermInfo specialDataPermInfo, PermItemInfo permitemInfo) throws BOSException, EASBizException {
        String permitemID;
        String objType;
        String cuID = specialDataPermInfo.getCU().getId().toString();
        SpecialDirectorPermitemInfo directorPermitemInfo = this.getSpecialDirectorPermitem(cuID, objType = specialDataPermInfo.getBizObjectType(), permitemID = permitemInfo.getId().toString());
        return directorPermitemInfo == null || SpecialPermTypeEnum.ON.equals((Object)directorPermitemInfo.getPermType());
    }

    private String getDirectorRule(UserInfo userInfo, SpecialDataPermInfo specialDataPermInfo) throws EASBizException, BOSException {
        String userID = userInfo.getId().toString();
        Set positionLongNumbers = this.getUserPositionNumber(specialDataPermInfo, userInfo, specialDataPermInfo.getCU().getId().toString());
        StringBuffer rule = new StringBuffer(400);
        StringBuffer hierarchyCondition = new StringBuffer(200);
        rule.append(" WHERE creator.id = '").append(userID).append("' ");
        if (positionLongNumbers != null && positionLongNumbers.size() > 0) {
            rule.append(" OR ");
            rule.append(" creator.id IN ( ");
            rule.append(" SELECT DISTINCT U.FID FROM T_PM_USER U ").append(" INNER JOIN T_BD_Person Person ON Person.FID = U.FPersonID ").append(" INNER JOIN T_ORG_PositionMember PositionMember ON Person.FID = PositionMember.FPersonID ").append(" INNER JOIN T_ORG_Position Position ON Position.FID = PositionMember.FPositionID ").append(" INNER JOIN T_ORG_PositionHierarchy AS PositionHierarchy ON PositionMember.FPositionID = PositionHierarchy.FChildID ").append(" WHERE ( ");
            Iterator iterator = positionLongNumbers.iterator();
            int size = positionLongNumbers.size();
            int index = 0;
            while (iterator.hasNext()) {
                PermPositionInfo ppi = (PermPositionInfo)iterator.next();
                String longNumber = ppi.getLongNumber();
                if (ppi.isRespPosition()) {
                    hierarchyCondition.append(" PositionHierarchy.FLongNumber = '").append(longNumber).append("' OR");
                }
                String longNumberSub = longNumber + "!%";
                if (index == size - 1) {
                    hierarchyCondition.append(" PositionHierarchy.FLongNumber LIKE N'").append(longNumberSub).append("' ");
                } else {
                    hierarchyCondition.append(" PositionHierarchy.FLongNumber LIKE N'").append(longNumberSub).append("' OR ");
                }
                ++index;
            }
            hierarchyCondition.append(" ) ").append(" AND PositionHierarchy.FHierarchyID = '00000000-0000-0000-0000-000000000001396FCAD0' ");
            hierarchyCondition.append(" ) ");
            rule.append(hierarchyCondition);
            if (specialDataPermInfo.getExtendedProperty("position-field") != null) {
                rule.append(" OR ");
                rule.append(specialDataPermInfo.getExtendedProperty("position-field"));
                rule.append(".id IN ( ");
                rule.append(" SELECT DISTINCT P.FID FROM T_ORG_Position P ").append(" INNER JOIN T_ORG_PositionHierarchy AS PositionHierarchy ON P.FID = PositionHierarchy.FChildID ").append(" WHERE ( ");
                rule.append(hierarchyCondition);
            }
        }
        return rule.toString();
    }

    private Set getPositionLongNumbersByAdmin(Context context, String adminOrgId) throws BOSException, EASBizException {
        HashSet<PermPositionInfo> longNumbers = new HashSet<PermPositionInfo>();
        StringBuffer stringBuffer = new StringBuffer(400);
        stringBuffer.append("SELECT PositionHierarchy.FLongNumber FROM T_ORG_PositionHierarchy PositionHierarchy ").append(" INNER JOIN T_ORG_Admin Admin1 ON PositionHierarchy.FChildID = Admin1.FResponPositionID ").append(" WHERE Admin1.FID = ?  AND PositionHierarchy.FHierarchyID = '00000000-0000-0000-0000-000000000001396FCAD0' ");
        Object[] params = new Object[]{adminOrgId};
        IRowSet rowSet = DbUtil.executeQuery((Context)context, (String)stringBuffer.toString(), (Object[])params);
        try {
            while (rowSet.next()) {
                String longNumber = rowSet.getString("FLongNumber");
                if (StringUtils.isEmpty((String)longNumber)) continue;
                longNumbers.add(new PermPositionInfo(longNumber, true));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new PermissionException(PermissionException.GET_INFO_FAIL, e);
        }
        return longNumbers;
    }

    private Set getPositionLongNumbers(Context context, String personID) throws BOSException, EASBizException {
        HashSet<PermPositionInfo> longNumbers = new HashSet<PermPositionInfo>();
        StringBuffer stringBuffer = new StringBuffer(400);
        stringBuffer.append("SELECT PositionHierarchy.FLongNumber,Position.FIsRespPosition FROM T_ORG_PositionHierarchy PositionHierarchy ").append(" INNER JOIN T_ORG_PositionMember PositionMember ON PositionHierarchy.FChildID = PositionMember.FPositionID ").append(" INNER JOIN T_BD_Person Person ON PositionMember.FPersonID = Person.FID ").append(" INNER JOIN T_ORG_Position Position ON Position.FID = PositionMember.FPositionID ").append(" WHERE FPersonID = ?  AND PositionHierarchy.FHierarchyID = '00000000-0000-0000-0000-000000000001396FCAD0' ");
        Object[] params = new Object[]{personID};
        IRowSet rowSet = DbUtil.executeQuery((Context)context, (String)stringBuffer.toString(), (Object[])params);
        try {
            while (rowSet.next()) {
                String longNumber = rowSet.getString("FLongNumber");
                boolean isRespPosition = rowSet.getBoolean("FIsRespPosition");
                if (StringUtils.isEmpty((String)longNumber)) continue;
                longNumbers.add(new PermPositionInfo(longNumber, isRespPosition));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new PermissionException(PermissionException.GET_INFO_FAIL, e);
        }
        return longNumbers;
    }

    private String getCreatorReverseRule(UserInfo userInfo) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(" WHERE creator.id <> '").append(userInfo.getId().toString()).append("' ");
        return buffer.toString();
    }

    private String getCreatorHasRightRule(SpecialDataPermInfo specialDataPermInfo, UserInfo userInfo) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(" WHERE creator.id = '").append(userInfo.getId().toString()).append("' ");
        if (specialDataPermInfo.getOtherOwners() != null && specialDataPermInfo.getOtherOwners().size() > 0) {
            int size = specialDataPermInfo.getOtherOwners().size();
            for (int index = 0; index < size; ++index) {
                if (specialDataPermInfo.getOtherOwners().get(index).getPropertyName().equals("auditor")) {
                    buffer.append(" OR id IN (SELECT FBillId FROM T_BAS_MULTIAPPROVE WHERE FBOSTYPE='" + specialDataPermInfo.getBizObjectType() + "' AND FCREATORID='" + userInfo.getId().toString() + "'");
                    buffer.append(" UNION ALL SELECT FBillId FROM T_BAS_MULTIAPPROVEHST WHERE FBOSTYPE='" + specialDataPermInfo.getBizObjectType() + "' AND FCREATORID='" + userInfo.getId().toString() + "')");
                } else if (!specialDataPermInfo.getOtherOwners().get(index).isIsOtherOwner()) {
                    if (userInfo.getPerson() == null || userInfo.getPerson().getId() == null) continue;
                    buffer.append(" OR " + specialDataPermInfo.getOtherOwners().get(index).getPropertyName() + ".id = '").append(userInfo.getPerson().getId().toString()).append("' ");
                    continue;
                }
                buffer.append(" OR " + specialDataPermInfo.getOtherOwners().get(index).getPropertyName() + ".id = '").append(userInfo.getId().toString()).append("' ");
            }
        }
        return buffer.toString();
    }

    private boolean userInExcepRange(SpecialDataPermInfo specialDataPermInfo, UserInfo userInfo, PermItemInfo permItem) throws BOSException, EASBizException {
        String permitemID;
        String objType;
        String cuID = specialDataPermInfo.getCU().getId().toString();
        OwnerExceptPermitemInfo ownerExceptPermitemInfo = this.getOwnerExceptPermitem(cuID, objType = specialDataPermInfo.getBizObjectType(), permitemID = permItem.getId().toString());
        return (ownerExceptPermitemInfo == null || SpecialPermTypeEnum.ON.equals((Object)ownerExceptPermitemInfo.getPermType())) && this.userInExcepRange(specialDataPermInfo, userInfo, specialDataPermInfo.getCU());
    }

    private String getSpecialDirectorRule(SpecialDataPermInfo specialDataPermInfo, UserInfo userInfo, PermItemInfo permItem) throws BOSException, EASBizException {
        if (this.isEnableDirectorPerm(specialDataPermInfo) && this.isEnableDirectorPermitemEntry(specialDataPermInfo, permItem)) {
            String rule = this.getDirectorRule(userInfo, specialDataPermInfo);
            return rule;
        }
        return null;
    }

    private String getCreatorRule(SpecialDataPermInfo specialDataPermInfo, UserInfo userInfo, PermItemInfo permItem) throws BOSException, EASBizException {
        SpecialDataPermEntryInfo entry = this.getSpecialDataPermEntry(specialDataPermInfo, permItem);
        String hasPerm = " WHERE ( id = '00000000-0000-0000-0000-00000000000013B7DE7F' OR id <> '00000000-0000-0000-0000-00000000000013B7DE7F' )";
        if (!specialDataPermInfo.isEnableCreatorPerm()) {
            return null;
        }
        if (SpecialDataPermType.DEFAULT.equals((Object)entry.getPermType())) {
            return null;
        }
        if (SpecialDataPermType.CREATEOR_NORMAL_PERM.equals((Object)entry.getPermType())) {
            if (!this.userInExcepRange(specialDataPermInfo, userInfo, permItem)) {
                String rule = this.getCreatorHasRightRule(specialDataPermInfo, userInfo);
                return rule;
            }
            return hasPerm;
        }
        if (!this.userInExcepRange(specialDataPermInfo, userInfo, permItem)) {
            String rule = " WHERE ( id = '00000000-0000-0000-0000-00000000000013B7DE7F' AND id <> '00000000-0000-0000-0000-00000000000013B7DE7F' )";
            return rule;
        }
        return hasPerm;
    }

    private OwnerExceptPermitemInfo getOwnerExceptPermitem(String cuID, String objType, String permitemID) throws BOSException, EASBizException {
        IOwnerExceptPermitem iOwnerExceptPerm = OwnerExceptPermitemFactory.getLocalInstance(this.context);
        StringBuffer oql = new StringBuffer();
        oql.append("select * where CU.id='").append(cuID).append("' and objType='").append(objType).append("' and permItem.id='").append(permitemID).append("'");
        OwnerExceptPermitemCollection col = iOwnerExceptPerm.getOwnerExceptPermitemCollection(oql.toString());
        if (col.size() > 0) {
            return col.get(0);
        }
        return null;
    }

    private SpecialDirectorPermitemInfo getSpecialDirectorPermitem(String cuID, String objType, String permitemID) throws BOSException, EASBizException {
        ISpecialDirectorPermitem iSpecialDirector = SpecialDirectorPermitemFactory.getLocalInstance(this.context);
        StringBuffer oql = new StringBuffer();
        oql.append("select * where CU.id='").append(cuID).append("' and objType='").append(objType).append("' and permItem.id='").append(permitemID).append("'");
        SpecialDirectorPermitemCollection col = iSpecialDirector.getSpecialDirectorPermitemCollection(oql.toString());
        if (col.size() > 0) {
            return col.get(0);
        }
        return null;
    }

    class PermPositionInfo {
        String longNumber;
        boolean isRespPosition = false;

        public PermPositionInfo(String longNumber, boolean isDir) {
            this.longNumber = longNumber;
            this.isRespPosition = isDir;
        }

        public boolean isRespPosition() {
            return this.isRespPosition;
        }

        public void setRespPosition(boolean isDir) {
            this.isRespPosition = isDir;
        }

        public String getLongNumber() {
            return this.longNumber;
        }

        void setLongNumber(String number) {
            this.longNumber = number;
        }
    }
}

