/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app.service.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.MultiLangHelper;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.PermissionException;
import com.kingdee.eas.base.permission.app.cache.PermissionCacheFactory;
import com.kingdee.eas.base.permission.app.service.IAdvancedOrgPermissionService;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.service.OrgCommonUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class AdvancedOrgPermissionService
implements IAdvancedOrgPermissionService {
    private static Logger logger = Logger.getLogger((String)AdvancedOrgPermissionService.class.getName());
    private Context context = null;

    public AdvancedOrgPermissionService(Context context) {
        this.context = context;
    }

    private String getAuthorizedOrgIdsSQL(Context ctx, IObjectPK userPK, String permItemID) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        String userID = userPK.toString();
        sql.append(" SELECT 1 FROM T_PM_UserOrgPerm USERORGPERM ").append(" WHERE UserOrgPerm.FOwner = '").append(userID).append("' AND UserOrgPerm.FPermItemID = '").append(permItemID).append("' AND UserOrgPerm.FPermType = ").append(10).append(" AND USERORGPERM.Forgid = BaseUnit.fid ").append(" UNION ALL ").append(" SELECT 1 FROM T_PM_RolePerm RolePerm ").append(" INNER JOIN T_PM_UserRoleOrg UserRoleOrg ON RolePerm.FRoleID = UserRoleOrg.FRoleID ").append(" WHERE UserRoleOrg.FUserID = '").append(userID).append("' AND RolePerm.FPermItemID = '").append(permItemID).append("' AND RolePerm.FPermType = ").append(10).append(" AND UserRoleOrg.Forgid = BaseUnit.fid ");
        return sql.toString();
    }

    private String getForbiddenOrgIdsSQL(Context ctx, IObjectPK userPK, String permItemID) throws BOSException, EASBizException {
        String userID = userPK.toString();
        StringBuffer sql = new StringBuffer();
        sql.append("select v.orgId from ( SELECT USERORGPERM.Forgid orgId FROM T_PM_UserOrgPerm UserOrgPerm ").append(" WHERE UserOrgPerm.FOwner = '").append(userID).append("' AND UserOrgPerm.FPermItemID = '").append(permItemID).append("' AND UserOrgPerm.FPermType = ").append(20).append(" UNION ALL ").append(" SELECT UserRoleOrg.Forgid orgId FROM T_PM_RolePerm RolePerm ").append(" INNER JOIN T_PM_UserRoleOrg UserRoleOrg ON  RolePerm.FRoleID = UserRoleOrg.FRoleID ").append(" WHERE UserRoleOrg.FUserID = '").append(userID).append("' AND RolePerm.FPermItemID = '").append(permItemID).append("' AND RolePerm.FPermType = ").append(20).append(") v ");
        return sql.toString();
    }

    @Override
    public FullOrgUnitCollection getAuthorizedOrgWithCUFilter(IObjectPK userPK, IObjectPK orgTreePK, String permItemName, boolean isOnlyCU) throws BOSException, EASBizException {
        assert (userPK != null && permItemName != null);
        long start = System.currentTimeMillis();
        FullOrgUnitCollection result = new FullOrgUnitCollection();
        PermItemInfo permItemInfo = PermissionCacheFactory.getPermItemCache(this.context).getPermItem(this.context, permItemName);
        String permItemID = permItemInfo.getId().toString();
        String treeID = null;
        treeID = !OrgCommonUtils.isBasicOrgType((OrgType)permItemInfo.getOrgRelation()) ? orgTreePK.toString() : PermissionCacheFactory.getOrgCache(this.context).getBasicTreeID(this.context, permItemInfo.getOrgRelation());
        String nameField = MultiLangHelper.getFieldName("FName", this.context.getLocale());
        StringBuffer sql = new StringBuffer(1000);
        sql.append(" SELECT BaseUnit.FID, BaseUnit.FNumber, BaseUnit.FISCU, Structure.FLongNumber, BaseUnit.").append(nameField);
        sql.append(" ,BaseUnit.FControlUnitID");
        sql.append(" FROM T_ORG_BaseUnit BaseUnit ").append(" INNER JOIN T_ORG_Structure Structure ON Structure.FUnitId = BaseUnit.FID ").append(" WHERE Structure.FTreeId = ? ");
        if (isOnlyCU) {
            sql.append(" AND BaseUnit.FISCU=1 ");
        }
        sql.append(" AND EXISTS ( ").append(this.getAuthorizedOrgIdsSQL(this.context, userPK, permItemID)).append(") ").append(" AND BaseUnit.FID NOT in ( ").append(this.getForbiddenOrgIdsSQL(this.context, userPK, permItemID)).append(")");
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = EJBFactory.getConnection((Context)this.context);
            ps = con.prepareStatement(sql.toString());
            ps.setString(1, treeID);
            rs = ps.executeQuery();
            while (rs.next()) {
                FullOrgUnitInfo fullOrgUnitInfo = new FullOrgUnitInfo();
                String orgId = rs.getString("FID");
                fullOrgUnitInfo.setId(BOSUuid.read((String)orgId));
                fullOrgUnitInfo.setNumber(rs.getString("FNumber"));
                fullOrgUnitInfo.setName(rs.getString(nameField));
                fullOrgUnitInfo.setLongNumber(rs.getString("FLongNumber"));
                int isCu = rs.getInt("FISCU");
                fullOrgUnitInfo.setIsCU(isCu == 1);
                CtrlUnitInfo cu = new CtrlUnitInfo();
                cu.setId(BOSUuid.read((String)rs.getString("FControlUnitID")));
                fullOrgUnitInfo.setCU(cu);
                result.add(fullOrgUnitInfo);
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                SQLUtils.cleanup(rs, (Statement)ps, (Connection)con);
                throw new PermissionException(PermissionException.GET_INFO_FAIL, e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)con);
        long end = System.currentTimeMillis();
        System.out.println("<<<<<<<<<<<<<<getAuthorizedOrgWithCU cost:" + (end - start));
        return result;
    }
}

