/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app.util.interior;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.base.permission.app.util.interior.UserLicenseGroupLogRegistryManager;
import com.kingdee.eas.base.permission.app.util.interior.bean.UserLicenseGroupLogInfo;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import org.apache.log4j.Logger;

public class UserLicenseGroupLogMonitorThread
implements Runnable {
    private static Logger logger = Logger.getLogger((String)UserLicenseGroupLogMonitorThread.class.getName());
    private boolean stop;
    UserLicenseGroupLogRegistryManager registryManager = UserLicenseGroupLogRegistryManager.getInstance();
    BlockingQueue<UserLicenseGroupLogInfo> queue = this.registryManager.getQueue();
    List<UserLicenseGroupLogInfo> failLogs = this.registryManager.getFailLogs();
    int Max_Fail_Times = 5;

    public void stopThread() {
        this.stop = true;
        logger.info((Object)"UserLicenseGroupLogMonitorThread.stopThread()");
    }

    public boolean isStopped() {
        return this.stop;
    }

    @Override
    public void run() {
        this.stop = false;
        while (!this.stop) {
            UserLicenseGroupLogInfo node;
            while (this.queue.peek() != null && (node = (UserLicenseGroupLogInfo)this.queue.poll()) != null) {
                try {
                    node.writeLog();
                    this.dealAfterLogSuccess();
                }
                catch (BOSException e) {
                    if (this.Max_Fail_Times <= node.getFailTimes()) {
                        this.removeFailLog(node);
                        continue;
                    }
                    if (!this.queue.offer(node)) {
                        this.addFailLog(node);
                        continue;
                    }
                    this.removeFailLog(node);
                }
            }
            this.stop = true;
        }
    }

    private void addFailLog(UserLicenseGroupLogInfo node) {
        if (this.failLogs == null) {
            return;
        }
        this.failLogs.add(node);
    }

    private void removeFailLog(UserLicenseGroupLogInfo node) {
        if (this.failLogs == null) {
            return;
        }
        this.failLogs.remove(node);
    }

    private void dealAfterLogSuccess() {
        if (this.failLogs == null || this.failLogs.size() == 0) {
            return;
        }
        int size = this.failLogs.size();
        for (int i = 0; i < size; ++i) {
            UserLicenseGroupLogInfo node = this.failLogs.get(i);
            if (!this.queue.offer(node)) continue;
            this.removeFailLog(node);
        }
    }
}

