/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.data.meta.bmd;

import com.kingdee.bos.ctrl.common.FullPath;
import com.kingdee.bos.ctrl.data.meta.MetaClass;
import com.kingdee.bos.ctrl.data.meta.MetaPackage;
import com.kingdee.bos.ctrl.data.meta.bmd.BmdMetaType;
import com.kingdee.bos.ctrl.reportone.data.meta.bmd.BmdMetaEnv;
import com.kingdee.bos.ctrl.reportone.data.meta.io.Bmd2Meta;
import com.kingdee.bos.metadata.management.PackageInfo;
import java.io.File;

public class BmdMetaPackage
extends MetaPackage {
    private BmdMetaEnv env;

    public BmdMetaPackage(BmdMetaEnv env) {
        this.env = env;
    }

    protected void init() {
        super.init();
        String resPath = this.env.makeResPath(this.getFullName());
        File dir = new File(resPath);
        File[] fs = dir.listFiles();
        if (fs == null) {
            return;
        }
        for (int i = 0; i < fs.length; ++i) {
            File f = fs[i];
            if (f.isDirectory()) {
                MetaPackage mp = this.loadPackageInfo(resPath, f.getName());
                if (mp == null) continue;
                this.addPackage(mp);
                continue;
            }
            MetaClass mc = this.loadObjectInfo(resPath, f.getName());
            if (mc == null) continue;
            this.addClass(mc);
        }
    }

    private MetaPackage loadPackageInfo(String resPath, String name) {
        if ("META-INF".equals(name) || "CVS".equals(name)) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(resPath);
        sb.append("/");
        sb.append(name);
        sb.append("/");
        sb.append(name);
        sb.append(FullPath.C_CATEGORY);
        sb.append(BmdMetaType.PACKAGE.getName());
        String resPkgInfo = sb.toString();
        File f = new File(resPkgInfo);
        Object bosObj = null;
        if (f.isFile()) {
            bosObj = this.env.loadMetaData(BmdMetaType.PACKAGE.getBOSType(), resPkgInfo);
        }
        BmdMetaPackage mp = new BmdMetaPackage(this.env);
        if (bosObj != null) {
            PackageInfo pkgInfo = (PackageInfo)bosObj;
            mp.setName(pkgInfo.getName());
            mp.setAlias(pkgInfo.getAlias());
            mp.setDesc(pkgInfo.getDescription());
        } else {
            mp.setName(name);
        }
        return mp;
    }

    private MetaClass loadObjectInfo(String resPath, String name) {
        String ext = FullPath.getCategory((String)name);
        if (ext == null) {
            return null;
        }
        BmdMetaType bmType = BmdMetaType.fromName((String)ext);
        if (bmType == null) {
            return null;
        }
        if (!this.env.isValidType(bmType)) {
            return null;
        }
        Object bosObj = this.env.loadMetaData(bmType.getBOSType(), resPath + "/" + name);
        if (bosObj == null) {
            return null;
        }
        return Bmd2Meta.parseBmdObject(bosObj);
    }
}

