/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.forapp.eas.actions;

import com.kingdee.bos.ctrl.common.layout.table.Cell;
import com.kingdee.bos.ctrl.common.layout.table.Table;
import com.kingdee.bos.ctrl.common.ui.MultiLangUI;
import com.kingdee.bos.ctrl.common.ui.TypicalDialog;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.ui.restree.AbstractResActionHandler;
import com.kingdee.bos.ctrl.common.ui.restree.ResObjectNode;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.MapUtil;
import com.kingdee.bos.ctrl.reportone.data.framework.bos.BosUtil;
import com.kingdee.bos.ctrl.reportone.forapp.eas.EasResource;
import com.kingdee.bos.ctrl.reportone.forapp.eas.Eas_BizContentTreeCtrl;
import com.kingdee.bos.ctrl.reportone.forapp.eas.Eas_KdrsReportUI;
import com.kingdee.bos.ctrl.reportone.forapp.kdrs.content.actions.AbstractContentResActionHandler;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.BizAttributes;
import com.kingdee.bos.ctrl.swing.KDMultiLangBox;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.management.LanguageCollection;
import com.kingdee.bos.metadata.management.LanguageInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.DiscretePermissionFactory;
import com.kingdee.eas.base.permission.IDiscretePermission;
import com.kingdee.eas.base.permission.IMainMenuItem;
import com.kingdee.eas.base.permission.MainMenuItemFactory;
import com.kingdee.eas.base.permission.MainMenuItemInfo;
import com.kingdee.eas.base.uiframe.IMainFunctionMenu;
import com.kingdee.eas.base.uiframe.MainFunctionMenuFactory;
import com.kingdee.eas.base.uiframe.OpenMethod;
import com.kingdee.eas.base.uiframe.client.F7MenuSupportNoLeafSelector;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.rpts.report.IReportEntity;
import com.kingdee.eas.rpts.report.ReportEntityFactory;
import com.kingdee.eas.rpts.report.ReportEntityInfo;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class Eas_PublishMenuHandler
extends AbstractContentResActionHandler {
    public static final Logger log = LogUtil.getPackageLogger(AbstractResActionHandler.class);
    public static final String ATTR_EAS_REPORT_ID = "eas-report-id";
    public static final String ATTR_EAS_MENU_PK = "eas-menu-pk";
    public static final String ATTR_EAS_PERMISSION_ITEM = "eas-permission-item";
    public static final String ATTR_EAS_PUBLISH_TYPE = "eas-publish-type";
    public static final String PUBLISH_PUBLIC = "publish-public";
    public static final String PUBLISH_PRIVATE = "publish-private";

    public static final void updateRemoteMenuCache() {
        try {
            IMainFunctionMenu imenu = MainFunctionMenuFactory.getRemoteInstance();
            Method method = IMainFunctionMenu.class.getMethod("", String.class);
            if (method != null) {
                method.invoke((Object)imenu, "");
            }
        }
        catch (Exception ex) {
            log.error((Object)"", (Throwable)ex);
        }
    }

    protected MainMenuItemInfo chooseMenuGroup() throws Exception {
        F7MenuSupportNoLeafSelector f7 = new F7MenuSupportNoLeafSelector((Component)this.getTree(), EasResource.getString("res_9"));
        Object rv = null;
        boolean selectedGroup = false;
        while (!selectedGroup) {
            f7.show();
            if (f7.isCanceled()) {
                return null;
            }
            rv = f7.getData();
            if (rv == null) {
                return null;
            }
            if (rv instanceof MainMenuItemInfo && ((MainMenuItemInfo)rv).isIsLeaf()) {
                WindowUtil.msgboxError((Object)EasResource.getString("reSelect2"), (String)EasResource.getString("res_9"), (Component)this.getTreeUI());
                continue;
            }
            if (rv instanceof String) {
                WindowUtil.msgboxError((Object)EasResource.getString("reSelect1"), (String)EasResource.getString("res_9"), (Component)this.getTreeUI());
                continue;
            }
            selectedGroup = true;
        }
        return (MainMenuItemInfo)rv;
    }

    protected boolean deployReport() throws Exception {
        IReportEntity reportEntity = ReportEntityFactory.getRemoteInstance();
        ReportEntityInfo reportEntityInfo = new ReportEntityInfo();
        reportEntityInfo.setReportPath(this.getPathText());
        ObjectUuidPK rptPk = new ObjectUuidPK(BOSUuid.create((String)"59CB05C6"));
        MainMenuItemInfo parent = this.chooseMenuGroup();
        if (parent == null) {
            return false;
        }
        String pathText = this.getPathText();
        String number = "KDRS" + System.currentTimeMillis();
        HashMap atts = this.getBizContent().getAttributes(pathText, BizAttributes.DEF_ATTRS);
        HashMap oldAlias = new HashMap();
        MapUtil.subKeyPrefix((Map)atts, (String)"alias.", oldAlias);
        AliasInputDialog dlg = (AliasInputDialog)((Object)WindowUtil.createWindow(AliasInputDialog.class, (Component)this.getTree()));
        dlg.setOldAlias(oldAlias);
        dlg.setTitle("\u62a5\u8868\u53d1\u5e03");
        dlg.setLabelText("\u83dc\u5355\u9879\u7684\u540d\u5b57:");
        if (!dlg.showDialog()) {
            return false;
        }
        HashMap newAlias = dlg.getNewAlias();
        MainMenuItemInfo mi = new MainMenuItemInfo();
        mi.setParent(parent);
        LanguageCollection lc = BosUtil.getMetaDataLoader().getSolution().getLanguages();
        int z = lc.size();
        for (int i = 0; i < z; ++i) {
            LanguageInfo li = lc.get(i);
            String alias = (String)newAlias.get(li.getLocaleString());
            mi.setName(alias, li.getLocale());
            reportEntityInfo.setReportName(alias, li.getLocale());
        }
        mi.setNumber(number);
        mi.setDescription((String)atts.get("description"));
        mi.setUiClassName(Eas_KdrsReportUI.class.getName());
        mi.setUiClassParam(rptPk.toString());
        mi.setOpenMethod(OpenMethod.DEFAULT);
        mi.setOrder("255");
        mi.setEnabled(true);
        mi.setVisible(true);
        mi.setIsReport(false);
        IMainMenuItem menu = MainMenuItemFactory.getRemoteInstance();
        IObjectPK menuPk = menu.addnew((CoreBaseInfo)mi);
        Eas_PublishMenuHandler.updateRemoteMenuCache();
        reportEntity.addnew((IObjectPK)rptPk, reportEntityInfo);
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put(ATTR_EAS_REPORT_ID, rptPk.toString());
        attrs.put(ATTR_EAS_MENU_PK, menuPk.toString());
        this.getBizContent().setAttributes(this.getPathText(), attrs);
        return true;
    }

    protected void unDeployReport(String rptId, String menuId) throws Exception {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        if (rptId != null) {
            try {
                IDiscretePermission permission = DiscretePermissionFactory.getRemoteInstance();
                ObjectUuidPK rptPk = new ObjectUuidPK("id", BOSUuid.create((String)"59CB05C6"));
                rptPk.setKeyValue("id", (Object)rptId);
                ArrayList<ObjectUuidPK> list = new ArrayList<ObjectUuidPK>();
                list.add(rptPk);
                permission.removeDiscretePermsByBoId(new ReportEntityInfo().getBOSType(), list);
                attrs.put(ATTR_EAS_REPORT_ID, null);
                log.info((Object)("\u79fb\u9664\u79bb\u6563\u6570\u636e\u6388\u6743\u8bb0\u5f55:" + rptId));
            }
            catch (Exception ex) {
                log.error((Object)"remove discrete data", (Throwable)ex);
            }
        }
        if (menuId != null) {
            try {
                IMainMenuItem menu = MainMenuItemFactory.getRemoteInstance();
                ObjectUuidPK menuPk = new ObjectUuidPK("id", new MainMenuItemInfo().getBOSType());
                menuPk.setKeyValue("id", (Object)menuId);
                menu.delete((IObjectPK)menuPk);
                attrs.put(ATTR_EAS_MENU_PK, null);
                log.info((Object)("\u79fb\u9664\u83dc\u5355\u9879:" + menuId));
            }
            catch (Exception ex) {
                log.error((Object)"uninstall menu", (Throwable)ex);
            }
        }
        this.getBizContent().setAttributes(this.getPathText(), attrs);
    }

    protected String getReportMenuPathText(String menuId) throws Exception {
        try {
            IMainMenuItem menu = MainMenuItemFactory.getRemoteInstance();
            ObjectUuidPK menuPk = new ObjectUuidPK("id", new MainMenuItemInfo().getBOSType());
            menuPk.setKeyValue("id", (Object)menuId);
            StringBuffer sb = new StringBuffer("");
            while (true) {
                MainMenuItemInfo menuItem = menu.getMainMenuItemInfo((IObjectPK)menuPk);
                sb.insert(0, "/" + menuItem.getName());
                menuItem = menuItem.getParent();
                if (menuItem == null) break;
                menuPk.setKeyValue("id", (Object)menuItem.getId().toString());
            }
            return sb.toString();
        }
        catch (ObjectNotFoundException e) {
            return null;
        }
    }

    protected void refreshParent() throws Exception {
        String reportName = this.getResNode().getName();
        this.setResNode((ResObjectNode)this.getResNode().getParent());
        this.forward("list");
        ((Eas_BizContentTreeCtrl)super.getBizContentTreeCtrl()).selectRowByResObjectNode(reportName);
    }

    protected boolean onAction() throws Exception {
        Object rptId;
        HashMap attrs = this.getBizContent().getAttributes(this.getPathText(), new String[]{ATTR_EAS_REPORT_ID, ATTR_EAS_MENU_PK});
        Object v0 = rptId = attrs == null ? null : attrs.get(ATTR_EAS_REPORT_ID);
        if (rptId != null) {
            String menuPk = (String)attrs.get(ATTR_EAS_MENU_PK);
            String menuItemPath = this.getReportMenuPathText(menuPk);
            if (menuItemPath == null || WindowUtil.msgboxYesNo((Component)this.getTreeUI(), (Object)(EasResource.getString("alreadyPublish") + menuItemPath + EasResource.getString("retreat")), (String)EasResource.getString("viewPublishReport"))) {
                this.unDeployReport(rptId, menuPk);
                WindowUtil.msgboxInfo((Object)EasResource.getString("undoInfo"), (String)EasResource.getString("undopublish"), (Component)this.getTreeUI());
                this.refreshParent();
            }
        } else if (this.deployReport()) {
            WindowUtil.msgboxInfo((Object)EasResource.getString("res_12"), (String)EasResource.getString("res_13"), (Component)this.getTree());
            this.refreshParent();
        }
        return false;
    }

    public static class AliasInputDialog
    extends TypicalDialog {
        protected KDMultiLangBox mlbAlias;
        protected String labelText = "\u522b\u540d";

        public AliasInputDialog() {
        }

        public AliasInputDialog(Dialog owner) {
            super(owner);
        }

        public AliasInputDialog(Frame owner) {
            super(owner);
        }

        protected void todoInit() {
            super.setTitle("\u522b\u540d");
            this.mlbAlias = MultiLangUI.newKDMultiLangBox();
            this.mlbAlias.setMaxLength(32);
        }

        protected void todoAddControls(Container parent, Cell thisCell) {
            super.setSize(320, 135);
            Table tab = thisCell.split(1, 1);
            tab.getStyle().clear(1);
            tab.rowStyle(0).setMargin(3);
            parent.add((Component)CtrlSwingUtilities.createLabelContainer((JComponent)this.mlbAlias, (String)this.labelText, (int)80), tab.cell(0, 0));
        }

        protected void todoActionPerformed(ActionEvent e) {
        }

        protected void todoKeyAction(int keyCode) {
        }

        public void setOldAlias(HashMap alias) {
            MultiLangUI.toKDMultiLangBox((KDMultiLangBox)this.mlbAlias, (HashMap)alias);
        }

        public HashMap getNewAlias() {
            return MultiLangUI.fromKDMultiLangBox((KDMultiLangBox)this.mlbAlias);
        }

        public final void setLabelText(String labelText) {
            this.labelText = labelText;
        }
    }
}

