/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.forapp.kdrs.listener;

import com.kingdee.bos.ctrl.common.ui.restree.ResObjectNode;
import com.kingdee.bos.ctrl.common.util.PathUtil;
import com.kingdee.bos.ctrl.reportone.forapp.kdrs.listener.INoteTreeListener;
import com.kingdee.bos.ctrl.reportone.forapp.kdrs.listener.NoteTreeEvent;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.storage.IBizStorage;
import com.kingdee.bos.ctrl.swing.KDTree;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class TemplateTreeListener
implements INoteTreeListener {
    private String _nodePath;
    private String _defaultTemplateName;
    private static Map _map = new HashMap();
    private TemplateTreeListener _preListener;
    private Map _properties;

    private TemplateTreeListener() {
    }

    public void buildChain(TemplateTreeListener preListener) {
        this._preListener = preListener;
    }

    public static String tree2path(ResObjectNode node) {
        TreeNode[] path = node.getPath();
        String nodePath = "";
        for (int i = 0; i < path.length; ++i) {
            ResObjectNode kid = (ResObjectNode)path[i];
            if (kid == node.getRoot()) continue;
            nodePath = nodePath + "/" + kid.getName();
        }
        return nodePath;
    }

    public static TemplateTreeListener getListener(ResObjectNode node) {
        TemplateTreeListener listener = (TemplateTreeListener)_map.get(node);
        if (listener == null) {
            if (node == null) {
                return null;
            }
            listener = new TemplateTreeListener();
            listener._nodePath = TemplateTreeListener.tree2path(node);
            _map.put(node, listener);
        }
        return listener;
    }

    @Override
    public void fireEvent(NoteTreeEvent event) {
        switch (event.getType()) {
            case 0: {
                this.mark(event);
                break;
            }
            case 1: {
                this.remove(event);
                break;
            }
            case 2: {
                this.add(event);
                break;
            }
        }
        if (this._preListener != null) {
            this._preListener.fireEvent(event);
        }
    }

    private void add(NoteTreeEvent event) {
        ResObjectNode node = (ResObjectNode)event.getSource();
        TreeNode parent = node.getParent();
        if (this.getDefaultTemplateName() != null && !this.getDefaultTemplateName().equals("")) {
            String targetPath = this.getNodePath() + this.getDefaultTemplateName();
            for (int i = 0; i < parent.getChildCount(); ++i) {
                ResObjectNode sibling = (ResObjectNode)parent.getChildAt(i);
                if (sibling.isChecked() || !targetPath.equals(event.getNodePath() + "/" + sibling.getName())) continue;
                sibling.setChecked(true);
                break;
            }
        }
    }

    private void remove(NoteTreeEvent event) {
        String targetPath;
        if (this.getDefaultTemplateName() != null && !this.getDefaultTemplateName().equals("") && (targetPath = this.getNodePath() + this.getDefaultTemplateName()).equals(event.getNodePath() + event.getNodeName())) {
            Object obj = event.getResource("IBizStorage");
            String cau = (String)event.getResource("cau");
            String basePath = (String)event.getResource("parentpath");
            if (obj == null) {
                return;
            }
            try {
                Class<?> noteuserConfigClass = Class.forName("com.kingdee.bos.ctrl.report.forapp.kdnote.client.NoteUserConfig");
                Object instance = null;
                Class[] typesRM = new Class[]{String.class};
                Class[] typesLD = new Class[]{IBizStorage.class, String.class};
                Class[] typesSV = new Class[]{IBizStorage.class, String.class, noteuserConfigClass};
                String path = PathUtil.makeChildPath((String)basePath, (String)this.getNodePath());
                Object[] argLD = new Object[]{obj, path};
                Object[] argRM = new Object[]{cau};
                Method loadMethod = noteuserConfigClass.getMethod("load", typesLD);
                Method removeMethod = noteuserConfigClass.getMethod("removeDefaultTemplateName", typesRM);
                Method saveMethod = noteuserConfigClass.getMethod("save", typesSV);
                instance = loadMethod.invoke(noteuserConfigClass, argLD);
                removeMethod.invoke(instance, argRM);
                Object[] argSV = new Object[]{obj, path, instance};
                saveMethod.invoke(noteuserConfigClass, argSV);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.setDefaultTemplateName("");
        }
    }

    private void mark(NoteTreeEvent event) {
        String targetPath;
        if (this.getDefaultTemplateName() != null && !this.getDefaultTemplateName().equals("") && (targetPath = this.getNodePath() + this.getDefaultTemplateName()).equals(event.getNodePath() + event.getNodeName())) {
            ResObjectNode node = (ResObjectNode)event.getSource();
            node.setChecked(true);
        }
    }

    public String getNodePath() {
        return this._nodePath;
    }

    public String getDefaultTemplateName() {
        return this._defaultTemplateName;
    }

    public void setDefaultTemplateName(String str) {
        this.setDefaultTemplateName(str, null, null);
    }

    public void setDefaultTemplateName(String str, ResObjectNode node, KDTree tree) {
        String preTemplateName = this._defaultTemplateName;
        this._defaultTemplateName = str;
        if (node != null && str != null && !str.equals("") && preTemplateName != null) {
            node = (ResObjectNode)node.getParent();
            String[] path = preTemplateName.split("/");
            ResObjectNode kid = null;
            boolean isget = true;
            block0: for (int i = 1; i < path.length - 1 && isget; ++i) {
                String childname = path[i];
                isget = false;
                for (int n = 0; n < node.getChildCount(); ++n) {
                    kid = (ResObjectNode)node.getChildAt(n);
                    if (!childname.equals(kid.getName())) continue;
                    node = kid;
                    isget = true;
                    continue block0;
                }
            }
            if (isget && path.length > 2) {
                kid.setChildrenLoaded(false);
                TreePath treepath = new TreePath(kid.getPath());
                tree.getSelectionModel().setSelectionPath(treepath);
            }
        }
    }

    public static Map get_map() {
        return _map;
    }

    public void addProperity(String key, String value) {
        this._properties.put(key, value);
    }

    public Object getProperity(String propertiyName) {
        return this._properties.get(propertiyName);
    }

    public static int size() {
        return _map.size();
    }

    public static void clear() {
        _map.clear();
    }
}

