/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.forapp.kdrs.storage.ui;

import com.kingdee.bos.ctrl.common.ui.tree.ATreeController;
import com.kingdee.bos.ctrl.common.ui.tree.TreeUI;
import com.kingdee.bos.ctrl.common.ui.tree.TreeUINode;
import com.kingdee.bos.ctrl.common.util.PathUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.reportone.forapp.kdrs.ClientResource;
import com.kingdee.bos.ctrl.reportone.forapp.kdrs.icons.KDRSIcons;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.storage.IBizStorage;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.storage.StorageCategory;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.KDRSException;
import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.tree.TreePath;

public class CommonBizStorageTreeCtrl
extends ATreeController {
    public static final HashMap LIST_ATTRS = new HashMap();
    public static final String[] GET_ATTRS;
    private IBizStorage bizSto;
    protected String _rootPath = "/";

    public CommonBizStorageTreeCtrl(IBizStorage bizSto) {
        this.bizSto = bizSto;
        this.initTreeUI(new TreeUI());
    }

    public IBizStorage getBizStorage() {
        return this.bizSto;
    }

    public void initTreeUI(TreeUI treeUI) {
        TreeUINode topNode = this.newTreeNode(StorageCategory.FOLDER, this._rootPath, ClientResource.getString("res_33"), true);
        topNode.setCustomIcon((Icon)KDRSIcons.ICN_STORAGE_ROOT);
        treeUI.setRootNode(topNode);
        this.bindTreeUI(treeUI, topNode);
    }

    protected boolean initNode(TreePath treePath) throws Exception {
        TreeUINode node = (TreeUINode)treePath.getLastPathComponent();
        String pathText = PathUtil.makeChildPath((String)this._rootPath, (String)this.makePathText(treePath));
        this.initFolderNode(pathText, node);
        return true;
    }

    protected void initFolderNode(String pathText, TreeUINode node) throws KDRSException {
        HashMap rv = this.bizSto.list(pathText, LIST_ATTRS);
        String[] names = (String[])rv.get("name");
        String[] alias = (String[])rv.get("alias");
        String[] types = (String[])rv.get("type");
        for (int i = 0; i < names.length; ++i) {
            String text;
            StorageCategory category = "Folder".equals(types[i]) ? StorageCategory.FOLDER : StorageCategory.FILE;
            if (!this.isVisible(category, text = TreeUINode.makeText((String)names[i], (String)alias[i]))) continue;
            TreeUINode tcnSub = CommonBizStorageTreeCtrl.newTreeNode(category, names[i], alias[i]);
            this.getTreeUI().addChildNode(tcnSub, node);
        }
    }

    protected static TreeUINode newTreeNode(Object category, String name, String alias) {
        TreeUINode tn = new TreeUINode(name);
        tn.setAlias(alias);
        tn.setCategory(category);
        tn.setAllowsChildren(StorageCategory.FOLDER == category);
        return tn;
    }

    public void setRootPath(String rootPath) {
        this._rootPath = rootPath;
    }

    public String getRootPath() {
        return this._rootPath;
    }

    public String getRelativeSelectionPathText() {
        return this.getTreeUI().getSelectionPathText();
    }

    public String getAbsoluteSelectionPathText() {
        String pathText = this.getRelativeSelectionPathText();
        if (!StringUtil.isEmptyString((String)this.getRootPath())) {
            pathText = PathUtil.makeChildPath((String)this.getRootPath(), (String)pathText);
        }
        return pathText;
    }

    static {
        LIST_ATTRS.put("name", null);
        LIST_ATTRS.put("alias", null);
        LIST_ATTRS.put("type", null);
        GET_ATTRS = new String[]{"name", "alias", "category"};
    }
}

