/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.kdrs.frameworks.bos.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.ORMRPCServiceLocator;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.BizRpcReducer;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.content.IBizContent;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.security.IBizSecurity;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.storage.IBizStorage;
import com.kingdee.bos.ctrl.reportone.kdrs.engine.ISession;
import com.kingdee.bos.ctrl.reportone.kdrs.engine.client.ClientSideSession;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.KDRSException;
import com.kingdee.bos.ctrl.reportone.kdrs.frameworks.bos.AbstractKdrsBosEngine;
import com.kingdee.bos.ctrl.reportone.kdrs.frameworks.bos.common.IBosSystem;
import com.kingdee.bos.ctrl.reportone.kdrs.frameworks.bos.common.IServiceWrapper;
import com.kingdee.bos.ctrl.reportone.kdrs.frameworks.bos.service.ServiceWrapper;
import com.kingdee.bos.ctrl.reportone.kdrs.frameworks.bos.service.ServiceWrapperBizObjectFactory;
import com.kingdee.bos.ctrl.reportone.r1.form.designer.util.MultiLanguageUtil;
import java.util.HashMap;
import java.util.Map;

public class KdrsBosClientEngine
extends AbstractKdrsBosEngine {
    private IServiceWrapper _serviceWrapper;
    private BizRpcReducer _rpcBatchCallerCore;

    public Map batchCall(Map batchRecords) throws KDRSException {
        if (this._serviceWrapper != null) {
            return this._serviceWrapper.batchCall(batchRecords);
        }
        throw new RuntimeException(MultiLanguageUtil.getMLS("client.KdrsClientEngine.errorTime", ""));
    }

    public void setRpcBatchCallerCore(BizRpcReducer rpcBatchCallerCore) {
        this._rpcBatchCallerCore = rpcBatchCallerCore;
    }

    @Override
    public ISession login(String ais, String lang) throws KDRSException {
        String loginResult = null;
        Map batchRecords = this._rpcBatchCallerCore != null ? this._rpcBatchCallerCore.getBatchRecords() : new HashMap<String, Object[]>();
        batchRecords.put("login", new Object[]{ais, lang});
        IServiceWrapper wrapper = this.createRemoteWapper();
        if (this._rpcBatchCallerCore != null) {
            batchRecords = wrapper.batchCall(batchRecords);
            loginResult = (String)batchRecords.remove("login");
            this._rpcBatchCallerCore.setBatchRecords(batchRecords);
        }
        this.setRpcBatchCallerCore(null);
        this._serviceWrapper = wrapper;
        if (loginResult == null) {
            loginResult = wrapper.login(ais, lang);
        }
        ClientSideSession session = new ClientSideSession(loginResult);
        session.setProperty(IBosSystem.class, wrapper);
        session.setProperty(IBizStorage.class, ServiceWrapperBizObjectFactory.createBizObject(session, wrapper, IBizStorage.class));
        session.setProperty(IBizContent.class, ServiceWrapperBizObjectFactory.createBizObject(session, wrapper, IBizContent.class));
        session.setProperty(IBizSecurity.class, ServiceWrapperBizObjectFactory.createBizObject(session, wrapper, IBizSecurity.class));
        return session;
    }

    @Override
    public void logout(ISession session) throws KDRSException {
        if (session == null) {
            return;
        }
        IBosSystem system = (IBosSystem)session.getProperty(IBosSystem.class);
        if (system != null) {
            system.logout(session.getSid());
        }
        super.logout(session);
    }

    @Override
    protected Object createBizObject(Class objCls, ISession session) throws KDRSException {
        throw new UnsupportedOperationException("Unsupported");
    }

    private IServiceWrapper createRemoteWapper() throws KDRSException {
        String rpcUrl = ORMRPCServiceLocator.getCurrentServiceURL();
        try {
            return (IServiceWrapper)BOSObjectFactory.createRemoteObject((String)rpcUrl, (String)ServiceWrapper.class.getName(), IServiceWrapper.class);
        }
        catch (BOSException ex) {
            throw KDRSException.makeException(ex);
        }
    }
}

