/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.kdrs.storage.db;

import com.kingdee.bos.ctrl.reportone.kdrs.Path;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.CircularReferenceException;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.db.TreeNode;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.db.bean.FileInfoBean;
import java.util.BitSet;
import java.util.HashMap;

public class FileTree
extends TreeNode {
    public FileTree(HashMap bean_mapping) throws CircularReferenceException {
        BitSet bitSet = new BitSet();
        HashMap node_mapping = new HashMap();
        for (FileInfoBean bean : bean_mapping.values()) {
            this.ensureNode(bean, bean_mapping, node_mapping, bitSet);
        }
    }

    TreeNode ensureNode(FileInfoBean bean, HashMap bean_mapping, HashMap node_mapping, BitSet bitSet) throws CircularReferenceException {
        TreeNode node = (TreeNode)node_mapping.get(bean);
        if (node == null) {
            FileInfoBean parent = (FileInfoBean)bean_mapping.get(new Integer(bean.getPid()));
            if (parent == null || bean.getPid() == -1) {
                this.fileInfo = bean;
                node = this;
            } else {
                int fid = bean.getPid();
                if (bitSet.get(fid)) {
                    throw new CircularReferenceException("File table is bad,circular info = " + bitSet);
                }
                bitSet.set(fid);
                node = this.ensureNode(parent, bean_mapping, node_mapping, bitSet).createChild(bean);
                bitSet.clear();
            }
            node_mapping.put(bean, node);
        }
        return node;
    }

    public TreeNode findNode(Path path) {
        if (path.isRoot()) {
            return this;
        }
        TreeNode node = this;
        Path[] paths = path.paths();
        for (int i = 1; i < paths.length && (node = node.findChild(paths[i].getName())) != null; ++i) {
        }
        return node;
    }
}

