/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.kdrs.storage.meta;

import com.kingdee.bos.ctrl.reportone.kdrs.Path;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.KDRSException;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.ResourceType;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.meta.FileMeta;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.meta.ILazyFolderMeta;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.meta.IMetas;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.meta.IResourceMeta;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.meta.LazyFolderMeta;
import java.util.Iterator;

public abstract class BasicMetas
implements IMetas {
    protected ILazyFolderMeta rootMeta;

    protected BasicMetas() throws KDRSException {
        this.initRootMeta();
    }

    private void initRootMeta() {
        this.rootMeta = (ILazyFolderMeta)this.createResourceMeta("", ResourceType.FOLDER);
    }

    @Override
    public IResourceMeta getMeta(Path resPath) {
        if (resPath.isRoot()) {
            return this.rootMeta;
        }
        ILazyFolderMeta parentMeta = this.getFolderMeta(resPath.getParent());
        return parentMeta != null ? parentMeta.getChild(resPath.getName()) : null;
    }

    @Override
    public ILazyFolderMeta getFolderMeta(Path folderPath) {
        IResourceMeta meta = this.rootMeta;
        Path[] paths = folderPath.paths();
        for (int i = 0; i < paths.length; ++i) {
            if (meta instanceof LazyFolderMeta) {
                Iterator children;
                LazyFolderMeta temp = (LazyFolderMeta)meta;
                if (!temp.isChildrenLoaded() && (children = this.loadChildren(paths[i])) != null) {
                    temp.addChildren(children);
                    temp.setChildrenLoaded();
                }
                if (i == paths.length - 1) continue;
                meta = temp.getChild(paths[i + 1].getName());
                continue;
            }
            return null;
        }
        return (LazyFolderMeta)meta;
    }

    @Override
    public boolean isReservedPath(Path path) {
        return false;
    }

    @Override
    public IResourceMeta createResourceMeta(String name, ResourceType type) {
        if (type == ResourceType.FILE) {
            return new FileMeta(name);
        }
        if (type == ResourceType.FOLDER) {
            return new LazyFolderMeta(name);
        }
        return null;
    }

    protected abstract Iterator loadChildren(Path var1);
}

