/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.form.designer.gui.property;

import com.kingdee.bos.ctrl.common.layout.table.Table;
import com.kingdee.bos.ctrl.common.layout.table.TableLayout;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.data.meta.MetaClass;
import com.kingdee.bos.ctrl.data.meta.MetaField;
import com.kingdee.bos.ctrl.reportone.forapp.eas.Eas_QuerySelector;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.ElementPath;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.property.AbstractPropertyPanel;
import com.kingdee.bos.ctrl.reportone.r1.form.designer.element.F7SelectObject;
import com.kingdee.bos.ctrl.reportone.r1.form.designer.gui.property.PanelMainF7Select;
import com.kingdee.bos.ctrl.reportone.r1.form.designer.util.MultiLanguageUtil;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.form.widget.QueryF7Model;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import com.kingdee.eas.basedata.org.OrgType;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PanelF7Select
extends AbstractPropertyPanel {
    private KDTextField txtUIAddress;
    private KDPromptBox bosQueryName;
    private KDComboBox cmbDisFormat;
    private KDComboBox cmbSubmitFormat;
    private KDCheckBox isEditable;
    private KDComboBox cmbEditFormat;
    private KDCheckBox isMultiSelection;
    private KDComboBox cmbFilterModle;
    private KDComboBox cmbValueFormat;
    private KDComboBox cmbEnTrustSels;
    private Eas_QuerySelector metaChooser;
    private MetaClass metaClass;
    private String strMetaName;
    private KDLabelContainer lbcOrgType;
    private String oldExp;
    static String[] orgTypes = new String[]{QueryF7Model.FILTER_MAIN_ORG_UNIT.getAlias(), QueryF7Model.FILTER_CU.getAlias(), QueryF7Model.FILTER_DELEGATION_FROM.getAlias(), QueryF7Model.FILTER_DELEGATION_TO.getAlias()};
    private ItemListener itemListener = new ItemListener(){

        @Override
        public void itemStateChanged(ItemEvent e) {
            KDComboBox cmb;
            if (e.getStateChange() == 1 && !((cmb = (KDComboBox)e.getSource()).getSelectedItem() instanceof String)) {
                MetaField metaField = (MetaField)cmb.getSelectedItem();
                String str = "$" + metaField.getName() + "$";
                cmb.setSelectedItem((Object)str);
            }
        }
    };
    private ActionListener actionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            Object obj = e.getSource();
            if (obj.equals(PanelF7Select.this.isEditable)) {
                if (PanelF7Select.this.isEditable.isSelected()) {
                    PanelF7Select.this.cmbEditFormat.setEnabled(true);
                    PanelF7Select.this.cmbSubmitFormat.setEnabled(true);
                } else {
                    PanelF7Select.this.cmbSubmitFormat.setEnabled(false);
                    PanelF7Select.this.cmbEditFormat.setEnabled(false);
                }
            }
        }
    };

    public PanelF7Select() {
        this.init();
        this.installListener();
    }

    private void clearItems() {
        this.cmbDisFormat.removeAllItems();
        this.cmbValueFormat.removeAllItems();
        this.cmbSubmitFormat.removeAllItems();
        this.cmbEditFormat.removeAllItems();
    }

    private void reload(MetaClass metaClass) {
        List list;
        this.clearItems();
        if (StringUtil.isEmptyString((String)this.strMetaName)) {
            this.strMetaName = metaClass.getExpr();
            this.bosQueryName.setData((Object)metaClass);
            this.bosQueryName.setText(this.strMetaName);
        }
        if ((list = metaClass.getFields()) != null) {
            for (int i = 0; i < list.size(); ++i) {
                MetaField metaField = (MetaField)list.get(i);
                this.cmbDisFormat.addItem((Object)metaField);
                this.cmbValueFormat.addItem((Object)metaField);
                this.cmbSubmitFormat.addItem((Object)metaField);
                this.cmbEditFormat.addItem((Object)metaField);
            }
            this.cmbDisFormat.setSelectedIndex(-1);
            this.cmbValueFormat.setSelectedIndex(-1);
            this.cmbSubmitFormat.setSelectedIndex(-1);
            this.cmbEditFormat.setSelectedIndex(-1);
        }
    }

    private void init() {
        this.txtUIAddress = new KDTextField();
        this.metaChooser = new Eas_QuerySelector();
        this.bosQueryName = new KDPromptBox();
        this.bosQueryName.setEditable(true);
        this.bosQueryName.setSelector((KDPromptSelector)this.metaChooser);
        this.isEditable = new KDCheckBox(MultiLanguageUtil.getMLS("allowEdit", ""));
        this.isEditable.addActionListener(this.actionListener);
        this.isMultiSelection = new KDCheckBox(MultiLanguageUtil.getMLS("allowMultiSelection", ""));
        this.cmbDisFormat = new KDComboBox();
        this.cmbDisFormat.addItemListener(this.itemListener);
        this.cmbDisFormat.setEditable(true);
        this.cmbSubmitFormat = new KDComboBox();
        this.cmbSubmitFormat.setEditable(true);
        this.cmbSubmitFormat.addItemListener(this.itemListener);
        this.cmbEditFormat = new KDComboBox();
        this.cmbEditFormat.setEditable(true);
        this.cmbEditFormat.addItemListener(this.itemListener);
        this.cmbValueFormat = new KDComboBox();
        this.cmbValueFormat.addItemListener(this.itemListener);
        this.cmbValueFormat.setEditable(true);
        this.cmbFilterModle = new KDComboBox();
        this.cmbFilterModle.addItems((Object[])orgTypes);
        this.cmbEnTrustSels = new KDComboBox();
        this.cmbEnTrustSels.addItems((Object[])PanelMainF7Select.orgTypes);
        this.cmbEnTrustSels.setSelectedIndex(-1);
        this.cmbEnTrustSels.setVisible(false);
        if (!this.isEditable.isSelected()) {
            this.cmbEditFormat.setEnabled(false);
            this.cmbSubmitFormat.setEnabled(false);
        }
        KDLabelContainer lbcUiAddress = CtrlSwingUtilities.createLabelContainer((JComponent)this.txtUIAddress, (String)MultiLanguageUtil.getMLS("uiAddress", ""), (int)100);
        KDLabelContainer lbcQueryName = CtrlSwingUtilities.createLabelContainer((JComponent)this.bosQueryName, (String)MultiLanguageUtil.getMLS("bosQueryName", ""), (int)100);
        KDLabelContainer lbcDisFormat = CtrlSwingUtilities.createLabelContainer((JComponent)this.cmbDisFormat, (String)MultiLanguageUtil.getMLS("displayFormat", ""), (int)100);
        KDLabelContainer lbcSubmitFormat = CtrlSwingUtilities.createLabelContainer((JComponent)this.cmbSubmitFormat, (String)MultiLanguageUtil.getMLS("submitFormat", ""), (int)100);
        KDLabelContainer lbcEditFormat = CtrlSwingUtilities.createLabelContainer((JComponent)this.cmbEditFormat, (String)MultiLanguageUtil.getMLS("editFormat", ""), (int)100);
        KDLabelContainer lbcValueFormat = CtrlSwingUtilities.createLabelContainer((JComponent)this.cmbValueFormat, (String)MultiLanguageUtil.getMLS("valueFormat", ""), (int)100);
        KDLabelContainer lbcBizOrg = CtrlSwingUtilities.createLabelContainer((JComponent)this.cmbFilterModle, (String)MultiLanguageUtil.getMLS("BizOrg", ""), (int)100);
        this.lbcOrgType = CtrlSwingUtilities.createLabelContainer((JComponent)this.cmbEnTrustSels, (String)MultiLanguageUtil.getMLS("orgType", ""), (int)80);
        this.lbcOrgType.setVisible(false);
        TableLayout tl = TableLayout.split((int)10, (int)1);
        tl.getStyle().setMargin(4, 8, 8, 8);
        tl.rowStyle(0).setMargin(4, 0, 0, 3);
        tl.rowStyle(1).setMargin(4, 0, 0, 3);
        tl.rowStyle(2).setMargin(4, 0, 0, 3);
        tl.rowStyle(3).setMargin(4, 0, 0, 3);
        tl.rowStyle(4).setMargin(4, 0, 0, 3);
        tl.rowStyle(5).setMargin(0, 0, 0, 0);
        tl.rowStyle(6).setMargin(25, 0, 0, 3);
        tl.rowStyle(7).setMargin(25, 0, 0, 3);
        tl.rowStyle(8).setMargin(0, 0, 0, 3);
        tl.rowStyle(9).setPriY(1);
        Table t = tl.cell(0).split(1, 2);
        t.colStyle(0).setWidth(300);
        t.colStyle(0).setMarginRight(10);
        t.colStyle(1).setPriX(1);
        this.setLayout((LayoutManager)tl);
        this.add((Component)lbcBizOrg, t.cell(0));
        this.add((Component)this.lbcOrgType, t.cell(1));
        this.add((Component)lbcQueryName, tl.cell(1, 0));
        this.add((Component)lbcUiAddress, tl.cell(2, 0));
        this.add((Component)lbcDisFormat, tl.cell(3, 0));
        this.add((Component)lbcValueFormat, tl.cell(4, 0));
        this.add((Component)this.isEditable, tl.cell(5, 0));
        this.add((Component)lbcEditFormat, tl.cell(6, 0));
        this.add((Component)lbcSubmitFormat, tl.cell(7, 0));
        this.add((Component)this.isMultiSelection, tl.cell(8, 0));
        if (this.isEnTrust()) {
            this.lbcOrgType.setVisible(true);
        }
    }

    private boolean isEnTrust() {
        return this.cmbFilterModle.getSelectedItem() == orgTypes[2] || this.cmbFilterModle.getSelectedItem() == orgTypes[3];
    }

    private void installListener() {
        this.cmbFilterModle.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (PanelF7Select.this.isEnTrust()) {
                    PanelF7Select.this.cmbEnTrustSels.setVisible(true);
                    PanelF7Select.this.lbcOrgType.setVisible(true);
                    PanelF7Select.this.refreshQuery();
                } else {
                    PanelF7Select.this.cmbEnTrustSels.setVisible(false);
                    PanelF7Select.this.lbcOrgType.setVisible(false);
                }
            }
        });
        this.bosQueryName.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                String str;
                if (PanelF7Select.this.metaChooser.getData() instanceof MetaClass) {
                    PanelF7Select.this.metaClass = (MetaClass)PanelF7Select.this.metaChooser.getData();
                    if (PanelF7Select.this.metaClass != null) {
                        PanelF7Select.this.reload(PanelF7Select.this.metaClass);
                    }
                }
                if (PanelF7Select.this.bosQueryName.getData() instanceof String && !StringUtil.equals((String)(str = PanelF7Select.this.bosQueryName.getText()), (String)PanelF7Select.this.oldExp)) {
                    try {
                        PanelF7Select.this.metaClass = Eas_QuerySelector.getMetaClass(str);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (PanelF7Select.this.metaClass == null) {
                        return;
                    }
                    PanelF7Select.this.reload(PanelF7Select.this.metaClass);
                }
            }
        });
        this.cmbEnTrustSels.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                PanelF7Select.this.refreshQuery();
            }
        });
    }

    private void refreshQuery() {
        Object o = this.cmbEnTrustSels.getSelectedItem();
        if (o instanceof OrgType) {
            String str;
            OrgType orgType = (OrgType)o;
            this.oldExp = str = PanelMainF7Select.paserOrtType2Query(orgType);
            this.metaClass = Eas_QuerySelector.getMetaClass(str);
            this.bosQueryName.setText(str);
            if (this.metaClass == null) {
                return;
            }
            this.reload(this.metaClass);
        }
    }

    @Override
    protected void updateElementValue(ElementPath elePath) {
        F7SelectObject ro = (F7SelectObject)elePath.getLastPathComponent();
        QueryF7Model model = new QueryF7Model();
        if (this.cmbFilterModle.getSelectedItem() != null) {
            model.setFilterMode(QueryF7Model.parseFilterType(this.cmbFilterModle.getSelectedItem().toString()));
            if (this.isEnTrust() && this.cmbEnTrustSels.getSelectedItem() instanceof OrgType) {
                model.setOrgType((OrgType)this.cmbEnTrustSels.getSelectedItem());
            }
        }
        if (this.bosQueryName.getData() instanceof String) {
            model.setQueryInfo((String)this.bosQueryName.getData());
        } else if (this.bosQueryName.getData() instanceof MetaClass) {
            model.setQueryInfo(((MetaClass)this.bosQueryName.getData()).getExpr());
        }
        if (this.cmbDisFormat.getSelectedItem() != null) {
            model.setDisplayFormat(this.cmbDisFormat.getSelectedItem().toString());
        }
        if (this.cmbValueFormat.getSelectedItem() != null) {
            model.setValueFormat(this.cmbValueFormat.getSelectedItem().toString());
        }
        if (this.isEditable.isSelected()) {
            model.setEditable(true);
            if (this.cmbSubmitFormat.getSelectedItem() != null) {
                model.setCommitFormat(this.cmbSubmitFormat.getSelectedItem().toString());
            }
            if (null != this.cmbEditFormat.getSelectedItem()) {
                model.setEditFormat(this.cmbEditFormat.getSelectedItem().toString());
            }
        } else {
            model.setEditable(false);
        }
        if (null != this.txtUIAddress.getText()) {
            model.setUIClassName(this.txtUIAddress.getText());
        }
        if (this.isMultiSelection.isSelected()) {
            model.setMultiSelectable(true);
        } else {
            model.setMultiSelectable(false);
        }
        ro.setModel(model);
    }

    @Override
    public String getTitle() {
        return MultiLanguageUtil.getMLS("f7Select", "");
    }

    private void setEditFormatEnable(boolean flag) {
        this.isEditable.setSelected(flag);
        this.cmbEditFormat.setEnabled(flag);
        this.cmbSubmitFormat.setEnabled(flag);
    }

    @Override
    public void prepareCtrlValue(ElementPath[] eles) {
        F7SelectObject ele = (F7SelectObject)eles[0].getLastPathComponent();
        QueryF7Model model = ele.getModel();
        if (model != null) {
            if (!StringUtil.isEmptyString((String)model.getQueryInfo())) {
                this.metaClass = Eas_QuerySelector.getMetaClass(model.getQueryInfo());
            }
            if (this.metaClass != null) {
                this.reload(this.metaClass);
            } else {
                this.bosQueryName.setData((Object)model.getQueryInfo());
            }
            if (model.getFilterMode() != null) {
                this.cmbFilterModle.setSelectedItem((Object)model.getFilterMode().getAlias());
                if (this.isEnTrust()) {
                    this.cmbEnTrustSels.setVisible(true);
                    this.cmbEnTrustSels.setSelectedItem((Object)model.getOrgType());
                } else {
                    this.cmbEnTrustSels.setVisible(false);
                }
            }
            if (model.getDisplayFormat() != null) {
                this.cmbDisFormat.setSelectedItem((Object)model.getDisplayFormat());
            }
            if (model.getValueFormat() != null) {
                this.cmbValueFormat.setSelectedItem((Object)model.getValueFormat());
            }
            if (model.isEditable()) {
                this.setEditFormatEnable(true);
                this.cmbEditFormat.setSelectedItem((Object)model.getEditFormat());
                this.cmbSubmitFormat.setSelectedItem((Object)model.getCommitFormat());
            } else {
                this.setEditFormatEnable(false);
            }
            if (!StringUtil.isEmptyString((String)model.getUIClassName())) {
                this.txtUIAddress.setText(model.getUIClassName());
            }
            if (model.isMultiSelectable()) {
                this.isMultiSelection.setSelected(true);
            } else {
                this.isMultiSelection.setSelected(false);
            }
        }
    }

    @Override
    public boolean verify() {
        if (this.cmbValueFormat.getSelectedItem() == null || StringUtil.isEmptyString((String)this.cmbValueFormat.getSelectedItem().toString())) {
            WindowUtil.msgboxError((Object)"\u8fd4\u56de\u683c\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (String)this.getTitle(), (Component)((Object)this));
            return false;
        }
        if (this.bosQueryName.getData() == null) {
            WindowUtil.msgboxError((Object)MultiLanguageUtil.getMLS("bosQueryNull", ""), (String)this.getTitle(), (Component)((Object)this));
            return false;
        }
        if (this.isEditable.isSelected()) {
            if (this.cmbSubmitFormat.getSelectedItem() == null || StringUtil.isEmptyString((String)this.cmbSubmitFormat.getSelectedItem().toString())) {
                WindowUtil.msgboxError((Object)MultiLanguageUtil.getMLS("submitFormatNull", ""), (String)this.getTitle(), (Component)((Object)this));
                return false;
            }
            if (this.cmbEditFormat.getSelectedItem() == null || StringUtil.isEmptyString((String)this.cmbEditFormat.getSelectedItem().toString())) {
                WindowUtil.msgboxError((Object)MultiLanguageUtil.getMLS("editFormatNull", ""), (String)this.getTitle(), (Component)((Object)this));
                return false;
            }
        }
        return true;
    }
}

