/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.form.designer.gui.property.crosstab.ui;

import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.reportone.data.process.dataset.crosstab.CrosstabInfo;
import com.kingdee.bos.ctrl.reportone.r1.form.designer.gui.property.crosstab.ui.CrosstabTableBinder;
import com.kingdee.bos.ctrl.swing.KDChart;
import com.kingdee.bos.ctrl.swing.chart.ChartType;
import com.kingdee.bos.ctrl.swing.chart.data.IChartData;
import com.kingdee.bos.ctrl.swing.chart.data.PieChartData;
import com.kingdee.bos.ctrl.swing.chart.util.ChartDataUtil;
import java.util.ArrayList;
import java.util.BitSet;

public class CrosstabChartBinder {
    private KDChart chart;
    private KDTable table;
    private int leftCols;
    private int headRowCount;
    private BitSet totalColumns;
    private BitSet totalRows;
    private boolean isEmptyCrosstab;
    private double[][] dataCache;

    public CrosstabChartBinder(CrosstabInfo crosstabInfo, KDChart chart) {
        this(crosstabInfo, chart, null);
    }

    public CrosstabChartBinder(CrosstabInfo crosstabInfo, KDChart chart, CrosstabTableBinder tableBinder) {
        boolean bl = this.isEmptyCrosstab = crosstabInfo == null || crosstabInfo.isEmpty();
        if (tableBinder == null) {
            tableBinder = new CrosstabTableBinder(crosstabInfo, new KDTable());
        }
        this.table = tableBinder.getTable();
        this.leftCols = tableBinder.getLeftCols();
        this.headRowCount = tableBinder.getHeadRowCount();
        this.totalColumns = tableBinder.getTotalColumns();
        this.totalRows = tableBinder.getTotalRows();
        this.chart = chart;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void bind(int seriesId) {
        if (this.isEmptyCrosstab) {
            return;
        }
        if (this.dataCache == null) {
            this.dataCache = this.makeDataWithoutTotal();
        }
        PieChartData chartData = null;
        ChartType ct = this.chart.getChartType();
        if (ct == ChartType.CT_PIE) {
            if (seriesId == -1) throw new UnsupportedOperationException();
            chartData = ChartDataUtil.createPieChartData((String[])this.getFlatTopNames(), (double[])this.dataCache[seriesId]);
        } else {
            String[] names;
            double[][] temp;
            if (ct == ChartType.CT_GANTT) {
                throw new UnsupportedOperationException("CT_GANTT");
            }
            if (seriesId != -1) {
                temp = new double[1][this.dataCache[0].length];
                System.arraycopy(this.dataCache[seriesId], 0, temp[0], 0, temp[0].length);
                names = new String[]{this.getFlatLeftNames()[seriesId]};
            } else {
                temp = this.dataCache;
                names = this.getFlatLeftNames();
            }
            chartData = ChartDataUtil.createCommonChartData((String[])names, (String[])this.getFlatTopNames(), (double[][])temp);
        }
        this.chart.clearChartDataCollection();
        this.chart.addChartData((IChartData)chartData);
    }

    private String[] getFlatTopNames() {
        int headRows = this.headRowCount;
        int tabCols = this.table.getColumnCount();
        ArrayList<String> list = new ArrayList<String>();
        StringBuffer sb = new StringBuffer();
        for (int col = this.leftCols; col < tabCols; ++col) {
            if (this.totalColumns.get(col)) continue;
            for (int row = 0; row < headRows; ++row) {
                if (this.totalRows.get(row)) continue;
                sb.append((String)this.table.getRow(row).getCell(col).getValue());
                if (row == headRows - 1) continue;
                sb.append(".");
            }
            list.add(sb.toString());
            sb.setLength(0);
        }
        String[] names = new String[list.size()];
        return list.toArray(names);
    }

    private String[] getFlatLeftNames() {
        int tabRows = this.table.getRowCount();
        ArrayList<String> list = new ArrayList<String>();
        StringBuffer sb = new StringBuffer();
        for (int row = this.headRowCount; row < tabRows; ++row) {
            if (this.totalRows.get(row)) continue;
            for (int col = 0; col < this.leftCols; ++col) {
                sb.append((String)this.table.getRow(row).getCell(col).getValue());
                if (col == this.leftCols - 1) continue;
                sb.append(".");
            }
            list.add(sb.toString());
            sb.setLength(0);
        }
        String[] names = new String[list.size()];
        return list.toArray(names);
    }

    private double[][] makeDataWithoutTotal() {
        int tabRows = this.table.getRowCount();
        int tabCols = this.table.getColumnCount();
        double[][] data = new double[tabRows - this.totalRows.cardinality()][tabCols - this.totalColumns.cardinality() - this.leftCols];
        int dataRow = 0;
        for (int row = this.headRowCount; row < tabRows; ++row) {
            if (this.totalRows.get(row)) continue;
            int dataCol = 0;
            for (int col = this.leftCols; col < tabCols; ++col) {
                if (this.totalColumns.get(col)) continue;
                Object obj = this.table.getCell(row, col).getValue();
                if (obj != null) {
                    data[dataRow][dataCol] = ((Number)obj).doubleValue();
                }
                ++dataCol;
            }
            ++dataRow;
        }
        return data;
    }
}

