/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.form.designer.gui.property.crosstab.ui;

import com.kingdee.bos.ctrl.common.CtrlUIEnv;
import com.kingdee.bos.ctrl.common.layout.table.Table;
import com.kingdee.bos.ctrl.common.layout.table.TableLayout;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.StreamUtil;
import com.kingdee.bos.ctrl.common.util.xml.XmlUtil;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.reportone.data.process.dataset.crosstab.CrosstabInfo;
import com.kingdee.bos.ctrl.reportone.r1.form.designer.gui.property.crosstab.CrosstabSADef;
import com.kingdee.bos.ctrl.reportone.r1.form.designer.gui.property.crosstab.io.CrosstabSADef2Xml;
import com.kingdee.bos.ctrl.reportone.r1.form.designer.gui.property.crosstab.io.Xml2CrosstabSADef;
import com.kingdee.bos.ctrl.reportone.r1.form.designer.gui.property.crosstab.ui.CrosstabBorderChooser;
import com.kingdee.bos.ctrl.reportone.r1.form.designer.gui.property.crosstab.ui.CrosstabPreviewPanel;
import com.kingdee.bos.ctrl.reportone.r1.form.designer.gui.property.crosstab.ui.CrosstabWordsStylePanel;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDPanel;
import java.awt.Component;
import java.awt.LayoutManager;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import javax.swing.border.TitledBorder;
import org.apache.log4j.Logger;
import org.jdom2.Element;

public class CrosstabStyleDesignerPanel
extends KDPanel {
    private static final Logger log = LogUtil.getPackageLogger(CrosstabStyleDesignerPanel.class);
    private CrosstabPreviewPanel previewPanel;
    private CrosstabWordsStylePanel wordsStylePanel;
    private CrosstabBorderChooser btFrame;

    public CrosstabStyleDesignerPanel() {
    }

    public CrosstabStyleDesignerPanel(CrosstabSADef saDef) {
        this.initCtrls(saDef, CrosstabPreviewPanel.demo);
    }

    public CrosstabStyleDesignerPanel(CrosstabSADef saDef, CrosstabInfo exampleData) {
        this.initCtrls(saDef, exampleData);
    }

    public void setCrosstabSADef(CrosstabSADef def) {
        if (def == null || def.isEmpty()) {
            try {
                InputStream in = StreamUtil.loadResource(CrosstabStyleDesignerPanel.class, (String)"default_crosstab_sa.xml");
                def = Xml2CrosstabSADef.toObject(XmlUtil.loadXmlStream((InputStream)in));
            }
            catch (Exception ex) {
                log.error(null, (Throwable)ex);
            }
        }
        if (this.previewPanel != null) {
            this.removeAll();
        }
        this.initCtrls(def, CrosstabPreviewPanel.demo);
    }

    public CrosstabSADef getCrosstabSADef() {
        if (this.previewPanel != null) {
            return this.previewPanel.getCrosstabSAs();
        }
        return null;
    }

    private void initCtrls(CrosstabSADef saDef, CrosstabInfo exampleData) {
        HashMap sas = saDef.getSAs();
        HashMap<String, String> itemAliases = new HashMap<String, String>();
        itemAliases.put("\u4ea4\u53c9\u5b57\u6bb5", "Crossfield");
        itemAliases.put("\u6c47\u603b\u5b57\u6bb5\u8868\u5934", "Total-tableHead");
        itemAliases.put("\u6c47\u603b\u5b57\u6bb5", "Totalfield");
        itemAliases.put("\u6c34\u5e73\u8868\u5934", "Horizontalfield");
        itemAliases.put("\u5782\u76f4\u8868\u5934", "Verticalfield");
        this.wordsStylePanel = new CrosstabWordsStylePanel(sas, itemAliases, new String[]{"\u6c34\u5e73\u8868\u5934", "\u5782\u76f4\u8868\u5934", "\u6c47\u603b\u5b57\u6bb5\u8868\u5934", "\u4ea4\u53c9\u5b57\u6bb5", "\u6c47\u603b\u5b57\u6bb5"});
        this.wordsStylePanel.setBorder(new TitledBorder("\u6587\u5b57\u6837\u5f0f"));
        this.previewPanel = new CrosstabPreviewPanel(exampleData, saDef);
        this.previewPanel.setBorder(new TitledBorder("\u9884\u89c8"));
        if (exampleData == CrosstabPreviewPanel.demo) {
            KDTable table = this.previewPanel.getTabBinder().getTable();
            table.setAutoResize(true);
        }
        this.btFrame = new CrosstabBorderChooser(new CrosstabBorderChooser.SelectBorder(){

            @Override
            public void onSelectBorder() {
                CrosstabStyleDesignerPanel.this.previewPanel.getCrosstabSAs().setFrameStyle(CrosstabStyleDesignerPanel.this.btFrame.getChoice());
                CrosstabStyleDesignerPanel.this.previewPanel.changeSA("Frame");
            }
        });
        TableLayout layout = TableLayout.split((int)1, (int)2);
        this.setLayout((LayoutManager)layout);
        Table leftTable = layout.cell(0, 0).split(2, 1);
        this.add((Component)((Object)this.wordsStylePanel), leftTable.cell(0, 0));
        leftTable.rowStyle(1).setHeight(19);
        leftTable.rowStyle(0).setPriY(1);
        leftTable.rowStyle(1).setMargin(0, 6, 0, 6);
        Table leftBottom = leftTable.cell(1, 0).split(1, 3);
        leftBottom.colStyle(2).setPriX(1);
        leftBottom.cell(0, 0).style().setWidth(26);
        this.add((Component)new KDLabel("\u8868\u683c\u8fb9\u6846: "), leftBottom.cell(0, 0));
        this.add((Component)((Object)this.btFrame), leftBottom.cell(0, 1));
        this.add((Component)((Object)this.previewPanel), layout.cell(0, 1));
        layout.cell(0, 0).style().setWidth(200);
        layout.colStyle(1).setPriX(1);
        layout.cell(0, 0).style().setMarginRight(6);
        this.wordsStylePanel.addItemStyleChangedListener(new CrosstabWordsStylePanel.ItemStyleChangedListener(){

            @Override
            public void onStyleChanged(String item) {
                CrosstabStyleDesignerPanel.this.previewPanel.changeSA(item);
            }
        });
    }

    public static void main(String[] args) {
        CtrlUIEnv.setKingdeeLAF();
        String file = "c:\\crosstab_sa.xml";
        try {
            CrosstabSADef def = null;
            try {
                def = Xml2CrosstabSADef.toObject(XmlUtil.loadXmlFile((String)file));
            }
            catch (IOException ex) {
                ex.printStackTrace();
                def = new CrosstabSADef();
            }
            CrosstabStyleDesignerPanel panel = new CrosstabStyleDesignerPanel();
            while (true) {
                panel.setCrosstabSADef(def);
                if (!WindowUtil.showSimpleDialog((Component)((Object)panel), null, null, null)) continue;
                def = panel.getCrosstabSADef();
                Element e = CrosstabSADef2Xml.toXml(def);
                XmlUtil.saveXmlFile((String)file, (Element)e);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(0);
            return;
        }
    }
}

