/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.form.engine.x.data.groupinggrid;

import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.common.log.LogUtil;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.common.log.Logger;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.common.node.ExportException;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.data.NameIndex;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.data.grouping.GroupRSCache;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.data.grouping.StatGroup;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.data.groupinggrid.IFlatBuilder;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.data.groupinggrid.RowContext;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.data.groupinggrid.pattern.GGPattern2Group;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.data.groupinggrid.pattern.GGRow;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.data.groupinggrid.pattern.GGRowType;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.data.groupinggrid.pattern.GroupingGrid;
import java.sql.ResultSet;
import java.sql.SQLException;

public class GGFlatEngine {
    private static final Logger log = LogUtil.getLogger(GGFlatEngine.class, 1);
    private RowContext[] patternRows;
    private int currentIndex = -1;
    private GroupRSCache grsCache;
    private IFlatBuilder flatBuilder;

    public void init(ResultSet rows, GroupingGrid grid) throws SQLException {
        int[] detailCols;
        int depth;
        GGPattern2Group f2g = new GGPattern2Group();
        f2g.parseGrid(grid, rows);
        StatGroup[] groups = f2g.getGroups();
        if (f2g.getDetailRows() > 0) {
            depth = groups.length + 1;
            detailCols = f2g.getDetailCols();
        } else {
            depth = groups.length;
            detailCols = null;
        }
        this.grsCache = new GroupRSCache();
        this.grsCache.init(rows, groups, detailCols);
        this.initPattern(grid, groups, depth);
        while (this.grsCache.hasNextGroup()) {
            this.grsCache.nextGroup(0);
        }
    }

    private void initPattern(GroupingGrid grid, StatGroup[] groups, int depth) throws SQLException {
        int rowCount = grid.getRowCount();
        this.patternRows = new RowContext[rowCount + 2 * depth];
        int row1 = 0;
        int row2 = rowCount - 1;
        int p1 = 0;
        int p2 = this.patternRows.length - 1;
        block0: for (int level = 0; level < depth; ++level) {
            int colIdx;
            NameIndex col;
            GGRow ggRow;
            int byCol;
            StatGroup group;
            if (level < groups.length) {
                group = groups[level];
                byCol = group.getByCol();
            } else {
                group = null;
                byCol = -1;
            }
            int groupStart = p1;
            int groupEnd = p2;
            RowContext rowCtx = new RowContext(groupEnd, this.grsCache, level, group, true, null);
            this.patternRows[p1++] = rowCtx;
            rowCtx = new RowContext(groupStart, this.grsCache, level, group, false, null);
            this.patternRows[p2--] = rowCtx;
            while (row1 <= row2) {
                ggRow = grid.getRow(row1);
                col = ggRow.getGroupCol();
                int n = GGRowType.DETAIL == ggRow.getType() ? -1 : (colIdx = col != null ? col.getIndex() : 0);
                if (colIdx != byCol) break;
                rowCtx = new RowContext(groupEnd, this.grsCache, level, group, true, ggRow);
                this.patternRows[p1++] = rowCtx;
                ++row1;
            }
            while (row1 <= row2) {
                ggRow = grid.getRow(row2);
                col = ggRow.getGroupCol();
                int n = GGRowType.DETAIL == ggRow.getType() ? -1 : (colIdx = col != null ? col.getIndex() : 0);
                if (colIdx != byCol) continue block0;
                rowCtx = new RowContext(groupStart, this.grsCache, level, group, false, ggRow);
                this.patternRows[p2--] = rowCtx;
                --row2;
            }
        }
    }

    public final RowContext[] getPatternRows() {
        return this.patternRows;
    }

    public final IFlatBuilder getFlatBuilder() {
        return this.flatBuilder;
    }

    public final void setFlatBuilder(IFlatBuilder listener) {
        this.flatBuilder = listener;
    }

    public final int findGroupCol(int level, String statType, int dataCol) throws SQLException {
        return this.grsCache.findGroupCol(level, statType, dataCol);
    }

    public final int findDetailCol(int dataCol) throws SQLException {
        return this.grsCache.findDetailCol(dataCol);
    }

    public final boolean nextRow() throws SQLException, ExportException {
        ++this.currentIndex;
        while (this.currentIndex < this.patternRows.length) {
            RowContext ctx = this.patternRows[this.currentIndex];
            if (ctx.getRowPattern() == null) {
                if (ctx.isPrefixRow()) {
                    if (this.grsCache.nextOutputRow(ctx.getGroupLevel())) {
                        this.startGroup(ctx);
                    } else {
                        this.currentIndex = ctx.getPeerIndex();
                    }
                } else {
                    this.endGroup(ctx);
                    this.currentIndex = ctx.getPeerIndex() - 1;
                }
            } else {
                this.buildRow(ctx);
                return true;
            }
            ++this.currentIndex;
        }
        return false;
    }

    private void startGroup(RowContext ctx) throws SQLException {
        if (log.isDebugEnable()) {
            log.debug("Start flat group ..." + ctx);
        }
    }

    private void endGroup(RowContext ctx) throws SQLException {
        if (log.isDebugEnable()) {
            log.debug("End flat group ..." + ctx);
        }
    }

    private void buildRow(RowContext ctx) throws ExportException, SQLException {
        if (log.isDebugEnable()) {
            log.debug("Build flat row ..." + ctx);
        }
        if (this.flatBuilder != null) {
            this.flatBuilder.buildRow(ctx);
        }
    }
}

