/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.print.barcode;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.DataType;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.data.BindField;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.data.Field;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.data.IBind;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.util.BarcodeUtils;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.data.R1PrintBindDataSource;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.util.UuidException;
import java.lang.reflect.Method;

public class BarcodeBindSource {
    private IBind.IBindDataSource bindDs;
    private IBind.IBindField bindField;
    private String dictId;
    private String dictNumber;
    private String text;
    private String format = "";
    private String type = "DataSource";
    public static final String DICT_BOSTYPE = "355D4F45";
    public static final String DICTENTRY_BOSTYPE = "E55A8C2D";
    public static IMetaDataLoader loader = MetaDataLoaderFactory.getMetaDataLoader(null);
    public static ICoreBase dictInterface;
    public static ICoreBase dictEntryInterface;
    public static EntityObjectInfo dictEntity;
    public static final String TYPE_TEXT = "Text";
    public static final String TYPE_DATASOURCE = "DataSource";

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String toDrawString() {
        if (this.bindDs == null || this.bindField == null) {
            return null;
        }
        return this.bindDs.getDs().toString() + ":" + this.bindField.getField().toDrawString();
    }

    public String getDictId() {
        return this.dictId;
    }

    public void setDictId(String dictId) {
        this.dictId = dictId;
    }

    public String getDictNumber() {
        return this.dictNumber;
    }

    public void setDictNumber(String dictNumber) {
        this.dictNumber = dictNumber;
    }

    public IBind.IBindDataSource getBindDs() {
        return this.bindDs;
    }

    public void setBindDs(IBind.IBindDataSource bindDs) {
        this.bindDs = bindDs;
    }

    public IBind.IBindField getBindField() {
        return this.bindField;
    }

    public void setBindField(IBind.IBindField bindField) {
        DataType dt;
        this.bindField = bindField;
        if (!(bindField == null || bindField.getField() == null || (dt = bindField.getField().getDataType()) == null || dt.intValue() != 5 && dt.intValue() != 3 || this.format != null && !"".equals(this.format))) {
            this.format = "0000.00";
        }
    }

    public String toString() {
        if (TYPE_TEXT.equals(this.getType())) {
            return this.getText();
        }
        return this.bindDs.getDs().toString() + ":" + this.bindField.getField().toDrawString();
    }

    public String toXML() {
        String ds = null;
        String field = null;
        if (TYPE_DATASOURCE.equals(this.getType())) {
            ds = this.getBindDs().getDs();
            field = this.getBindField().getField().getName();
            return "{" + this.getType() + "@" + ds + "@" + field + "@" + this.getDictId() + "@" + this.format + "}";
        }
        if (TYPE_TEXT.equals(this.getType())) {
            return "{" + this.getType() + "@" + BarcodeUtils.unicodeEncode(this.getText()) + "}";
        }
        return "";
    }

    public void fromXML(String str) {
        str = str.substring(1, str.length() - 1);
        String[] fs = str.split("@");
        String type = fs[0];
        this.setType(type);
        if (TYPE_TEXT.equals(type)) {
            this.setText(BarcodeUtils.unicodeDecode(fs[1]));
        } else if (TYPE_DATASOURCE.equals(type)) {
            R1PrintBindDataSource bindDs = new R1PrintBindDataSource();
            bindDs.setDs(fs[1]);
            BindField bindField = new BindField();
            bindField.setField(Field.valueOf(fs[2], null));
            this.setBindDs(bindDs);
            this.setBindField(bindField);
            IObjectValue dictValue = this.getDictObject(fs[3]);
            if (dictValue != null) {
                this.setDictId(dictValue.get("id").toString());
                this.setDictNumber(dictValue.getString("number"));
            }
            if (fs.length >= 5) {
                this.setFormat(fs[4]);
            }
        }
    }

    private IObjectValue getDictObject(String id) {
        if (id == null || "".equals(id.trim()) || "null".equalsIgnoreCase(id)) {
            return null;
        }
        CoreBaseInfo result = null;
        try {
            result = BarcodeBindSource.getDictInterface().getValue("select id,number where id='" + id + "'");
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (UuidException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static EntityObjectInfo getDictEntity() {
        if (dictEntity == null) {
            dictEntity = loader.getEntity(BOSObjectType.create((String)DICT_BOSTYPE));
        }
        return dictEntity;
    }

    public static ICoreBase getDictInterface() throws BOSException {
        if (dictInterface == null) {
            try {
                String factory = BarcodeBindSource.getDictEntity().getBusinessImplFactory();
                Class<?> c = null;
                Method method = null;
                c = Class.forName(factory);
                method = c.getMethod("getRemoteInstance", new Class[0]);
                dictInterface = (ICoreBase)method.invoke(c, new Object[0]);
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
        return dictInterface;
    }

    public static ICoreBase getDictEntryInterface() throws BOSException {
        if (dictEntryInterface == null) {
            try {
                EntityObjectInfo eoi = loader.getEntity(BOSObjectType.create((String)DICTENTRY_BOSTYPE));
                String factory = eoi.getBusinessImplFactory();
                Class<?> c = null;
                Method method = null;
                c = Class.forName(factory);
                method = c.getMethod("getRemoteInstance", new Class[0]);
                dictEntryInterface = (ICoreBase)method.invoke(c, new Object[0]);
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
        return dictEntryInterface;
    }
}

