/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.print.designer.gui.property.grid;

import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.ElementPath;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.AbstractColumn;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.AbstractRow;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.core.ComboPanel;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.property.AbstractPropertyPanel;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.util.MultiLanguageUtil;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.element.grid.layoutgrid.LayoutGrid;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.gui.property.grid.RowsColsPane;
import java.awt.BorderLayout;
import java.awt.Component;

public class PanelLayoutGrid
extends AbstractPropertyPanel {
    private RowsColsPane _rowsColsPane;
    private boolean _isSingleSelected;
    private ComboPanel _core;

    public PanelLayoutGrid() {
        this.init();
    }

    public void init() {
        this._rowsColsPane = new RowsColsPane();
        this._rowsColsPane.setPromptText(MultiLanguageUtil.getMLS("grid.PanelLayoutGrid.explain", ""));
        this.setLayout(new BorderLayout());
        this.add((Component)((Object)this._rowsColsPane), "North");
    }

    @Override
    public String getTitle() {
        return MultiLanguageUtil.getMLS("grid.PanelLayoutGrid.PLayoutGrid", "");
    }

    @Override
    public void prepareSupplyValue(ComboPanel core, ElementPath[] eps) {
        this._core = core;
    }

    @Override
    public void prepareCtrlValue(ElementPath[] eps) {
        this._isSingleSelected = eps.length == 1;
        this._rowsColsPane.setRowsCtrlEnabled(this._isSingleSelected);
        this._rowsColsPane.setColsCtrlEnabled(this._isSingleSelected);
        LayoutGrid grid = (LayoutGrid)eps[0].getLastPathComponent();
        this._rowsColsPane.setRows(grid.getRowsCount());
        this._rowsColsPane.setCols(grid.getColumnsCount());
    }

    @Override
    protected void updateElementValue(ElementPath elePath) {
        if (this._isSingleSelected) {
            LayoutGrid grid = (LayoutGrid)elePath.getLastPathComponent();
            this.adjustRows(grid, this._rowsColsPane.getRows());
            this.adjustCols(grid, this._rowsColsPane.getCols());
        }
    }

    private void adjustRows(LayoutGrid grid, int newRows) {
        block3: {
            int oldRows;
            block2: {
                oldRows = grid.getRowsCount();
                if (newRows >= oldRows) break block2;
                for (int i = oldRows - 1; i >= newRows; --i) {
                    this._core.getModel().removeElement(grid, grid.getRow(i));
                }
                break block3;
            }
            if (newRows <= oldRows) break block3;
            int c = newRows - oldRows;
            for (int i = 0; i < c; ++i) {
                AbstractRow row = grid.addRow(1);
                this._core.getModel().allotSubElementIdWidthFire(grid, row);
            }
        }
    }

    private void adjustCols(LayoutGrid grid, int newCols) {
        block3: {
            int oldCols;
            block2: {
                oldCols = grid.getColumnsCount();
                if (newCols >= oldCols) break block2;
                for (int i = oldCols - 1; i >= newCols; --i) {
                    this._core.getModel().removeElement(grid, grid.getColumn(i));
                }
                break block3;
            }
            if (newCols <= oldCols) break block3;
            int c = newCols - oldCols;
            for (int i = 0; i < c; ++i) {
                AbstractColumn col = grid.addColumn();
                this._core.getModel().allotSubElementIdWidthFire(grid, col);
            }
        }
    }
}

