/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.print.designer.renderer;

import com.kingdee.bos.ctrl.kdf.util.style.LineStyle;
import com.kingdee.bos.ctrl.kdf.util.style.PenStyle;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.IElement;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.IReportObject;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.cellvalue.ICellValue;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.core.PageContainer;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.renderer.AbstractObjectRenderer;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.util.Util;
import com.kingdee.bos.ctrl.reportone.r1.print.common.R1PrintStringRender;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.element.loop.LoopArea;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.element.loop.LoopContainer;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.renderer.RendererUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;

public class LoopAreaRenderer
extends AbstractObjectRenderer {
    private LoopArea _loopArea;
    private Color _color4RepeatArea = new Color(100, 100, 100, 40);
    private Stroke _stroke4AssLine = new BasicStroke(1.0f, 0, 0, 10.0f, new float[]{10.0f, 2.0f, 2.0f, 2.0f, 4.0f, 2.0f, 2.0f, 2.0f}, 0.0f);
    private Color _color4Arrowhead = new Color(200, 200, 200);
    private Stroke _stroke4Arrowhead = new BasicStroke(4.0f);
    private Stroke _stroke4ArrowheadConnecting = new BasicStroke(2.0f, 0, 0, 10.0f, new float[]{30.0f, 3.0f, 3.0f, 3.0f}, 0.0f);
    private Style _style4InvlidValue;

    private Style getStyle4InvalidValue() {
        if (this._style4InvlidValue == null) {
            StyleAttributes sa = Styles.getDefaultSA();
            sa.setFontColor(Color.RED);
            this._style4InvlidValue = Styles.getStyle((ShareStyleAttributes)sa);
        }
        return this._style4InvlidValue;
    }

    @Override
    public void setReportObject(IReportObject obj) {
        this._loopArea = (LoopArea)obj;
    }

    @Override
    public void draw(Graphics graphics, PageContainer c) {
        Style style = this.getStyle(this._loopArea);
        int x = this._loopArea.getXLom();
        int y = this._loopArea.getYLom();
        int w = this._loopArea.getWidthLom();
        int h = this._loopArea.getHeightLom();
        Rectangle rect = new Rectangle(x, y, w, h);
        Util.lom2Pixel(rect);
        ++rect.width;
        ++rect.height;
        this.drawBackground(graphics, rect, style);
        this.drawBorder(graphics, rect, style);
        LoopContainer lc = this._loopArea.getLoopContainer();
        int lcW = lc.getWidthLom();
        int lcH = lc.getHeightLom();
        this.drawAssLine((Graphics2D)graphics, x, y, w, h, lcW, lcH);
        this.drawArrowhead((Graphics2D)graphics, x, y, w, h, lcW, lcH);
        style = this.getStyle(lc);
        rect = new Rectangle(x, y, lcW, lcH);
        Util.lom2Pixel(rect);
        ++rect.width;
        ++rect.height;
        this.drawBackground(graphics, rect, style);
        this.drawBorder(graphics, rect, style);
        this.drawText(graphics, lc.getValue(), rect, style, lc);
    }

    private void drawText(Graphics g, ICellValue value, Rectangle rect, Style style, Object target) {
        if (value != null) {
            R1PrintStringRender r1TextRender = R1PrintStringRender.getKeepClipInstance();
            rect = new Rectangle(rect.x + 2, rect.y + 2, rect.width - 4, rect.height - 4);
            if (value.isInvalid()) {
                style = this.getStyle4InvalidValue();
            } else if (style == null) {
                style = Styles.getDefaultStyle();
            }
            r1TextRender.drawText(g, rect, value.getDrawString(), style, target);
        }
    }

    private void drawAssLine(Graphics2D graphics, int x, int y, int width, int height, int unitW, int unitH) {
        Rectangle rect1 = new Rectangle(x, y + unitH, unitW, height - unitH);
        Util.lom2Pixel(rect1);
        ++rect1.width;
        this.drawBackground((Graphics)graphics, rect1, this._color4RepeatArea);
        Rectangle rect2 = new Rectangle(0, y, width - unitW, height);
        Util.lom2Pixel(rect2);
        rect2.x = rect1.x + rect1.width - 2;
        this.drawBackground((Graphics)graphics, rect2, this._color4RepeatArea);
        if (this.isTooSmall(unitW, unitH)) {
            return;
        }
        Color oriColor = graphics.getColor();
        Stroke oriStroke = graphics.getStroke();
        graphics.setColor(Color.LIGHT_GRAY);
        graphics.setStroke(this._stroke4AssLine);
        int bottom = y + height / unitH * unitH;
        int right = x + width / unitW * unitW;
        int y1 = Util.lom2Pixel(y);
        int y2 = Util.lom2Pixel(bottom);
        for (int addX = unitW; addX < width; addX += unitW) {
            int xx = Util.lom2Pixel(x + addX);
            graphics.drawLine(xx, y1, xx, y2);
        }
        int x1 = Util.lom2Pixel(x);
        int x2 = Util.lom2Pixel(right);
        for (int addY = unitH; addY < height; addY += unitH) {
            int yy = Util.lom2Pixel(y + addY);
            graphics.drawLine(x1, yy, x2, yy);
        }
        graphics.setStroke(oriStroke);
        graphics.setColor(oriColor);
    }

    private Style getStyle(IElement ele) {
        StyleAttributes sa = ele.getStyleAttribute();
        sa = sa == null ? Styles.getDefaultSA() : Styles.getSA((StyleAttributes)sa);
        if (LineStyle.isNull((LineStyle)sa.getBorderLineStyle(Styles.Position.LEFT))) {
            RendererUtil.initBorder(sa, Styles.Position.LEFT, LineStyle.SINGLE_LINE, PenStyle.PS_DASH, Color.GRAY);
        }
        if (LineStyle.isNull((LineStyle)sa.getBorderLineStyle(Styles.Position.RIGHT))) {
            RendererUtil.initBorder(sa, Styles.Position.RIGHT, LineStyle.SINGLE_LINE, PenStyle.PS_DASH, Color.GRAY);
        }
        if (LineStyle.isNull((LineStyle)sa.getBorderLineStyle(Styles.Position.TOP))) {
            RendererUtil.initBorder(sa, Styles.Position.TOP, LineStyle.SINGLE_LINE, PenStyle.PS_DASH, Color.GRAY);
        }
        if (LineStyle.isNull((LineStyle)sa.getBorderLineStyle(Styles.Position.BOTTOM))) {
            RendererUtil.initBorder(sa, Styles.Position.BOTTOM, LineStyle.SINGLE_LINE, PenStyle.PS_DASH, Color.GRAY);
        }
        return Styles.getStyle((ShareStyleAttributes)sa);
    }

    private boolean isTooSmall(int unitW, int unitH) {
        return unitW < 50 || unitH < 30;
    }

    private void drawArrowhead(Graphics2D graphics, int x, int y, int width, int height, int unitW, int unitH) {
        Color oriColor = graphics.getColor();
        Stroke oriStroke = graphics.getStroke();
        graphics.setColor(this._color4Arrowhead);
        graphics.setStroke(this._stroke4Arrowhead);
        if (this.isTooSmall(unitW, unitH)) {
            if (width > 100 && height > 100) {
                this.drawGeneralArrowhead(graphics, x, y, width, height);
            }
            graphics.setStroke(oriStroke);
            graphics.setColor(oriColor);
            return;
        }
        int rows = height / unitH;
        int cols = width / unitW;
        if (this._loopArea.isRepeatHorizontal()) {
            if (cols >= 2) {
                int x1 = Util.lom2Pixel(x + (int)((double)unitW * 1.33));
                int y1 = Util.lom2Pixel(y + (int)((double)unitH * 0.5));
                int x2 = Util.lom2Pixel(x + (int)(((double)cols - 0.33) * (double)unitW));
                int y2 = y1;
                graphics.drawLine(x1, y1, x2, y2);
                this.drawArrowHead(graphics, x2, y2, true);
                if (rows >= 2) {
                    int x3 = Util.lom2Pixel(x + (int)((double)unitW * 0.33));
                    int y3 = Util.lom2Pixel(y + (int)((double)unitH * 1.5));
                    int x4 = x2;
                    int y4 = y3;
                    graphics.drawLine(x3, y3, x4, y4);
                    this.drawArrowHead(graphics, x4, y4, true);
                    graphics.setStroke(this._stroke4ArrowheadConnecting);
                    graphics.drawLine(x2, y2, x3, y3);
                }
            } else if (rows >= 2) {
                this.drawGeneralArrowhead(graphics, x, y, width, height);
            }
        } else if (rows >= 2) {
            int x1 = Util.lom2Pixel(x + (int)((double)unitW * 0.5));
            int y1 = Util.lom2Pixel(y + (int)((double)unitH * 1.33));
            int x2 = x1;
            int y2 = Util.lom2Pixel(y + (int)(((double)rows - 0.33) * (double)unitH));
            graphics.drawLine(x1, y1, x2, y2);
            this.drawArrowHead(graphics, x2, y2, false);
            if (cols >= 2) {
                int x3 = Util.lom2Pixel(x + (int)((double)unitW * 1.5));
                int y3 = Util.lom2Pixel(y + (int)((double)unitH * 0.33));
                int x4 = x3;
                int y4 = y2;
                graphics.drawLine(x3, y3, x4, y4);
                this.drawArrowHead(graphics, x4, y4, false);
                graphics.setStroke(this._stroke4ArrowheadConnecting);
                graphics.drawLine(x2, y2, x3, y3);
            }
        } else if (cols >= 2) {
            this.drawGeneralArrowhead(graphics, x, y, width, height);
        }
        graphics.setStroke(oriStroke);
        graphics.setColor(oriColor);
    }

    private void drawGeneralArrowhead(Graphics2D graphics, int x, int y, int width, int height) {
        if (this._loopArea.isRepeatHorizontal()) {
            int x1 = Util.lom2Pixel(x + (int)((double)width * 0.33));
            int y1 = Util.lom2Pixel(y + (int)((double)height * 0.5));
            int x2 = Util.lom2Pixel(x + (int)((double)width * 0.67));
            int y2 = y1;
            graphics.drawLine(x1, y1, x2, y2);
            this.drawArrowHead(graphics, x2, y2, true);
        } else {
            int x1 = Util.lom2Pixel(x + (int)((double)width * 0.5));
            int y1 = Util.lom2Pixel(y + (int)((double)height * 0.33));
            int x2 = x1;
            int y2 = Util.lom2Pixel(y + (int)((double)height * 0.67));
            graphics.drawLine(x1, y1, x2, y2);
            this.drawArrowHead(graphics, x2, y2, false);
        }
    }

    private void drawArrowHead(Graphics2D graphics, int x, int y, boolean isHorizontal) {
        if (isHorizontal) {
            graphics.drawLine(x, y, x - 10, y - 4);
            graphics.drawLine(x, y, x - 10, y + 4);
        } else {
            graphics.drawLine(x, y, x - 4, y - 10);
            graphics.drawLine(x, y, x + 4, y - 10);
        }
    }
}

