/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.print.designer.renderer;

import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.IReportObject;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.core.PageContainer;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.renderer.AbstractObjectRenderer;
import com.kingdee.bos.ctrl.reportone.r1.print.common.R1PrintStringRender;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.element.TextObject;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.renderer.RendererUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;

public class TextRenderer
extends AbstractObjectRenderer {
    private TextObject _objText;

    @Override
    public void setReportObject(IReportObject obj) {
        this._objText = (TextObject)obj;
    }

    @Override
    public void draw(Graphics graphics, PageContainer c) {
        Rectangle rect = new Rectangle(this._objText.getX(), this._objText.getY(), this._objText.getWidth(), this._objText.getHeight());
        int angle = this._objText.getRotate();
        double rad = (double)angle / 360.0 * 2.0 * Math.PI;
        Graphics2D g2 = (Graphics2D)graphics;
        g2 = (Graphics2D)g2.create();
        Shape clip = g2.getClip();
        int tx = (int)Math.round(rect.getX() + rect.getWidth() / 2.0);
        int ty = (int)Math.round(rect.getY() + rect.getHeight() / 2.0);
        g2.rotate(rad, tx, ty);
        g2.setClip(clip);
        this.doDraw(g2, c);
    }

    private void doDraw(Graphics graphics, PageContainer c) {
        Rectangle rect = new Rectangle(this._objText.getX(), this._objText.getY(), this._objText.getWidth(), this._objText.getHeight());
        StyleAttributes saForDraw = this._objText.getStyleAttribute() == null ? Styles.getDefaultSA() : Styles.getSA((StyleAttributes)this._objText.getStyleAttribute());
        String text = RendererUtil.getDrawingText(this._objText);
        if (text == RendererUtil.ErrorResult) {
            saForDraw.setFontColor(Color.RED);
        }
        Style style = Styles.getStyle((ShareStyleAttributes)saForDraw);
        this.drawBackground(graphics, rect, style);
        RendererUtil.drawDashBorder(graphics, rect);
        this.drawBorder(graphics, rect, style);
        R1PrintStringRender r1Render = R1PrintStringRender.getKeepClipInstance();
        rect = new Rectangle(rect.x + 1, rect.y + 1, rect.width - 2, rect.height - 2);
        r1Render.drawText(graphics, rect, text, style, this._objText);
    }
}

