/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.print.engine;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.ORMRPCServiceLocator;
import com.kingdee.bos.ctrl.common.digitalstyle.FormatResult;
import com.kingdee.bos.ctrl.common.digitalstyle.Formats;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.common.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.kdf.formatter.NumberTranslate;
import com.kingdee.bos.ctrl.kdf.formatter.PRCChineseBigNumberResource;
import com.kingdee.bos.ctrl.reportone.data.framework.bos.BosUtil;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.IWidgetExecuteHelper;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.script.method.INowMethod;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.script.method.NowMethod;
import com.kingdee.bos.ctrl.script.miniscript.exec.objs.Null;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;

public class ScriptSystemMethod {
    private IWidgetExecuteHelper _executeHelper;
    private HashMap _variant;
    private final String now2Date = "@@nowDate##";
    private static NumberTranslate _prcBigNumber = new NumberTranslate(PRCChineseBigNumberResource.getInstance());

    void setExecuteHelper(IWidgetExecuteHelper helper) {
        this._executeHelper = helper;
    }

    private HashMap getVariant() {
        if (this._variant == null) {
            this._variant = new HashMap();
        }
        return this._variant;
    }

    public void set(String name, Object value) {
        this.getVariant().put(name, value);
    }

    public Object get(String name) {
        return this.getVariant().get(name);
    }

    public Object now2() {
        Object date = this.getVariant().get("@@nowDate##");
        if (null == date) {
            String rpcUrl = ORMRPCServiceLocator.getCurrentServiceURL();
            if (null == BosUtil.getBosContext()) {
                try {
                    INowMethod method = (INowMethod)BOSObjectFactory.createRemoteObject((String)rpcUrl, (String)NowMethod.class.getName(), INowMethod.class);
                    date = method.currentDate();
                    this.getVariant().put("@@nowDate##", date);
                }
                catch (BOSException bOSException) {
                    // empty catch block
                }
            }
            if (date == null) {
                date = new Date();
            }
        }
        return date;
    }

    public String format(Object value, String formatString) {
        Variant var = new Variant(value);
        FormatResult fmtResult = Formats.getFormat((String)formatString).format(var);
        String strResult = fmtResult.toString();
        return strResult;
    }

    public String formatChequeDate(Object value, String formatString) {
        return this.formatChequeDate(value, formatString, 1);
    }

    public String formatChequeDate(Object value, String formatString, int mode) {
        boolean toDealDay;
        Calendar t;
        String prefix;
        if (value == null) {
            return "";
        }
        if (mode == 0) {
            prefix = "[DBNum5]";
        } else if (mode == 1) {
            prefix = "[DBNum2]";
        } else {
            return "Invalid mode: " + mode;
        }
        if (!formatString.startsWith(prefix)) {
            formatString = prefix + formatString;
        }
        Variant var = new Variant(value);
        FormatResult fmtResult = Formats.getFormat((String)formatString).format(var);
        String strResult = fmtResult.toString();
        try {
            t = var.toCalendar();
        }
        catch (SyntaxErrorException e) {
            return strResult;
        }
        int month = t.get(2) + 1;
        int day = t.get(5);
        boolean toDealMonth = month == 10;
        boolean bl = toDealDay = day == 10 || day == 20 || day == 30;
        if (!toDealMonth && !toDealDay) {
            return strResult;
        }
        boolean haveMonth = formatString.indexOf("mm") != -1;
        boolean haveDay = formatString.indexOf("dd") != -1;
        int idxMonthStart = -1;
        if (haveMonth) {
            FormatResult tempResult = Formats.getFormat((String)(prefix + "mm")).format(new Variant((Object)("2007-" + month + "-1")));
            String strTempResult = tempResult.toString();
            idxMonthStart = strResult.indexOf(strTempResult);
        }
        int idxDayStart = -1;
        if (haveDay) {
            FormatResult tempResult = Formats.getFormat((String)(prefix + "dd")).format(new Variant((Object)("2007-1-" + day)));
            String strTempResult = tempResult.toString();
            idxDayStart = strResult.lastIndexOf(strTempResult);
        }
        StringBuffer sbNewResult = new StringBuffer(strResult);
        if (idxDayStart != -1 && toDealDay) {
            sbNewResult.insert(idxDayStart, "\u96f6");
        }
        if (idxMonthStart != -1 && toDealMonth) {
            sbNewResult.insert(idxMonthStart, "\u96f6");
        }
        return sbNewResult.toString();
    }

    public String formatChineseRMB(String value) {
        if (value == null || value.length() <= 0) {
            return value;
        }
        return this.transRmb(value);
    }

    public String formatChequeCurrency(Object value) {
        return this.formatChequeCurrency(value, '\uffe5', 1);
    }

    public String formatChequeCurrency(Object value, char fillChar, int fillMode) {
        int fillCount;
        Variant var = new Variant(value);
        FormatResult fmtRst = Formats.getFormat((String)"[DBNum8]0.00").format(var);
        String formated = fmtRst.toString();
        StringBuffer sb = new StringBuffer();
        sb.append(formated.substring(0, formated.length() - 3));
        sb.append(formated.substring(formated.length() - 2));
        if (fillMode == 1) {
            sb.insert(0, fillChar);
        } else if (fillMode >= 2 && (fillCount = fillMode - sb.length()) > 0) {
            for (int i = 0; i < fillCount; ++i) {
                sb.insert(0, fillChar);
            }
        }
        return sb.toString();
    }

    public Object getFieldValue(String ds, String field) {
        Variant var = this._executeHelper.getDataHelper().getFieldValue(ds, field);
        if (var != null) {
            return var.getValue();
        }
        return Null.NULL;
    }

    public String repeatString(String source, int times) {
        return StringUtil.makeRepeatString((String)source, (int)times);
    }

    public String leftString(String src, int len) {
        if (len < 0) {
            len = 0;
        }
        if (len > src.length()) {
            len = src.length();
        }
        return src.substring(0, len);
    }

    public String rightString(String src, int len) {
        int start;
        if (len < 0) {
            len = 0;
        }
        if ((start = src.length() - len) < 0) {
            start = 0;
        }
        return src.substring(start);
    }

    public String middleString(String src, int start, int len) {
        int end = (start = start < 0 ? 0 : start) + (len = len < 0 ? 0 : len);
        if (end > src.length()) {
            end = src.length();
        }
        return src.substring(start, end);
    }

    public String replaceString(String src, String sub, String newSub) {
        StringBuffer result = new StringBuffer();
        int subLen = sub.length();
        int last = 0;
        if (subLen > 0) {
            int found = 0;
            while (found >= 0) {
                found = src.indexOf(sub, last);
                if (found < 0) continue;
                result.append(src.substring(last, found));
                result.append(newSub);
                last = found + subLen;
            }
        }
        result.append(src.substring(last));
        return result.toString();
    }

    private int innerDateGet(Object value, int key) {
        Calendar cal;
        Variant var = new Variant(value);
        try {
            cal = var.toCalendar();
        }
        catch (SyntaxErrorException e) {
            return -1;
        }
        return cal.get(key);
    }

    public int year(Object value) {
        return this.innerDateGet(value, 1);
    }

    public int month(Object value) {
        return this.innerDateGet(value, 2) + 1;
    }

    public int day(Object value) {
        return this.innerDateGet(value, 5);
    }

    public int hour(Object value) {
        return this.innerDateGet(value, 11);
    }

    public int minute(Object value) {
        return this.innerDateGet(value, 12);
    }

    public int second(Object value) {
        return this.innerDateGet(value, 13);
    }

    public int week(Object value) {
        return this.innerDateGet(value, 7);
    }

    private String transRmb(String resource) {
        String[] strs = this.split(resource);
        if (strs == null) {
            return resource;
        }
        String head = strs[0];
        String trail = strs[1];
        resource = strs[2];
        int radixIndex = resource.indexOf(".");
        int radixCount = radixIndex > 0 ? resource.length() - 1 - radixIndex : 0;
        String integerStr = resource;
        String decStr = "";
        String decStr2 = "";
        if (radixIndex > 0) {
            integerStr = resource.substring(0, radixIndex);
            decStr = resource.substring(radixIndex + 1, radixIndex + 2);
        }
        if (radixCount >= 2) {
            decStr2 = resource.substring(radixIndex + 2);
        }
        StringBuffer sb = new StringBuffer(30);
        sb.append(head);
        boolean hasInt = false;
        if (integerStr.equals("0") && radixIndex < 0) {
            sb.append("\u96f6\u5143");
        } else if (!integerStr.equals("0")) {
            sb.append(_prcBigNumber.toNumber(integerStr));
            sb.append("\u5143");
            hasInt = true;
        }
        if (radixIndex > 0) {
            if (!decStr.equals("0")) {
                sb.append(_prcBigNumber.toNumber(decStr));
                sb.append("\u89d2");
            } else if (hasInt) {
                sb.append("\u96f6");
            }
            if (radixCount == 1) {
                sb.append("\u6574");
            } else {
                if (decStr2.equals("0")) {
                    sb.append("\u96f6");
                } else {
                    sb.append(_prcBigNumber.toNumber(decStr2));
                }
                sb.append("\u5206");
            }
        } else {
            sb.append("\u6574");
        }
        sb.append(trail);
        return sb.toString();
    }

    private String[] split(String resource) {
        int radixIndex;
        int radixCount;
        String trail;
        int i;
        int headIndex = -1;
        int trailIndex = -1;
        boolean overHead = false;
        String strSeparator = ",";
        if (resource.indexOf(strSeparator) >= 0) {
            resource = resource.replaceAll(strSeparator, "");
        }
        int size = resource.length();
        for (i = 0; i < size; ++i) {
            char c = resource.charAt(i);
            if (headIndex < 0 && (c >= '0' && c <= '9' || c == '.' || c == '-')) {
                headIndex = i;
                overHead = true;
            }
            if (trailIndex >= 0 || !overHead || c >= '0' && c <= '9' || c == '.' || c == '-') continue;
            trailIndex = i;
        }
        if (trailIndex == 0) {
            return null;
        }
        String head = headIndex > 0 ? resource.substring(0, headIndex) : "";
        String string = trail = trailIndex > 0 ? resource.substring(trailIndex) : "";
        String string2 = trailIndex > 0 ? resource.substring(0, trailIndex) : (headIndex > 0 ? resource.substring(headIndex) : (resource = trailIndex > 0 ? resource.substring(headIndex, trailIndex) : resource));
        if (resource.charAt(0) == '-') {
            resource = resource.substring(1);
        }
        int n = radixCount = (radixIndex = resource.indexOf(".")) > 0 ? resource.length() - 1 - radixIndex : 0;
        if (radixCount > 0) {
            for (i = radixIndex + Math.min(2, radixCount); i > radixIndex && resource.charAt(i) == '0'; --i) {
            }
            resource = resource.substring(0, i == radixIndex ? i : i + 1);
        }
        String[] strs = new String[]{head, trail, resource};
        return strs;
    }

    public void beforeFirst(String ds) {
        this._executeHelper.getDataHelper().beforeFirst(ds);
    }

    public String desensitize(Object src, int pre, int last, char placeHolder) {
        if (src instanceof String) {
            StringBuilder sb = new StringBuilder();
            String source = (String)src;
            if (source.length() < pre + last) {
                return source;
            }
            for (int i = 0; i < source.length(); ++i) {
                if (i < pre || i > source.length() - last - 1) {
                    sb.append(source.charAt(i));
                    continue;
                }
                sb.append(placeHolder);
            }
            return sb.toString();
        }
        return "";
    }
}

