/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.affair.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.hraux.DiplomaInfo;
import com.kingdee.eas.basedata.org.PositionMemberCollection;
import com.kingdee.eas.basedata.org.PositionMemberFactory;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.affair.AffairUtilFacadeFactory;
import com.kingdee.eas.hr.affair.FireBillEntryInfo;
import com.kingdee.eas.hr.affair.FireBillInfo;
import com.kingdee.eas.hr.affair.FluctuationBillEntryInfo;
import com.kingdee.eas.hr.affair.FluctuationBillInfo;
import com.kingdee.eas.hr.affair.HRAffairException;
import com.kingdee.eas.hr.affair.HireBillEntryInfo;
import com.kingdee.eas.hr.affair.HireBillInfo;
import com.kingdee.eas.hr.affair.IAffairUtilFacade;
import com.kingdee.eas.hr.affair.ResignBillEntryInfo;
import com.kingdee.eas.hr.affair.ResignBillInfo;
import com.kingdee.eas.hr.affair.RetireBillEntryInfo;
import com.kingdee.eas.hr.affair.RetireBillInfo;
import com.kingdee.eas.hr.affair.app.AbstractHRAffairPersonPreProcessFacadeControllerBean;
import com.kingdee.eas.hr.base.EmployeeTypeInfo;
import com.kingdee.eas.hr.base.batch.BatchProcessedResult;
import com.kingdee.eas.hr.base.util.HRResourceUtils;
import com.kingdee.eas.hr.emp.IPersonDegree;
import com.kingdee.eas.hr.emp.IPersonPosition;
import com.kingdee.eas.hr.emp.PersonDegreeCollection;
import com.kingdee.eas.hr.emp.PersonDegreeFactory;
import com.kingdee.eas.hr.emp.PersonPositionCollection;
import com.kingdee.eas.hr.emp.PersonPositionFactory;
import com.kingdee.eas.hr.emp.PersonPositionInfo;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class HRAffairPersonPreProcessFacadeControllerBean
extends AbstractHRAffairPersonPreProcessFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.affair.app.HRAffairPersonPreProcessFacadeControllerBean");
    private String resClass = "com.kingdee.eas.hr.affair.HRAffairResource.";

    @Override
    protected BatchProcessedResult _preProcessFlucPerson(Context ctx, List persons, String billID) throws BOSException, EASBizException {
        if (persons == null || persons.size() <= 0) {
            return null;
        }
        BatchProcessedResult result = new BatchProcessedResult();
        PersonInfo personInfo = null;
        FluctuationBillInfo flucBillInfo = new FluctuationBillInfo();
        FluctuationBillEntryInfo entryInfo = new FluctuationBillEntryInfo();
        IAffairUtilFacade affairUtilFacade = AffairUtilFacadeFactory.getLocalInstance(ctx);
        String billNumber = null;
        HashMap map = null;
        int size = persons.size();
        for (int i = 0; i < size; ++i) {
            PositionMemberCollection postRelCols;
            EmployeeTypeInfo empType;
            PersonPositionInfo ppInfo;
            DiplomaInfo diplomaInfo;
            personInfo = (PersonInfo)persons.get(i);
            if (this.checkNoPositionPerson(ctx, personInfo, result)) continue;
            if (affairUtilFacade.isPersonInProcess(flucBillInfo.getBOSType(), entryInfo.getBOSType(), personInfo, billID)) {
                billNumber = affairUtilFacade.getNumberInProcessOfPerson(flucBillInfo.getBOSType(), entryInfo.getBOSType(), personInfo, billID);
                if (billNumber == null) continue;
                result.catchException((Throwable)((Object)new HRAffairException(HRAffairException.PERSON_IN_NUMBER_PROCESS, new Object[]{personInfo.getName(), billNumber})));
                continue;
            }
            map = AffairUtilFacadeFactory.getLocalInstance(ctx).checkIsPersonInOtherBill(flucBillInfo.getBOSType(), entryInfo.getBOSType(), personInfo, billID);
            if (map != null && map.size() != 0) {
                for (Map.Entry entry : map.entrySet()) {
                    String billName = entry.getKey().toString();
                    String billNum = entry.getValue().toString();
                    result.catchException((Throwable)((Object)new HRAffairException(HRAffairException.PERSON_IN_OTHERBILL, new Object[]{personInfo.getName(), billNum, billName})));
                }
                continue;
            }
            String personID = personInfo.getId().toString();
            ArrayList degreeRelInfo = this.getDegreeRelInfo(ctx, personID);
            if (degreeRelInfo != null) {
                personInfo.put("degreeRelInfo", (Object)degreeRelInfo);
            }
            if ((diplomaInfo = this.getDiplomaInfo(ctx, personID)) != null) {
                personInfo.put("diplomaInfo", (Object)diplomaInfo);
            }
            if ((ppInfo = this.getPersonPositionInfo(ctx, personID)) != null) {
                personInfo.put("personPosition", (Object)ppInfo);
            }
            if ((empType = personInfo.getEmployeeType()) != null && empType.getInService().getValue() == 1 && (postRelCols = this.getPersonMemberCollections(ctx, personID)) != null) {
                personInfo.put("positionMember", (Object)postRelCols);
            }
            result.add((Object)personInfo);
        }
        return result;
    }

    @Override
    protected BatchProcessedResult _preProcessHirePerson(Context ctx, List persons, String billID) throws BOSException, EASBizException {
        if (persons == null || persons.size() <= 0) {
            return null;
        }
        BatchProcessedResult result = new BatchProcessedResult();
        PersonInfo personInfo = null;
        HireBillInfo hireBillInfo = new HireBillInfo();
        HireBillEntryInfo entryInfo = new HireBillEntryInfo();
        IAffairUtilFacade affairUtilFacade = AffairUtilFacadeFactory.getLocalInstance(ctx);
        String billNumber = null;
        HashMap map = null;
        int size = persons.size();
        for (int i = 0; i < size; ++i) {
            PersonPositionInfo ppInfo;
            ArrayList degreeRelInfo;
            ArrayList postAndOrg;
            personInfo = (PersonInfo)persons.get(i);
            if (this.isFormEmp(ctx, personInfo.getId().toString())) {
                result.catchException((Throwable)((Object)new HRAffairException(HRAffairException.HIRE_EMPLOYEETYPE_NOT_FORMAL)));
                continue;
            }
            if (affairUtilFacade.isPersonInProcess(hireBillInfo.getBOSType(), entryInfo.getBOSType(), personInfo, billID)) {
                billNumber = affairUtilFacade.getNumberInProcessOfPerson(hireBillInfo.getBOSType(), entryInfo.getBOSType(), personInfo, billID);
                if (billNumber == null) continue;
                result.catchException((Throwable)((Object)new HRAffairException(HRAffairException.PERSON_IN_NUMBER_PROCESS, new Object[]{personInfo.getName(), billNumber})));
                continue;
            }
            map = AffairUtilFacadeFactory.getLocalInstance(ctx).checkIsPersonInOtherBill(hireBillInfo.getBOSType(), entryInfo.getBOSType(), personInfo, billID);
            if (map != null && map.size() != 0) {
                for (Map.Entry entry : map.entrySet()) {
                    String billName = entry.getKey().toString();
                    String billNum = entry.getValue().toString();
                    result.catchException((Throwable)((Object)new HRAffairException(HRAffairException.PERSON_IN_OTHERBILL, new Object[]{personInfo.getName(), billNum, billName})));
                }
                continue;
            }
            String personID = personInfo.getId().toString();
            ArrayList personDatas = this.getPersonDatas(ctx, personID);
            if (personDatas != null) {
                personInfo.put("personDatas", (Object)personDatas);
            }
            if ((postAndOrg = this.getPersonPostAndOrgName(ctx, personID)) != null) {
                personInfo.put("postAndOrg", (Object)postAndOrg);
            }
            ArrayList postOrg = this.getPersonPostAndOrg(ctx, personID);
            if (personDatas != null) {
                personInfo.put("postOrg", (Object)postOrg);
            }
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("id"));
            selector.add(new SelectorItemInfo("gender"));
            selector.add(new SelectorItemInfo("number"));
            selector.add(new SelectorItemInfo("birthday"));
            selector.add(new SelectorItemInfo("officePhone"));
            selector.add(new SelectorItemInfo("highestTechPost.id"));
            selector.add(new SelectorItemInfo("highestTechPost.number"));
            selector.add(new SelectorItemInfo("highestTechPost.name"));
            selector.add(new SelectorItemInfo("highestDegree.id"));
            selector.add(new SelectorItemInfo("highestDegree.name"));
            selector.add(new SelectorItemInfo("highestDegree.number"));
            PersonInfo person = PersonFactory.getLocalInstance((Context)ctx).getPersonInfo((IObjectPK)new ObjectUuidPK(personInfo.getId()), selector);
            if (person != null) {
                if (person.getGender() != null) {
                    personInfo.setGender(person.getGender());
                }
                personInfo.setNumber(person.getNumber());
                personInfo.setBirthday(person.getBirthday());
                personInfo.setOfficePhone(person.getOfficePhone());
                personInfo.setHighestDegree(person.getHighestDegree());
                personInfo.setHighestTechPost(person.getHighestTechPost());
            }
            if ((degreeRelInfo = this.getDegreeRelInfo(ctx, personID)) != null) {
                personInfo.put("degreeRelInfo", (Object)degreeRelInfo);
            }
            if ((ppInfo = this.getPersonPositionInfo(ctx, personID)) != null) {
                personInfo.put("personPosition", (Object)ppInfo);
            }
            result.add((Object)personInfo);
        }
        return result;
    }

    private boolean checkNoPositionPerson(Context ctx, PersonInfo personInfo, BatchProcessedResult result) throws BOSException, EASBizException {
        if (personInfo == null) {
            return true;
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("birthday"));
        selector.add(new SelectorItemInfo("employeeType.id"));
        selector.add(new SelectorItemInfo("employeeType.name"));
        selector.add(new SelectorItemInfo("employeeType.number"));
        selector.add(new SelectorItemInfo("employeeType.inService"));
        PersonInfo person = PersonFactory.getLocalInstance((Context)ctx).getPersonInfo((IObjectPK)new ObjectUuidPK(personInfo.getId()), selector);
        if (person != null) {
            EmployeeTypeInfo empType = person.getEmployeeType();
            if (empType.getInService().getValue() != 1 && empType.getInService().getValue() != 3 && empType.getInService().getValue() != 4) {
                result.addinvalidInfo(HRResourceUtils.getMessage((String)"com.kingdee.eas.hr.affair.HRAffairResource", (String)"PersonNoRetireWorkResion", (String[])new String[]{person.getName()}));
                return true;
            }
            personInfo.setEmployeeType(empType);
            personInfo.setBirthday(person.getBirthday());
        }
        return false;
    }

    private ArrayList getDegreeRelInfo(Context ctx, String personId) throws BOSException, EASBizException {
        String oql = "select degree.name, diploma.name, graduateSchool, specialty where isHighest = 1 and person.id = '" + personId + "'";
        PersonDegreeCollection c = PersonDegreeFactory.getLocalInstance((Context)ctx).getPersonDegreeCollection(oql);
        ArrayList<String> value = null;
        if (c.size() > 0) {
            value = new ArrayList<String>();
            if (c.get(0).getDegree() != null) {
                value.add(c.get(0).getDegree().getName());
            } else {
                value.add(null);
            }
            value.add(c.get(0).getGraduateSchool());
            value.add(c.get(0).getSpecialty());
            if (c.get(0).getDiploma() != null) {
                value.add(c.get(0).getDiploma().getName());
            } else {
                value.add(null);
            }
        }
        return value;
    }

    private DiplomaInfo getDiplomaInfo(Context ctx, String personId) throws BOSException, EASBizException {
        DiplomaInfo dip = null;
        IPersonDegree ipd = PersonDegreeFactory.getLocalInstance((Context)ctx);
        PersonDegreeCollection pdc = ipd.getPersonDegreeCollection("select diploma.id,diploma.name,diploma,number where person.id = '" + personId + "' and isHighest = '1'");
        if (pdc.size() > 0) {
            dip = pdc.get(0).getDiploma();
        }
        return dip;
    }

    private PersonPositionInfo getPersonPositionInfo(Context ctx, String personId) throws BOSException, EASBizException {
        String oql = "select id,personDep.id,personDep.name,personDep.number,personDep.displayName,primaryPosition.id,primaryPosition.name,primaryPosition.job.id,primaryPosition.job.name,jobStartDate, lenOfActualService, enterDate, joinDate, joinGroupDate, jobLevel.id, jobLevel.number, jobLevel.name, jobGrade.id, jobGrade.name, jobGrade.number where person.id = '" + personId + "'";
        PersonPositionCollection c = PersonPositionFactory.getLocalInstance((Context)ctx).getPersonPositionCollection(oql);
        if (c.size() > 0) {
            return c.get(0);
        }
        return null;
    }

    private PositionMemberCollection getPersonMemberCollections(Context ctx, String personId) throws BOSException, EASBizException {
        String oql = "select beginDate, endDate, position.id, position.name, position.number, position.job.id, position.job.name, position.job.number, id, position.adminOrgUnit.id, position.adminOrgUnit.name, position.adminOrgUnit.displayName,personRZType.id,personRZType.nuber,personRZType.name,isPrimary where person.id = '" + personId + "' ";
        PositionMemberCollection c = PositionMemberFactory.getLocalInstance((Context)ctx).getPositionMemberCollection(oql);
        if (c.size() > 0) {
            return c;
        }
        return null;
    }

    private ArrayList getPersonDatas(Context ctx, String personId) throws BOSException, EASBizException {
        String oql = "select jobStartDate, lenOfActualService, person.number, person.birthday, person.officePhone, enterDate, tryoutMonth where person.id = '" + personId + "'";
        IPersonPosition ipp = PersonPositionFactory.getLocalInstance((Context)ctx);
        PersonPositionCollection c = ipp.getPersonPositionCollection(oql);
        if (c.size() == 0) {
            return null;
        }
        PersonPositionInfo info = c.get(0);
        ArrayList<Comparable<Date>> value = new ArrayList<Comparable<Date>>();
        value.add(info.getEnterDate());
        value.add(Integer.valueOf(info.getTryoutMonth()));
        value.add(info.getJobStartDate());
        value.add(info.getLenOfActualService());
        return value;
    }

    private ArrayList getPersonPostAndOrgName(Context ctx, String personId) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)personId));
        filter.getFilterItems().add(new FilterItemInfo("isPrimary", (Object)1));
        filter.setMaskString("#0 and #1");
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSelector().add(new SelectorItemInfo("position.id"));
        evi.getSelector().add(new SelectorItemInfo("position.name"));
        evi.getSelector().add(new SelectorItemInfo("position.job.id"));
        evi.getSelector().add(new SelectorItemInfo("id"));
        evi.getSelector().add(new SelectorItemInfo("position.adminOrgUnit.name"));
        evi.getSelector().add(new SelectorItemInfo("position.adminOrgUnit.displayName"));
        PositionMemberCollection c = PositionMemberFactory.getLocalInstance((Context)ctx).getPositionMemberCollection(evi);
        ArrayList<String> value = null;
        if (c.size() > 0) {
            value = new ArrayList<String>();
            value.add(c.get(0).getPosition().getName());
            value.add(c.get(0).getPosition().getAdminOrgUnit().getName());
            value.add((String)c.get(0).getId());
            if (c.get(0).getPosition().getJob() != null) {
                value.add((String)c.get(0).getPosition().getJob().getId());
            }
            value.add((String)c.get(0).getPosition().getId());
            value.add(c.get(0).getPosition().getAdminOrgUnit().getDisplayName());
        }
        return value;
    }

    private ArrayList getPersonPostAndOrg(Context ctx, String personId) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)personId));
        filter.getFilterItems().add(new FilterItemInfo("isPrimary", (Object)1));
        filter.setMaskString("#0 and #1");
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSelector().add(new SelectorItemInfo("position.id"));
        evi.getSelector().add(new SelectorItemInfo("position.name"));
        evi.getSelector().add(new SelectorItemInfo("position.job.id"));
        evi.getSelector().add(new SelectorItemInfo("id"));
        evi.getSelector().add(new SelectorItemInfo("position.adminOrgUnit.name"));
        PositionMemberCollection c = PositionMemberFactory.getLocalInstance((Context)ctx).getPositionMemberCollection(evi);
        ArrayList<Object> value = null;
        if (c.size() > 0) {
            value = new ArrayList<Object>();
            value.add(c.get(0).getPosition());
            value.add(c.get(0).getPosition().getAdminOrgUnit().getName());
            value.add(c.get(0).getId());
            if (c.get(0).getPosition().getJob() != null) {
                value.add(c.get(0).getPosition().getJob().getId());
            }
            value.add(c.get(0).getPosition().getId());
        }
        return value;
    }

    private boolean isFormEmp(Context ctx, String personId) throws BOSException, EASBizException {
        PersonCollection c = PersonFactory.getLocalInstance((Context)ctx).getPersonCollection("select employeeType.id where id = '" + personId + "'");
        return c.size() > 0 && c.get(0).getEmployeeType().getId().toString().equals("00000000-0000-0000-0000-000000000001A29E85B3");
    }

    @Override
    protected BatchProcessedResult _preProcessFirePerson(Context ctx, List persons, String billID) throws BOSException, EASBizException {
        if (persons == null || persons.size() <= 0) {
            return null;
        }
        BatchProcessedResult result = new BatchProcessedResult();
        PersonInfo personInfo = null;
        FireBillInfo fireBillInfo = new FireBillInfo();
        FireBillEntryInfo entryInfo = new FireBillEntryInfo();
        IAffairUtilFacade affairUtilFacade = AffairUtilFacadeFactory.getLocalInstance(ctx);
        String billNumber = null;
        HashMap map = null;
        int size = persons.size();
        for (int i = 0; i < size; ++i) {
            personInfo = (PersonInfo)persons.get(i);
            if (affairUtilFacade.isPersonInProcess(fireBillInfo.getBOSType(), entryInfo.getBOSType(), personInfo, billID)) {
                billNumber = affairUtilFacade.getNumberInProcessOfPerson(fireBillInfo.getBOSType(), entryInfo.getBOSType(), personInfo, billID);
                if (billNumber == null) continue;
                result.catchException((Throwable)((Object)new HRAffairException(HRAffairException.PERSON_IN_NUMBER_PROCESS, new Object[]{personInfo.getName(), billNumber})));
                continue;
            }
            map = AffairUtilFacadeFactory.getLocalInstance(ctx).checkIsPersonInOtherBill(fireBillInfo.getBOSType(), entryInfo.getBOSType(), personInfo, billID);
            if (map != null && map.size() != 0) {
                for (Map.Entry entry : map.entrySet()) {
                    String billName = entry.getKey().toString();
                    String billNum = entry.getValue().toString();
                    result.catchException((Throwable)((Object)new HRAffairException(HRAffairException.PERSON_IN_OTHERBILL, new Object[]{personInfo.getName(), billNum, billName})));
                }
                continue;
            }
            result.add((Object)personInfo);
        }
        return result;
    }

    @Override
    protected BatchProcessedResult _preProcessResignPerson(Context ctx, List persons, String billID) throws BOSException, EASBizException {
        if (persons == null || persons.size() <= 0) {
            return null;
        }
        BatchProcessedResult result = new BatchProcessedResult();
        PersonInfo personInfo = null;
        ResignBillInfo resignBillInfo = new ResignBillInfo();
        ResignBillEntryInfo entryInfo = new ResignBillEntryInfo();
        IAffairUtilFacade affairUtilFacade = AffairUtilFacadeFactory.getLocalInstance(ctx);
        String billNumber = null;
        HashMap map = null;
        int size = persons.size();
        for (int i = 0; i < size; ++i) {
            personInfo = (PersonInfo)persons.get(i);
            if (affairUtilFacade.isPersonInProcess(resignBillInfo.getBOSType(), entryInfo.getBOSType(), personInfo, billID)) {
                billNumber = affairUtilFacade.getNumberInProcessOfPerson(resignBillInfo.getBOSType(), entryInfo.getBOSType(), personInfo, billID);
                if (billNumber == null) continue;
                result.catchException((Throwable)((Object)new HRAffairException(HRAffairException.PERSON_IN_NUMBER_PROCESS, new Object[]{personInfo.getName(), billNumber})));
                continue;
            }
            map = AffairUtilFacadeFactory.getLocalInstance(ctx).checkIsPersonInOtherBill(resignBillInfo.getBOSType(), entryInfo.getBOSType(), personInfo, billID);
            if (map != null && map.size() != 0) {
                for (Map.Entry entry : map.entrySet()) {
                    String billName = entry.getKey().toString();
                    String billNum = entry.getValue().toString();
                    result.catchException((Throwable)((Object)new HRAffairException(HRAffairException.PERSON_IN_OTHERBILL, new Object[]{personInfo.getName(), billNum, billName})));
                }
                continue;
            }
            result.add((Object)personInfo);
        }
        return result;
    }

    @Override
    protected BatchProcessedResult _preProcessRetirePerson(Context ctx, List persons, String billID) throws BOSException, EASBizException {
        if (persons == null || persons.size() <= 0) {
            return null;
        }
        BatchProcessedResult result = new BatchProcessedResult();
        PersonInfo personInfo = null;
        RetireBillInfo retireBillInfo = new RetireBillInfo();
        RetireBillEntryInfo entryInfo = new RetireBillEntryInfo();
        IAffairUtilFacade affairUtilFacade = AffairUtilFacadeFactory.getLocalInstance(ctx);
        String billNumber = null;
        HashMap map = null;
        int size = persons.size();
        for (int i = 0; i < size; ++i) {
            personInfo = (PersonInfo)persons.get(i);
            if (affairUtilFacade.isPersonInProcess(retireBillInfo.getBOSType(), entryInfo.getBOSType(), personInfo, billID)) {
                billNumber = affairUtilFacade.getNumberInProcessOfPerson(retireBillInfo.getBOSType(), entryInfo.getBOSType(), personInfo, billID);
                if (billNumber == null) continue;
                result.catchException((Throwable)((Object)new HRAffairException(HRAffairException.PERSON_IN_NUMBER_PROCESS, new Object[]{personInfo.getName(), billNumber})));
                continue;
            }
            map = AffairUtilFacadeFactory.getLocalInstance(ctx).checkIsPersonInOtherBill(retireBillInfo.getBOSType(), entryInfo.getBOSType(), personInfo, billID);
            if (map != null && map.size() != 0) {
                for (Map.Entry entry : map.entrySet()) {
                    String billName = entry.getKey().toString();
                    String billNum = entry.getValue().toString();
                    result.catchException((Throwable)((Object)new HRAffairException(HRAffairException.PERSON_IN_OTHERBILL, new Object[]{personInfo.getName(), billNum, billName})));
                }
                continue;
            }
            result.add((Object)personInfo);
        }
        return result;
    }
}

