/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.affair.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionFactory;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.affair.HRAffairBizBillEntryInfo;
import com.kingdee.eas.hr.affair.HRAffairBizBillInfo;
import com.kingdee.eas.hr.affair.PluralityDelBizBillEntryCollection;
import com.kingdee.eas.hr.affair.PluralityDelBizBillEntryFactory;
import com.kingdee.eas.hr.affair.PluralityDelBizBillEntryInfo;
import com.kingdee.eas.hr.affair.PluralityDelBizBillFactory;
import com.kingdee.eas.hr.affair.PluralityDelBizBillInfo;
import com.kingdee.eas.hr.affair.app.AbstractPluralityDelBizBillControllerBean;
import com.kingdee.eas.hr.affair.app.HrAffairFillEmptyBizDefineUtil;
import com.kingdee.eas.hr.affair.app.PluralityDelBizBillBizBean;
import com.kingdee.eas.hr.affair.util.AffairUtil;
import com.kingdee.eas.hr.base.EmpAffairBizBillException;
import com.kingdee.eas.hr.base.EmpPosOrgRelationCollection;
import com.kingdee.eas.hr.base.EmpPosOrgRelationFactory;
import com.kingdee.eas.hr.base.EmpPostExperienceHisInfo;
import com.kingdee.eas.hr.base.HRBillBaseEntryInfo;
import com.kingdee.eas.hr.base.IHRBillBaseEntry;
import com.kingdee.eas.hr.base.app.EmpPosOrgRelationQueryHelper;
import com.kingdee.eas.hr.base.app.EmpPostExperienceHisHelper;
import com.kingdee.eas.hr.base.app.HRBillAppUtils;
import com.kingdee.eas.hr.base.app.IHRBillBizBean;
import com.kingdee.eas.hr.base.app.his.HistoryVersionUtil;
import com.kingdee.eas.hr.emp.app.util.SHREmpOptOrgnizationTool;
import com.kingdee.eas.hr.emp.app.util.SHREmpOptPersonTool;
import java.util.Date;

public class PluralityDelBizBillControllerBean
extends AbstractPluralityDelBizBillControllerBean {
    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        PluralityDelBizBillInfo billInfo = (PluralityDelBizBillInfo)model;
        this.checkPositionBeforeSubmit(ctx, billInfo);
        HrAffairFillEmptyBizDefineUtil.fillPluralityDelBizBillEntry(ctx, billInfo.getEntrys());
        return super._addnew(ctx, model);
    }

    @Override
    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        PluralityDelBizBillInfo billInfo = (PluralityDelBizBillInfo)model;
        HrAffairFillEmptyBizDefineUtil.fillPluralityDelBizBillEntry(ctx, billInfo.getEntrys());
        return super._submit(ctx, model);
    }

    @Override
    protected String getBillField() {
        return "bill";
    }

    @Override
    protected String getEntryField() {
        return "entrys";
    }

    @Override
    protected String getEntryEffectDateField() {
        return "bizDate";
    }

    protected String getEffectFunction() {
        return "com.kingdee.eas.hr.affair.app.PluralityDelBizBillEffectFunction";
    }

    @Override
    protected IHRBillBaseEntry getEntryInterface(Context ctx) throws BOSException, EASBizException {
        return PluralityDelBizBillEntryFactory.getLocalInstance(ctx);
    }

    @Override
    protected IHRBillBizBean getBizBean() {
        return new PluralityDelBizBillBizBean();
    }

    @Override
    protected void _entryEffect(Context ctx, HRBillBaseEntryInfo entry) throws BOSException, EASBizException {
        super._entryEffect(ctx, entry);
    }

    @Override
    protected void _doWithPriorityThingEffect(Context ctx, HRAffairBizBillEntryInfo entry) throws BOSException, EASBizException {
        super._doWithPriorityThingEffect(ctx, entry);
        AffairUtil.updateAffairEntryJobGradeInfo(ctx, PluralityDelBizBillEntryFactory.getLocalInstance(ctx), entry);
    }

    @Override
    protected void _doWithSpecialFiledsEffect(Context ctx, HRAffairBizBillEntryInfo entry) throws BOSException, EASBizException {
        super._doWithSpecialFiledsEffect(ctx, entry);
        PluralityDelBizBillEntryInfo affairEntry = (PluralityDelBizBillEntryInfo)entry;
        HRBillAppUtils.updateAffairBizHistory((Context)ctx, (String)affairEntry.getOldEmpType().getId().toString(), (String)affairEntry.getId().toString());
    }

    protected String getPermItemNameDelete() {
        return "plurDel_Delete";
    }

    protected String getPermItemNameAddnew() {
        return "plurDel_AddNew";
    }

    protected String getPermItemNameEdit() {
        return "plurDel_Update";
    }

    protected String getEntryIdStr(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        PluralityDelBizBillInfo BillInfo = PluralityDelBizBillFactory.getLocalInstance(ctx).getPluralityDelBizBillInfo(pk);
        PluralityDelBizBillEntryCollection billEntryCol = BillInfo.getEntrys();
        StringBuffer billEntryIdStr = new StringBuffer();
        int size = billEntryCol.size();
        for (int i = 0; i < size; ++i) {
            billEntryIdStr.append("'");
            billEntryIdStr.append(billEntryCol.get(i).getId().toString());
            if (i == size - 1) {
                billEntryIdStr.append("'");
                continue;
            }
            billEntryIdStr.append("',");
        }
        return billEntryIdStr.toString();
    }

    @Override
    protected HRAffairBizBillEntryInfo storefieldsForEntry(Context ctx, HRAffairBizBillInfo billInfo, HRAffairBizBillEntryInfo info) throws EASBizException, BOSException {
        PluralityDelBizBillEntryInfo entryInfo = (PluralityDelBizBillEntryInfo)info;
        entryInfo.put("bill", billInfo);
        PersonInfo personInfo = SHREmpOptPersonTool.getPersonDetailInfo((Context)ctx, (String)entryInfo.getPerson().getId().toString());
        entryInfo.setPerson(personInfo);
        EmpPostExperienceHisInfo pointEmpPostExpHis = EmpPostExperienceHisHelper.getPointDateEmpPostExpHis((Context)ctx, (String)entryInfo.getPerson().getId().toString(), (Date)entryInfo.getBizDate());
        if (null == entryInfo.getMainPosition()) {
            entryInfo.setMainPosition(pointEmpPostExpHis.getPosition());
        }
        if (null == entryInfo.getMainAdminOrg()) {
            entryInfo.setMainAdminOrg(pointEmpPostExpHis.getAdminOrg());
        }
        if (null == entryInfo.getMainCompany()) {
            entryInfo.setMainCompany(pointEmpPostExpHis.getCompany());
        }
        if (null == entryInfo.getOldAdminOrg()) {
            AdminOrgUnitInfo adminOrgUnitInfo = SHREmpOptOrgnizationTool.getAdminOrgUnitByPosition((Context)ctx, (String)entryInfo.getOldPosition().getId().toString());
            entryInfo.setOldAdminOrg(adminOrgUnitInfo);
        }
        if (null == entryInfo.getEmpType()) {
            entryInfo.setEmpType(personInfo.getEmployeeType());
        }
        if (null == entryInfo.getOldEmpType()) {
            entryInfo.setOldEmpType(personInfo.getEmployeeType());
        }
        if (billInfo.getAdminOrg() == null) {
            billInfo.setAdminOrg(entryInfo.getAdminOrg());
        }
        return entryInfo;
    }

    protected void checkPositionBeforeSubmit(Context ctx, PluralityDelBizBillInfo billInfo) throws EASBizException, BOSException {
        PluralityDelBizBillEntryInfo entryInfo = null;
        PersonInfo person = null;
        PositionInfo position = null;
        PluralityDelBizBillEntryCollection entryColl = billInfo.getEntrys();
        int size = entryColl.size();
        for (int i = 0; i < size; ++i) {
            entryInfo = entryColl.get(i);
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)entryInfo.getPerson().getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("position.id", (Object)entryInfo.getOldPosition().getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("adminOrg.id", (Object)entryInfo.getOldAdminOrg().getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("isinner", (Object)true));
            filter.getFilterItems().add(new FilterItemInfo("positionstatus", (Object)new Integer(0), CompareType.GREATER));
            filter.getFilterItems().add(new FilterItemInfo("assigntype", (Object)new Integer(0)));
            FilterInfo filterDateTime = HistoryVersionUtil.getPointDateTimeFilterInfo((Date)entryInfo.getBizDate());
            filter.mergeFilter(filterDateTime, "and");
            view.setFilter(filter);
            EmpPosOrgRelationQueryHelper queryHelper = new EmpPosOrgRelationQueryHelper();
            view.setSelector(queryHelper.getSelector());
            EmpPosOrgRelationCollection empposorgRelationColl = EmpPosOrgRelationFactory.getLocalInstance((Context)ctx).getEmpPosOrgRelationCollection(view);
            if (empposorgRelationColl.size() >= 1) continue;
            person = PersonFactory.getLocalInstance((Context)ctx).getPersonInfo((IObjectPK)new ObjectUuidPK(entryInfo.getPerson().getId().toString()));
            position = PositionFactory.getLocalInstance((Context)ctx).getPositionInfo((IObjectPK)new ObjectUuidPK(entryInfo.getOldPosition().getId().toString()));
            throw new EmpAffairBizBillException(EmpAffairBizBillException.PLURALITYDEL_EFFECT_EXCEPTION, new Object[]{person.getName(), position.getName()});
        }
    }

    @Override
    protected void checkBeforeSubmit(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        PluralityDelBizBillInfo billInfo = (PluralityDelBizBillInfo)model;
        this.checkPositionBeforeSubmit(ctx, billInfo);
        super.checkBeforeSubmit(ctx, model);
    }
}

