/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.affair.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.AdminOrgFacadeFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.IPositionMember;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.org.PositionMemberCollection;
import com.kingdee.eas.basedata.org.PositionMemberFactory;
import com.kingdee.eas.basedata.org.PositionMemberInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.affair.PositionChangeParam;
import com.kingdee.eas.hr.affair.app.IPositionChange;
import com.kingdee.eas.hr.base.EmpInfoMultiPageInfo;
import com.kingdee.eas.hr.base.app.HRBillAppUtils;
import com.kingdee.eas.hr.emp.IPersonWorkExpCur;
import com.kingdee.eas.hr.emp.PersonWorkExpCurFactory;
import com.kingdee.eas.hr.emp.PersonWorkExpCurInfo;
import com.kingdee.eas.hr.org.JobGradeInfo;
import com.kingdee.eas.hr.org.JobLevelInfo;
import com.kingdee.eas.util.app.DbUtil;
import java.util.Date;

public class PositionChange
implements IPositionChange {
    @Override
    public void change(Context ctx, PositionChangeParam p) throws BOSException, EASBizException {
        if (p == null || p.getPerson() == null) {
            return;
        }
        p.preProcess();
        this.handleJobGradeAndJobLevel(ctx, p);
        this.handleWorkExp(ctx, p);
        if (p.getOldPosition() == null) {
            if (p.getNewPosition() == null) {
                if (p.getNewAdmin() != null) {
                    this.handleNoPosition(ctx, p);
                }
            } else {
                this.handleAddPosition(ctx, p);
            }
        } else if (p.getNewPosition() == null) {
            if (p.getNewAdmin() != null) {
                this.handleNoPosition(ctx, p);
            } else {
                this.handleDelPosition(ctx, p);
            }
        } else if (!p.getOldPosition().getId().equals((Object)p.getNewPosition().getId())) {
            this.handleReplacePosition(ctx, p);
        }
    }

    private void handleAddPosition(Context ctx, PositionChangeParam p) throws BOSException, EASBizException {
        PositionMemberInfo pmInfo = this.getPMInfo(ctx, p);
        if (pmInfo != null) {
            PositionMemberFactory.getLocalInstance((Context)ctx).addnew((CoreBaseInfo)pmInfo, true);
        }
    }

    private void handleDelPosition(Context ctx, PositionChangeParam p) throws BOSException, EASBizException {
        String personID = p.getPerson().getId().toString();
        String positionID = p.getOldPosition().getId().toString();
        PositionMemberFactory.getLocalInstance((Context)ctx).delete("where isPrimary = 0 AND person.id = '" + personID + "' AND position.id = '" + positionID + "'");
    }

    private void handleReplacePosition(Context ctx, PositionChangeParam p) throws BOSException, EASBizException {
        PositionMemberInfo pmInfo = HRBillAppUtils.getPMInfoByPersonAndPosition((Context)ctx, (BOSUuid)p.getPerson().getId(), (BOSUuid)p.getOldPosition().getId());
        if (pmInfo != null) {
            p.setPrimaryChange(pmInfo.isIsPrimary());
            pmInfo = this.getPMInfo(pmInfo, p);
            if (pmInfo != null) {
                PositionMemberFactory.getLocalInstance((Context)ctx).update((IObjectPK)new ObjectUuidPK(pmInfo.getId()), (CoreBaseInfo)pmInfo, true);
            }
        }
    }

    private void handleNoPosition(Context ctx, PositionChangeParam p) throws BOSException, EASBizException {
        String personID = p.getPerson().getId().toString();
        if (p.getOldPosition() != null) {
            PositionMemberFactory.getLocalInstance((Context)ctx).delete("where person.id = '" + personID + "'");
        }
        String newAdminID = p.getNewAdmin().getId().toString();
        DbUtil.execute((Context)ctx, (String)("update T_HR_PersonPosition set FPrimaryPositionID = null,FPersonDep = ?,FgkAdminID = ? where FPersonID = '" + personID + "'"), (Object[])new Object[]{newAdminID, newAdminID});
    }

    private void handleWorkExp(Context ctx, PositionChangeParam p) throws BOSException, EASBizException {
        if (p == null || p.getPerson() == null || p.getOldPosition() == null) {
            return;
        }
        IPersonWorkExpCur ipwxc = PersonWorkExpCurFactory.getLocalInstance((Context)ctx);
        PersonWorkExpCurInfo pwInfo = null;
        if (p.getNewPosition() == null && p.getNewAdmin() != null) {
            PositionMemberCollection pmCol = HRBillAppUtils.getPMCollectionsByPerson((Context)ctx, (BOSUuid)p.getPerson().getId());
            if (pmCol != null) {
                int size = pmCol.size();
                for (int i = 0; i < size; ++i) {
                    pwInfo = this.getWorkExpInfo(ctx, p, pmCol.get(i));
                    if (pwInfo == null) continue;
                    ipwxc.addnew((EmpInfoMultiPageInfo)pwInfo);
                }
            }
        } else {
            if (p.getOldPosition().getId().equals((Object)p.getNewPosition().getId())) {
                return;
            }
            PositionMemberInfo pmInfo = HRBillAppUtils.getPMInfoByPersonAndPosition((Context)ctx, (BOSUuid)p.getPerson().getId(), (BOSUuid)p.getOldPosition().getId());
            pwInfo = this.getWorkExpInfo(ctx, p, pmInfo);
            if (pwInfo != null) {
                ipwxc.addnew((EmpInfoMultiPageInfo)pwInfo);
            }
        }
    }

    protected PersonWorkExpCurInfo getWorkExpInfo(Context ctx, PositionChangeParam p, PositionMemberInfo pmInfo) throws BOSException, EASBizException {
        if (p == null || pmInfo == null) {
            return null;
        }
        PersonInfo pInfo = p.getPerson();
        PersonWorkExpCurInfo pwInfo = null;
        JobLevelInfo jobLevelInfo = null;
        jobLevelInfo = p.getOldJobLevel();
        pwInfo = new PersonWorkExpCurInfo();
        pwInfo.setPerson(pmInfo.getPerson());
        pwInfo.setEndDate(HRBillAppUtils.getPreviousDay((Date)p.getBizDate()));
        pwInfo.setPosition(pmInfo.getPosition());
        pwInfo.setBeginDate(pmInfo.getBeginDate());
        pwInfo.setJob(pmInfo.getPosition().getJob());
        AdminOrgUnitInfo[] admins = AdminOrgFacadeFactory.getLocalInstance((Context)ctx).getComAndDeptByPositionId(pmInfo.getPosition().getId().toString());
        pwInfo.setDept(admins[0]);
        pwInfo.setJobGrade(p.getOldJobGrade());
        if (jobLevelInfo != null) {
            pwInfo.setJobLevel(jobLevelInfo);
        }
        pwInfo.setDescription(p.getDescription());
        pwInfo.setJobGradeDate(p.getBizDate());
        pwInfo.setIsPrimary(pmInfo.isIsPrimary());
        pwInfo.setPersonRZType(pmInfo.getPersonRZType());
        pwInfo.setPastPositon(pmInfo.getPosition().getName());
        if (admins[0] != null && admins[0].getDisplayName() != null) {
            pwInfo.setPastDept(admins[0].getDisplayName());
        }
        if (pmInfo.getPosition().getJob() != null && pmInfo.getPosition().getJob().getName() != null) {
            pwInfo.setPastJob(pmInfo.getPosition().getJob().getName());
        }
        if (jobLevelInfo != null && jobLevelInfo.getId() != null) {
            pwInfo.setPastJobLevel(jobLevelInfo.getName());
        }
        if (pmInfo.getPersonRZType() != null && pmInfo.getPersonRZType().getName() != null) {
            pwInfo.setPastRZType(pmInfo.getPersonRZType().getName());
        }
        pwInfo.setCheckLen(pmInfo.getCheckLen());
        pwInfo.setCheckOverTime(pmInfo.getCheckOverTime());
        pwInfo.setIsCheck(pmInfo.isIsCheck());
        pwInfo.setBatchNumber(pmInfo.getPersonnelNumber());
        pwInfo.setChekState(pmInfo.getCheckState());
        return pwInfo;
    }

    protected void handleJobGradeAndJobLevel(Context ctx, PositionChangeParam p) throws BOSException, EASBizException {
        if (p == null) {
            return;
        }
        String personID = p.getPerson().getId().toString();
        JobGradeInfo newJobGrade = p.getNewJobGrade();
        JobLevelInfo newJobLevel = p.getNewJobLevel();
        PositionInfo newPosInfo = p.getNewPosition();
        JobGradeInfo oldJobGrade = p.getOldJobGrade();
        JobLevelInfo oldJobLevel = p.getOldJobLevel();
        PositionInfo oldPosition = p.getOldPosition();
        if (newJobGrade != oldJobGrade || newJobLevel != oldJobLevel || newPosInfo != oldPosition) {
            HRBillAppUtils.saveJobGradeHistoryData((Context)ctx, (Date)p.getBizDate(), (PersonInfo)p.getPerson());
        }
        HRBillAppUtils.saveJobGradeEndDate((Context)ctx, (String)personID, (Date)p.getBizDate(), (JobGradeInfo)p.getOldJobGrade(), (JobGradeInfo)newJobGrade);
        HRBillAppUtils.saveJobGradeLevel((Context)ctx, (String)personID, (JobGradeInfo)newJobGrade, (JobLevelInfo)newJobLevel);
    }

    public PositionMemberInfo getPMInfo(Context ctx, PositionChangeParam p) throws BOSException, EASBizException {
        if (p == null || p.getPerson() == null || p.getNewPosition() == null) {
            return null;
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)p.getPerson().getId()));
        filter.getFilterItems().add(new FilterItemInfo("position.id", (Object)p.getNewPosition().getId()));
        filter.setMaskString("#0 and #1");
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        IPositionMember ipm = PositionMemberFactory.getLocalInstance((Context)ctx);
        PositionMemberCollection pmColl = ipm.getPositionMemberCollection(evi);
        PositionMemberInfo pmInfo = null;
        if (pmColl.size() == 0) {
            pmInfo = this.getPMInfo(pmInfo, p);
        } else {
            pmInfo = pmColl.get(0);
            pmInfo = this.getPMInfo(pmInfo, p);
        }
        return pmInfo;
    }

    public PositionMemberInfo getPMInfo(PositionMemberInfo pmInfo, PositionChangeParam p) {
        if (pmInfo == null) {
            pmInfo = new PositionMemberInfo();
        }
        pmInfo.setPerson(p.getPerson());
        pmInfo.setPosition(p.getNewPosition());
        pmInfo.setIsPrimary(p.isPrimaryChange());
        pmInfo.setBeginDate(p.getBizDate());
        pmInfo.setCheckLen(p.getCheckLength());
        pmInfo.setCheckOverTime(p.getCheckOverDate());
        pmInfo.setIsCheck(false);
        return pmInfo;
    }
}

