/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.affair.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.hraux.EnableStateEnum;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.JobInfo;
import com.kingdee.eas.basedata.org.PositionCollection;
import com.kingdee.eas.basedata.org.PositionFactory;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.affair.AffairBizException;
import com.kingdee.eas.hr.affair.HRAffairBizBillEntryInfo;
import com.kingdee.eas.hr.affair.HRAffairBizBillInfo;
import com.kingdee.eas.hr.affair.HRAffairException;
import com.kingdee.eas.hr.affair.IResignBizBillEntry;
import com.kingdee.eas.hr.affair.ResignBizBillEntryCollection;
import com.kingdee.eas.hr.affair.ResignBizBillEntryFactory;
import com.kingdee.eas.hr.affair.ResignBizBillEntryInfo;
import com.kingdee.eas.hr.affair.ResignBizBillFactory;
import com.kingdee.eas.hr.affair.ResignBizBillInfo;
import com.kingdee.eas.hr.affair.app.AbstractResignBizBillControllerBean;
import com.kingdee.eas.hr.affair.app.ResignBizBillBizBean;
import com.kingdee.eas.hr.base.EmpLaborRelationFactory;
import com.kingdee.eas.hr.base.EmpLaborRelationInfo;
import com.kingdee.eas.hr.base.EmployeeTypeFactory;
import com.kingdee.eas.hr.base.EmployeeTypeInfo;
import com.kingdee.eas.hr.base.HRBillBaseEntryInfo;
import com.kingdee.eas.hr.base.HRBillStateEnum;
import com.kingdee.eas.hr.base.IHRBillBaseEntry;
import com.kingdee.eas.hr.base.app.EmpPostExperienceHisHelper;
import com.kingdee.eas.hr.base.app.HRBillAppUtils;
import com.kingdee.eas.hr.base.app.IHRBillBizBean;
import com.kingdee.eas.hr.base.app.util.AffairUnAuditAppUtils;
import com.kingdee.eas.hr.base.app.util.SHRSameDatePersonChangeUtil;
import com.kingdee.eas.hr.base.util.EmpPosOrgRelationUtil;
import com.kingdee.eas.hr.base.util.HRUtil;
import com.kingdee.eas.hr.emp.EmployeeBizException;
import com.kingdee.eas.hr.emp.PersonPositionFactory;
import com.kingdee.eas.hr.emp.PersonPositionInfo;
import com.kingdee.eas.hr.emp.app.util.PersonBlackListUtil;
import com.kingdee.eas.hr.emp.probation.util.ProbationMangerUtil;
import com.kingdee.eas.hr.org.JobGradeInfo;
import com.kingdee.eas.hr.org.JobLevelInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.DateTimeUtils;
import java.sql.Date;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResignBizBillControllerBean
extends AbstractResignBizBillControllerBean {
    private static Logger logger = LoggerFactory.getLogger(ResignBizBillControllerBean.class);

    protected String getEffectFunction() {
        return "com.kingdee.eas.hr.affair.app.ResignBizBillEffectFunction";
    }

    @Override
    protected IHRBillBaseEntry getEntryInterface(Context ctx) throws BOSException, EASBizException {
        return ResignBizBillEntryFactory.getLocalInstance(ctx);
    }

    @Override
    protected IHRBillBizBean getBizBean() {
        return new ResignBizBillBizBean();
    }

    @Override
    protected void _doWithOtherChangeEffect(Context ctx, HRAffairBizBillEntryInfo entry) throws BOSException, EASBizException {
        super._doWithOtherChangeEffect(ctx, entry);
        ResignBizBillEntryInfo affairEntry = (ResignBizBillEntryInfo)entry;
        PersonInfo person = affairEntry.getPerson();
        if (person == null) {
            return;
        }
        HRBillAppUtils.updateAffairBizHistory((Context)ctx, (String)affairEntry.getOldEmpType().getId().toString(), (String)affairEntry.getId().toString());
        ProbationMangerUtil.abortPersonProbationBillAfterResign((Context)ctx, (String)person.getId().toString());
    }

    protected String getEntryIdStr(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        ResignBizBillInfo BillInfo = ResignBizBillFactory.getLocalInstance(ctx).getResignBizBillInfo(pk);
        ResignBizBillEntryCollection billEntryCol = BillInfo.getEntrys();
        StringBuffer billEntryIdStr = new StringBuffer();
        int size = billEntryCol.size();
        for (int i = 0; i < size; ++i) {
            billEntryIdStr.append("'");
            billEntryIdStr.append(billEntryCol.get(i).getId().toString());
            if (i == size - 1) {
                billEntryIdStr.append("'");
                continue;
            }
            billEntryIdStr.append("',");
        }
        return billEntryIdStr.toString();
    }

    @Override
    protected void _setAudited(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        IResignBizBillEntry iEntry = null;
        ResignBizBillEntryCollection entryCol = null;
        int size = 0;
        StringBuffer oql = new StringBuffer("select bizDate,reason,adminOrg,empType,reasonType where bill = '");
        oql.append(billID).append("'");
        try {
            iEntry = ResignBizBillEntryFactory.getLocalInstance(ctx);
            entryCol = iEntry.getResignBizBillEntryCollection(oql.toString());
        }
        catch (BOSException e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        if (entryCol != null) {
            size = entryCol.size();
        }
        if (size <= 0) {
            return;
        }
        for (int i = 0; i < size; ++i) {
            if (entryCol.get(i).getBizDate() != null && entryCol.get(i).getEmpType() != null && entryCol.get(i).getAdminOrg() != null) continue;
            throw new AffairBizException(AffairBizException.POS_ADMIN_BIZDATE_RES_NOTNULL);
        }
        HRAffairBizBillInfo model = this.getHRAffairBizBillInfo(ctx, (IObjectPK)new ObjectUuidPK(billID));
        this.handlerQuitLimit(ctx, model, HRBillStateEnum.AUDITED);
        super._setAudited(ctx, billID);
    }

    @Override
    public void _unAuditEachEntrySpecialPropertyRecovery(Context ctx, HRAffairBizBillEntryInfo entry) throws BOSException, EASBizException {
        EmployeeTypeInfo typeInfo;
        ResignBizBillEntryInfo entryInfo = (ResignBizBillEntryInfo)entry;
        PersonPositionInfo plInfo = new PersonPositionInfo();
        plInfo.setGkAdmin(null);
        plInfo.setLeftDate(null);
        plInfo.setDimissionReason(null);
        plInfo.setPerson(entryInfo.getPerson());
        AffairUnAuditAppUtils.updatePersonSinglePagePartial((ICoreBase)PersonPositionFactory.getLocalInstance((Context)ctx), (CoreBaseInfo)plInfo, (String)"gkAdmin,leftDate,dimissionReason");
        if (this.isCreateUserJob(entry)) {
            this.dropJobProcess(ctx, "'" + entry.getId().toString() + "'");
        } else if (entryInfo.getOldEmpType() != null && entryInfo.getOldEmpType().getId() != null && EnableStateEnum.ENABLE.equals((Object)(typeInfo = EmployeeTypeFactory.getLocalInstance((Context)ctx).getEmployeeTypeInfo((IObjectPK)new ObjectUuidPK(entryInfo.getOldEmpType().getId()))).getUserState())) {
            String sql = "update t_pm_user set FFORBIDDEN = 0 where fpersonID ='" + entryInfo.getPerson().getId() + "'";
            DbUtil.execute((Context)ctx, (String)sql);
            HRBillAppUtils.callBackUser((Context)ctx, (String)entryInfo.getPerson().getId().toString());
        }
        PersonBlackListUtil.removeFromPersonBlackList((Context)ctx, (String)entry.getId().toString());
        entryInfo.setCertBillEntry(null);
        entryInfo.setCertBill(null);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("certBillEntry"));
        selector.add(new SelectorItemInfo("certBill"));
        ResignBizBillEntryFactory.getLocalInstance(ctx).updatePartial((CoreBaseInfo)entryInfo, selector);
    }

    @Override
    protected IObjectPK _forbidUser(Context ctx, BOSUuid entryID) throws BOSException, EASBizException {
        if (entryID != null) {
            HRBillBaseEntryInfo entry = this.getEntryInterface(ctx).getHRBillBaseEntryInfo((IObjectPK)new ObjectUuidPK(entryID));
            HROrgUnitInfo hro = this.getHROrgUnit(ctx, new ObjectUuidPK(entryID));
            if (ContextUtil.getCurrentUserInfo((Context)ctx) == null) {
                UserInfo user = UserFactory.getLocalInstance((Context)ctx).getUser("administrator");
                ContextUtil.setCurrentUserInfo((Context)ctx, (UserInfo)user);
            }
            if (ContextUtil.getCurrentHRUnit((Context)ctx) == null) {
                ContextUtil.setCurrentHRUnit((Context)ctx, (HROrgUnitInfo)hro);
            }
            this.doForbidUser(ctx, entry);
        }
        return null;
    }

    protected void _entryEffectOthers(Context ctx, HRBillBaseEntryInfo entry) throws BOSException, EASBizException {
        String oql;
        HRAffairBizBillEntryInfo affairEntry = (HRAffairBizBillEntryInfo)entry;
        IUser iUser = UserFactory.getLocalInstance((Context)ctx);
        if (!iUser.exists(oql = "where person.id='" + affairEntry.getPerson().getId() + "'")) {
            return;
        }
        if (this.isCreateUserJob(affairEntry)) {
            this.createUserBackGroundJob(ctx, (IObjectValue)entry, "entryID");
        } else {
            this.doForbidUser(ctx, entry);
        }
    }

    public void setIsSameDatePersonChange(Context ctx, SHRSameDatePersonChangeUtil util, HRBillBaseEntryInfo entry) throws BOSException {
        ResignBizBillEntryInfo billentryInfo = (ResignBizBillEntryInfo)entry;
        boolean isSameDatePersonChange = false;
        if (null != billentryInfo.getPerson() && null != billentryInfo.getBizDate()) {
            isSameDatePersonChange = util.isSameDatePersonChange(ctx, billentryInfo.getPerson().getId().toString(), billentryInfo.getBizDate(), 1);
        }
        billentryInfo.put("isSameDatePersonChange", isSameDatePersonChange);
    }

    protected void setUnauditIsSameDatePersonChange(Context ctx, HRBillBaseEntryInfo entry) throws BOSException {
        HRAffairBizBillEntryInfo billentryInfo = (HRAffairBizBillEntryInfo)entry;
        billentryInfo.put("isSameDatePersonChange", EmpPosOrgRelationUtil.isUnauditSameDatePersonChange((Context)ctx, (HRAffairBizBillEntryInfo)billentryInfo));
    }

    private boolean isCreateUserJob(HRAffairBizBillEntryInfo entryInfo) {
        boolean isCreateUserJob = false;
        java.util.Date now = new java.util.Date();
        Date forbidUserDate = entryInfo.getDate("forbidUserDate");
        java.util.Date bizDate = entryInfo.getBizDate();
        if (forbidUserDate != null && now.before(forbidUserDate)) {
            isCreateUserJob = true;
        }
        if (forbidUserDate == null && now.before(bizDate)) {
            isCreateUserJob = true;
        }
        return isCreateUserJob;
    }

    @Override
    protected HRAffairBizBillInfo storefieldsForBill(Context ctx, HRAffairBizBillInfo billInfo) throws EASBizException, BOSException {
        super.storefieldsForBill(ctx, billInfo);
        if (billInfo.getId() == null && billInfo.get("isFromSSC") == null) {
            billInfo.put("isFromSSC", false);
        }
        return billInfo;
    }

    @Override
    protected HRAffairBizBillEntryInfo storefieldsForEntry(Context ctx, HRAffairBizBillInfo billInfo, HRAffairBizBillEntryInfo entryInfo) throws EASBizException, BOSException {
        ResignBizBillEntryInfo info = (ResignBizBillEntryInfo)entryInfo;
        if (info.getEnterDate() == null) {
            String oql = " where person.id = '" + info.getPerson().getId().toString() + "'";
            EmpLaborRelationInfo empLaborRelationInfo = EmpLaborRelationFactory.getLocalInstance((Context)ctx).getEmpLaborRelationInfo(oql);
            info.setEnterDate(empLaborRelationInfo.getEnterDate());
        }
        if (info.getForbidUserDate() == null) {
            info.setForbidUserDate(HRUtil.getAftereDate((java.util.Date)info.getLeftCompanyDate()));
        }
        this.checkForbidUserDate(info);
        return super.storefieldsForEntry(ctx, billInfo, entryInfo);
    }

    protected void checkForbidUserDate(ResignBizBillEntryInfo entryInfo) throws EmployeeBizException {
        if (entryInfo.getForbidUserDate() != null && DateTimeUtils.dayBefore((java.util.Date)entryInfo.getForbidUserDate(), (java.util.Date)entryInfo.getLeftCompanyDate())) {
            logger.error("ResignBizBillControllerBean-personId\uff1a" + entryInfo.getPerson().getId().toString() + "\uff0cForbidUserDate\uff1a" + entryInfo.getForbidUserDate() + "\uff0cLeftCompanyDate\uff1a" + entryInfo.getLeftCompanyDate());
            throw new EmployeeBizException(EmployeeBizException.EXCEPTION237);
        }
    }

    @Override
    protected void refreshEmpPostExperience(Context ctx, HRBillBaseEntryInfo entry) throws BOSException, EASBizException {
        PositionCollection posColl;
        java.util.Date effect;
        Map map = null;
        PositionInfo positionInfo = null;
        AdminOrgUnitInfo adminOrgInfo = null;
        AdminOrgUnitInfo companyInfo = null;
        AdminOrgUnitInfo departmentInfo = null;
        EmployeeTypeInfo empTypeInfo = null;
        JobGradeInfo jobGradeInfo = null;
        JobLevelInfo jobLevelInfo = null;
        JobInfo jobInfo = null;
        String personId = null;
        ResignBizBillEntryInfo entryInfo = (ResignBizBillEntryInfo)entry;
        PersonInfo person = (PersonInfo)entryInfo.get("person");
        if (person != null && person.getId() != null) {
            personId = person.getId().toString();
        }
        if ((map = EmpPostExperienceHisHelper.getPersonAllRelationHisMap((Context)ctx, (String)personId, (java.util.Date)(effect = (java.util.Date)entryInfo.get("bizDate")))) == null) {
            return;
        }
        positionInfo = (PositionInfo)map.get("position");
        adminOrgInfo = (AdminOrgUnitInfo)map.get("adminOrg");
        companyInfo = (AdminOrgUnitInfo)map.get("company");
        departmentInfo = (AdminOrgUnitInfo)map.get("department");
        empTypeInfo = (EmployeeTypeInfo)map.get("empType");
        jobGradeInfo = (JobGradeInfo)map.get("jobGrade");
        jobLevelInfo = (JobLevelInfo)map.get("jobLevel");
        jobInfo = (JobInfo)map.get("job");
        adminOrgInfo.setDepartment(departmentInfo);
        positionInfo.setAdminOrgUnit(adminOrgInfo);
        entryInfo.put("oldPosition", positionInfo);
        entryInfo.put("newPosition", positionInfo);
        entryInfo.put("oldAdminOrg", adminOrgInfo);
        entryInfo.put("oldAdmin", adminOrgInfo);
        entryInfo.put("adminOrg", adminOrgInfo);
        entryInfo.put("newAdmin", adminOrgInfo);
        entryInfo.put("oldCompany", companyInfo);
        entryInfo.put("company", companyInfo);
        entryInfo.put("oldEmpType", empTypeInfo);
        entryInfo.put("oldLaborRelState", empTypeInfo);
        entryInfo.put("newLaborRelState", empTypeInfo);
        entryInfo.put("oldJob", jobInfo);
        if (null != entryInfo.get("position") && (posColl = PositionFactory.getLocalInstance((Context)ctx).getPositionCollection("select job.id where id = '" + ((PositionInfo)entryInfo.get("position")).getId().toString() + "'")).size() > 0) {
            entryInfo.put("job", posColl.get(0).getJob());
        }
        entryInfo.put("oldJobGrade", jobGradeInfo);
        entryInfo.put("jobGrade", jobGradeInfo);
        entryInfo.put("oldJobLevel", jobLevelInfo);
        entryInfo.put("jobLevel", jobLevelInfo);
        ResignBizBillEntryFactory.getLocalInstance(ctx).save((CoreBaseInfo)entryInfo);
    }

    @Override
    protected void refreshResignBillForExperience(Context ctx, HRBillBaseEntryInfo entry) throws BOSException, EASBizException {
        PositionCollection posColl;
        java.util.Date effect;
        Map map = null;
        PositionInfo positionInfo = null;
        AdminOrgUnitInfo adminOrgInfo = null;
        AdminOrgUnitInfo companyInfo = null;
        AdminOrgUnitInfo departmentInfo = null;
        EmployeeTypeInfo empTypeInfo = null;
        JobGradeInfo jobGradeInfo = null;
        JobLevelInfo jobLevelInfo = null;
        JobInfo jobInfo = null;
        String personId = null;
        ResignBizBillEntryInfo entryInfo = (ResignBizBillEntryInfo)entry;
        PersonInfo person = (PersonInfo)entryInfo.get("person");
        if (person != null && person.getId() != null) {
            personId = person.getId().toString();
        }
        if ((map = EmpPostExperienceHisHelper.getPersonAllRelationHisMap((Context)ctx, (String)personId, (java.util.Date)(effect = (java.util.Date)entryInfo.get("bizDate")))) == null) {
            return;
        }
        positionInfo = (PositionInfo)map.get("position");
        adminOrgInfo = (AdminOrgUnitInfo)map.get("adminOrg");
        companyInfo = (AdminOrgUnitInfo)map.get("company");
        departmentInfo = (AdminOrgUnitInfo)map.get("department");
        empTypeInfo = (EmployeeTypeInfo)map.get("empType");
        jobGradeInfo = (JobGradeInfo)map.get("jobGrade");
        jobLevelInfo = (JobLevelInfo)map.get("jobLevel");
        jobInfo = (JobInfo)map.get("job");
        adminOrgInfo.setDepartment(departmentInfo);
        positionInfo.setAdminOrgUnit(adminOrgInfo);
        entryInfo.put("oldPosition", positionInfo);
        entryInfo.put("newPosition", positionInfo);
        entryInfo.put("oldAdminOrg", adminOrgInfo);
        entryInfo.put("oldAdmin", adminOrgInfo);
        entryInfo.put("adminOrg", adminOrgInfo);
        entryInfo.put("newAdmin", adminOrgInfo);
        entryInfo.put("oldCompany", companyInfo);
        entryInfo.put("company", companyInfo);
        entryInfo.put("oldEmpType", empTypeInfo);
        entryInfo.put("oldLaborRelState", empTypeInfo);
        entryInfo.put("newLaborRelState", empTypeInfo);
        entryInfo.put("oldJob", jobInfo);
        if (null != entryInfo.get("position") && (posColl = PositionFactory.getLocalInstance((Context)ctx).getPositionCollection("select job.id where id = '" + ((PositionInfo)entryInfo.get("position")).getId().toString() + "'")).size() > 0) {
            entryInfo.put("job", posColl.get(0).getJob());
        }
        entryInfo.put("oldJobGrade", jobGradeInfo);
        entryInfo.put("jobGrade", jobGradeInfo);
        entryInfo.put("oldJobLevel", jobLevelInfo);
        entryInfo.put("jobLevel", jobLevelInfo);
    }

    @Override
    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IObjectCollection entries = (IObjectCollection)model.get(this.getEntryField());
        if (entries.size() == 0) {
            throw new HRAffairException(HRAffairException.NO_ENTRIES);
        }
        for (int i = 0; i < entries.size(); ++i) {
            ResignBizBillEntryInfo entryInfo = (ResignBizBillEntryInfo)entries.getObject(i);
            this.refreshResignBillForExperience(ctx, entryInfo);
        }
        IObjectPK pk = super._save(ctx, model);
        return pk;
    }

    @Override
    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        HRAffairBizBillInfo info = (HRAffairBizBillInfo)model;
        this.handlerQuitLimit(ctx, info, HRBillStateEnum.SUBMITED);
        IObjectPK pk = super._submit(ctx, model);
        return pk;
    }

    @Override
    protected void _submit(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        HRAffairBizBillInfo info = (HRAffairBizBillInfo)model;
        this.handlerQuitLimit(ctx, info, HRBillStateEnum.AUDITING);
        super._submit(ctx, pk, model);
    }

    @Override
    protected IObjectPK _submitEffect(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        HRAffairBizBillInfo info = (HRAffairBizBillInfo)model;
        info.put("submitEffectFlag", true);
        this.handlerQuitLimit(ctx, info, HRBillStateEnum.AUDITED);
        IObjectPK pk = super._submitEffect(ctx, model);
        return pk;
    }

    @Override
    protected void _abortBizBill(Context ctx, String billId) throws BOSException, EASBizException {
        super._abortBizBill(ctx, billId);
        this.handlerBackQuitLimit(ctx, billId, HRBillStateEnum.SUBMITED);
    }

    @Override
    protected void _untiCheckBizBill(Context ctx, String billId) throws BOSException, EASBizException {
        super._untiCheckBizBill(ctx, billId);
        this.handlerBackQuitLimit(ctx, billId, HRBillStateEnum.AUDITED);
    }

    @Override
    protected void _untiCheckBizBillEntry(Context ctx, String entryId) throws BOSException, EASBizException {
        super._untiCheckBizBillEntry(ctx, entryId);
        this.handlerBackQuitLimitByEntryId(ctx, entryId, HRBillStateEnum.AUDITED);
    }
}

