/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base;

import com.kingdee.eas.hr.base.ExpressionValue;
import com.kingdee.eas.hr.base.MappingOperationEnum;
import com.kingdee.util.StringUtils;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;

public class Expression
implements Serializable {
    private static final long serialVersionUID = -1337936075628673299L;
    public static final String AND = " and ";
    public static final String OR = " or ";
    private String field = null;
    private MappingOperationEnum oprt = null;
    private ExpressionValue value = null;
    private Expression next = null;
    private String relationWithNex = null;
    private String expression = null;

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public String getField() {
        return this.field;
    }

    public void setField(String field) {
        this.field = field;
    }

    public Expression getNext() {
        return this.next;
    }

    public void setNext(Expression next) {
        this.next = next;
    }

    public MappingOperationEnum getOprt() {
        return this.oprt;
    }

    public void setOprt(MappingOperationEnum oprt) {
        this.oprt = oprt;
    }

    public String getRelationWithNex() {
        return this.relationWithNex;
    }

    public void setRelationWithNex(String relationWithNex) {
        this.relationWithNex = relationWithNex;
    }

    public ExpressionValue getValue() {
        return this.value;
    }

    public void setValue(ExpressionValue value) {
        this.value = value;
    }

    public void convert() {
        if (StringUtils.isEmpty((String)this.expression)) {
            return;
        }
        Iterator ite = MappingOperationEnum.iterator();
        String ops = null;
        String[] split = null;
        MappingOperationEnum op = null;
        while (ite.hasNext()) {
            op = (MappingOperationEnum)((Object)ite.next());
            ops = op.getValue();
            split = StringUtils.split((String)this.expression, (String)ops);
            if (split.length <= 1) continue;
            this.field = split[0].trim();
            this.oprt = op;
            this.value = new ExpressionValue(split[1].trim());
            break;
        }
    }

    public String toString() {
        if (this.expression == null && this.field != null && this.oprt != null && this.value != null) {
            this.expression = this.field + this.oprt.getValue() + this.value;
            if (this.next != null) {
                this.expression = this.expression + this.relationWithNex + this.next.toString();
            }
        }
        if (this.expression == null) {
            return "";
        }
        return this.expression;
    }

    public String toOql() {
        String oql = null;
        if (this.value != null && this.value.getValueType() == 1) {
            Date date = Expression.parse(this.value.getValue(), "yyyy-MM-dd", null);
            if (this.field != null && this.oprt != null) {
                if (date == null) {
                    oql = this.field + " is null";
                } else {
                    SimpleDateFormat sFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    oql = this.field + this.oprt.getValue() + "{ts'" + sFormat.format(date) + "'}";
                }
            }
        }
        if (oql == null) {
            oql = this.field + this.oprt.getValue() + this.value;
        }
        if (this.next != null) {
            oql = oql + this.relationWithNex + this.next.toOql();
        }
        return oql;
    }

    public static Date parse(String source, String pattern, Date defaultDate) {
        SimpleDateFormat df = new SimpleDateFormat(pattern);
        Date date = null;
        try {
            date = df.parse(source);
        }
        catch (Exception e) {
            date = defaultDate;
        }
        return date;
    }
}

