/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base;

import com.kingdee.eas.hr.base.Expression;
import com.kingdee.util.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class ExpressionNode
implements Serializable {
    private static final long serialVersionUID = -6199381542918230925L;
    private String root = null;
    private String logic = null;
    private List children = null;
    private ExpressionNode parent = null;

    public ExpressionNode(String exp) {
        this.root = exp;
    }

    public String getLogic() {
        return this.logic;
    }

    public void setLogic(String logic) {
        this.logic = logic;
    }

    public String getRoot() {
        return this.root;
    }

    public void setRoot(String root) {
        this.root = root;
    }

    public ExpressionNode getParent() {
        return this.parent;
    }

    public void setParent(ExpressionNode parent) {
        this.parent = parent;
    }

    public void addChild(ExpressionNode child) {
        if (child != null) {
            if (this.children == null) {
                this.children = new ArrayList();
            }
            child.setParent(this);
            this.children.add(child);
        }
    }

    public List getChildren() {
        return this.children;
    }

    public Expression buildExpression() {
        if (this.isLeaf()) {
            Expression exp = null;
            if (!StringUtils.isEmpty((String)this.root)) {
                exp = new Expression();
                exp.setExpression(this.root);
                exp.convert();
            }
            return exp;
        }
        ExpressionNode node = null;
        Expression head = null;
        Expression previous = null;
        Expression exp = null;
        int size = this.children.size();
        for (int i = 0; i < size; ++i) {
            node = (ExpressionNode)this.children.get(i);
            exp = node.buildExpression();
            if (exp == null) continue;
            if (head == null) {
                head = exp;
            } else if (previous != null) {
                previous.setNext(exp);
                previous.setRelationWithNex(this.logic);
            }
            previous = exp;
        }
        return head;
    }

    public boolean isLeaf() {
        return this.children == null;
    }

    public String toString() {
        return this.root;
    }

    public void buildTree() {
        block6: {
            String exp;
            String[] chs;
            ExpressionNode child;
            block5: {
                if (StringUtils.isEmpty((String)this.root)) {
                    return;
                }
                child = null;
                chs = StringUtils.split((String)this.root, (String)" or ");
                exp = null;
                if (chs.length != 1) break block5;
                chs = StringUtils.split((String)this.root, (String)" and ");
                if (chs.length <= 1) break block6;
                this.setLogic(" and ");
                for (int i = 0; i < chs.length; ++i) {
                    child = new ExpressionNode(chs[i].trim());
                    this.addChild(child);
                }
                break block6;
            }
            this.setLogic(" or ");
            for (int i = 0; i < chs.length; ++i) {
                exp = chs[i].trim();
                child = new ExpressionNode(exp);
                String[] subs = StringUtils.split((String)exp, (String)" and ");
                if (subs.length > 1) {
                    child.setLogic(" and ");
                    for (int j = 0; j < subs.length; ++j) {
                        this.addChild(new ExpressionNode(subs[j].trim()));
                    }
                }
                this.addChild(child);
            }
        }
    }
}

