/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.CryptoUtil;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.permission.Administrator;
import com.kingdee.eas.base.permission.UserException;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import org.apache.log4j.Logger;

public class CheckLogin {
    private static Logger logger = Logger.getLogger(CheckLogin.class);
    private Component parentComponent = null;

    public CheckLogin(Component parentComponent) {
        this.parentComponent = parentComponent;
    }

    public boolean isLogin() throws EASBizException {
        UserInfo userInfo = ContextHelperFactory.getRemoteInstance().getCurrentUser();
        if (Administrator.isSuperCUAdmin((IObjectPK)new ObjectUuidPK(userInfo.getId()))) {
            return true;
        }
        if ("00000000-0000-0000-0000-00000000000013B7DE7F".equals(userInfo.getId().toString())) {
            return true;
        }
        try {
            userInfo = UserFactory.getRemoteInstance().getUserByID((IObjectPK)new ObjectUuidPK("00000000-0000-0000-0000-00000000000013B7DE7F"));
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage());
        }
        JPasswordField pwd = new JPasswordField();
        Object[] message = new Object[]{EASResource.getString((String)"com.kingdee.eas.hr.base.BASEAutoGenerateResource", (String)"7_CheckLogin"), pwd};
        int res = JOptionPane.showConfirmDialog(this.parentComponent, message, " ", 2, 3);
        if (res != 0) {
            return false;
        }
        String logonPassword = new String(pwd.getPassword());
        return CheckLogin.matchPassword(userInfo, logonPassword);
    }

    public static boolean matchPassword(UserInfo userInfo, String password) throws EASBizException {
        if (StringUtils.isEmpty((String)password)) {
            return StringUtils.isEmpty((String)userInfo.getPassword());
        }
        return CheckLogin.encrypt(userInfo.getId().toString(), password).equals(userInfo.getPassword());
    }

    public static String encrypt(String userID, String password) throws EASBizException {
        try {
            return CryptoUtil.encrypt((String)(userID + password.trim()));
        }
        catch (Exception e) {
            throw new UserException(UserException.ENCRYPT_FAIL);
        }
    }
}

