/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.client;

import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.QueryPanelTypeEnum;
import com.kingdee.eas.base.commonquery.client.DataObject;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.hr.base.client.Util;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;

public class CommonFilterUtil {
    public static QueryInfo getQueryInfo(String query, String dynQueryId) {
        QueryInfo queryInfo = Util.getQueryInfo((IMetaDataPK)new MetaDataPK(query));
        if (dynQueryId != null) {
            EntityViewInfo entityViewInfoByDynQuery = Util.getEntityViewInfoByDynQuery(queryInfo, BOSUuid.read((String)dynQueryId));
            queryInfo = Util.getDyFilterQuery(queryInfo, entityViewInfoByDynQuery);
        }
        return queryInfo;
    }

    public static DataObject[] getQueryFilterFields(String query, String dynQueryId) {
        QueryInfo queryInfo = CommonFilterUtil.getQueryInfo(query, dynQueryId);
        return Util.getConditionArray(queryInfo, QueryPanelTypeEnum.FILTER_PANEL);
    }

    public static Map getQueryFilterFieldsMap(String query, String dynQueryId) {
        QueryInfo queryInfo = CommonFilterUtil.getQueryInfo(query, dynQueryId);
        return CommonFilterUtil.getQueryFilterFieldsMap(queryInfo);
    }

    public static Map getQueryFilterFieldsMap(QueryInfo queryInfo) {
        DataObject[] dos = Util.getConditionArray(queryInfo, QueryPanelTypeEnum.FILTER_PANEL);
        HashMap<String, DataObject> queryFieldMap = new HashMap<String, DataObject>();
        for (int i = 0; i < dos.length; ++i) {
            queryFieldMap.put(dos[i].getValue(), dos[i]);
        }
        return queryFieldMap;
    }

    public static Map getSortedMap(Map map, String sortedValueKey) {
        TreeMap sortedMap = new TreeMap();
        for (Map.Entry entry : map.entrySet()) {
            DataBaseInfo info = (DataBaseInfo)entry.getValue();
            Object key = info.get(sortedValueKey);
            if (sortedMap.containsKey(key)) {
                throw new RuntimeException("Cann't sort!The " + sortedValueKey + " exists not only one " + info + " $$ " + sortedMap.get(key));
            }
            sortedMap.put(key, entry.getValue());
        }
        return sortedMap;
    }

    public static void reFreshMapIndex(Map map) {
        Map sortedMap = CommonFilterUtil.getSortedMap(map, "index");
        Iterator iterator = sortedMap.entrySet().iterator();
        int i = 0;
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            DataBaseInfo info = (DataBaseInfo)entry.getValue();
            info.put("index", (Object)i);
            ++i;
        }
    }

    public static void copyMultLangFieldIfNull(CoreBaseInfo info, String key) {
        int i;
        String name = null;
        for (i = 1; i < 4 && StringUtils.isEmpty((String)(name = (String)info.get(key, new Locale("L" + i)))); ++i) {
        }
        for (i = 1; i < 4; ++i) {
            String n = (String)info.get(key, new Locale("L" + i));
            if (!StringUtils.isEmpty((String)n)) continue;
            info.put(key, (Object)name, new Locale("L" + i));
        }
    }
}

