/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.client;

import com.kingdee.bos.ctrl.report.forapp.kdnote.client.DefaultNoteDataProvider;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.eas.hr.base.client.CustomFilterBuilder;
import com.kingdee.eas.hr.base.client.HRFilterMaker;

public class DataProviderSetting {
    private String dsName = null;
    private DefaultNoteDataProvider.ICustomFilterMaker customFilterMaker = null;
    private String foreignKey = null;
    private IHRCustomFilter filter = null;
    private IMetaDataPK queryPK = null;
    private DataProviderSetting next = null;

    public DataProviderSetting() {
        this(null, null, null, null);
    }

    public DataProviderSetting(String dsName) {
        this(dsName, null, null, null);
    }

    public DataProviderSetting(String dsName, IMetaDataPK queryPK) {
        this(dsName, queryPK, null, null);
    }

    public DataProviderSetting(String dsName, IMetaDataPK queryPK, String foreignKey) {
        this(dsName, queryPK, foreignKey, null);
    }

    public DataProviderSetting(String dsName, IMetaDataPK queryPK, String foreignKey, IHRCustomFilter filter) {
        this.dsName = dsName;
        this.foreignKey = foreignKey;
        this.filter = filter;
        this.queryPK = queryPK;
        this.customFilterMaker = new HRFilterMaker(this);
    }

    public IMetaDataPK getQueryPK() {
        return this.queryPK;
    }

    public void setQueryPK(IMetaDataPK queryPK) {
        this.queryPK = queryPK;
    }

    public String getDsName() {
        return this.dsName;
    }

    public void setDsName(String dsName) {
        this.dsName = dsName;
    }

    public DefaultNoteDataProvider.ICustomFilterMaker getCustomFilterMaker() {
        return this.customFilterMaker;
    }

    public void setFilter(IHRCustomFilter filter) {
        this.filter = filter;
    }

    public String getForeignKey() {
        return this.foreignKey;
    }

    public void setForeignKey(String foreignKey) {
        this.foreignKey = foreignKey;
    }

    public void buildFilter(CustomFilterBuilder builder) {
        if (this.filter != null) {
            this.filter.build(builder);
        }
    }

    public void append(DataProviderSetting next) {
        if (next != null) {
            this.next = next;
        }
    }

    public DataProviderSetting next() {
        return this.next;
    }

    public static void addDataSource(DefaultNoteDataProvider dataProvider, DataProviderSetting setting) {
        if (dataProvider == null || setting == null) {
            return;
        }
        DataProviderSetting next = setting.next();
        if (next == null) {
            String dsName = setting.getDsName();
            dataProvider.addMetaDataPK(dsName, setting.getQueryPK());
            dataProvider.addCustomFilterMaker(dsName, setting.getCustomFilterMaker());
        } else {
            String dsName = setting.getDsName();
            dataProvider.addMetaDataPK(dsName, setting.getQueryPK());
            dataProvider.addCustomFilterMaker(dsName, setting.getCustomFilterMaker());
            DataProviderSetting.addSubDataSource(dataProvider, setting);
        }
    }

    public static void addSubDataSource(DefaultNoteDataProvider dataProvider, DataProviderSetting setting) {
        if (dataProvider == null || setting == null) {
            return;
        }
        String dsName = setting.getDsName();
        dataProvider.addMetaDataPK(dsName, setting.getQueryPK());
        dataProvider.addCustomFilterMaker(dsName, setting.getCustomFilterMaker());
        dataProvider.addForeignKey((Object)dsName, setting.getForeignKey());
        DataProviderSetting next = setting.next();
        if (next != null) {
            DataProviderSetting.addSubDataSource(dataProvider, next);
        }
    }

    public static interface IHRCustomFilter {
        public void build(CustomFilterBuilder var1);
    }
}

