/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.eas.hr.base.client.DuplicateVerifier;
import com.kingdee.eas.hr.base.client.IVerifier;
import com.kingdee.eas.hr.base.util.HRResourceUtils;
import com.kingdee.eas.util.client.MsgBox;

public class DuplicateColumnVerifier
implements IVerifier {
    private String[] cols = null;
    private KDTable kdt = null;

    public DuplicateColumnVerifier(KDTable kdt, String[] cols) {
        this.cols = cols;
        this.kdt = kdt;
    }

    @Override
    public boolean verify() throws Exception {
        if (this.kdt == null || this.cols == null || this.cols.length <= 0) {
            return true;
        }
        IRow r = null;
        int size = this.kdt.getRowCount();
        for (int i = 0; i < size; ++i) {
            r = this.kdt.getRow(i);
            if (!this.verifyDupInRow(r, this.cols, i)) continue;
            return false;
        }
        return true;
    }

    private boolean verifyDupInRow(IRow row, String[] cols, int index) {
        if (row == null || cols == null || cols.length <= 0) {
            return false;
        }
        int len = cols.length;
        Object iObj = null;
        Object jObj = null;
        boolean isDup = false;
        for (int i = 0; i < len; ++i) {
            iObj = row.getCell(cols[i]).getValue();
            for (int j = i + 1; j < len; ++j) {
                jObj = row.getCell(cols[j]).getValue();
                isDup = this.checkNotNullDup(iObj, jObj);
                if (!isDup) continue;
                String iAlias = this.kdt.getHeadRow(0).getCell(cols[i]).getValue().toString();
                String jAlias = this.kdt.getHeadRow(0).getCell(cols[j]).getValue().toString();
                MsgBox.showInfo((String)HRResourceUtils.getMessage("com.kingdee.eas.hr.base.BASEAutoGenerateResource", "155_DuplicateColumnVerifier", new String[]{String.valueOf(index + 1), iAlias, jAlias}));
                return true;
            }
        }
        return false;
    }

    private boolean checkNotNullDup(Object obj1, Object obj2) {
        if (obj1 == null || obj2 == null) {
            return false;
        }
        return DuplicateVerifier.checkDup(obj1, obj2);
    }
}

