/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.client;

import com.kingdee.eas.hr.base.client.Node;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class Edge {
    private Node sourceNode;
    private Node targetNode;
    private Point startPort = null;
    private Point endPort = null;
    public boolean isSelected = false;
    private GeneralPath edgePath = null;
    private List points = null;
    private Point selectPoint = null;
    private Color color = new Color(186, 187, 189);

    public void setSourceNode(Node sourceNode) {
        this.sourceNode = sourceNode;
        this.sourceNode.addEdge(this);
    }

    public Node getSourceNode() {
        return this.sourceNode;
    }

    public void setTargetNode(Node targetNode) {
        this.targetNode = targetNode;
        this.targetNode.addEdge(this);
    }

    public Node getTargetNode() {
        return this.targetNode;
    }

    public void setPoints(List points) {
        this.points = points;
    }

    public List getPoints() {
        return this.points;
    }

    public boolean isInRect(Rectangle rect) {
        if (!rect.contains(this.startPort)) {
            return false;
        }
        if (!rect.contains(this.endPort)) {
            return false;
        }
        int size = this.points.size() - 1;
        for (int i = 1; i < size; ++i) {
            if (rect.contains((Point)this.points.get(i))) continue;
            return false;
        }
        return true;
    }

    public void moveSelectPointTo(Point offsetPoint) {
        if (this.selectPoint == null) {
            return;
        }
        this.selectPoint.x += offsetPoint.x;
        this.selectPoint.y += offsetPoint.y;
    }

    public void moveAllPointTo(Point offsetPoint) {
        if (this.points == null || this.points.size() < 3) {
            return;
        }
        Point p = null;
        int size = this.points.size() - 1;
        for (int i = 1; i < size; ++i) {
            p = (Point)this.points.get(i);
            p.x += offsetPoint.x;
            p.y += offsetPoint.y;
        }
    }

    public boolean setSelectPoint(Point point) {
        Rectangle rect = new Rectangle(this.startPort.x - 3, this.startPort.y - 3, 6, 6);
        if (rect.contains(point)) {
            this.selectPoint = this.startPort;
            return true;
        }
        rect = new Rectangle(this.endPort.x - 3, this.endPort.y - 3, 6, 6);
        if (rect.contains(point)) {
            this.selectPoint = this.endPort;
            return true;
        }
        if (this.points != null && this.points.size() > 2) {
            Point p = null;
            int size = this.points.size() - 1;
            for (int i = 1; i < size; ++i) {
                p = (Point)this.points.get(i);
                rect = new Rectangle(p.x - 3, p.y - 3, 6, 6);
                if (!rect.contains(point)) continue;
                this.selectPoint = p;
                return true;
            }
        }
        this.selectPoint = null;
        return false;
    }

    public void addPoint(Point point) {
        if (this.points == null || this.points.size() == 0) {
            this.points = new ArrayList();
            this.points.add(point);
        } else {
            Rectangle rect = null;
            Point p = null;
            for (int i = this.points.size() - 1; i > 0; --i) {
                p = (Point)this.points.get(i);
                rect = new Rectangle(p.x - 3, p.y - 3, 6, 6);
                if (!rect.contains(point)) continue;
                this.points.remove(i);
                return;
            }
            int index = 0;
            double min = Double.MAX_VALUE;
            double dist = 0.0;
            for (int i = 0; i < this.points.size() - 1; ++i) {
                Point p1 = (Point)this.points.get(i);
                if (i == 0) {
                    p1 = this.startPort;
                }
                Point p2 = (Point)this.points.get(i + 1);
                if (i == this.points.size() - 2) {
                    p2 = this.endPort;
                }
                if (!((dist = new Line2D.Double(p1, p2).ptSegDistSq(point)) < min)) continue;
                min = dist;
                index = i + 1;
            }
            this.points.add(index, point);
        }
    }

    private GeneralPath getLinePath() {
        GeneralPath path = new GeneralPath();
        if (this.sourceNode == null || this.targetNode == null || this.points != null && this.points.size() == 1) {
            return path;
        }
        if (this.points == null || this.points.size() == 0 || this.points.size() == 2) {
            Point targetNodeCenterPoint = new Point(this.targetNode.getX() + this.targetNode.getWidth() / 2, this.targetNode.getY() + this.targetNode.getHeight() / 2);
            Point sourceNodeCenterPoint = new Point(this.sourceNode.getX() + this.sourceNode.getWidth() / 2, this.sourceNode.getY() + this.sourceNode.getHeight() / 2);
            this.startPort = this.getNodePort(this.sourceNode, targetNodeCenterPoint, true);
            this.endPort = this.getNodePort(this.targetNode, sourceNodeCenterPoint, true);
            path.moveTo((float)this.startPort.getX(), (float)this.startPort.getY());
            path.lineTo((float)this.endPort.getX(), (float)this.endPort.getY());
            return path;
        }
        this.startPort = this.getNodePort(this.sourceNode, (Point)this.points.get(1), false);
        this.endPort = this.getNodePort(this.targetNode, (Point)this.points.get(this.points.size() - 2), false);
        path.moveTo((float)this.startPort.getX(), (float)this.startPort.getY());
        int size = this.points.size() - 1;
        for (int i = 1; i < size; ++i) {
            path.lineTo((float)((Point)this.points.get(i)).getX(), (float)((Point)this.points.get(i)).getY());
        }
        path.lineTo((float)this.endPort.getX(), (float)this.endPort.getY());
        return path;
    }

    public boolean contains(Graphics g, Point point) {
        boolean exist = false;
        Graphics2D g2d = (Graphics2D)g;
        Rectangle rect = null;
        rect = new Rectangle(point.x - 3, point.y - 3, 6, 6);
        try {
            exist = g2d.hit(rect, this.edgePath, true);
        }
        catch (Exception e) {
            exist = false;
        }
        if (!exist && this.isSelected) {
            rect = new Rectangle(this.startPort.x - 3, this.startPort.y - 3, 6, 6);
            if (rect.contains(point)) {
                return true;
            }
            rect = new Rectangle(this.endPort.x - 3, this.endPort.y - 3, 6, 6);
            if (rect.contains(point)) {
                return true;
            }
            if (this.points != null && this.points.size() > 2) {
                Point p = null;
                int size = this.points.size() - 1;
                for (int i = 1; i < size; ++i) {
                    p = (Point)this.points.get(i);
                    rect = new Rectangle(p.x - 3, p.y - 3, 6, 6);
                    if (!rect.contains(point)) continue;
                    return true;
                }
            }
        }
        return exist;
    }

    public void render(Graphics g, HashMap renderMap) {
        Graphics2D g2d = (Graphics2D)g;
        Color oldColor = g2d.getColor();
        g2d.setColor(this.color);
        Stroke oldStroke = g2d.getStroke();
        g2d.setStroke(new BasicStroke(2.0f));
        this.edgePath = this.getLinePath();
        g2d.draw(this.edgePath);
        g2d.setStroke(oldStroke);
        g2d.setColor(oldColor);
        if (this.isSelected) {
            oldColor = g.getColor();
            g.setColor(new Color(204, 157, 96));
            if (this.startPort != null) {
                g.drawRect(this.startPort.x - 3, this.startPort.y - 3, 6, 6);
            }
            if (this.endPort != null) {
                g.drawRect(this.endPort.x - 3, this.endPort.y - 3, 6, 6);
            }
            if (this.points != null && this.points.size() > 2) {
                int size = this.points.size() - 1;
                for (int i = 1; i < size; ++i) {
                    Point point = (Point)this.points.get(i);
                    g.drawRect(point.x - 3, point.y - 3, 6, 6);
                }
            }
            g.setColor(oldColor);
        }
    }

    private Point getNodePort(Node node, Point targetPoint, boolean flag) {
        double xCenter = node.getX() + node.getWidth() / 2;
        double yCenter = node.getY() + node.getHeight() / 2;
        double dx = targetPoint.getX() - xCenter;
        double dy = targetPoint.getY() - yCenter;
        double alpha = Math.atan2(dy, dx);
        double xout = 0.0;
        double yout = 0.0;
        double pi = Math.PI;
        double pi2 = 1.5707963267948966;
        double beta = pi2 - alpha;
        double t = Math.atan2(node.getHeight(), node.getWidth());
        if (alpha < -pi + t || alpha > pi - t) {
            xout = node.getX();
            yout = yCenter - (double)node.getWidth() * Math.tan(alpha) / 2.0;
        } else if (alpha < -t) {
            yout = node.getY();
            xout = xCenter - (double)node.getHeight() * Math.tan(beta) / 2.0;
        } else if (alpha < t) {
            xout = node.getX() + node.getWidth();
            yout = yCenter + (double)node.getWidth() * Math.tan(alpha) / 2.0;
        } else {
            yout = node.getY() + node.getHeight();
            xout = xCenter + (double)node.getHeight() * Math.tan(beta) / 2.0;
        }
        if (flag) {
            return new Point((int)xout, (int)yout);
        }
        if (targetPoint.getX() >= (double)node.getX() && targetPoint.getX() <= (double)(node.getX() + node.getWidth())) {
            xout = targetPoint.getX();
        } else if (targetPoint.getY() >= (double)node.getY() && targetPoint.getY() <= (double)(node.getY() + node.getHeight())) {
            yout = targetPoint.getY();
        }
        if (targetPoint.getX() < (double)node.getX()) {
            xout = node.getX();
        } else if (targetPoint.getX() > (double)(node.getX() + node.getWidth())) {
            xout = node.getX() + node.getWidth();
        }
        if (targetPoint.getY() < (double)node.getY()) {
            yout = node.getY();
        } else if (targetPoint.getY() > (double)(node.getY() + node.getHeight())) {
            yout = node.getY() + node.getHeight();
        }
        return new Point((int)xout, (int)yout);
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Color getColor() {
        return this.color;
    }

    public Point getStartPort() {
        return this.startPort;
    }

    public Point getEndPort() {
        return this.endPort;
    }

    public GeneralPath getEdgePath() {
        return this.edgePath;
    }
}

