/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.client;

import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.org.client.PositionPromptBox2;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.base.BaseException;
import com.kingdee.eas.hr.base.EmpPosOrgRelationFactory;
import com.kingdee.eas.hr.base.EmpPosOrgRelationInfo;
import com.kingdee.eas.hr.base.client.AbstractEmpPosOrgRelationEditUI;
import com.kingdee.eas.hr.base.client.CustomerSettingsSwitch;
import com.kingdee.eas.hr.base.client.IHRF7CommonRegister;
import com.kingdee.eas.hr.emp.EmpInnerWorkExpFactory;
import com.kingdee.eas.hr.emp.EmpInnerWorkExpInfo;
import com.kingdee.eas.hr.emp.EmployeeException;
import com.kingdee.eas.hr.emp.IEmpInnerWorkExp;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.util.Date;
import org.apache.log4j.Logger;

public class EmpPosOrgRelationEditUI
extends AbstractEmpPosOrgRelationEditUI {
    private static final Logger logger = CoreUIObject.getLogger(EmpPosOrgRelationEditUI.class);

    protected void initWorkButton() {
        super.initWorkButton();
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.loadEmpCheckHireInfo();
    }

    private void loadEmpCheckHireInfo() {
    }

    private void setDefaultValue() {
    }

    @Override
    public void storeFields() {
        super.storeFields();
        this.storeEmpCheckHireInfo();
    }

    private void storeEmpCheckHireInfo() {
        try {
            IEmpInnerWorkExp iEmpInnerWorkExp = EmpInnerWorkExpFactory.getRemoteInstance();
            EmpInnerWorkExpInfo hireInfo = iEmpInnerWorkExp.getEmpInnerWorkExpInfoByRela(this.editData);
            if (hireInfo == null) {
                hireInfo = new EmpInnerWorkExpInfo();
            }
            hireInfo.setEmpPosRela(this.editData);
            iEmpInnerWorkExp.submit((CoreBaseInfo)hireInfo);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    protected void registerContextChangeF7(IHRF7CommonRegister register) {
        register.registerPositionPromptBox2(this.prmtposition);
        try {
            PositionPromptBox2 pmtPosition = (PositionPromptBox2)this.prmtposition.getSelector();
            int param = CustomerSettingsSwitch.getInstance().getFunctionParamValue("POST_HOLDING");
            if (0 != param) {
                pmtPosition.setAllAdminFilter();
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    protected void chkisPrimary_itemStateChanged(ItemEvent e) throws Exception {
    }

    @Override
    protected void prmtposition_dataChanged(DataChangeEvent e) throws Exception {
        PositionInfo pInfo = (PositionInfo)e.getNewValue();
        this.setOtherData(pInfo);
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        super.beforeStoreFields(e);
        this.verifyDateField();
        if (this.prmtposition.getData() == null) {
            this.prmtposition.requestFocusInWindow();
            throw new EmployeeException(EmployeeException.PM_POSITION_MUST_NOT_NULL);
        }
    }

    private void verifyDateField() throws BaseException, EmployeeException {
        if (this.pkeffectStartDate.getValue() == null) {
            this.pkeffectStartDate.requestFocusInWindow();
            throw new BaseException(BaseException.BEGINDATECANTNULL);
        }
        Date beginDate = (Date)this.pkeffectStartDate.getValue();
        Date endDate = (Date)this.pkeffectEndDate.getValue();
        if (beginDate == null || endDate == null) {
            return;
        }
        if (DateTimeUtils.dayBefore((Date)endDate, (Date)beginDate)) {
            throw new EmployeeException(EmployeeException.EMP_BEGINDATE_ENDDATE_ERROR);
        }
    }

    private void setOtherData(PositionInfo pInfo) {
        if (pInfo == null) {
            this.clearPositionInfo();
            return;
        }
        this.prmtadminOrg.setData((Object)pInfo.getAdminOrgUnit());
    }

    private void clearPositionInfo() {
        this.prmtadminOrg.setData(null);
    }

    private String getSuperior(String positionId, String hierarchyId) throws Exception {
        StringBuffer superior = new StringBuffer();
        MetaDataPK qryPk = new MetaDataPK("com.kingdee.eas.hr.emp.app.SuperiorQuery");
        IQueryExecutor iqryEx = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)qryPk);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("child.id", (Object)positionId));
        filter.getFilterItems().add(new FilterItemInfo("Hierarchy.id", (Object)hierarchyId));
        filter.setMaskString("#0 and #1");
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        iqryEx.setObjectView(evi);
        IRowSet rows = SQLExecutorFactory.getRemoteInstance((String)iqryEx.getSQL()).executeSQL();
        while (rows.next()) {
            if (superior.length() == 0) {
                superior.append(rows.getString("name"));
                continue;
            }
            superior.append(",").append(rows.getString("name"));
        }
        rows.close();
        return superior.toString();
    }

    private String getSuperPosition(String positionId, String hierarchyId) throws Exception {
        StringBuffer position = new StringBuffer();
        MetaDataPK qryPk = new MetaDataPK("com.kingdee.eas.hr.emp.app.SuperPositionQuery");
        IQueryExecutor iqryEx = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)qryPk);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("Child.id", (Object)positionId));
        filter.getFilterItems().add(new FilterItemInfo("Hierarchy.id", (Object)hierarchyId));
        filter.setMaskString("#0 and #1");
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        iqryEx.setObjectView(evi);
        IRowSet rows = SQLExecutorFactory.getRemoteInstance((String)iqryEx.getSQL()).executeSQL();
        while (rows.next()) {
            if (position.length() == 0) {
                position.append(rows.getString("name"));
                continue;
            }
            position.append(",").append(rows.getString("name"));
        }
        rows.close();
        return position.toString();
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return EmpPosOrgRelationFactory.getRemoteInstance();
    }

    @Override
    protected IObjectValue createNewData() {
        EmpPosOrgRelationInfo objectValue = new EmpPosOrgRelationInfo();
        objectValue.setCreator((UserInfo)SysContext.getSysContext().getCurrentUser());
        return objectValue;
    }
}

