/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.client;

import com.kingdee.bos.Context;
import com.kingdee.bos.appframework.uistatemanage.ActionManager;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.framework.FrameWorkUtils;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.hr.base.client.HRActionManager;
import com.kingdee.eas.hr.base.client.ICoreUIBiz;
import com.kingdee.eas.hr.base.client.PlugInUIDecorator;
import com.kingdee.eas.hr.base.client.PlugInUIParam;
import com.kingdee.eas.hr.base.util.HRResourceUtils;
import com.kingdee.eas.util.client.AdvMsgBox;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.KeyStroke;

public class HRCoreUIObject {
    protected CoreUI ui = null;
    protected PlugInUIDecorator plugIn = null;
    protected PlugInUIParam plugInParam = null;
    protected ICoreUIBiz biz = null;
    protected Map uiContext = null;
    protected Context mainOrgContext = null;

    public Context getMainOrgContext() {
        return this.mainOrgContext;
    }

    public void setMainOrgContext(Context mainOrgContext) {
        this.mainOrgContext = mainOrgContext;
        if (this.plugInParam != null) {
            this.plugInParam.put("mainOrgContext", mainOrgContext);
        }
    }

    public HRCoreUIObject(CoreUI ui, Map uiContext, PlugInUIDecorator plugIn, PlugInUIParam plugInParam, ICoreUIBiz biz) {
        this.ui = ui;
        this.uiContext = uiContext;
        this.plugIn = plugIn;
        this.plugInParam = plugInParam;
        this.biz = biz;
    }

    public void beforeOnLoad() throws Exception {
        if (this.plugIn != null) {
            this.plugIn.beforeOnLoad();
        }
        if (this.biz != null) {
            this.biz.beforeOnLoad();
        }
    }

    public void afterOnLoad() throws Exception {
        if (this.biz != null) {
            this.biz.afterOnLoad();
        }
        if (this.plugIn != null) {
            this.plugIn.afterOnLoad();
        }
        this.initKeyStroke();
    }

    protected void initKeyStroke() {
        if (this.ui == null) {
            return;
        }
        InputMap inputMap = this.ui.getInputMap(2);
        ActionMap actionMap = this.ui.getActionMap();
        if (inputMap == null || actionMap == null) {
            return;
        }
        KeyStroke ks = KeyStroke.getKeyStroke(120, 512);
        inputMap.put(ks, "GET_UI_NAME");
        actionMap.remove(inputMap.get(ks));
        actionMap.put(inputMap.get(ks), new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String msg = HRResourceUtils.getMessage("com.kingdee.eas.hr.base.BASEAutoGenerateResource", "161_HRCoreUIObject", new String[]{HRCoreUIObject.this.ui.getMetaDataPK().getFullName()});
                AdvMsgBox.createAdvMsgBox((Component)HRCoreUIObject.this.ui, (String)EASResource.getString((String)"com.kingdee.eas.hr.base.BASEAutoGenerateResource", (String)"54_HRCoreUIObject"), (String)msg, (String)msg, (int)1, (int)8188).show();
            }
        });
    }

    public void handUIException(Throwable exc) {
        if (this.ui != null) {
            this.ui.handUIException(exc);
        }
    }

    public static ActionManager getActionManager(ActionManager actionManager, CoreUIObject ui) {
        if (actionManager == null) {
            actionManager = new HRActionManager(ui);
        }
        return actionManager;
    }

    protected void initMainOrgContext(Map uiContext, Context mainOrgContext, OrgType mainOrgType, String orgId) {
        OrgUnitInfo orgUnitInfo;
        if (orgId == null || uiContext == null || mainOrgContext == null || mainOrgType == null) {
            return;
        }
        if (mainOrgContext != null && (orgUnitInfo = FrameWorkUtils.getCurrentOrgUnit((Context)mainOrgContext, (OrgType)mainOrgType)) != null && orgId.equals(orgUnitInfo.getId().toString())) {
            return;
        }
        try {
            FrameWorkUtils.switchOrg((Context)mainOrgContext, (String)orgId);
            orgUnitInfo = FrameWorkUtils.getCurrentOrgUnit((Context)mainOrgContext, (OrgType)mainOrgType);
            if (orgUnitInfo != null) {
                uiContext.put(mainOrgType, orgUnitInfo);
                uiContext.put("ORG.PK", new ObjectUuidPK(orgUnitInfo.getId()));
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    public void checkTableParsed() {
        if (this.biz != null) {
            this.biz.checkTableParsed();
        }
    }
}

