/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.client;

import com.kingdee.eas.hr.base.client.Edge;
import com.kingdee.eas.hr.base.client.IOrgChartTreeBuilder;
import com.kingdee.eas.hr.base.util.OrgChartUtil;
import com.kingdee.util.StringUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Node {
    private int x;
    private int y;
    private int width;
    private int height;
    private Rectangle rect = new Rectangle();
    private List edgeList = new ArrayList();
    private String id = null;
    private String name = null;
    private List nameList = null;
    public static final int HORIZONTAL_DISPLAY = 1;
    public static final int VERTICAL_DISPLAY = 2;
    public static final int HANDLE_SIZE = 6;
    public static final int MIN_WIDTH_SIZE = 20;
    public static final int MIN_HEIGHT_SIZE = 20;
    private int displayTextType = 1;
    public boolean isSelected = false;
    private Color background = new Color(229, 241, 255);
    private Color borderColor = new Color(159, 206, 151);
    private Color fontColor = Color.BLACK;
    private Font font = null;
    private boolean isExpand = false;
    private boolean isLeaf = false;
    public Rectangle[] handles = new Rectangle[8];
    private Map clientProperty = null;

    public String toString() {
        return this.name + " : " + this.rect.toString();
    }

    public Node(int x, int y, int w, int h, String id, String name, boolean isLeaf) {
        this.x = x;
        this.y = y;
        this.width = w;
        this.height = h;
        this.isLeaf = isLeaf;
        this.rect = new Rectangle(x, y, w, h);
        this.updateHandles();
        this.setName(name);
        this.id = id;
    }

    public boolean contains(Point point) {
        return this.rect.contains(point);
    }

    public void adjustEdge(int offsetX, int offsetY) {
        Edge edge = null;
        Point lastPoint = null;
        Point point = null;
        for (int i = this.edgeList.size() - 1; i >= 0; --i) {
            Node sNode;
            edge = (Edge)this.edgeList.get(i);
            if (edge.getTargetNode() == this) {
                if (edge.getPoints().size() > 3) {
                    lastPoint = (Point)edge.getPoints().get(edge.getPoints().size() - 3);
                    point = (Point)edge.getPoints().get(edge.getPoints().size() - 2);
                    if (lastPoint.y > this.y - offsetY && lastPoint.y < this.y - offsetY + this.height || lastPoint.x > this.x - offsetX && lastPoint.x < this.x - offsetX + this.width) {
                        edge.getPoints().remove(edge.getPoints().size() - 2);
                        continue;
                    }
                    if (point.x > this.x - offsetX && point.x < this.x - offsetX + this.width) {
                        point.x = this.x + this.width / 2;
                    }
                    if (point.y <= this.y - offsetY || point.y >= this.y - offsetY + this.height) continue;
                    point.y = this.y + this.height / 2;
                    continue;
                }
                if (edge.getPoints().size() != 3) continue;
                sNode = edge.getSourceNode();
                lastPoint = (Point)edge.getPoints().get(edge.getPoints().size() - 2);
                if (lastPoint.x > sNode.getX() && lastPoint.x < sNode.getX() + sNode.getWidth() && (lastPoint.y < this.y - offsetY || lastPoint.y > this.y - offsetY + this.getHeight())) {
                    edge.getPoints().add(2, new Point(this.x + this.width / 2, lastPoint.y));
                    continue;
                }
                if (lastPoint.y <= sNode.getY() || lastPoint.y >= sNode.getY() + sNode.getHeight() || lastPoint.x >= this.x - offsetX && lastPoint.x <= this.getX() - offsetX + this.getWidth()) continue;
                edge.getPoints().add(2, new Point(lastPoint.x, this.y + this.height / 2));
                continue;
            }
            if (edge.getSourceNode() != this) continue;
            sNode = edge.getSourceNode();
            if (edge.getPoints().size() < 3) continue;
            point = (Point)edge.getPoints().get(1);
            Rectangle rect = (Rectangle)sNode.getRect().clone();
            rect.x -= offsetX;
            rect.y -= offsetY;
            if (rect.contains(point)) continue;
            if (point.x > sNode.getX() - offsetX && point.x < sNode.x - offsetX + sNode.width) {
                point.x = sNode.getX() + sNode.width / 2;
                continue;
            }
            if (point.y <= sNode.getY() - offsetY || point.y >= sNode.y - offsetY + sNode.height || point.x >= sNode.getX() - offsetX && point.x <= sNode.getX() + sNode.width) continue;
            point.y = sNode.getY() + sNode.height / 2;
        }
    }

    public Cursor getMouseCursor(Point point) {
        if (!this.isSelected) {
            return null;
        }
        if (this.rect.contains(point)) {
            int size = this.handles.length;
            for (int i = 0; i < size; ++i) {
                if (this.handles[0].contains(point)) {
                    return Cursor.getPredefinedCursor(6);
                }
                if (this.handles[7].contains(point)) {
                    return Cursor.getPredefinedCursor(5);
                }
                if (this.handles[1].contains(point)) {
                    return Cursor.getPredefinedCursor(10);
                }
                if (this.handles[6].contains(point)) {
                    return Cursor.getPredefinedCursor(11);
                }
                if (this.handles[2].contains(point)) {
                    return Cursor.getPredefinedCursor(4);
                }
                if (this.handles[5].contains(point)) {
                    return Cursor.getPredefinedCursor(7);
                }
                if (this.handles[3].contains(point)) {
                    return Cursor.getPredefinedCursor(8);
                }
                if (!this.handles[4].contains(point)) continue;
                return Cursor.getPredefinedCursor(9);
            }
            return null;
        }
        return null;
    }

    public void updateHandles() {
        this.handles[0] = new Rectangle(this.x, this.y, 6, 6);
        this.handles[1] = new Rectangle(this.x, this.y + (this.height - 6) / 2, 6, 6);
        this.handles[2] = new Rectangle(this.x, this.y + this.height - 6, 6, 6);
        this.handles[3] = new Rectangle(this.x + (this.width - 6) / 2, this.y, 6, 6);
        this.handles[4] = new Rectangle(this.x + (this.width - 6) / 2, this.y + this.height - 6, 6, 6);
        this.handles[5] = new Rectangle(this.x + this.width - 6, this.y, 6, 6);
        this.handles[6] = new Rectangle(this.x + this.width - 6, this.y + (this.height - 6) / 2, 6, 6);
        this.handles[7] = new Rectangle(this.x + this.width - 6, this.y + this.height - 6, 6, 6);
    }

    private void drawChildFlag(Graphics g, HashMap renderMap) {
        if (this.isLeaf()) {
            return;
        }
        this.isExpand = false;
        int size = this.edgeList.size();
        for (int i = 0; i < size; ++i) {
            if (((Edge)this.edgeList.get(i)).getSourceNode() != this) continue;
            this.isExpand = true;
            return;
        }
        if (renderMap.get("FROM_PRINT") != null) {
            return;
        }
        int x = this.x + this.width - 6 - 1;
        int y = this.y + this.height - 6 - 1;
        Color oldColor = g.getColor();
        g.setColor(new Color(116, 175, 184));
        Polygon path = new Polygon();
        path.addPoint(x, y);
        path.addPoint(x + 3, y + 6);
        path.addPoint(x + 6, y);
        g.fillPolygon(path);
        g.setColor(oldColor);
    }

    private void drawHandles(Graphics g, HashMap renderMap) {
        Color oldColor = g.getColor();
        g.setColor(new Color(204, 157, 96));
        if (this.isSelected) {
            int size = this.handles.length;
            for (int i = 0; i < size; ++i) {
                g.drawRect(this.handles[i].x, this.handles[i].y, this.handles[i].width, this.handles[i].height);
            }
        }
        g.setColor(oldColor);
    }

    public void render(Graphics g, HashMap renderMap) {
        Color oldColor = g.getColor();
        g.setColor(this.getBackground());
        g.fillRect(this.rect.x + 1, this.rect.y + 1, this.rect.width - 1, this.rect.height - 1);
        g.setColor(this.borderColor);
        Graphics2D g2d = (Graphics2D)g;
        Stroke oldStroke = g2d.getStroke();
        g2d.setStroke(new BasicStroke(2.0f));
        g.drawRect(this.rect.x, this.rect.y, this.rect.width, this.rect.height);
        g2d.setStroke(oldStroke);
        g.setColor(oldColor);
        IOrgChartTreeBuilder chartBuilder = (IOrgChartTreeBuilder)renderMap.get("CHART_RENDER");
        g.translate(this.x, this.y);
        if (chartBuilder.renderNode(g, this, renderMap)) {
            g.translate(-this.x, -this.y);
            this.drawHandles(g, renderMap);
            this.drawChildFlag(g, renderMap);
            return;
        }
        g.translate(-this.x, -this.y);
        this.drawHandles(g, renderMap);
        if (!StringUtils.isEmpty((String)this.getName())) {
            this.nameList = OrgChartUtil.getPrintScreenStr(this.getName(), this, g.getFontMetrics());
        }
        if (this.nameList == null || this.nameList.size() == 0) {
            return;
        }
        int fontHeight = g.getFontMetrics().getHeight();
        String name = null;
        Font oldFont = g.getFont();
        oldColor = g.getColor();
        g.setFont(this.font);
        g.setColor(this.fontColor);
        int size = this.nameList.size();
        for (int i = 0; i < size; ++i) {
            name = this.nameList.get(i).toString();
            if (this.displayTextType == 1) {
                if (fontHeight * (i + 1) > this.rect.height) break;
                if (i == size - 1) {
                    g.drawString(name, this.rect.x + 6 + (this.rect.width - 12 - g.getFontMetrics().stringWidth(name)) / 2, this.rect.y + fontHeight * (i + 1));
                    continue;
                }
                g.drawString(name, this.rect.x + 6, this.rect.y + fontHeight * (i + 1));
                continue;
            }
            if (fontHeight * (i + 1) > this.rect.width) break;
            StringBuffer sb = new StringBuffer();
            char[] strs = this.nameList.get(i).toString().toCharArray();
            int length = strs.length;
            for (int j = 0; j < length; ++j) {
                String s = String.valueOf(strs[j]);
                if (s.equals("(") || s.equals("\uff08")) {
                    s = "\ufe35";
                }
                if (s.equals(")") || s.equals("\uff09")) {
                    s = "\ufe36";
                }
                sb.append(s);
                g.drawString(s, this.rect.x + 6 + fontHeight * i, this.rect.y + g.getFontMetrics().getHeight() * (j + 1));
            }
        }
        g.setFont(oldFont);
        g.setColor(oldColor);
        this.drawChildFlag(g, renderMap);
    }

    public void setX(int x) {
        int offsetX = x - this.x;
        this.x = x;
        this.rect.x = x;
        if (this.isSelected) {
            this.updateHandles();
        }
        this.adjustEdge(offsetX, 0);
    }

    public int getX() {
        return this.x;
    }

    public void setY(int y) {
        int offsetY = y - this.y;
        this.y = y;
        this.rect.y = y;
        if (this.isSelected) {
            this.updateHandles();
        }
        this.adjustEdge(0, offsetY);
    }

    public int getY() {
        return this.y;
    }

    public void setWidth(int width) {
        if (width < 20) {
            return;
        }
        this.width = width;
        this.rect.width = width;
        if (this.isSelected) {
            this.updateHandles();
        }
    }

    public int getWidth() {
        return this.width;
    }

    public void setHeight(int height) {
        if (height < 20) {
            return;
        }
        this.height = height;
        this.rect.height = height;
        if (this.isSelected) {
            this.updateHandles();
        }
    }

    public int getHeight() {
        return this.height;
    }

    public void setEdgeList(List edgeList) {
        this.edgeList = edgeList;
    }

    public List getEdgeList() {
        return this.edgeList;
    }

    public void addEdge(Edge edge) {
        this.edgeList.add(edge);
    }

    public void removeEdge(Edge edge) {
        this.edgeList.remove(edge);
    }

    public void setDisplayTextType(int displayTextType) {
        this.displayTextType = displayTextType;
    }

    public int getDisplayTextType() {
        return this.displayTextType;
    }

    public Rectangle getRect() {
        return this.rect;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setBackground(Color background) {
        this.background = background;
    }

    public Color getBackground() {
        return this.background;
    }

    public void setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setFontColor(Color fontColor) {
        this.fontColor = fontColor;
    }

    public Color getFontColor() {
        return this.fontColor;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public Font getFont() {
        return this.font;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public void setExpand(boolean isExpand) {
        this.isExpand = isExpand;
    }

    public boolean isExpand() {
        return this.isExpand;
    }

    public void setLeaf(boolean isLeaf) {
        this.isLeaf = isLeaf;
    }

    public boolean isLeaf() {
        return this.isLeaf;
    }

    public void setClientProperty(HashMap clientProperty) {
        this.clientProperty = clientProperty;
    }

    public Map getClientProperty() {
        if (this.clientProperty == null) {
            this.clientProperty = new HashMap();
        }
        return this.clientProperty;
    }
}

