/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.client;

import com.kingdee.bos.ctrl.common.util.FileUtil;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.BaseException;
import com.kingdee.eas.hr.base.IOrgChartHistory;
import com.kingdee.eas.hr.base.OrgChartHistoryFactory;
import com.kingdee.eas.hr.base.OrgChartHistoryInfo;
import com.kingdee.eas.hr.base.OrgChartShowEnum;
import com.kingdee.eas.hr.base.client.AbstractOrgChartMainUI;
import com.kingdee.eas.hr.base.client.DesignerPanel;
import com.kingdee.eas.hr.base.client.Edge;
import com.kingdee.eas.hr.base.client.FindChartNodeDialog;
import com.kingdee.eas.hr.base.client.IOrgChartTreeBuilder;
import com.kingdee.eas.hr.base.client.Node;
import com.kingdee.eas.hr.base.client.OrgChartHistoryListUI;
import com.kingdee.eas.hr.base.client.OrgChartHistorySaveUI;
import com.kingdee.eas.hr.base.client.OrgChartPrintPreviewUI;
import com.kingdee.eas.hr.base.client.OrgChartStyleSelectUI;
import com.kingdee.eas.hr.base.client.OrgChartSwitchUI;
import com.kingdee.eas.hr.base.client.OrgChartTreeBuilder;
import com.kingdee.eas.hr.base.client.OutLinePanel;
import com.kingdee.eas.hr.base.client.Property;
import com.kingdee.eas.hr.base.client.PropertySheetTable;
import com.kingdee.eas.hr.base.client.PropertySheetTableModel;
import com.kingdee.eas.hr.base.util.HRFileUtil;
import com.kingdee.eas.hr.base.util.OrgChartUtil;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileFilter;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class OrgChartMainUI
extends AbstractOrgChartMainUI
implements PropertyChangeListener {
    private DesignerPanel designerPanel = null;
    private PropertySheetTable table = null;
    private OutLinePanel outLinePanel = null;
    private IOrgChartTreeBuilder chartBuilder = null;
    private PageFormat pageFormat = null;
    private OrgChartHistoryInfo chartHistoryInfo = null;
    private IUIWindow orgChartStyleSelectDialog = null;
    private IUIWindow orgChartSwitchDialog = null;

    public IOrgChartTreeBuilder getChartBuilder() {
        return this.chartBuilder;
    }

    private void initAlginButtons() {
        this.btnLeftAlign.setIcon(EASResource.getIcon((String)"tbtn_left.gif"));
        this.btnRightAlign.setIcon(EASResource.getIcon((String)"tbtn_right.gif"));
        this.btnTopAlign.setIcon(EASResource.getIcon((String)"tbtn_top.gif"));
        this.btnBottomAlign.setIcon(EASResource.getIcon((String)"tbtn_bottom.gif"));
        this.btnSameWidth.setIcon(EASResource.getIcon((String)"tbtn_width.gif"));
        this.btnSameHeight.setIcon(EASResource.getIcon((String)"tbtn_hight.gif"));
        this.btnSameWidthAndHeight.setIcon(EASResource.getIcon((String)"tbtn_dx.gif"));
        this.btnSameHorizontalGap.setIcon(EASResource.getIcon((String)"tbtn_hxspace.gif"));
        this.btnSameVerticalGap.setIcon(EASResource.getIcon((String)"tbtn_zxspace.gif"));
        this.btnAddHorizontalGap.setIcon(EASResource.getIcon((String)"tbtn_addhxspace.gif"));
        this.btnReduceHorizontalGap.setIcon(EASResource.getIcon((String)"tbtn_dechxspace.gif"));
        this.btnAddVerticalGap.setIcon(EASResource.getIcon((String)"tbtn_addzxspace.gif"));
        this.btnReduceVerticalGap.setIcon(EASResource.getIcon((String)"tbtn_deczxspace.gif"));
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.initAlginButtons();
        this.leftSplitPane.setDividerLocation(0.6);
        this.leftSplitPane.setResizeWeight(0.6);
        this.rightSplitPane.setDividerLocation(1.0);
        this.rightSplitPane.setResizeWeight(1.0);
        this.rightSplitPane.setEnabled(false);
        this.splitPane.setDividerLocation(0.3);
        this.splitPane.setResizeWeight(0.3);
        this.rightSplitPane.setOneTouchExpandable(false);
        this.btnNormalSize.setIcon(EASResource.getIcon((String)"imgTbtn_trimsize"));
        this.btnZoomOut.setIcon(EASResource.getIcon((String)"imgTbtn_zoomin"));
        this.btnZoomIn.setIcon(EASResource.getIcon((String)"imgTbtn_zoomout"));
        this.btnExpand.setIcon(EASCommonResource.getIcon((String)"com.kingdee.eas.basedata.common.EASImageResource", (String)"imgTbtn_expand", (Locale)SysContext.getSysContext().getLocale()));
        this.btnUnExpand.setIcon(EASCommonResource.getIcon((String)"com.kingdee.eas.basedata.common.EASImageResource", (String)"imgTbtn_constriction", (Locale)SysContext.getSysContext().getLocale()));
        try {
            this.chartBuilder = new OrgChartTreeBuilder();
            this.chartBuilder.setShowSealUp(false);
            this.chartBuilder.setShowVirtualOrg(false);
            this.chartBuilder.builder();
            this.designerPanel = new DesignerPanel(this.chartBuilder.getNodeList(), this.chartBuilder.getEdgeList(), this.chartBuilder);
            this.designerPanel.addPropertyChangeListener(this);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        this.table = new PropertySheetTable();
        PropertySheetTableModel model = new PropertySheetTableModel();
        model.setProperties(this.createChartPropertys(null));
        this.table.setModel(model);
        this.table.getColumnModel().getColumn(0).setMaxWidth(80);
        this.table.getColumnModel().getColumn(0).setResizable(false);
        this.leftSplitPane.setTopComponent((Component)new JScrollPane(this.table));
        this.rightSplitPane.setLeftComponent((Component)new KDScrollPane((Component)this.designerPanel));
        this.rightSplitPane.setRightComponent((Component)new KDPanel());
        if (this.chartBuilder.getRootNode() != null) {
            Node node = this.chartBuilder.getRootNode();
            this.designerPanel.setRootNode(node);
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            int x = (int)(screenSize.getWidth() * 0.7 * 0.8 * 0.5 - (double)node.getWidth() / 2.0);
            ((JViewport)this.designerPanel.getParent()).setViewPosition(new Point(node.getX() - x, node.getY()));
        }
        KDPanel bottomPanel = new KDPanel();
        bottomPanel.setBorder(BorderFactory.createEtchedBorder(1));
        bottomPanel.setLayout((LayoutManager)new BorderLayout());
        this.outLinePanel = new OutLinePanel(this.designerPanel);
        bottomPanel.add((Component)((Object)this.outLinePanel), (Object)"Center");
        this.leftSplitPane.setBottomComponent((Component)bottomPanel);
        this.setUITitle(this.resHelper.getString("this.title"));
    }

    public void onLoad() throws Exception {
        super.onLoad();
        UndoAction undoAction = new UndoAction(this.designerPanel);
        RedoAction redoAction = new RedoAction(this.designerPanel);
        this.getInputMap(2).put(KeyStroke.getKeyStroke(90, 2), undoAction.getValue("Name"));
        this.getInputMap(2).put(KeyStroke.getKeyStroke(89, 128), redoAction.getValue("Name"));
        this.getActionMap().put("UndoAction", undoAction);
        this.getActionMap().put("RedoAction", redoAction);
    }

    private void undo() throws Exception {
        this.designerPanel.undo();
    }

    @Override
    protected void btnZoomIn_actionPerformed(ActionEvent e) throws Exception {
        super.btnZoomIn_actionPerformed(e);
        this.designerPanel.zoomIn();
    }

    @Override
    protected void btnZoomOut_actionPerformed(ActionEvent e) throws Exception {
        super.btnZoomOut_actionPerformed(e);
        this.designerPanel.zoomOut();
    }

    @Override
    protected void btnExpand_actionPerformed(ActionEvent e) throws Exception {
        super.btnExpand_actionPerformed(e);
        if (this.designerPanel.getSelectedNodes().size() != 1) {
            return;
        }
        Node node = (Node)this.designerPanel.getSelectedNodes().get(0);
        if (node.isLeaf() || node.isExpand()) {
            return;
        }
        if (this.orgChartStyleSelectDialog == null) {
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"Owner", (Object)this);
            IUIFactory uiFactory = null;
            uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
            this.orgChartStyleSelectDialog = uiFactory.create(OrgChartStyleSelectUI.class.getName(), (Map)uiContext);
        }
        this.orgChartStyleSelectDialog.show();
        if (((OrgChartStyleSelectUI)this.orgChartStyleSelectDialog.getUIObject()).isCanceled()) {
            return;
        }
        int chartStyle = ((OrgChartStyleSelectUI)this.orgChartStyleSelectDialog.getUIObject()).getSelectedChartStyle();
        HashMap map = null;
        if (this.chartBuilder != null) {
            map = this.chartBuilder.builderChildNodes(node, chartStyle);
        }
        if (map == null) {
            return;
        }
        node.setExpand(true);
        ArrayList nodeList = (ArrayList)map.get("NODE_LIST");
        ArrayList edgeList = (ArrayList)map.get("EDGE_LIST");
        this.designerPanel.appendChildNode(nodeList, edgeList);
    }

    @Override
    protected void btnUnExpand_actionPerformed(ActionEvent e) throws Exception {
        super.btnUnExpand_actionPerformed(e);
        if (this.designerPanel.getSelectedNodes().size() != 1) {
            return;
        }
        Node node = (Node)this.designerPanel.getSelectedNodes().get(0);
        node.setExpand(false);
        this.designerPanel.removeChildNode(node);
    }

    @Override
    protected void btnExportToPicture_actionPerformed(ActionEvent e) throws Exception {
        super.btnExportToPicture_actionPerformed(e);
        KDFileChooser fileChooser = new KDFileChooser();
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                String extension = FileUtil.getExtension((File)f);
                if (extension != null) {
                    return extension.equalsIgnoreCase("jpg") || extension.equalsIgnoreCase("jpeg");
                }
                return false;
            }

            @Override
            public String getDescription() {
                return "JPEG ( *.jpg;*.jpeg )";
            }
        });
        int result = fileChooser.showSaveDialog((Component)((Object)this));
        if (result != 0) {
            return;
        }
        File file = fileChooser.getSelectedFile();
        if (null != file.getParentFile() && !file.getParentFile().isDirectory()) {
            throw new BaseException(BaseException.OUTPUT_FILE_ERROR);
        }
        if (!file.getAbsolutePath().endsWith(".jpg") && !file.getAbsolutePath().endsWith(".jpeg")) {
            file = new File(file.getAbsolutePath() + ".jpg");
        }
        if (file.exists()) {
            if (MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.basedata.org.client.OrgResource.FILE_IS_EXIST")) != 0) {
                return;
            }
        } else {
            HRFileUtil.validateFile(file);
        }
        int w = this.designerPanel.getPreferredSize().width;
        int h = this.designerPanel.getPreferredSize().height;
        BufferedImage image = (BufferedImage)this.designerPanel.createImage(w, h);
        Graphics2D g2 = image.createGraphics();
        this.designerPanel.getRenderMap().put("FROM_PRINT", Boolean.TRUE);
        this.designerPanel.print(g2);
        this.designerPanel.getRenderMap().remove("FROM_PRINT");
        try (FilterOutputStream bos = null;){
            bos = new BufferedOutputStream(new FileOutputStream(file));
            ImageIO.write((RenderedImage)image, "jpg", bos);
        }
    }

    @Override
    protected void btnPrint_actionPerformed(ActionEvent e) throws Exception {
        super.btnPrint_actionPerformed(e);
        this.designerPanel.getRenderMap().put("FROM_PRINT", Boolean.TRUE);
        PrinterJob pj = PrinterJob.getPrinterJob();
        if (this.pageFormat == null) {
            this.pageFormat = pj.defaultPage();
        }
        pj.setPrintable(this.designerPanel, this.pageFormat);
        if (pj.printDialog()) {
            pj.print();
        }
        this.designerPanel.getRenderMap().remove("FROM_PRINT");
    }

    @Override
    protected void btnPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.btnPrintPreview_actionPerformed(e);
        this.designerPanel.getRenderMap().put("FROM_PRINT", Boolean.TRUE);
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"Owner", (Object)this);
        uiContext.put((Object)"DesignerPanel", (Object)this.designerPanel);
        IUIFactory uiFactory = null;
        uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow curDialog = uiFactory.create(OrgChartPrintPreviewUI.class.getName(), (Map)uiContext);
        ((JDialog)curDialog).setVisible(true);
        if (this.getClientProperty("PAGEFORMAT") != null) {
            this.pageFormat = (PageFormat)this.getClientProperty("PAGEFORMAT");
        }
        this.designerPanel.getRenderMap().remove("FROM_PRINT");
    }

    @Override
    protected void btnSwitchOrg_actionPerformed(ActionEvent e) throws Exception {
        super.btnSwitchOrg_actionPerformed(e);
        if (this.orgChartSwitchDialog == null) {
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"Owner", (Object)this);
            IUIFactory uiFactory = null;
            uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
            this.orgChartSwitchDialog = uiFactory.create(OrgChartSwitchUI.class.getName(), (Map)uiContext);
        }
        this.orgChartSwitchDialog.show();
        if (((OrgChartSwitchUI)this.orgChartSwitchDialog.getUIObject()).isCanceled()) {
            return;
        }
        OrgChartSwitchUI switchUI = (OrgChartSwitchUI)this.orgChartSwitchDialog.getUIObject();
        this.chartBuilder = switchUI.getChartBuilder();
        this.chartBuilder.setShowSealUp(false);
        this.chartBuilder.setShowVirtualOrg(false);
        this.chartBuilder.builder();
        this.designerPanel.setChartBuilder(this.chartBuilder);
        this.chartHistoryInfo = null;
    }

    @Override
    protected void btnOpenHistory_actionPerformed(ActionEvent e) throws Exception {
        super.btnOpenHistory_actionPerformed(e);
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"Owner", (Object)this);
        IUIFactory uiFactory = null;
        uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow curDialog = uiFactory.create(OrgChartHistoryListUI.class.getName(), (Map)uiContext);
        curDialog.show();
        if (((OrgChartHistoryListUI)curDialog.getUIObject()).isCanceled()) {
            return;
        }
        this.chartHistoryInfo = ((OrgChartHistoryListUI)curDialog.getUIObject()).getOrgChartHistoryInfo();
        String buildClassName = this.chartHistoryInfo.getBuilderClassName();
        Class<?> classObj = Class.forName(buildClassName);
        this.chartBuilder = (IOrgChartTreeBuilder)classObj.newInstance();
        List nodesAndEdges = this.chartBuilder.getNodesAndEdgesAndBgFromXML(this.chartHistoryInfo.getChartXmlData());
        ArrayList nodeList = (ArrayList)nodesAndEdges.get(0);
        ArrayList edgeList = (ArrayList)nodesAndEdges.get(1);
        if (nodesAndEdges.size() > 2) {
            String mainBackgroundColor = (String)nodesAndEdges.get(2);
            Color bgColor = new Color(Integer.parseInt(mainBackgroundColor));
            this.designerPanel.setBackground(bgColor);
        } else {
            this.designerPanel.setBackground(new Color(255, 255, 255));
        }
        this.designerPanel.reset(this.chartBuilder, nodeList, edgeList);
    }

    @Override
    protected void btnRemove_actionPerformed(ActionEvent e) throws Exception {
        super.btnRemove_actionPerformed(e);
        if (this.designerPanel.getSelectedNodes() == null || this.designerPanel.getSelectedNodes().size() == 0) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.base.BASEAutoGenerateResource", (String)"87_OrgChartMainUI"));
            return;
        }
        if (MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.base.BASEAutoGenerateResource", (String)"88_OrgChartMainUI")))) {
            List nodes = this.designerPanel.getSelectedNodes();
            Node node = null;
            List edges = null;
            Edge edge = null;
            int size = nodes.size();
            for (int i = 0; i < size; ++i) {
                node = (Node)nodes.get(i);
                edges = node.getEdgeList();
                int length = edges.size();
                for (int t = 0; t < length; ++t) {
                    edge = (Edge)edges.get(t);
                    if (edge.getTargetNode().isSelected) continue;
                    MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.base.BASEAutoGenerateResource", (String)"89_OrgChartMainUI"));
                    return;
                }
            }
            this.designerPanel.removeNodes(nodes);
        }
    }

    @Override
    protected void btnSaveToHistory_actionPerformed(ActionEvent e) throws Exception {
        super.btnSaveToHistory_actionPerformed(e);
        String name = null;
        if (this.chartHistoryInfo == null) {
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"Owner", (Object)this);
            IUIFactory uiFactory = null;
            uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
            IUIWindow curDialog = uiFactory.create(OrgChartHistorySaveUI.class.getName(), (Map)uiContext);
            curDialog.show();
            if (((OrgChartHistorySaveUI)curDialog.getUIObject()).isCanceled()) {
                return;
            }
            name = ((OrgChartHistorySaveUI)curDialog.getUIObject()).getName();
        } else {
            name = this.chartHistoryInfo.getName();
        }
        Document doc = new Document();
        Element root = new Element("OrgChart");
        doc.setRootElement(root);
        Element nodesAndEdges = this.chartBuilder.saveNodesAndEdgesAndBgToXML(this.designerPanel.getNodeList(), this.designerPanel.getEdgeList(), this.designerPanel.getBackground());
        root.addContent((Content)nodesAndEdges);
        XMLOutputter outp = new XMLOutputter();
        Format format = Format.getCompactFormat();
        format.setEncoding("utf-8");
        outp.setFormat(format);
        String chartXMLData = outp.outputString(doc);
        IOrgChartHistory iChartHistory = OrgChartHistoryFactory.getRemoteInstance();
        if (this.chartHistoryInfo == null) {
            this.chartHistoryInfo = new OrgChartHistoryInfo();
        }
        this.chartHistoryInfo.setName(name);
        this.chartHistoryInfo.setChartXmlData(chartXMLData);
        this.chartHistoryInfo.setBuilderClassName(this.chartBuilder.getClass().getName());
        this.chartHistoryInfo.setHrOrgUnit(SysContext.getSysContext().getCurrentHRUnit());
        IObjectPK pk = iChartHistory.submit((CoreBaseInfo)this.chartHistoryInfo);
        this.chartHistoryInfo = iChartHistory.getOrgChartHistoryInfo(pk);
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.base.BASEAutoGenerateResource", (String)"90_OrgChartMainUI"));
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        List selectedNodes = this.designerPanel.getSelectedNodes();
        List selectedEdges = this.designerPanel.getSelectedEdges();
        if (evt.getNewValue() instanceof DesignerPanel) {
            if (selectedNodes.size() > 1 && selectedEdges.size() > 1) {
                this.table.setEnabled(false);
                return;
            }
            this.table.setEnabled(true);
            if (this.table.getCellEditor() != null) {
                this.table.getCellEditor().cancelCellEditing();
            }
            PropertySheetTableModel model = (PropertySheetTableModel)this.table.getModel();
            if (selectedNodes.size() == 0 && selectedEdges.size() == 0) {
                model.setProperties(this.createChartPropertys(evt));
            } else if (selectedNodes.size() > 0) {
                Node node = (Node)selectedNodes.get(0);
                model.setProperties(this.createNodePropertys(node));
            } else {
                model.clear();
            }
        } else {
            Property property = (Property)evt.getSource();
            if (selectedNodes.size() > 0) {
                Node node = null;
                int size = selectedNodes.size();
                for (int i = 0; i < size; ++i) {
                    node = (Node)selectedNodes.get(i);
                    if (property.getName().equals(EASResource.getString((String)"com.kingdee.eas.hr.base.BASEAutoGenerateResource", (String)"91_OrgChartMainUI"))) {
                        node.setBackground((Color)evt.getNewValue());
                        continue;
                    }
                    if (property.getName().equals(EASResource.getString((String)"com.kingdee.eas.hr.base.BASEAutoGenerateResource", (String)"92_OrgChartMainUI"))) {
                        node.setName(evt.getNewValue().toString());
                        continue;
                    }
                    if (property.getName().equals(EASResource.getString((String)"com.kingdee.eas.hr.base.BASEAutoGenerateResource", (String)"153_OrgChartMainUI"))) {
                        try {
                            node.setY(Integer.valueOf(evt.getNewValue().toString()));
                        }
                        catch (NumberFormatException e) {
                            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.base.BASEAutoGenerateResource", (String)"93_OrgChartMainUI"));
                        }
                        continue;
                    }
                    if (property.getName().equals(EASResource.getString((String)"com.kingdee.eas.hr.base.BASEAutoGenerateResource", (String)"154_OrgChartMainUI"))) {
                        try {
                            node.setX(Integer.valueOf(evt.getNewValue().toString()));
                        }
                        catch (NumberFormatException e) {
                            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.base.BASEAutoGenerateResource", (String)"93_OrgChartMainUI"));
                        }
                        continue;
                    }
                    if (property.getName().equals(EASResource.getString((String)"com.kingdee.eas.hr.base.BASEAutoGenerateResource", (String)"94_OrgChartMainUI"))) {
                        try {
                            node.setWidth(Integer.valueOf(evt.getNewValue().toString()));
                        }
                        catch (NumberFormatException e) {
                            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.base.BASEAutoGenerateResource", (String)"93_OrgChartMainUI"));
                        }
                        continue;
                    }
                    if (property.getName().equals(EASResource.getString((String)"com.kingdee.eas.hr.base.BASEAutoGenerateResource", (String)"95_OrgChartMainUI"))) {
                        try {
                            node.setHeight(Integer.valueOf(evt.getNewValue().toString()));
                        }
                        catch (NumberFormatException e) {
                            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.base.BASEAutoGenerateResource", (String)"93_OrgChartMainUI"));
                        }
                        continue;
                    }
                    if (property.getName().equals(EASResource.getString((String)"com.kingdee.eas.hr.base.BASEAutoGenerateResource", (String)"96_OrgChartMainUI"))) {
                        node.setFont((Font)evt.getNewValue());
                        continue;
                    }
                    if (property.getName().equals(EASResource.getString((String)"com.kingdee.eas.hr.base.BASEAutoGenerateResource", (String)"97_OrgChartMainUI"))) {
                        node.setFontColor((Color)evt.getNewValue());
                        continue;
                    }
                    if (property.getName().equals(EASResource.getString((String)"com.kingdee.eas.hr.base.BASEAutoGenerateResource", (String)"98_OrgChartMainUI"))) {
                        node.setBorderColor((Color)evt.getNewValue());
                        continue;
                    }
                    if (!property.getName().equals(EASResource.getString((String)"com.kingdee.eas.hr.base.BASEAutoGenerateResource", (String)"139_OrgChartMainUI"))) continue;
                    node.setDisplayTextType(((OrgChartShowEnum)((Object)evt.getNewValue())).getValue());
                }
                this.designerPanel.repaint();
            } else if (property.getName().equals(EASResource.getString((String)"com.kingdee.eas.hr.base.BASEAutoGenerateResource", (String)"91_OrgChartMainUI"))) {
                this.designerPanel.setBackground((Color)evt.getNewValue());
            } else if (property.getName().equals(EASResource.getString((String)"com.kingdee.eas.hr.base.BASEAutoGenerateResource", (String)"99_OrgChartMainUI"))) {
                this.designerPanel.setEdgeColor((Color)evt.getNewValue());
            } else if (property.getName().equals(EASResource.getString((String)"com.kingdee.eas.hr.base.BASEAutoGenerateResource", (String)"100_OrgChartMainUI"))) {
                this.designerPanel.setNodeBorderColor((Color)evt.getNewValue());
            } else if (property.getName().equals(EASResource.getString((String)"com.kingdee.eas.hr.base.BASEAutoGenerateResource", (String)"101_OrgChartMainUI"))) {
                this.designerPanel.setNodeBackgroundColor((Color)evt.getNewValue());
            } else if (property.getName().equals(EASResource.getString((String)"com.kingdee.eas.hr.base.BASEAutoGenerateResource", (String)"96_OrgChartMainUI"))) {
                this.designerPanel.setContentFont((Font)evt.getNewValue());
            } else if (property.getName().equals(EASResource.getString((String)"com.kingdee.eas.hr.base.BASEAutoGenerateResource", (String)"97_OrgChartMainUI"))) {
                this.designerPanel.setFontColor((Color)evt.getNewValue());
            }
        }
        this.outLinePanel.repaint();
    }

    private Property[] createNodePropertys(Node node) {
        Property[] propertys = new Property[10];
        Property property = new Property();
        property.setName(EASResource.getString((String)"com.kingdee.eas.hr.base.BASEAutoGenerateResource", (String)"92_OrgChartMainUI"));
        property.setValue(node.getName());
        property.addPropertyChangeListener(this);
        if (this.designerPanel.getSelectedNodes().size() == 1) {
            property.setEditable(true);
        }
        propertys[0] = property;
        property = new Property();
        property.setName(EASResource.getString((String)"com.kingdee.eas.hr.base.BASEAutoGenerateResource", (String)"91_OrgChartMainUI"));
        property.setValue(node.getBackground());
        property.setType(2);
        property.addPropertyChangeListener(this);
        property.setEditable(true);
        propertys[1] = property;
        property = new Property();
        property.setName(EASResource.getString((String)"com.kingdee.eas.hr.base.BASEAutoGenerateResource", (String)"96_OrgChartMainUI"));
        property.setValue(node.getFont());
        property.setType(3);
        property.addPropertyChangeListener(this);
        property.setEditable(true);
        propertys[2] = property;
        property = new Property();
        property.setName(EASResource.getString((String)"com.kingdee.eas.hr.base.BASEAutoGenerateResource", (String)"139_OrgChartMainUI"));
        property.setValue((Object)OrgChartShowEnum.getEnum(node.getDisplayTextType()));
        property.addPropertyChangeListener(this);
        property.setType(4);
        property.setEditable(true);
        propertys[3] = property;
        property = new Property();
        property.setName(EASResource.getString((String)"com.kingdee.eas.hr.base.BASEAutoGenerateResource", (String)"97_OrgChartMainUI"));
        property.setValue(node.getFontColor());
        property.setType(2);
        property.addPropertyChangeListener(this);
        property.setEditable(true);
        propertys[4] = property;
        property = new Property();
        property.setName(EASResource.getString((String)"com.kingdee.eas.hr.base.BASEAutoGenerateResource", (String)"98_OrgChartMainUI"));
        property.setValue(node.getBorderColor());
        property.setType(2);
        property.addPropertyChangeListener(this);
        property.setEditable(true);
        propertys[5] = property;
        property = new Property();
        property.setName(EASResource.getString((String)"com.kingdee.eas.hr.base.BASEAutoGenerateResource", (String)"95_OrgChartMainUI"));
        property.setValue(node.getHeight());
        property.addPropertyChangeListener(this);
        property.setEditable(true);
        propertys[6] = property;
        property = new Property();
        property.setName(EASResource.getString((String)"com.kingdee.eas.hr.base.BASEAutoGenerateResource", (String)"94_OrgChartMainUI"));
        property.setValue(node.getWidth());
        property.addPropertyChangeListener(this);
        property.setEditable(true);
        propertys[7] = property;
        property = new Property();
        property.setName(EASResource.getString((String)"com.kingdee.eas.hr.base.BASEAutoGenerateResource", (String)"153_OrgChartMainUI"));
        property.setValue(node.getY());
        property.addPropertyChangeListener(this);
        property.setEditable(true);
        propertys[8] = property;
        property = new Property();
        property.setName(EASResource.getString((String)"com.kingdee.eas.hr.base.BASEAutoGenerateResource", (String)"154_OrgChartMainUI"));
        property.setValue(node.getX());
        property.addPropertyChangeListener(this);
        property.setEditable(true);
        propertys[9] = property;
        return propertys;
    }

    private Property[] createChartPropertys(PropertyChangeEvent evt) {
        Property[] propertys = new Property[10];
        Property property = new Property();
        property.setName(EASResource.getString((String)"com.kingdee.eas.hr.base.BASEAutoGenerateResource", (String)"91_OrgChartMainUI"));
        property.setValue(this.designerPanel.getBackground());
        property.setType(2);
        property.addPropertyChangeListener(this);
        property.setEditable(true);
        propertys[0] = property;
        property = new Property();
        property.setName(EASResource.getString((String)"com.kingdee.eas.hr.base.BASEAutoGenerateResource", (String)"96_OrgChartMainUI"));
        property.setValue(this.designerPanel.getContentFont());
        property.setType(3);
        property.addPropertyChangeListener(this);
        property.setEditable(true);
        propertys[1] = property;
        property = new Property();
        property.setName(EASResource.getString((String)"com.kingdee.eas.hr.base.BASEAutoGenerateResource", (String)"97_OrgChartMainUI"));
        property.setValue(this.designerPanel.getFontColor());
        property.setType(2);
        property.addPropertyChangeListener(this);
        property.setEditable(true);
        propertys[2] = property;
        property = new Property();
        property.setName(EASResource.getString((String)"com.kingdee.eas.hr.base.BASEAutoGenerateResource", (String)"99_OrgChartMainUI"));
        property.setValue(this.designerPanel.getEdgeColor());
        property.setType(2);
        property.addPropertyChangeListener(this);
        property.setEditable(true);
        propertys[3] = property;
        property = new Property();
        property.setName(EASResource.getString((String)"com.kingdee.eas.hr.base.BASEAutoGenerateResource", (String)"100_OrgChartMainUI"));
        property.setValue(this.designerPanel.getNodeBorderColor());
        property.setType(2);
        property.addPropertyChangeListener(this);
        property.setEditable(true);
        propertys[4] = property;
        property = new Property();
        property.setName(EASResource.getString((String)"com.kingdee.eas.hr.base.BASEAutoGenerateResource", (String)"101_OrgChartMainUI"));
        property.setValue(this.designerPanel.getNodeBackgroundColor());
        property.setType(2);
        property.addPropertyChangeListener(this);
        property.setEditable(true);
        propertys[5] = property;
        property = new Property();
        property.setName(EASResource.getString((String)"com.kingdee.eas.hr.base.BASEAutoGenerateResource", (String)"95_OrgChartMainUI"));
        property.setValue(this.designerPanel.getHeight());
        property.addPropertyChangeListener(this);
        propertys[6] = property;
        property = new Property();
        property.setName(EASResource.getString((String)"com.kingdee.eas.hr.base.BASEAutoGenerateResource", (String)"94_OrgChartMainUI"));
        property.setValue(this.designerPanel.getWidth());
        property.addPropertyChangeListener(this);
        propertys[7] = property;
        MouseEvent event = null;
        if (evt != null && evt.getOldValue() instanceof MouseEvent) {
            event = (MouseEvent)evt.getOldValue();
        }
        property = new Property();
        property.setName(EASResource.getString((String)"com.kingdee.eas.hr.base.BASEAutoGenerateResource", (String)"102_OrgChartMainUI"));
        if (event != null) {
            property.setValue(event.getPoint().x);
        }
        property.setEditable(false);
        property.addPropertyChangeListener(this);
        propertys[8] = property;
        property = new Property();
        property.setName(EASResource.getString((String)"com.kingdee.eas.hr.base.BASEAutoGenerateResource", (String)"103_OrgChartMainUI"));
        if (event != null) {
            property.setValue(event.getPoint().y);
        }
        property.setEditable(false);
        property.addPropertyChangeListener(this);
        propertys[9] = property;
        return propertys;
    }

    @Override
    protected void btnAddHorizontalGap_actionPerformed(ActionEvent e) throws Exception {
        super.btnAddHorizontalGap_actionPerformed(e);
        OrgChartUtil.addHorizontalGap(this.designerPanel);
    }

    @Override
    protected void btnAddVerticalGap_actionPerformed(ActionEvent e) throws Exception {
        super.btnAddVerticalGap_actionPerformed(e);
        OrgChartUtil.addVerticalGap(this.designerPanel);
    }

    @Override
    protected void btnLeftAlign_actionPerformed(ActionEvent e) throws Exception {
        super.btnLeftAlign_actionPerformed(e);
        OrgChartUtil.alignLeft(this.designerPanel);
    }

    @Override
    protected void btnReduceHorizontalGap_actionPerformed(ActionEvent e) throws Exception {
        super.btnReduceHorizontalGap_actionPerformed(e);
        OrgChartUtil.reduceHorizontalGap(this.designerPanel);
    }

    @Override
    protected void btnReduceVerticalGap_actionPerformed(ActionEvent e) throws Exception {
        super.btnReduceVerticalGap_actionPerformed(e);
        OrgChartUtil.reduceVerticalGap(this.designerPanel);
    }

    @Override
    protected void btnRightAlign_actionPerformed(ActionEvent e) throws Exception {
        super.btnRightAlign_actionPerformed(e);
        OrgChartUtil.alignRight(this.designerPanel);
    }

    @Override
    protected void btnSameHeight_actionPerformed(ActionEvent e) throws Exception {
        super.btnSameHeight_actionPerformed(e);
        OrgChartUtil.setSameHeight(this.designerPanel);
    }

    @Override
    protected void btnSameHorizontalGap_actionPerformed(ActionEvent e) throws Exception {
        super.btnSameHorizontalGap_actionPerformed(e);
        OrgChartUtil.setHorizontalGapEqual(this.designerPanel);
    }

    @Override
    protected void btnSameVerticalGap_actionPerformed(ActionEvent e) throws Exception {
        super.btnSameVerticalGap_actionPerformed(e);
        OrgChartUtil.setVerticalGapEqual(this.designerPanel);
    }

    @Override
    protected void btnSameWidth_actionPerformed(ActionEvent e) throws Exception {
        super.btnSameWidth_actionPerformed(e);
        OrgChartUtil.setSameWidth(this.designerPanel);
    }

    @Override
    protected void btnSameWidthAndHeight_actionPerformed(ActionEvent e) throws Exception {
        super.btnSameWidthAndHeight_actionPerformed(e);
        OrgChartUtil.setSameWidthAndHeight(this.designerPanel);
    }

    @Override
    protected void btnTopAlign_actionPerformed(ActionEvent e) throws Exception {
        super.btnTopAlign_actionPerformed(e);
        OrgChartUtil.alignTop(this.designerPanel);
    }

    @Override
    protected void btnBottomAlign_actionPerformed(ActionEvent e) throws Exception {
        super.btnBottomAlign_actionPerformed(e);
        OrgChartUtil.alignBottom(this.designerPanel);
    }

    @Override
    protected void btnLocate_actionPerformed(ActionEvent e) throws Exception {
        super.btnLocate_actionPerformed(e);
        FindChartNodeDialog findDialog = new FindChartNodeDialog(this.designerPanel);
        findDialog.show();
    }

    @Override
    protected void btnNormalSize_actionPerformed(ActionEvent e) throws Exception {
        super.btnNormalSize_actionPerformed(e);
        this.designerPanel.resetZoom();
    }

    @Override
    public void actionSaveAsToHistory_actionPerformed(ActionEvent e) throws Exception {
        super.actionSaveAsToHistory_actionPerformed(e);
        if (this.chartHistoryInfo != null) {
            String name = null;
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"Owner", (Object)this);
            IUIFactory uiFactory = null;
            uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
            IUIWindow curDialog = uiFactory.create(OrgChartHistorySaveUI.class.getName(), (Map)uiContext);
            curDialog.show();
            if (((OrgChartHistorySaveUI)curDialog.getUIObject()).isCanceled()) {
                return;
            }
            name = ((OrgChartHistorySaveUI)curDialog.getUIObject()).getName();
            this.chartHistoryInfo.setName(name);
            this.chartHistoryInfo.setId(null);
        }
        this.btnSaveToHistory_actionPerformed(e);
    }

    static class RedoAction
    extends AbstractAction {
        DesignerPanel dp;

        public RedoAction(DesignerPanel dp) {
            super("RedoAction");
            this.dp = dp;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.dp.redo();
        }
    }

    static class UndoAction
    extends AbstractAction {
        DesignerPanel dp;

        public UndoAction(DesignerPanel dp) {
            super("UndoAction");
            this.dp = dp;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.dp.undo();
        }
    }
}

