/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.client;

import com.kingdee.bos.ctrl.swing.KDFont;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.hr.base.BaseInnerFacadeFactory;
import com.kingdee.eas.hr.base.IBaseInnerFacade;
import com.kingdee.eas.hr.base.client.Edge;
import com.kingdee.eas.hr.base.client.Node;
import com.kingdee.eas.hr.base.client.OrgChartTreeBaseBuilder;
import com.kingdee.eas.hr.base.util.OrgChartUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.sql.Blob;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;

public class OrgChartPersonPhotoBuilder
extends OrgChartTreeBaseBuilder {
    private HashMap posiMap = new HashMap();
    private HashMap perMap = new HashMap();
    private HashMap photoMap = new HashMap();
    private Image img = new ImageIcon(EASResource.getImage((String)"imgWf_manual")).getImage();

    @Override
    public boolean renderNode(Graphics g, Node node, HashMap renderMap) {
        Rectangle rect = node.getRect();
        String name = node.getName();
        Color fontColor = node.getFontColor();
        Color splitLineColor = new Color(210, 208, 160);
        if (StringUtils.isEmpty((String)name)) {
            return true;
        }
        List nameList = OrgChartUtil.getPrintScreenStr(name, node, g.getFontMetrics());
        name = nameList.get(0).toString();
        int fontHeight = g.getFontMetrics().getHeight();
        Color oldColor = g.getColor();
        g.setColor(fontColor);
        g.drawString(name, 6 + (rect.width - 12 - g.getFontMetrics().stringWidth(name)) / 2, fontHeight);
        g.setColor(oldColor);
        Graphics2D g2d = (Graphics2D)g;
        Stroke oldStroke = g2d.getStroke();
        oldColor = g2d.getColor();
        g2d.setStroke(new BasicStroke(2.0f));
        g2d.setColor(splitLineColor);
        g2d.drawLine(5, fontHeight + 6, node.getWidth() - 5, fontHeight + 6);
        g2d.setColor(oldColor);
        g2d.setStroke(oldStroke);
        if (node.getClientProperty().get("Position_Name") == null) {
            PositionInfo posiInfo = (PositionInfo)this.posiMap.get(node.getId());
            if (posiInfo == null) {
                return true;
            }
            name = posiInfo.getName();
            node.getClientProperty().put("Position_Name", name);
            node.getClientProperty().put("Position_ID", posiInfo.getId().toString());
        } else {
            name = node.getClientProperty().get("Position_Name").toString();
        }
        nameList = OrgChartUtil.getPrintScreenStr(name, node, g.getFontMetrics());
        List empInfos = null;
        empInfos = node.getClientProperty().get("Emp_List") == null ? (List)this.perMap.get(node.getClientProperty().get("Position_ID").toString()) : (List)node.getClientProperty().get("Emp_List");
        if (empInfos != null && empInfos.size() == 1 && this.photoMap != null && this.photoMap.get(((PersonInfo)empInfos.get(0)).getId().toString()) != null) {
            String empName = empInfos.get(0).toString();
            name = name + "(" + empName + ")";
        } else {
            name = nameList.get(0).toString();
        }
        oldColor = g.getColor();
        g.setColor(fontColor);
        g.drawString(name, 6 + (rect.width - 12 - g.getFontMetrics().stringWidth(name)) / 2, fontHeight * 2 + 6);
        g.setColor(oldColor);
        oldColor = g2d.getColor();
        oldStroke = g2d.getStroke();
        g2d.setStroke(new BasicStroke(2.0f));
        g2d.setColor(splitLineColor);
        g.drawLine(5, fontHeight * 2 + 12, node.getWidth() - 5, fontHeight * 2 + 12);
        g2d.setColor(oldColor);
        g2d.setStroke(oldStroke);
        List empList = null;
        if (node.getClientProperty().get("Emp_List") == null) {
            empList = (List)this.perMap.get(node.getClientProperty().get("Position_ID").toString());
            if (empList == null) {
                return true;
            }
            node.getClientProperty().put("Emp_List", empList);
        } else {
            empList = (List)node.getClientProperty().get("Emp_List");
        }
        BufferedImage big = null;
        int size = empList.size();
        for (int i = 0; i < size; ++i) {
            if (i == 2 && size > 3) {
                name = "......";
            } else {
                name = empList.get(i).toString();
                nameList = OrgChartUtil.getPrintScreenStr(name, node, g.getFontMetrics());
                name = nameList.get(0).toString();
            }
            if (size == 1 && (big = (BufferedImage)this.photoMap.get(((PersonInfo)empList.get(i)).getId().toString())) != null) {
                g.drawImage(big, 1, fontHeight * 2 + 12 + 1, node.getWidth() - 1, node.getHeight() - fontHeight * 2 - 12 - 1, null);
                break;
            }
            g.drawString(name, 6 + (rect.width - 12 - g.getFontMetrics().stringWidth(name)) / 2, fontHeight * (i + 3) + 12);
            if (i == 2) break;
        }
        return true;
    }

    @Override
    public HashMap builderChildNodes(Node node, int chartStyle) throws Exception {
        HashMap retMap = super.builderChildNodes(node, chartStyle);
        if (retMap == null) {
            return null;
        }
        this.getPersonPhotoData((List)retMap.get("NODE_LIST"));
        return retMap;
    }

    @Override
    public void builder() throws Exception {
        super.builder();
        this.getPersonPhotoData(this.getNodeList());
    }

    private void getPersonPhotoData(List nodeList) throws Exception {
        if (nodeList == null) {
            return;
        }
        ArrayList<BOSUuid> empIds = new ArrayList<BOSUuid>();
        Node node = null;
        int size = nodeList.size();
        for (int i = 0; i < size; ++i) {
            List empList;
            node = (Node)nodeList.get(i);
            PositionInfo posiInfo = (PositionInfo)this.posiMap.get(node.getId());
            if (posiInfo == null || (empList = (List)this.perMap.get(posiInfo.getId().toString())) == null || empList.size() != 1) continue;
            empIds.add(((PersonInfo)empList.get(0)).getId());
        }
        if (empIds.size() == 0) {
            return;
        }
        StringBuffer sql = new StringBuffer("SELECT FPersonID,FImageData FROM T_HR_PersonPhoto ");
        sql.append("WHERE FImageData IS NOT NULL AND FPersonID IN(");
        int size2 = empIds.size() - 1;
        for (int i = 0; i < size2; ++i) {
            sql.append("'");
            sql.append(empIds.get(i));
            sql.append("',");
        }
        sql.append("'").append(empIds.get(empIds.size() - 1)).append("')");
        IRowSet rows = SQLExecutorFactory.getRemoteInstance((String)sql.toString()).executeSQL();
        String personId = null;
        ByteArrayInputStream bais = null;
        BufferedImage bfg = null;
        Blob blob = null;
        while (rows.next()) {
            personId = rows.getString("FPersonID");
            blob = rows.getBlob("FImageData");
            bais = new ByteArrayInputStream(blob.getBytes(1L, (int)blob.length() - 1));
            bfg = ImageIO.read(bais);
            this.photoMap.put(personId, bfg);
        }
    }

    @Override
    public int getNodeHeight() {
        return 120;
    }

    @Override
    public int getNodeWidth() {
        return 100;
    }

    @Override
    public IRowSet getOrgChartDataRowSet() throws Exception {
        IBaseInnerFacade iBaseInner = BaseInnerFacadeFactory.getRemoteInstance();
        ArrayList list = iBaseInner.getOrgChartData();
        if (null == list || list.size() != 2) {
            return null;
        }
        IRowSet rows = (IRowSet)list.get(0);
        PositionInfo pInfo = null;
        while (rows.next()) {
            if (rows.getString("responPosition.id") == null) continue;
            pInfo = new PositionInfo();
            pInfo.setId(BOSUuid.read((String)rows.getString("responPosition.id")));
            pInfo.setName(rows.getString("responPosition.name"));
            this.posiMap.put(rows.getString("id"), pInfo);
        }
        rows = (IRowSet)list.get(1);
        PersonInfo empInfo = null;
        List empList = null;
        while (rows.next()) {
            if (rows.getString("Person.id") == null) continue;
            empInfo = new PersonInfo();
            empInfo.setId(BOSUuid.read((String)rows.getString("Person.id")));
            empInfo.setName(rows.getString("Person.name"));
            empList = this.perMap.containsKey(rows.getString("id")) ? (List)this.perMap.get(rows.getString("id")) : new ArrayList();
            if (!empList.contains(empInfo)) {
                empList.add(empInfo);
            }
            this.perMap.put(rows.getString("id"), empList);
        }
        return super.getOrgChartDataRowSet();
    }

    static void Paint4(String methodName, Graphics g, int x, int y, int width, int heigh, int xLength, int yLength) {
        try {
            Method m = g.getClass().getMethod(methodName, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
            m.invoke((Object)g, new Integer(x), new Integer(y), new Integer(width), new Integer(heigh));
            y = y + heigh + yLength;
            m.invoke((Object)g, new Integer(x), new Integer(y), new Integer(width), new Integer(heigh));
            x = x - width - xLength;
            m.invoke((Object)g, new Integer(x), new Integer(y), new Integer(width), new Integer(heigh));
            x = x + width * 2 + xLength * 2;
            m.invoke((Object)g, new Integer(x), new Integer(y), new Integer(width), new Integer(heigh));
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    static void Paint4Line(String methodName, Graphics g, int x1, int y1, int x2, int y2, int xLength, int yLength) {
        try {
            Method m = g.getClass().getMethod(methodName, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
            m.invoke((Object)g, new Integer(x1), new Integer(y1), new Integer(x2), new Integer(y2));
            m.invoke((Object)g, new Integer(x1), new Integer(y1 += yLength), new Integer(x2), new Integer(y2 += yLength));
            m.invoke((Object)g, new Integer(x1 -= xLength), new Integer(y1), new Integer(x2 -= xLength), new Integer(y2));
            m.invoke((Object)g, new Integer(x1 += 2 * xLength), new Integer(y1), new Integer(x2 += 2 * xLength), new Integer(y2));
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    static boolean isChinaLocale() {
        return SysContext.getSysContext().getLocale().equals(new Locale("l2"));
    }

    @Override
    public void paintDemo(Graphics g, Dimension size) {
        int cnOffSet = 0;
        if (OrgChartPersonPhotoBuilder.isChinaLocale()) {
            cnOffSet = 10;
        }
        g.setColor(new Color(192, 192, 192));
        g.fillRect(0, 0, size.width, size.height);
        g.setColor(Color.BLACK);
        OrgChartPersonPhotoBuilder.Paint4("drawRect", g, 125, 5, 100, 80, 17, 35);
        g.setColor(Color.WHITE);
        OrgChartPersonPhotoBuilder.Paint4("fillRect", g, 126, 6, 99, 79, 18, 36);
        g.setColor(Color.BLACK);
        int fontHeight = g.getFontMetrics().getHeight();
        OrgChartPersonPhotoBuilder.Paint4Line("drawLine", g, 125, 5 + fontHeight, 225, 5 + fontHeight, 117, 115);
        OrgChartPersonPhotoBuilder.Paint4Line("drawLine", g, 125, 5 + fontHeight * 2, 225, 5 + fontHeight * 2, 117, 115);
        g.drawString(EASResource.getString((String)"com.kingdee.eas.hr.base.BASEAutoGenerateResource", (String)"104_OrgChartPersonPhotoBuilder"), 160, 19);
        g.drawString(EASResource.getString((String)"com.kingdee.eas.hr.base.BASEAutoGenerateResource", (String)"105_OrgChartPersonPhotoBuilder"), 140 + cnOffSet, 37);
        g.drawImage(this.img, 140, 37, 73, 50, null);
        g.drawString(EASResource.getString((String)"com.kingdee.eas.hr.base.BASEAutoGenerateResource", (String)"106_OrgChartPersonPhotoBuilder"), 40, 134);
        g.drawString(EASResource.getString((String)"com.kingdee.eas.hr.base.BASEAutoGenerateResource", (String)"105_OrgChartPersonPhotoBuilder"), 25 + cnOffSet, 152);
        g.drawImage(this.img, 20, 152, 73, 50, null);
        g.drawString(EASResource.getString((String)"com.kingdee.eas.hr.base.BASEAutoGenerateResource", (String)"107_OrgChartPersonPhotoBuilder"), 160, 134);
        g.drawString(EASResource.getString((String)"com.kingdee.eas.hr.base.BASEAutoGenerateResource", (String)"105_OrgChartPersonPhotoBuilder"), 140 + cnOffSet, 152);
        g.drawImage(this.img, 140, 152, 73, 50, null);
        g.drawString(EASResource.getString((String)"com.kingdee.eas.hr.base.BASEAutoGenerateResource", (String)"108_OrgChartPersonPhotoBuilder"), 270, 134);
        g.drawString(EASResource.getString((String)"com.kingdee.eas.hr.base.BASEAutoGenerateResource", (String)"105_OrgChartPersonPhotoBuilder"), 260 + cnOffSet, 152);
        g.drawImage(this.img, 260, 152, 73, 50, null);
        g.drawLine(175, 85, 175, 120);
        g.drawLine(62, 100, 290, 100);
        g.drawLine(62, 100, 62, 120);
        g.drawLine(290, 100, 290, 120);
    }

    @Override
    public Element saveNodesAndEdgesAndBgToXML(List nodes, List edges, Color bg) {
        if (nodes == null) {
            return null;
        }
        Element nodeAndEdgeElement = new Element("NodeAndEdge");
        Element nodeElement = null;
        Element edgeElement = null;
        Element nodeListElement = null;
        Element edgeListElement = null;
        Element bgElement = null;
        Element positionElement = null;
        Element emplistElement = null;
        Element employeeElement = null;
        Node node = null;
        Edge edge = null;
        KDFont font = null;
        nodeListElement = new Element("NodeList");
        int size = nodes.size();
        for (int i = 0; i < size; ++i) {
            node = (Node)nodes.get(i);
            nodeElement = new Element("Node");
            nodeElement.addContent((Content)new Element("X").setText(Integer.toString(node.getX())));
            nodeElement.addContent((Content)new Element("Y").setText(Integer.toString(node.getY())));
            nodeElement.addContent((Content)new Element("Width").setText(Integer.toString(node.getWidth())));
            nodeElement.addContent((Content)new Element("Height").setText(Integer.toString(node.getHeight())));
            nodeElement.addContent((Content)new Element("BgColor").setText(Integer.toString(node.getBackground().getRGB())));
            nodeElement.addContent((Content)new Element("BorderColor").setText(Integer.toString(node.getBorderColor().getRGB())));
            nodeElement.addContent((Content)new Element("fontColor").setText(Integer.toString(node.getFontColor().getRGB())));
            nodeElement.addContent((Content)new Element("ObjID").setText(node.getId()));
            nodeElement.addContent((Content)new Element("Name").setText(node.getName()));
            nodeElement.addContent((Content)new Element("IsLeaf").setText(Boolean.toString(node.isLeaf())));
            if (node.getClientProperty().get("Position_ID") != null) {
                positionElement = new Element("PositionInfo");
                positionElement.addContent((Content)new Element("ID").setText(node.getClientProperty().get("Position_ID").toString()));
                positionElement.addContent((Content)new Element("Name").setText(node.getClientProperty().get("Position_Name").toString()));
                nodeElement.addContent((Content)positionElement);
            }
            if (node.getClientProperty().get("Emp_List") != null) {
                List empList = (List)node.getClientProperty().get("Emp_List");
                emplistElement = new Element("EmpList");
                int length = empList.size();
                for (int t = 0; t < length && t <= 3; ++t) {
                    PersonInfo pInfo = (PersonInfo)empList.get(t);
                    employeeElement = new Element("Emp");
                    employeeElement.addContent((Content)new Element("ID").setText(pInfo.getId().toString()));
                    employeeElement.addContent((Content)new Element("Name").setText(pInfo.getName()));
                    emplistElement.addContent((Content)employeeElement);
                }
                nodeElement.addContent((Content)emplistElement);
            }
            if ((font = (KDFont)node.getFont()) != null) {
                nodeElement.addContent((Content)new Element("FontName").setText(font.getName().toString()));
                nodeElement.addContent((Content)new Element("FontStyle").setText(Integer.toString(font.getStyle())));
                nodeElement.addContent((Content)new Element("FontSize").setText(Integer.toString(new Float(font.getSize()).intValue())));
            }
            nodeListElement.addContent((Content)nodeElement);
        }
        nodeAndEdgeElement.addContent((Content)nodeListElement);
        edgeListElement = new Element("EdgeList");
        Element pointListElement = null;
        Element pointElement = null;
        Point point = null;
        int size2 = edges.size();
        for (int i = 0; i < size2; ++i) {
            edge = (Edge)edges.get(i);
            edgeElement = new Element("Edge");
            edgeElement.addContent((Content)new Element("Color").setText(Integer.toString(edge.getColor().getRGB())));
            edgeElement.addContent((Content)new Element("SNodeID").setText(edge.getSourceNode().getId()));
            edgeElement.addContent((Content)new Element("TNodeID").setText(edge.getTargetNode().getId()));
            pointListElement = new Element("PointList");
            int length = edge.getPoints().size();
            for (int t = 1; t < length - 1; ++t) {
                point = (Point)edge.getPoints().get(t);
                pointElement = new Element("Point");
                pointElement.addContent((Content)new Element("X").setText(Integer.toString(point.x)));
                pointElement.addContent((Content)new Element("Y").setText(Integer.toString(point.y)));
                pointListElement.addContent((Content)pointElement);
            }
            edgeElement.addContent((Content)pointListElement);
            edgeListElement.addContent((Content)edgeElement);
        }
        nodeAndEdgeElement.addContent((Content)edgeListElement);
        bgElement = new Element("Background");
        bgElement.setText(Integer.toString(bg.getRGB()));
        nodeAndEdgeElement.addContent((Content)bgElement);
        return nodeAndEdgeElement;
    }

    @Override
    public List getNodesAndEdgesAndBgFromXML(String xmlData) throws Exception {
        SAXBuilder builder = new SAXBuilder();
        Document doc = builder.build((Reader)new StringReader(xmlData));
        Element root = doc.getRootElement();
        Element nodeAndEdgeElement = root.getChild("NodeAndEdge");
        Element nodeListElement = nodeAndEdgeElement.getChild("NodeList");
        Element bg = nodeAndEdgeElement.getChild("Background");
        Element nodeElement = null;
        Element fontName = null;
        Element fontStyle = null;
        Element fontSize = null;
        Element displayTextType = null;
        KDFont font = null;
        ArrayList<Node> nodeList = new ArrayList<Node>();
        Node node = null;
        String x = null;
        String y = null;
        String width = null;
        String height = null;
        String bgColor = null;
        String borderColor = null;
        String fontColor = null;
        String mainBackgroundColor = null;
        String name = null;
        String objId = null;
        String isLeaf = null;
        HashMap<String, Node> nodeMap = new HashMap<String, Node>();
        Element positionElement = null;
        Element empListElement = null;
        Element employeeElement = null;
        int size = nodeListElement.getChildren().size();
        for (int i = 0; i < size; ++i) {
            nodeElement = (Element)nodeListElement.getChildren().get(i);
            x = nodeElement.getChild("X").getText();
            y = nodeElement.getChild("Y").getText();
            width = nodeElement.getChild("Width").getText();
            height = nodeElement.getChild("Height").getText();
            bgColor = nodeElement.getChild("BgColor").getText();
            borderColor = nodeElement.getChild("BorderColor").getText();
            fontColor = nodeElement.getChild("fontColor").getText();
            name = nodeElement.getChild("Name").getText();
            objId = nodeElement.getChild("ObjID").getText();
            isLeaf = nodeElement.getChild("IsLeaf").getText();
            fontName = nodeElement.getChild("FontName");
            fontStyle = nodeElement.getChild("FontStyle");
            fontSize = nodeElement.getChild("FontSize");
            displayTextType = nodeElement.getChild("DisplayTextType");
            node = new Node(Integer.parseInt(x), Integer.parseInt(y), Integer.parseInt(width), Integer.parseInt(height), objId, name, Boolean.valueOf(isLeaf));
            node.setBackground(new Color(Integer.parseInt(bgColor)));
            node.setBorderColor(new Color(Integer.parseInt(borderColor)));
            node.setFontColor(new Color(Integer.parseInt(fontColor)));
            if (nodeElement.getChild("PositionInfo") != null) {
                positionElement = nodeElement.getChild("PositionInfo");
                node.getClientProperty().put("Position_ID", positionElement.getChild("ID").getText());
                node.getClientProperty().put("Position_Name", positionElement.getChild("Name").getText());
            }
            if (nodeElement.getChild("EmpList") != null) {
                empListElement = nodeElement.getChild("EmpList");
                ArrayList<PersonInfo> empList = new ArrayList<PersonInfo>();
                PersonInfo pInfo = null;
                int length = empListElement.getChildren().size();
                for (int t = 0; t < length; ++t) {
                    pInfo = new PersonInfo();
                    employeeElement = (Element)empListElement.getChildren().get(t);
                    pInfo.setId(BOSUuid.read((String)employeeElement.getChild("ID").getText()));
                    pInfo.setName(employeeElement.getChild("Name").getText());
                    empList.add(pInfo);
                }
                node.getClientProperty().put("Emp_List", empList);
            }
            if (fontName != null && fontStyle != null && fontSize != null) {
                font = new KDFont(fontName.getText(), new Integer(fontStyle.getText()).intValue(), new Integer(fontSize.getText()).intValue());
                node.setFont((Font)font);
            }
            nodeMap.put(objId, node);
            nodeList.add(node);
        }
        Element edgeListElement = nodeAndEdgeElement.getChild("EdgeList");
        Element edgeElement = null;
        Element pointListElement = null;
        String color = null;
        String sNodeId = null;
        String tNodeId = null;
        Edge edge = null;
        ArrayList<Edge> edgeList = new ArrayList<Edge>();
        ArrayList<Point> pointList = null;
        int size2 = edgeListElement.getChildren().size();
        for (int i = 0; i < size2; ++i) {
            edgeElement = (Element)edgeListElement.getChildren().get(i);
            color = edgeElement.getChild("Color").getText();
            sNodeId = edgeElement.getChild("SNodeID").getText();
            tNodeId = edgeElement.getChild("TNodeID").getText();
            edge = new Edge();
            edge.setSourceNode((Node)nodeMap.get(sNodeId));
            edge.setTargetNode((Node)nodeMap.get(tNodeId));
            edge.setColor(new Color(Integer.parseInt(color)));
            pointListElement = edgeElement.getChild("PointList");
            pointList = new ArrayList<Point>();
            pointList.add(new Point(0, 0));
            int length = pointListElement.getChildren().size();
            for (int t = 0; t < length; ++t) {
                Element pointElement = (Element)pointListElement.getChildren().get(t);
                x = pointElement.getChild("X").getText();
                y = pointElement.getChild("Y").getText();
                pointList.add(new Point(Integer.parseInt(x), Integer.parseInt(y)));
            }
            pointList.add(new Point(0, 0));
            edge.setPoints(pointList);
            edgeList.add(edge);
        }
        ArrayList<Object> nodeAndEdgeList = new ArrayList<Object>();
        nodeAndEdgeList.add(nodeList);
        nodeAndEdgeList.add(edgeList);
        if (bg != null) {
            mainBackgroundColor = bg.getText();
            nodeAndEdgeList.add(mainBackgroundColor);
        }
        this.getOrgChartDataRowSet();
        this.getPersonPhotoData(nodeList);
        return nodeAndEdgeList;
    }
}

