/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.client;

import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.hr.base.client.AbstractOrgChartPrintPreviewUI;
import com.kingdee.eas.hr.base.client.DesignerPanel;
import com.kingdee.eas.hr.base.client.OrgChartPreviewPanel;
import com.kingdee.eas.hr.base.util.HRResourceUtils;
import com.kingdee.eas.util.client.ComponentUtil;
import com.kingdee.util.StringUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class OrgChartPrintPreviewUI
extends AbstractOrgChartPrintPreviewUI {
    private static final Logger logger = CoreUIObject.getLogger(OrgChartPrintPreviewUI.class);
    private DesignerPanel designerPanel;
    private PageFormat pageFormat = null;
    private int curPageIndex = 0;
    private OrgChartPreviewPanel previewPanel = null;
    private KDLabel statusBar = null;
    private int pageCount = 1;
    private double scale = 1.0;

    public PageFormat getPageFormat() {
        return this.pageFormat;
    }

    @Override
    protected void btnPrint_actionPerformed(ActionEvent e) throws Exception {
        super.btnPrint_actionPerformed(e);
        PrinterJob pj = PrinterJob.getPrinterJob();
        if (this.pageFormat == null) {
            this.pageFormat = pj.defaultPage();
        }
        pj.setPrintable(this.designerPanel, this.pageFormat);
        if (pj.printDialog()) {
            pj.print();
        }
    }

    private void setPageToolbar() {
        this.btnFirstPage.setEnabled(this.curPageIndex != 0);
        this.btnPreviousPage.setEnabled(this.curPageIndex > 0);
        this.btnNextPage.setEnabled(this.curPageIndex < this.pageCount - 1);
        this.btnLastPage.setEnabled(this.curPageIndex != this.pageCount - 1);
    }

    @Override
    protected void btnPrintSetup_actionPerformed(ActionEvent e) throws Exception {
        super.btnPrintSetup_actionPerformed(e);
        PrinterJob pj = PrinterJob.getPrinterJob();
        this.pageFormat = this.pageFormat == null ? pj.pageDialog(pj.defaultPage()) : pj.pageDialog(this.pageFormat);
        if (this.getUIContext().get("Owner") != null && this.getUIContext().get("Owner") instanceof CoreUI) {
            ((CoreUI)this.getUIContext().get("Owner")).putClientProperty((Object)"PAGEFORMAT", (Object)this.pageFormat);
        }
        this.previewPanel.setPf(this.pageFormat);
        this.updatePageCount();
    }

    @Override
    protected void btnFirstPage_actionPerformed(ActionEvent e) throws Exception {
        super.btnFirstPage_actionPerformed(e);
        if (this.curPageIndex == 0) {
            return;
        }
        this.curPageIndex = 0;
        this.previewPanel.setPageIndex(this.curPageIndex);
        this.updateStatusBar();
    }

    @Override
    protected void btnPreviousPage_actionPerformed(ActionEvent e) throws Exception {
        super.btnPreviousPage_actionPerformed(e);
        if (this.curPageIndex == 0) {
            return;
        }
        --this.curPageIndex;
        this.previewPanel.setPageIndex(this.curPageIndex);
        this.updateStatusBar();
    }

    @Override
    protected void btnNextPage_actionPerformed(ActionEvent e) throws Exception {
        super.btnNextPage_actionPerformed(e);
        ++this.curPageIndex;
        this.previewPanel.setPageIndex(this.curPageIndex);
        this.updateStatusBar();
    }

    @Override
    protected void btnLastPage_actionPerformed(ActionEvent e) throws Exception {
        super.btnLastPage_actionPerformed(e);
        this.curPageIndex = this.pageCount - 1;
        this.previewPanel.setPageIndex(this.curPageIndex);
        this.updateStatusBar();
    }

    @Override
    protected void cboScale_itemStateChanged(ItemEvent e) throws Exception {
        super.cboScale_itemStateChanged(e);
        if (this.cboScale.getSelectedItem() == null) {
            return;
        }
        String obj = this.cboScale.getSelectedItem().toString();
        if (StringUtils.isEmpty((String)obj)) {
            return;
        }
        try {
            obj = obj.substring(0, obj.length() - 1);
            this.scale = Double.parseDouble(obj);
            this.scale /= 100.0;
        }
        catch (Exception ee) {
            Double initScale = new Double(this.scale * 100.0);
            ((JTextField)this.cboScale.getEditor().getEditorComponent()).setText(initScale + "%");
            return;
        }
        this.previewPanel.setScale(this.scale);
        this.previewScrollPanel.getViewport().setViewSize(this.previewPanel.getPreferredSize());
    }

    private Rectangle getWindowSize() throws Exception {
        Window dialog = ComponentUtil.getOwnerWindow(null);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Insets screenInsets = Toolkit.getDefaultToolkit().getScreenInsets(dialog.getGraphicsConfiguration());
        Rectangle desktopBounds = new Rectangle(screenInsets.left, screenInsets.top, screenSize.width - screenInsets.left - screenInsets.right, screenSize.height - screenInsets.top - screenInsets.bottom);
        return desktopBounds;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        Rectangle desktopBounds = this.getWindowSize();
        this.designerPanel = (DesignerPanel)this.getUIContext().get("DesignerPanel");
        this.remove((Component)this.previewScrollPanel);
        Dimension preferedSize = new Dimension(desktopBounds.width - 10, desktopBounds.height - 100);
        double defaultScale = this.getDefaultScale(preferedSize);
        this.previewPanel = new OrgChartPreviewPanel(this.designerPanel, this.pageFormat, defaultScale, this.curPageIndex, preferedSize);
        this.previewScrollPanel = new KDScrollPane((Component)((Object)this.previewPanel));
        this.setLayout(new BorderLayout());
        this.previewScrollPanel.setBounds(new Rectangle(0, 0, 800, 600));
        this.add((Component)this.previewScrollPanel, "Center");
        this.statusBar = new KDLabel();
        this.add((Component)this.statusBar, "South");
        this.updatePageCount();
        this.cboScale.setEditable(true);
        Double initScale = new Double(defaultScale * 100.0);
        ((JTextField)this.cboScale.getEditor().getEditorComponent()).setText(initScale.intValue() + "%");
    }

    private void updateStatusBar() {
        this.statusBar.setText(HRResourceUtils.getMessage("com.kingdee.eas.hr.base.BASEAutoGenerateResource", "164_OrgChartPrintPreviewUI", new String[]{String.valueOf(this.curPageIndex + 1), String.valueOf(this.pageCount)}));
        this.setPageToolbar();
    }

    private void updatePageCount() {
        int sr = Toolkit.getDefaultToolkit().getScreenResolution();
        double pageScale = 72.0 / (double)sr;
        Dimension pSize = this.designerPanel.getPreferredSize();
        int cols = (int)Math.max(Math.ceil((double)pSize.width / (this.pageFormat.getImageableWidth() / pageScale)), 1.0);
        int rows = (int)Math.max(Math.ceil((double)pSize.height / (this.pageFormat.getImageableHeight() / pageScale)), 1.0);
        this.pageCount = cols * rows;
        this.updateStatusBar();
    }

    private double getDefaultScale(Dimension preferedSize) {
        if (this.pageFormat == null) {
            this.pageFormat = PrinterJob.getPrinterJob().defaultPage();
        }
        double containerHeight = preferedSize.getHeight();
        double pageHeight = this.pageFormat.getHeight();
        int sr = Toolkit.getDefaultToolkit().getScreenResolution();
        double pageScale = 72.0 / (double)sr;
        double scale = 1.0;
        if (pageHeight / pageScale > containerHeight) {
            scale = containerHeight / (pageHeight / pageScale);
        }
        return scale;
    }
}

