/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.client;

import com.kingdee.eas.hr.base.client.Property;
import com.kingdee.eas.util.client.EASResource;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class PropertySheetTableModel
extends AbstractTableModel
implements PropertyChangeListener {
    public static final int NAME_COLUMN = 0;
    public static final int VALUE_COLUMN = 1;
    public static final int NUM_COLUMNS = 2;
    private List propertyList = null;
    private PropertyChangeSupport listeners = new PropertyChangeSupport(this);

    @Override
    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return EASResource.getString((String)"com.kingdee.eas.hr.base.BASEAutoGenerateResource", (String)"114_PropertySheetTableModel");
            }
            case 1: {
                return EASResource.getString((String)"com.kingdee.eas.hr.base.BASEAutoGenerateResource", (String)"115_PropertySheetTableModel");
            }
        }
        return "";
    }

    public PropertySheetTableModel() {
        this.propertyList = new ArrayList();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.removePropertyChangeListener(listener);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.listeners.firePropertyChange(evt);
    }

    public void setProperties(Property[] newProperties) {
        for (Property prop : this.propertyList) {
            prop.removePropertyChangeListener(this);
        }
        this.propertyList.clear();
        this.propertyList.addAll(Arrays.asList(newProperties));
        for (Property prop : this.propertyList) {
            prop.addPropertyChangeListener(this);
        }
        this.fireTableDataChanged();
    }

    public void clear() {
        for (Property prop : this.propertyList) {
            prop.removePropertyChangeListener(this);
        }
        this.propertyList.clear();
        this.fireTableDataChanged();
    }

    public Property getPropertyByIndex(int row) {
        return (Property)this.propertyList.get(row);
    }

    public void addProperty(Property property) {
        this.propertyList.add(property);
        property.addPropertyChangeListener(this);
        this.fireTableDataChanged();
    }

    public void addProperty(int index, Property property) {
        this.propertyList.add(index, property);
        property.addPropertyChangeListener(this);
        this.fireTableDataChanged();
    }

    public void removeProperty(Property property) {
        this.propertyList.remove(property);
        property.removePropertyChangeListener(this);
        this.fireTableDataChanged();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public int getRowCount() {
        return this.propertyList.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Object result = null;
        Property property = (Property)this.propertyList.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                result = property.getName();
                break;
            }
            case 1: {
                result = property.getValue();
                break;
            }
        }
        return result;
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        Property property = (Property)this.propertyList.get(rowIndex);
        property.setValue(value);
    }
}

